import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OsConfigOsPolicyAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * OS policy assignment description. Length of the description is limited to 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#description OsConfigOsPolicyAssignment#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#id OsConfigOsPolicyAssignment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#location OsConfigOsPolicyAssignment#location}
    */
    readonly location: string;
    /**
    * Resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#name OsConfigOsPolicyAssignment#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#project OsConfigOsPolicyAssignment#project}
    */
    readonly project?: string;
    /**
    * instance_filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#instance_filter OsConfigOsPolicyAssignment#instance_filter}
    */
    readonly instanceFilter: OsConfigOsPolicyAssignmentInstanceFilter;
    /**
    * os_policies block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#os_policies OsConfigOsPolicyAssignment#os_policies}
    */
    readonly osPolicies: OsConfigOsPolicyAssignmentOsPolicies[] | cdktf.IResolvable;
    /**
    * rollout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#rollout OsConfigOsPolicyAssignment#rollout}
    */
    readonly rollout: OsConfigOsPolicyAssignmentRollout;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#timeouts OsConfigOsPolicyAssignment#timeouts}
    */
    readonly timeouts?: OsConfigOsPolicyAssignmentTimeouts;
}
export interface OsConfigOsPolicyAssignmentInstanceFilterExclusionLabels {
    /**
    * Labels are identified by key/value pairs in this map. A VM should contain all the key/value pairs specified in this map to be selected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#labels OsConfigOsPolicyAssignment#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
}
export declare function osConfigOsPolicyAssignmentInstanceFilterExclusionLabelsToTerraform(struct?: OsConfigOsPolicyAssignmentInstanceFilterExclusionLabels | cdktf.IResolvable): any;
export declare class OsConfigOsPolicyAssignmentInstanceFilterExclusionLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OsConfigOsPolicyAssignmentInstanceFilterExclusionLabels | cdktf.IResolvable | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentInstanceFilterExclusionLabels | cdktf.IResolvable | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class OsConfigOsPolicyAssignmentInstanceFilterExclusionLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OsConfigOsPolicyAssignmentInstanceFilterExclusionLabels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OsConfigOsPolicyAssignmentInstanceFilterExclusionLabelsOutputReference;
}
export interface OsConfigOsPolicyAssignmentInstanceFilterInclusionLabels {
    /**
    * Labels are identified by key/value pairs in this map. A VM should contain all the key/value pairs specified in this map to be selected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#labels OsConfigOsPolicyAssignment#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
}
export declare function osConfigOsPolicyAssignmentInstanceFilterInclusionLabelsToTerraform(struct?: OsConfigOsPolicyAssignmentInstanceFilterInclusionLabels | cdktf.IResolvable): any;
export declare class OsConfigOsPolicyAssignmentInstanceFilterInclusionLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OsConfigOsPolicyAssignmentInstanceFilterInclusionLabels | cdktf.IResolvable | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentInstanceFilterInclusionLabels | cdktf.IResolvable | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class OsConfigOsPolicyAssignmentInstanceFilterInclusionLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OsConfigOsPolicyAssignmentInstanceFilterInclusionLabels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OsConfigOsPolicyAssignmentInstanceFilterInclusionLabelsOutputReference;
}
export interface OsConfigOsPolicyAssignmentInstanceFilterInventories {
    /**
    * Required. The OS short name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#os_short_name OsConfigOsPolicyAssignment#os_short_name}
    */
    readonly osShortName: string;
    /**
    * The OS version Prefix matches are supported if asterisk(*) is provided as the last character. For example, to match all versions with a major version of `7`, specify the following value for this field `7.*` An empty string matches all OS versions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#os_version OsConfigOsPolicyAssignment#os_version}
    */
    readonly osVersion?: string;
}
export declare function osConfigOsPolicyAssignmentInstanceFilterInventoriesToTerraform(struct?: OsConfigOsPolicyAssignmentInstanceFilterInventories | cdktf.IResolvable): any;
export declare class OsConfigOsPolicyAssignmentInstanceFilterInventoriesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OsConfigOsPolicyAssignmentInstanceFilterInventories | cdktf.IResolvable | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentInstanceFilterInventories | cdktf.IResolvable | undefined);
    private _osShortName?;
    get osShortName(): string;
    set osShortName(value: string);
    get osShortNameInput(): string | undefined;
    private _osVersion?;
    get osVersion(): string;
    set osVersion(value: string);
    resetOsVersion(): void;
    get osVersionInput(): string | undefined;
}
export declare class OsConfigOsPolicyAssignmentInstanceFilterInventoriesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OsConfigOsPolicyAssignmentInstanceFilterInventories[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OsConfigOsPolicyAssignmentInstanceFilterInventoriesOutputReference;
}
export interface OsConfigOsPolicyAssignmentInstanceFilter {
    /**
    * Target all VMs in the project. If true, no other criteria is permitted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#all OsConfigOsPolicyAssignment#all}
    */
    readonly all?: boolean | cdktf.IResolvable;
    /**
    * exclusion_labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#exclusion_labels OsConfigOsPolicyAssignment#exclusion_labels}
    */
    readonly exclusionLabels?: OsConfigOsPolicyAssignmentInstanceFilterExclusionLabels[] | cdktf.IResolvable;
    /**
    * inclusion_labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#inclusion_labels OsConfigOsPolicyAssignment#inclusion_labels}
    */
    readonly inclusionLabels?: OsConfigOsPolicyAssignmentInstanceFilterInclusionLabels[] | cdktf.IResolvable;
    /**
    * inventories block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#inventories OsConfigOsPolicyAssignment#inventories}
    */
    readonly inventories?: OsConfigOsPolicyAssignmentInstanceFilterInventories[] | cdktf.IResolvable;
}
export declare function osConfigOsPolicyAssignmentInstanceFilterToTerraform(struct?: OsConfigOsPolicyAssignmentInstanceFilterOutputReference | OsConfigOsPolicyAssignmentInstanceFilter): any;
export declare class OsConfigOsPolicyAssignmentInstanceFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentInstanceFilter | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentInstanceFilter | undefined);
    private _all?;
    get all(): boolean | cdktf.IResolvable;
    set all(value: boolean | cdktf.IResolvable);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _exclusionLabels;
    get exclusionLabels(): OsConfigOsPolicyAssignmentInstanceFilterExclusionLabelsList;
    putExclusionLabels(value: OsConfigOsPolicyAssignmentInstanceFilterExclusionLabels[] | cdktf.IResolvable): void;
    resetExclusionLabels(): void;
    get exclusionLabelsInput(): cdktf.IResolvable | OsConfigOsPolicyAssignmentInstanceFilterExclusionLabels[] | undefined;
    private _inclusionLabels;
    get inclusionLabels(): OsConfigOsPolicyAssignmentInstanceFilterInclusionLabelsList;
    putInclusionLabels(value: OsConfigOsPolicyAssignmentInstanceFilterInclusionLabels[] | cdktf.IResolvable): void;
    resetInclusionLabels(): void;
    get inclusionLabelsInput(): cdktf.IResolvable | OsConfigOsPolicyAssignmentInstanceFilterInclusionLabels[] | undefined;
    private _inventories;
    get inventories(): OsConfigOsPolicyAssignmentInstanceFilterInventoriesList;
    putInventories(value: OsConfigOsPolicyAssignmentInstanceFilterInventories[] | cdktf.IResolvable): void;
    resetInventories(): void;
    get inventoriesInput(): cdktf.IResolvable | OsConfigOsPolicyAssignmentInstanceFilterInventories[] | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsInventoryFilters {
    /**
    * Required. The OS short name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#os_short_name OsConfigOsPolicyAssignment#os_short_name}
    */
    readonly osShortName: string;
    /**
    * The OS version Prefix matches are supported if asterisk(*) is provided as the last character. For example, to match all versions with a major version of `7`, specify the following value for this field `7.*` An empty string matches all OS versions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#os_version OsConfigOsPolicyAssignment#os_version}
    */
    readonly osVersion?: string;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsInventoryFiltersToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsInventoryFilters | cdktf.IResolvable): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsInventoryFiltersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsInventoryFilters | cdktf.IResolvable | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsInventoryFilters | cdktf.IResolvable | undefined);
    private _osShortName?;
    get osShortName(): string;
    set osShortName(value: string);
    get osShortNameInput(): string | undefined;
    private _osVersion?;
    get osVersion(): string;
    set osVersion(value: string);
    resetOsVersion(): void;
    get osVersionInput(): string | undefined;
}
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsInventoryFiltersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsInventoryFilters[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsInventoryFiltersOutputReference;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileGcs {
    /**
    * Required. Bucket of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#bucket OsConfigOsPolicyAssignment#bucket}
    */
    readonly bucket: string;
    /**
    * Generation number of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#generation OsConfigOsPolicyAssignment#generation}
    */
    readonly generation?: number;
    /**
    * Required. Name of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#object OsConfigOsPolicyAssignment#object}
    */
    readonly object: string;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileGcsToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileGcsOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileGcs): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileGcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileGcs | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileGcs | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _generation?;
    get generation(): number;
    set generation(value: number);
    resetGeneration(): void;
    get generationInput(): number | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileRemote {
    /**
    * SHA256 checksum of the remote file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#sha256_checksum OsConfigOsPolicyAssignment#sha256_checksum}
    */
    readonly sha256Checksum?: string;
    /**
    * Required. URI from which to fetch the object. It should contain both the protocol and path following the format `{protocol}://{location}`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#uri OsConfigOsPolicyAssignment#uri}
    */
    readonly uri: string;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileRemoteToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileRemoteOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileRemote): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileRemoteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileRemote | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileRemote | undefined);
    private _sha256Checksum?;
    get sha256Checksum(): string;
    set sha256Checksum(value: string);
    resetSha256Checksum(): void;
    get sha256ChecksumInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFile {
    /**
    * Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#allow_insecure OsConfigOsPolicyAssignment#allow_insecure}
    */
    readonly allowInsecure?: boolean | cdktf.IResolvable;
    /**
    * A local path within the VM to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#local_path OsConfigOsPolicyAssignment#local_path}
    */
    readonly localPath?: string;
    /**
    * gcs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#gcs OsConfigOsPolicyAssignment#gcs}
    */
    readonly gcs?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileGcs;
    /**
    * remote block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#remote OsConfigOsPolicyAssignment#remote}
    */
    readonly remote?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileRemote;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFile): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFile | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFile | undefined);
    private _allowInsecure?;
    get allowInsecure(): boolean | cdktf.IResolvable;
    set allowInsecure(value: boolean | cdktf.IResolvable);
    resetAllowInsecure(): void;
    get allowInsecureInput(): boolean | cdktf.IResolvable | undefined;
    private _localPath?;
    get localPath(): string;
    set localPath(value: string);
    resetLocalPath(): void;
    get localPathInput(): string | undefined;
    private _gcs;
    get gcs(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileGcsOutputReference;
    putGcs(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileGcs): void;
    resetGcs(): void;
    get gcsInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileGcs | undefined;
    private _remote;
    get remote(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileRemoteOutputReference;
    putRemote(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileRemote): void;
    resetRemote(): void;
    get remoteInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileRemote | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforce {
    /**
    * Optional arguments to pass to the source during execution.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#args OsConfigOsPolicyAssignment#args}
    */
    readonly args?: string[];
    /**
    * Required. The script interpreter to use. Possible values: INTERPRETER_UNSPECIFIED, NONE, SHELL, POWERSHELL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#interpreter OsConfigOsPolicyAssignment#interpreter}
    */
    readonly interpreter: string;
    /**
    * Only recorded for enforce Exec. Path to an output file (that is created by this Exec) whose content will be recorded in OSPolicyResourceCompliance after a successful run. Absence or failure to read this file will result in this ExecResource being non-compliant. Output file size is limited to 100K bytes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#output_file_path OsConfigOsPolicyAssignment#output_file_path}
    */
    readonly outputFilePath?: string;
    /**
    * An inline script. The size of the script is limited to 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#script OsConfigOsPolicyAssignment#script}
    */
    readonly script?: string;
    /**
    * file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#file OsConfigOsPolicyAssignment#file}
    */
    readonly file?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFile;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforce): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforce | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforce | undefined);
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _interpreter?;
    get interpreter(): string;
    set interpreter(value: string);
    get interpreterInput(): string | undefined;
    private _outputFilePath?;
    get outputFilePath(): string;
    set outputFilePath(value: string);
    resetOutputFilePath(): void;
    get outputFilePathInput(): string | undefined;
    private _script?;
    get script(): string;
    set script(value: string);
    resetScript(): void;
    get scriptInput(): string | undefined;
    private _file;
    get file(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFileOutputReference;
    putFile(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFile): void;
    resetFile(): void;
    get fileInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceFile | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileGcs {
    /**
    * Required. Bucket of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#bucket OsConfigOsPolicyAssignment#bucket}
    */
    readonly bucket: string;
    /**
    * Generation number of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#generation OsConfigOsPolicyAssignment#generation}
    */
    readonly generation?: number;
    /**
    * Required. Name of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#object OsConfigOsPolicyAssignment#object}
    */
    readonly object: string;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileGcsToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileGcsOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileGcs): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileGcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileGcs | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileGcs | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _generation?;
    get generation(): number;
    set generation(value: number);
    resetGeneration(): void;
    get generationInput(): number | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileRemote {
    /**
    * SHA256 checksum of the remote file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#sha256_checksum OsConfigOsPolicyAssignment#sha256_checksum}
    */
    readonly sha256Checksum?: string;
    /**
    * Required. URI from which to fetch the object. It should contain both the protocol and path following the format `{protocol}://{location}`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#uri OsConfigOsPolicyAssignment#uri}
    */
    readonly uri: string;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileRemoteToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileRemoteOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileRemote): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileRemoteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileRemote | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileRemote | undefined);
    private _sha256Checksum?;
    get sha256Checksum(): string;
    set sha256Checksum(value: string);
    resetSha256Checksum(): void;
    get sha256ChecksumInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFile {
    /**
    * Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#allow_insecure OsConfigOsPolicyAssignment#allow_insecure}
    */
    readonly allowInsecure?: boolean | cdktf.IResolvable;
    /**
    * A local path within the VM to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#local_path OsConfigOsPolicyAssignment#local_path}
    */
    readonly localPath?: string;
    /**
    * gcs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#gcs OsConfigOsPolicyAssignment#gcs}
    */
    readonly gcs?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileGcs;
    /**
    * remote block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#remote OsConfigOsPolicyAssignment#remote}
    */
    readonly remote?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileRemote;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFile): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFile | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFile | undefined);
    private _allowInsecure?;
    get allowInsecure(): boolean | cdktf.IResolvable;
    set allowInsecure(value: boolean | cdktf.IResolvable);
    resetAllowInsecure(): void;
    get allowInsecureInput(): boolean | cdktf.IResolvable | undefined;
    private _localPath?;
    get localPath(): string;
    set localPath(value: string);
    resetLocalPath(): void;
    get localPathInput(): string | undefined;
    private _gcs;
    get gcs(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileGcsOutputReference;
    putGcs(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileGcs): void;
    resetGcs(): void;
    get gcsInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileGcs | undefined;
    private _remote;
    get remote(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileRemoteOutputReference;
    putRemote(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileRemote): void;
    resetRemote(): void;
    get remoteInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileRemote | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidate {
    /**
    * Optional arguments to pass to the source during execution.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#args OsConfigOsPolicyAssignment#args}
    */
    readonly args?: string[];
    /**
    * Required. The script interpreter to use. Possible values: INTERPRETER_UNSPECIFIED, NONE, SHELL, POWERSHELL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#interpreter OsConfigOsPolicyAssignment#interpreter}
    */
    readonly interpreter: string;
    /**
    * Only recorded for enforce Exec. Path to an output file (that is created by this Exec) whose content will be recorded in OSPolicyResourceCompliance after a successful run. Absence or failure to read this file will result in this ExecResource being non-compliant. Output file size is limited to 100K bytes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#output_file_path OsConfigOsPolicyAssignment#output_file_path}
    */
    readonly outputFilePath?: string;
    /**
    * An inline script. The size of the script is limited to 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#script OsConfigOsPolicyAssignment#script}
    */
    readonly script?: string;
    /**
    * file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#file OsConfigOsPolicyAssignment#file}
    */
    readonly file?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFile;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidate): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidate | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidate | undefined);
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _interpreter?;
    get interpreter(): string;
    set interpreter(value: string);
    get interpreterInput(): string | undefined;
    private _outputFilePath?;
    get outputFilePath(): string;
    set outputFilePath(value: string);
    resetOutputFilePath(): void;
    get outputFilePathInput(): string | undefined;
    private _script?;
    get script(): string;
    set script(value: string);
    resetScript(): void;
    get scriptInput(): string | undefined;
    private _file;
    get file(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFileOutputReference;
    putFile(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFile): void;
    resetFile(): void;
    get fileInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateFile | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExec {
    /**
    * enforce block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#enforce OsConfigOsPolicyAssignment#enforce}
    */
    readonly enforce?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforce;
    /**
    * validate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#validate OsConfigOsPolicyAssignment#validate}
    */
    readonly validate: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidate;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExec): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExec | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExec | undefined);
    private _enforce;
    get enforce(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforceOutputReference;
    putEnforce(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforce): void;
    resetEnforce(): void;
    get enforceInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecEnforce | undefined;
    private _validate;
    get validate(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidateOutputReference;
    putValidate(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidate): void;
    get validateInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecValidate | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileGcs {
    /**
    * Required. Bucket of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#bucket OsConfigOsPolicyAssignment#bucket}
    */
    readonly bucket: string;
    /**
    * Generation number of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#generation OsConfigOsPolicyAssignment#generation}
    */
    readonly generation?: number;
    /**
    * Required. Name of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#object OsConfigOsPolicyAssignment#object}
    */
    readonly object: string;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileGcsToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileGcsOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileGcs): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileGcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileGcs | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileGcs | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _generation?;
    get generation(): number;
    set generation(value: number);
    resetGeneration(): void;
    get generationInput(): number | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileRemote {
    /**
    * SHA256 checksum of the remote file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#sha256_checksum OsConfigOsPolicyAssignment#sha256_checksum}
    */
    readonly sha256Checksum?: string;
    /**
    * Required. URI from which to fetch the object. It should contain both the protocol and path following the format `{protocol}://{location}`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#uri OsConfigOsPolicyAssignment#uri}
    */
    readonly uri: string;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileRemoteToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileRemoteOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileRemote): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileRemoteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileRemote | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileRemote | undefined);
    private _sha256Checksum?;
    get sha256Checksum(): string;
    set sha256Checksum(value: string);
    resetSha256Checksum(): void;
    get sha256ChecksumInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFile {
    /**
    * Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#allow_insecure OsConfigOsPolicyAssignment#allow_insecure}
    */
    readonly allowInsecure?: boolean | cdktf.IResolvable;
    /**
    * A local path within the VM to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#local_path OsConfigOsPolicyAssignment#local_path}
    */
    readonly localPath?: string;
    /**
    * gcs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#gcs OsConfigOsPolicyAssignment#gcs}
    */
    readonly gcs?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileGcs;
    /**
    * remote block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#remote OsConfigOsPolicyAssignment#remote}
    */
    readonly remote?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileRemote;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFile): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFile | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFile | undefined);
    private _allowInsecure?;
    get allowInsecure(): boolean | cdktf.IResolvable;
    set allowInsecure(value: boolean | cdktf.IResolvable);
    resetAllowInsecure(): void;
    get allowInsecureInput(): boolean | cdktf.IResolvable | undefined;
    private _localPath?;
    get localPath(): string;
    set localPath(value: string);
    resetLocalPath(): void;
    get localPathInput(): string | undefined;
    private _gcs;
    get gcs(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileGcsOutputReference;
    putGcs(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileGcs): void;
    resetGcs(): void;
    get gcsInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileGcs | undefined;
    private _remote;
    get remote(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileRemoteOutputReference;
    putRemote(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileRemote): void;
    resetRemote(): void;
    get remoteInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileRemote | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFile {
    /**
    * A a file with this content. The size of the content is limited to 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#content OsConfigOsPolicyAssignment#content}
    */
    readonly content?: string;
    /**
    * Required. The absolute path of the file within the VM.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#path OsConfigOsPolicyAssignment#path}
    */
    readonly path: string;
    /**
    * Required. Desired state of the file. Possible values: OS_POLICY_COMPLIANCE_STATE_UNSPECIFIED, COMPLIANT, NON_COMPLIANT, UNKNOWN, NO_OS_POLICIES_APPLICABLE
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#state OsConfigOsPolicyAssignment#state}
    */
    readonly state: string;
    /**
    * file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#file OsConfigOsPolicyAssignment#file}
    */
    readonly file?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFile;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFile): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFile | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFile | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    resetContent(): void;
    get contentInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    get permissions(): string;
    private _state?;
    get state(): string;
    set state(value: string);
    get stateInput(): string | undefined;
    private _file;
    get file(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFileOutputReference;
    putFile(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFile): void;
    resetFile(): void;
    get fileInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileFile | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgApt {
    /**
    * Required. Package name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#name OsConfigOsPolicyAssignment#name}
    */
    readonly name: string;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgAptToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgAptOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgApt): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgAptOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgApt | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgApt | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceGcs {
    /**
    * Required. Bucket of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#bucket OsConfigOsPolicyAssignment#bucket}
    */
    readonly bucket: string;
    /**
    * Generation number of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#generation OsConfigOsPolicyAssignment#generation}
    */
    readonly generation?: number;
    /**
    * Required. Name of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#object OsConfigOsPolicyAssignment#object}
    */
    readonly object: string;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceGcsToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceGcsOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceGcs): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceGcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceGcs | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceGcs | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _generation?;
    get generation(): number;
    set generation(value: number);
    resetGeneration(): void;
    get generationInput(): number | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceRemote {
    /**
    * SHA256 checksum of the remote file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#sha256_checksum OsConfigOsPolicyAssignment#sha256_checksum}
    */
    readonly sha256Checksum?: string;
    /**
    * Required. URI from which to fetch the object. It should contain both the protocol and path following the format `{protocol}://{location}`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#uri OsConfigOsPolicyAssignment#uri}
    */
    readonly uri: string;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceRemoteToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceRemoteOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceRemote): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceRemoteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceRemote | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceRemote | undefined);
    private _sha256Checksum?;
    get sha256Checksum(): string;
    set sha256Checksum(value: string);
    resetSha256Checksum(): void;
    get sha256ChecksumInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSource {
    /**
    * Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#allow_insecure OsConfigOsPolicyAssignment#allow_insecure}
    */
    readonly allowInsecure?: boolean | cdktf.IResolvable;
    /**
    * A local path within the VM to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#local_path OsConfigOsPolicyAssignment#local_path}
    */
    readonly localPath?: string;
    /**
    * gcs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#gcs OsConfigOsPolicyAssignment#gcs}
    */
    readonly gcs?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceGcs;
    /**
    * remote block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#remote OsConfigOsPolicyAssignment#remote}
    */
    readonly remote?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceRemote;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSource): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSource | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSource | undefined);
    private _allowInsecure?;
    get allowInsecure(): boolean | cdktf.IResolvable;
    set allowInsecure(value: boolean | cdktf.IResolvable);
    resetAllowInsecure(): void;
    get allowInsecureInput(): boolean | cdktf.IResolvable | undefined;
    private _localPath?;
    get localPath(): string;
    set localPath(value: string);
    resetLocalPath(): void;
    get localPathInput(): string | undefined;
    private _gcs;
    get gcs(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceGcsOutputReference;
    putGcs(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceGcs): void;
    resetGcs(): void;
    get gcsInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceGcs | undefined;
    private _remote;
    get remote(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceRemoteOutputReference;
    putRemote(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceRemote): void;
    resetRemote(): void;
    get remoteInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceRemote | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDeb {
    /**
    * Whether dependencies should also be installed. - install when false: `dpkg -i package` - install when true: `apt-get update && apt-get -y install package.deb`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#pull_deps OsConfigOsPolicyAssignment#pull_deps}
    */
    readonly pullDeps?: boolean | cdktf.IResolvable;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#source OsConfigOsPolicyAssignment#source}
    */
    readonly source: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSource;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDeb): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDeb | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDeb | undefined);
    private _pullDeps?;
    get pullDeps(): boolean | cdktf.IResolvable;
    set pullDeps(value: boolean | cdktf.IResolvable);
    resetPullDeps(): void;
    get pullDepsInput(): boolean | cdktf.IResolvable | undefined;
    private _source;
    get source(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSourceOutputReference;
    putSource(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSource): void;
    get sourceInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebSource | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgGooget {
    /**
    * Required. Package name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#name OsConfigOsPolicyAssignment#name}
    */
    readonly name: string;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgGoogetToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgGoogetOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgGooget): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgGoogetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgGooget | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgGooget | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceGcs {
    /**
    * Required. Bucket of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#bucket OsConfigOsPolicyAssignment#bucket}
    */
    readonly bucket: string;
    /**
    * Generation number of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#generation OsConfigOsPolicyAssignment#generation}
    */
    readonly generation?: number;
    /**
    * Required. Name of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#object OsConfigOsPolicyAssignment#object}
    */
    readonly object: string;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceGcsToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceGcsOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceGcs): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceGcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceGcs | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceGcs | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _generation?;
    get generation(): number;
    set generation(value: number);
    resetGeneration(): void;
    get generationInput(): number | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceRemote {
    /**
    * SHA256 checksum of the remote file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#sha256_checksum OsConfigOsPolicyAssignment#sha256_checksum}
    */
    readonly sha256Checksum?: string;
    /**
    * Required. URI from which to fetch the object. It should contain both the protocol and path following the format `{protocol}://{location}`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#uri OsConfigOsPolicyAssignment#uri}
    */
    readonly uri: string;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceRemoteToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceRemoteOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceRemote): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceRemoteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceRemote | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceRemote | undefined);
    private _sha256Checksum?;
    get sha256Checksum(): string;
    set sha256Checksum(value: string);
    resetSha256Checksum(): void;
    get sha256ChecksumInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSource {
    /**
    * Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#allow_insecure OsConfigOsPolicyAssignment#allow_insecure}
    */
    readonly allowInsecure?: boolean | cdktf.IResolvable;
    /**
    * A local path within the VM to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#local_path OsConfigOsPolicyAssignment#local_path}
    */
    readonly localPath?: string;
    /**
    * gcs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#gcs OsConfigOsPolicyAssignment#gcs}
    */
    readonly gcs?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceGcs;
    /**
    * remote block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#remote OsConfigOsPolicyAssignment#remote}
    */
    readonly remote?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceRemote;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSource): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSource | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSource | undefined);
    private _allowInsecure?;
    get allowInsecure(): boolean | cdktf.IResolvable;
    set allowInsecure(value: boolean | cdktf.IResolvable);
    resetAllowInsecure(): void;
    get allowInsecureInput(): boolean | cdktf.IResolvable | undefined;
    private _localPath?;
    get localPath(): string;
    set localPath(value: string);
    resetLocalPath(): void;
    get localPathInput(): string | undefined;
    private _gcs;
    get gcs(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceGcsOutputReference;
    putGcs(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceGcs): void;
    resetGcs(): void;
    get gcsInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceGcs | undefined;
    private _remote;
    get remote(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceRemoteOutputReference;
    putRemote(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceRemote): void;
    resetRemote(): void;
    get remoteInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceRemote | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsi {
    /**
    * Additional properties to use during installation. This should be in the format of Property=Setting. Appended to the defaults of `ACTION=INSTALL REBOOT=ReallySuppress`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#properties OsConfigOsPolicyAssignment#properties}
    */
    readonly properties?: string[];
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#source OsConfigOsPolicyAssignment#source}
    */
    readonly source: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSource;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsi): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsi | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsi | undefined);
    private _properties?;
    get properties(): string[];
    set properties(value: string[]);
    resetProperties(): void;
    get propertiesInput(): string[] | undefined;
    private _source;
    get source(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSourceOutputReference;
    putSource(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSource): void;
    get sourceInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiSource | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceGcs {
    /**
    * Required. Bucket of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#bucket OsConfigOsPolicyAssignment#bucket}
    */
    readonly bucket: string;
    /**
    * Generation number of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#generation OsConfigOsPolicyAssignment#generation}
    */
    readonly generation?: number;
    /**
    * Required. Name of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#object OsConfigOsPolicyAssignment#object}
    */
    readonly object: string;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceGcsToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceGcsOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceGcs): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceGcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceGcs | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceGcs | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _generation?;
    get generation(): number;
    set generation(value: number);
    resetGeneration(): void;
    get generationInput(): number | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceRemote {
    /**
    * SHA256 checksum of the remote file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#sha256_checksum OsConfigOsPolicyAssignment#sha256_checksum}
    */
    readonly sha256Checksum?: string;
    /**
    * Required. URI from which to fetch the object. It should contain both the protocol and path following the format `{protocol}://{location}`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#uri OsConfigOsPolicyAssignment#uri}
    */
    readonly uri: string;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceRemoteToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceRemoteOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceRemote): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceRemoteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceRemote | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceRemote | undefined);
    private _sha256Checksum?;
    get sha256Checksum(): string;
    set sha256Checksum(value: string);
    resetSha256Checksum(): void;
    get sha256ChecksumInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSource {
    /**
    * Defaults to false. When false, files are subject to validations based on the file type: Remote: A checksum must be specified. Cloud Storage: An object generation number must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#allow_insecure OsConfigOsPolicyAssignment#allow_insecure}
    */
    readonly allowInsecure?: boolean | cdktf.IResolvable;
    /**
    * A local path within the VM to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#local_path OsConfigOsPolicyAssignment#local_path}
    */
    readonly localPath?: string;
    /**
    * gcs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#gcs OsConfigOsPolicyAssignment#gcs}
    */
    readonly gcs?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceGcs;
    /**
    * remote block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#remote OsConfigOsPolicyAssignment#remote}
    */
    readonly remote?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceRemote;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSource): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSource | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSource | undefined);
    private _allowInsecure?;
    get allowInsecure(): boolean | cdktf.IResolvable;
    set allowInsecure(value: boolean | cdktf.IResolvable);
    resetAllowInsecure(): void;
    get allowInsecureInput(): boolean | cdktf.IResolvable | undefined;
    private _localPath?;
    get localPath(): string;
    set localPath(value: string);
    resetLocalPath(): void;
    get localPathInput(): string | undefined;
    private _gcs;
    get gcs(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceGcsOutputReference;
    putGcs(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceGcs): void;
    resetGcs(): void;
    get gcsInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceGcs | undefined;
    private _remote;
    get remote(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceRemoteOutputReference;
    putRemote(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceRemote): void;
    resetRemote(): void;
    get remoteInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceRemote | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpm {
    /**
    * Whether dependencies should also be installed. - install when false: `rpm --upgrade --replacepkgs package.rpm` - install when true: `yum -y install package.rpm` or `zypper -y install package.rpm`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#pull_deps OsConfigOsPolicyAssignment#pull_deps}
    */
    readonly pullDeps?: boolean | cdktf.IResolvable;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#source OsConfigOsPolicyAssignment#source}
    */
    readonly source: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSource;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpm): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpm | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpm | undefined);
    private _pullDeps?;
    get pullDeps(): boolean | cdktf.IResolvable;
    set pullDeps(value: boolean | cdktf.IResolvable);
    resetPullDeps(): void;
    get pullDepsInput(): boolean | cdktf.IResolvable | undefined;
    private _source;
    get source(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSourceOutputReference;
    putSource(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSource): void;
    get sourceInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmSource | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgYum {
    /**
    * Required. Package name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#name OsConfigOsPolicyAssignment#name}
    */
    readonly name: string;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgYumToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgYumOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgYum): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgYumOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgYum | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgYum | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgZypper {
    /**
    * Required. Package name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#name OsConfigOsPolicyAssignment#name}
    */
    readonly name: string;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgZypperToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgZypperOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgZypper): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgZypperOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgZypper | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgZypper | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkg {
    /**
    * Required. The desired state the agent should maintain for this package. Possible values: DESIRED_STATE_UNSPECIFIED, INSTALLED, REMOVED
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#desired_state OsConfigOsPolicyAssignment#desired_state}
    */
    readonly desiredState: string;
    /**
    * apt block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#apt OsConfigOsPolicyAssignment#apt}
    */
    readonly apt?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgApt;
    /**
    * deb block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#deb OsConfigOsPolicyAssignment#deb}
    */
    readonly deb?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDeb;
    /**
    * googet block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#googet OsConfigOsPolicyAssignment#googet}
    */
    readonly googet?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgGooget;
    /**
    * msi block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#msi OsConfigOsPolicyAssignment#msi}
    */
    readonly msi?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsi;
    /**
    * rpm block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#rpm OsConfigOsPolicyAssignment#rpm}
    */
    readonly rpm?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpm;
    /**
    * yum block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#yum OsConfigOsPolicyAssignment#yum}
    */
    readonly yum?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgYum;
    /**
    * zypper block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#zypper OsConfigOsPolicyAssignment#zypper}
    */
    readonly zypper?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgZypper;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkg): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkg | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkg | undefined);
    private _desiredState?;
    get desiredState(): string;
    set desiredState(value: string);
    get desiredStateInput(): string | undefined;
    private _apt;
    get apt(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgAptOutputReference;
    putApt(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgApt): void;
    resetApt(): void;
    get aptInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgApt | undefined;
    private _deb;
    get deb(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDebOutputReference;
    putDeb(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDeb): void;
    resetDeb(): void;
    get debInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgDeb | undefined;
    private _googet;
    get googet(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgGoogetOutputReference;
    putGooget(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgGooget): void;
    resetGooget(): void;
    get googetInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgGooget | undefined;
    private _msi;
    get msi(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsiOutputReference;
    putMsi(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsi): void;
    resetMsi(): void;
    get msiInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgMsi | undefined;
    private _rpm;
    get rpm(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpmOutputReference;
    putRpm(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpm): void;
    resetRpm(): void;
    get rpmInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgRpm | undefined;
    private _yum;
    get yum(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgYumOutputReference;
    putYum(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgYum): void;
    resetYum(): void;
    get yumInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgYum | undefined;
    private _zypper;
    get zypper(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgZypperOutputReference;
    putZypper(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgZypper): void;
    resetZypper(): void;
    get zypperInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgZypper | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryApt {
    /**
    * Required. Type of archive files in this repository. Possible values: ARCHIVE_TYPE_UNSPECIFIED, DEB, DEB_SRC
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#archive_type OsConfigOsPolicyAssignment#archive_type}
    */
    readonly archiveType: string;
    /**
    * Required. List of components for this repository. Must contain at least one item.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#components OsConfigOsPolicyAssignment#components}
    */
    readonly components: string[];
    /**
    * Required. Distribution of this repository.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#distribution OsConfigOsPolicyAssignment#distribution}
    */
    readonly distribution: string;
    /**
    * URI of the key file for this repository. The agent maintains a keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#gpg_key OsConfigOsPolicyAssignment#gpg_key}
    */
    readonly gpgKey?: string;
    /**
    * Required. URI for this repository.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#uri OsConfigOsPolicyAssignment#uri}
    */
    readonly uri: string;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryAptToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryAptOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryApt): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryAptOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryApt | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryApt | undefined);
    private _archiveType?;
    get archiveType(): string;
    set archiveType(value: string);
    get archiveTypeInput(): string | undefined;
    private _components?;
    get components(): string[];
    set components(value: string[]);
    get componentsInput(): string[] | undefined;
    private _distribution?;
    get distribution(): string;
    set distribution(value: string);
    get distributionInput(): string | undefined;
    private _gpgKey?;
    get gpgKey(): string;
    set gpgKey(value: string);
    resetGpgKey(): void;
    get gpgKeyInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryGoo {
    /**
    * Required. The name of the repository.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#name OsConfigOsPolicyAssignment#name}
    */
    readonly name: string;
    /**
    * Required. The url of the repository.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#url OsConfigOsPolicyAssignment#url}
    */
    readonly url: string;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryGooToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryGooOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryGoo): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryGooOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryGoo | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryGoo | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryYum {
    /**
    * Required. The location of the repository directory.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#base_url OsConfigOsPolicyAssignment#base_url}
    */
    readonly baseUrl: string;
    /**
    * The display name of the repository.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#display_name OsConfigOsPolicyAssignment#display_name}
    */
    readonly displayName?: string;
    /**
    * URIs of GPG keys.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#gpg_keys OsConfigOsPolicyAssignment#gpg_keys}
    */
    readonly gpgKeys?: string[];
    /**
    * Required. A one word, unique name for this repository. This is the `repo id` in the yum config file and also the `display_name` if `display_name` is omitted. This id is also used as the unique identifier when checking for resource conflicts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#id OsConfigOsPolicyAssignment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryYumToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryYumOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryYum): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryYumOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryYum | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryYum | undefined);
    private _baseUrl?;
    get baseUrl(): string;
    set baseUrl(value: string);
    get baseUrlInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _gpgKeys?;
    get gpgKeys(): string[];
    set gpgKeys(value: string[]);
    resetGpgKeys(): void;
    get gpgKeysInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryZypper {
    /**
    * Required. The location of the repository directory.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#base_url OsConfigOsPolicyAssignment#base_url}
    */
    readonly baseUrl: string;
    /**
    * The display name of the repository.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#display_name OsConfigOsPolicyAssignment#display_name}
    */
    readonly displayName?: string;
    /**
    * URIs of GPG keys.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#gpg_keys OsConfigOsPolicyAssignment#gpg_keys}
    */
    readonly gpgKeys?: string[];
    /**
    * Required. A one word, unique name for this repository. This is the `repo id` in the zypper config file and also the `display_name` if `display_name` is omitted. This id is also used as the unique identifier when checking for GuestPolicy conflicts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#id OsConfigOsPolicyAssignment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryZypperToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryZypperOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryZypper): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryZypperOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryZypper | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryZypper | undefined);
    private _baseUrl?;
    get baseUrl(): string;
    set baseUrl(value: string);
    get baseUrlInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _gpgKeys?;
    get gpgKeys(): string[];
    set gpgKeys(value: string[]);
    resetGpgKeys(): void;
    get gpgKeysInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepository {
    /**
    * apt block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#apt OsConfigOsPolicyAssignment#apt}
    */
    readonly apt?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryApt;
    /**
    * goo block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#goo OsConfigOsPolicyAssignment#goo}
    */
    readonly goo?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryGoo;
    /**
    * yum block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#yum OsConfigOsPolicyAssignment#yum}
    */
    readonly yum?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryYum;
    /**
    * zypper block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#zypper OsConfigOsPolicyAssignment#zypper}
    */
    readonly zypper?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryZypper;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryOutputReference | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepository): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepository | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepository | undefined);
    private _apt;
    get apt(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryAptOutputReference;
    putApt(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryApt): void;
    resetApt(): void;
    get aptInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryApt | undefined;
    private _goo;
    get goo(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryGooOutputReference;
    putGoo(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryGoo): void;
    resetGoo(): void;
    get gooInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryGoo | undefined;
    private _yum;
    get yum(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryYumOutputReference;
    putYum(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryYum): void;
    resetYum(): void;
    get yumInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryYum | undefined;
    private _zypper;
    get zypper(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryZypperOutputReference;
    putZypper(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryZypper): void;
    resetZypper(): void;
    get zypperInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryZypper | undefined;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResources {
    /**
    * Required. The id of the resource with the following restrictions: * Must contain only lowercase letters, numbers, and hyphens. * Must start with a letter. * Must be between 1-63 characters. * Must end with a number or a letter. * Must be unique within the OS policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#id OsConfigOsPolicyAssignment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * exec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#exec OsConfigOsPolicyAssignment#exec}
    */
    readonly exec?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExec;
    /**
    * file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#file OsConfigOsPolicyAssignment#file}
    */
    readonly file?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFile;
    /**
    * pkg block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#pkg OsConfigOsPolicyAssignment#pkg}
    */
    readonly pkg?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkg;
    /**
    * repository block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#repository OsConfigOsPolicyAssignment#repository}
    */
    readonly repository?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepository;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResources | cdktf.IResolvable): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResources | cdktf.IResolvable | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResources | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _exec;
    get exec(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExecOutputReference;
    putExec(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExec): void;
    resetExec(): void;
    get execInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesExec | undefined;
    private _file;
    get file(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFileOutputReference;
    putFile(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFile): void;
    resetFile(): void;
    get fileInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesFile | undefined;
    private _pkg;
    get pkg(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkgOutputReference;
    putPkg(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkg): void;
    resetPkg(): void;
    get pkgInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesPkg | undefined;
    private _repository;
    get repository(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepositoryOutputReference;
    putRepository(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepository): void;
    resetRepository(): void;
    get repositoryInput(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesRepository | undefined;
}
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResources[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesOutputReference;
}
export interface OsConfigOsPolicyAssignmentOsPoliciesResourceGroups {
    /**
    * inventory_filters block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#inventory_filters OsConfigOsPolicyAssignment#inventory_filters}
    */
    readonly inventoryFilters?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsInventoryFilters[] | cdktf.IResolvable;
    /**
    * resources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#resources OsConfigOsPolicyAssignment#resources}
    */
    readonly resources: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResources[] | cdktf.IResolvable;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesResourceGroupsToTerraform(struct?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroups | cdktf.IResolvable): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroups | cdktf.IResolvable | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroups | cdktf.IResolvable | undefined);
    private _inventoryFilters;
    get inventoryFilters(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsInventoryFiltersList;
    putInventoryFilters(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsInventoryFilters[] | cdktf.IResolvable): void;
    resetInventoryFilters(): void;
    get inventoryFiltersInput(): cdktf.IResolvable | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsInventoryFilters[] | undefined;
    private _resources;
    get resources(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResourcesList;
    putResources(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResources[] | cdktf.IResolvable): void;
    get resourcesInput(): cdktf.IResolvable | OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsResources[] | undefined;
}
export declare class OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OsConfigOsPolicyAssignmentOsPoliciesResourceGroups[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsOutputReference;
}
export interface OsConfigOsPolicyAssignmentOsPolicies {
    /**
    * This flag determines the OS policy compliance status when none of the resource groups within the policy are applicable for a VM. Set this value to `true` if the policy needs to be reported as compliant even if the policy has nothing to validate or enforce.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#allow_no_resource_group_match OsConfigOsPolicyAssignment#allow_no_resource_group_match}
    */
    readonly allowNoResourceGroupMatch?: boolean | cdktf.IResolvable;
    /**
    * Policy description. Length of the description is limited to 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#description OsConfigOsPolicyAssignment#description}
    */
    readonly description?: string;
    /**
    * Required. The id of the OS policy with the following restrictions: * Must contain only lowercase letters, numbers, and hyphens. * Must start with a letter. * Must be between 1-63 characters. * Must end with a number or a letter. * Must be unique within the assignment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#id OsConfigOsPolicyAssignment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * Required. Policy mode Possible values: MODE_UNSPECIFIED, VALIDATION, ENFORCEMENT
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#mode OsConfigOsPolicyAssignment#mode}
    */
    readonly mode: string;
    /**
    * resource_groups block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#resource_groups OsConfigOsPolicyAssignment#resource_groups}
    */
    readonly resourceGroups: OsConfigOsPolicyAssignmentOsPoliciesResourceGroups[] | cdktf.IResolvable;
}
export declare function osConfigOsPolicyAssignmentOsPoliciesToTerraform(struct?: OsConfigOsPolicyAssignmentOsPolicies | cdktf.IResolvable): any;
export declare class OsConfigOsPolicyAssignmentOsPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OsConfigOsPolicyAssignmentOsPolicies | cdktf.IResolvable | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentOsPolicies | cdktf.IResolvable | undefined);
    private _allowNoResourceGroupMatch?;
    get allowNoResourceGroupMatch(): boolean | cdktf.IResolvable;
    set allowNoResourceGroupMatch(value: boolean | cdktf.IResolvable);
    resetAllowNoResourceGroupMatch(): void;
    get allowNoResourceGroupMatchInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    private _resourceGroups;
    get resourceGroups(): OsConfigOsPolicyAssignmentOsPoliciesResourceGroupsList;
    putResourceGroups(value: OsConfigOsPolicyAssignmentOsPoliciesResourceGroups[] | cdktf.IResolvable): void;
    get resourceGroupsInput(): cdktf.IResolvable | OsConfigOsPolicyAssignmentOsPoliciesResourceGroups[] | undefined;
}
export declare class OsConfigOsPolicyAssignmentOsPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OsConfigOsPolicyAssignmentOsPolicies[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OsConfigOsPolicyAssignmentOsPoliciesOutputReference;
}
export interface OsConfigOsPolicyAssignmentRolloutDisruptionBudget {
    /**
    * Specifies a fixed value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#fixed OsConfigOsPolicyAssignment#fixed}
    */
    readonly fixed?: number;
    /**
    * Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#percent OsConfigOsPolicyAssignment#percent}
    */
    readonly percent?: number;
}
export declare function osConfigOsPolicyAssignmentRolloutDisruptionBudgetToTerraform(struct?: OsConfigOsPolicyAssignmentRolloutDisruptionBudgetOutputReference | OsConfigOsPolicyAssignmentRolloutDisruptionBudget): any;
export declare class OsConfigOsPolicyAssignmentRolloutDisruptionBudgetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentRolloutDisruptionBudget | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentRolloutDisruptionBudget | undefined);
    private _fixed?;
    get fixed(): number;
    set fixed(value: number);
    resetFixed(): void;
    get fixedInput(): number | undefined;
    private _percent?;
    get percent(): number;
    set percent(value: number);
    resetPercent(): void;
    get percentInput(): number | undefined;
}
export interface OsConfigOsPolicyAssignmentRollout {
    /**
    * Required. This determines the minimum duration of time to wait after the configuration changes are applied through the current rollout. A VM continues to count towards the `disruption_budget` at least until this duration of time has passed after configuration changes are applied.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#min_wait_duration OsConfigOsPolicyAssignment#min_wait_duration}
    */
    readonly minWaitDuration: string;
    /**
    * disruption_budget block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#disruption_budget OsConfigOsPolicyAssignment#disruption_budget}
    */
    readonly disruptionBudget: OsConfigOsPolicyAssignmentRolloutDisruptionBudget;
}
export declare function osConfigOsPolicyAssignmentRolloutToTerraform(struct?: OsConfigOsPolicyAssignmentRolloutOutputReference | OsConfigOsPolicyAssignmentRollout): any;
export declare class OsConfigOsPolicyAssignmentRolloutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentRollout | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentRollout | undefined);
    private _minWaitDuration?;
    get minWaitDuration(): string;
    set minWaitDuration(value: string);
    get minWaitDurationInput(): string | undefined;
    private _disruptionBudget;
    get disruptionBudget(): OsConfigOsPolicyAssignmentRolloutDisruptionBudgetOutputReference;
    putDisruptionBudget(value: OsConfigOsPolicyAssignmentRolloutDisruptionBudget): void;
    get disruptionBudgetInput(): OsConfigOsPolicyAssignmentRolloutDisruptionBudget | undefined;
}
export interface OsConfigOsPolicyAssignmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#create OsConfigOsPolicyAssignment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#delete OsConfigOsPolicyAssignment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment#update OsConfigOsPolicyAssignment#update}
    */
    readonly update?: string;
}
export declare function osConfigOsPolicyAssignmentTimeoutsToTerraform(struct?: OsConfigOsPolicyAssignmentTimeoutsOutputReference | OsConfigOsPolicyAssignmentTimeouts | cdktf.IResolvable): any;
export declare class OsConfigOsPolicyAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigOsPolicyAssignmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: OsConfigOsPolicyAssignmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment google_os_config_os_policy_assignment}
*/
export declare class OsConfigOsPolicyAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_os_config_os_policy_assignment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/os_config_os_policy_assignment google_os_config_os_policy_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OsConfigOsPolicyAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: OsConfigOsPolicyAssignmentConfig);
    get baseline(): cdktf.IResolvable;
    get deleted(): cdktf.IResolvable;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    get revisionCreateTime(): string;
    get revisionId(): string;
    get rolloutState(): string;
    get uid(): string;
    private _instanceFilter;
    get instanceFilter(): OsConfigOsPolicyAssignmentInstanceFilterOutputReference;
    putInstanceFilter(value: OsConfigOsPolicyAssignmentInstanceFilter): void;
    get instanceFilterInput(): OsConfigOsPolicyAssignmentInstanceFilter | undefined;
    private _osPolicies;
    get osPolicies(): OsConfigOsPolicyAssignmentOsPoliciesList;
    putOsPolicies(value: OsConfigOsPolicyAssignmentOsPolicies[] | cdktf.IResolvable): void;
    get osPoliciesInput(): cdktf.IResolvable | OsConfigOsPolicyAssignmentOsPolicies[] | undefined;
    private _rollout;
    get rollout(): OsConfigOsPolicyAssignmentRolloutOutputReference;
    putRollout(value: OsConfigOsPolicyAssignmentRollout): void;
    get rolloutInput(): OsConfigOsPolicyAssignmentRollout | undefined;
    private _timeouts;
    get timeouts(): OsConfigOsPolicyAssignmentTimeoutsOutputReference;
    putTimeouts(value: OsConfigOsPolicyAssignmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | OsConfigOsPolicyAssignmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
