import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrivatecaCaPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#id PrivatecaCaPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Labels with user-defined metadata.
  
  An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
  "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#labels PrivatecaCaPool#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Location of the CaPool. A full list of valid locations can be found by
  running 'gcloud privateca locations list'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#location PrivatecaCaPool#location}
    */
    readonly location: string;
    /**
    * The name for this CaPool.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#name PrivatecaCaPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#project PrivatecaCaPool#project}
    */
    readonly project?: string;
    /**
    * The Tier of this CaPool. Possible values: ["ENTERPRISE", "DEVOPS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#tier PrivatecaCaPool#tier}
    */
    readonly tier: string;
    /**
    * issuance_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#issuance_policy PrivatecaCaPool#issuance_policy}
    */
    readonly issuancePolicy?: PrivatecaCaPoolIssuancePolicy;
    /**
    * publishing_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#publishing_options PrivatecaCaPool#publishing_options}
    */
    readonly publishingOptions?: PrivatecaCaPoolPublishingOptions;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#timeouts PrivatecaCaPool#timeouts}
    */
    readonly timeouts?: PrivatecaCaPoolTimeouts;
}
export interface PrivatecaCaPoolIssuancePolicyAllowedIssuanceModes {
    /**
    * When true, allows callers to create Certificates by specifying a CertificateConfig.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#allow_config_based_issuance PrivatecaCaPool#allow_config_based_issuance}
    */
    readonly allowConfigBasedIssuance: boolean | cdktf.IResolvable;
    /**
    * When true, allows callers to create Certificates by specifying a CSR.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#allow_csr_based_issuance PrivatecaCaPool#allow_csr_based_issuance}
    */
    readonly allowCsrBasedIssuance: boolean | cdktf.IResolvable;
}
export declare function privatecaCaPoolIssuancePolicyAllowedIssuanceModesToTerraform(struct?: PrivatecaCaPoolIssuancePolicyAllowedIssuanceModesOutputReference | PrivatecaCaPoolIssuancePolicyAllowedIssuanceModes): any;
export declare class PrivatecaCaPoolIssuancePolicyAllowedIssuanceModesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCaPoolIssuancePolicyAllowedIssuanceModes | undefined;
    set internalValue(value: PrivatecaCaPoolIssuancePolicyAllowedIssuanceModes | undefined);
    private _allowConfigBasedIssuance?;
    get allowConfigBasedIssuance(): boolean | cdktf.IResolvable;
    set allowConfigBasedIssuance(value: boolean | cdktf.IResolvable);
    get allowConfigBasedIssuanceInput(): boolean | cdktf.IResolvable | undefined;
    private _allowCsrBasedIssuance?;
    get allowCsrBasedIssuance(): boolean | cdktf.IResolvable;
    set allowCsrBasedIssuance(value: boolean | cdktf.IResolvable);
    get allowCsrBasedIssuanceInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve {
    /**
    * The algorithm used. Possible values: ["ECDSA_P256", "ECDSA_P384", "EDDSA_25519"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#signature_algorithm PrivatecaCaPool#signature_algorithm}
    */
    readonly signatureAlgorithm: string;
}
export declare function privatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurveToTerraform(struct?: PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurveOutputReference | PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve): any;
export declare class PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve | undefined;
    set internalValue(value: PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve | undefined);
    private _signatureAlgorithm?;
    get signatureAlgorithm(): string;
    set signatureAlgorithm(value: string);
    get signatureAlgorithmInput(): string | undefined;
}
export interface PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa {
    /**
    * The maximum allowed RSA modulus size, in bits. If this is not set, or if set to zero, the
  service will not enforce an explicit upper bound on RSA modulus sizes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#max_modulus_size PrivatecaCaPool#max_modulus_size}
    */
    readonly maxModulusSize?: string;
    /**
    * The minimum allowed RSA modulus size, in bits. If this is not set, or if set to zero, the
  service-level min RSA modulus size will continue to apply.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#min_modulus_size PrivatecaCaPool#min_modulus_size}
    */
    readonly minModulusSize?: string;
}
export declare function privatecaCaPoolIssuancePolicyAllowedKeyTypesRsaToTerraform(struct?: PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsaOutputReference | PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa): any;
export declare class PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa | undefined;
    set internalValue(value: PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa | undefined);
    private _maxModulusSize?;
    get maxModulusSize(): string;
    set maxModulusSize(value: string);
    resetMaxModulusSize(): void;
    get maxModulusSizeInput(): string | undefined;
    private _minModulusSize?;
    get minModulusSize(): string;
    set minModulusSize(value: string);
    resetMinModulusSize(): void;
    get minModulusSizeInput(): string | undefined;
}
export interface PrivatecaCaPoolIssuancePolicyAllowedKeyTypes {
    /**
    * elliptic_curve block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#elliptic_curve PrivatecaCaPool#elliptic_curve}
    */
    readonly ellipticCurve?: PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve;
    /**
    * rsa block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#rsa PrivatecaCaPool#rsa}
    */
    readonly rsa?: PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa;
}
export declare function privatecaCaPoolIssuancePolicyAllowedKeyTypesToTerraform(struct?: PrivatecaCaPoolIssuancePolicyAllowedKeyTypes | cdktf.IResolvable): any;
export declare class PrivatecaCaPoolIssuancePolicyAllowedKeyTypesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PrivatecaCaPoolIssuancePolicyAllowedKeyTypes | cdktf.IResolvable | undefined;
    set internalValue(value: PrivatecaCaPoolIssuancePolicyAllowedKeyTypes | cdktf.IResolvable | undefined);
    private _ellipticCurve;
    get ellipticCurve(): PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurveOutputReference;
    putEllipticCurve(value: PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve): void;
    resetEllipticCurve(): void;
    get ellipticCurveInput(): PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve | undefined;
    private _rsa;
    get rsa(): PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsaOutputReference;
    putRsa(value: PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa): void;
    resetRsa(): void;
    get rsaInput(): PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa | undefined;
}
export declare class PrivatecaCaPoolIssuancePolicyAllowedKeyTypesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PrivatecaCaPoolIssuancePolicyAllowedKeyTypes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PrivatecaCaPoolIssuancePolicyAllowedKeyTypesOutputReference;
}
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId {
    /**
    * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#object_id_path PrivatecaCaPool#object_id_path}
    */
    readonly objectIdPath: number[];
}
export declare function privatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectIdToTerraform(struct?: PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectIdOutputReference | PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId): any;
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId | undefined;
    set internalValue(value: PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId | undefined);
    private _objectIdPath?;
    get objectIdPath(): number[];
    set objectIdPath(value: number[]);
    get objectIdPathInput(): number[] | undefined;
}
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions {
    /**
    * Indicates whether or not this extension is critical (i.e., if the client does not know how to
  handle this extension, the client should consider this to be an error).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#critical PrivatecaCaPool#critical}
    */
    readonly critical: boolean | cdktf.IResolvable;
    /**
    * The value of this X.509 extension. A base64-encoded string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#value PrivatecaCaPool#value}
    */
    readonly value: string;
    /**
    * object_id block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#object_id PrivatecaCaPool#object_id}
    */
    readonly objectId: PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId;
}
export declare function privatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsToTerraform(struct?: PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions | cdktf.IResolvable): any;
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions | cdktf.IResolvable | undefined;
    set internalValue(value: PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions | cdktf.IResolvable | undefined);
    private _critical?;
    get critical(): boolean | cdktf.IResolvable;
    set critical(value: boolean | cdktf.IResolvable);
    get criticalInput(): boolean | cdktf.IResolvable | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    private _objectId;
    get objectId(): PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectIdOutputReference;
    putObjectId(value: PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId): void;
    get objectIdInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId | undefined;
}
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsOutputReference;
}
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions {
    /**
    * When true, the "CA" in Basic Constraints extension will be set to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#is_ca PrivatecaCaPool#is_ca}
    */
    readonly isCa?: boolean | cdktf.IResolvable;
    /**
    * Refers to the "path length constraint" in Basic Constraints extension. For a CA certificate, this value describes the depth of
  subordinate CA certificates that are allowed. If this value is less than 0, the request will fail.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#max_issuer_path_length PrivatecaCaPool#max_issuer_path_length}
    */
    readonly maxIssuerPathLength?: number;
    /**
    * When true, the "CA" in Basic Constraints extension will be set to false.
  If both 'is_ca' and 'non_ca' are unset, the extension will be omitted from the CA certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#non_ca PrivatecaCaPool#non_ca}
    */
    readonly nonCa?: boolean | cdktf.IResolvable;
    /**
    * When true, the "path length constraint" in Basic Constraints extension will be set to 0.
  if both 'max_issuer_path_length' and 'zero_max_issuer_path_length' are unset,
  the max path length will be omitted from the CA certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#zero_max_issuer_path_length PrivatecaCaPool#zero_max_issuer_path_length}
    */
    readonly zeroMaxIssuerPathLength?: boolean | cdktf.IResolvable;
}
export declare function privatecaCaPoolIssuancePolicyBaselineValuesCaOptionsToTerraform(struct?: PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptionsOutputReference | PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions): any;
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions | undefined;
    set internalValue(value: PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions | undefined);
    private _isCa?;
    get isCa(): boolean | cdktf.IResolvable;
    set isCa(value: boolean | cdktf.IResolvable);
    resetIsCa(): void;
    get isCaInput(): boolean | cdktf.IResolvable | undefined;
    private _maxIssuerPathLength?;
    get maxIssuerPathLength(): number;
    set maxIssuerPathLength(value: number);
    resetMaxIssuerPathLength(): void;
    get maxIssuerPathLengthInput(): number | undefined;
    private _nonCa?;
    get nonCa(): boolean | cdktf.IResolvable;
    set nonCa(value: boolean | cdktf.IResolvable);
    resetNonCa(): void;
    get nonCaInput(): boolean | cdktf.IResolvable | undefined;
    private _zeroMaxIssuerPathLength?;
    get zeroMaxIssuerPathLength(): boolean | cdktf.IResolvable;
    set zeroMaxIssuerPathLength(value: boolean | cdktf.IResolvable);
    resetZeroMaxIssuerPathLength(): void;
    get zeroMaxIssuerPathLengthInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage {
    /**
    * The key may be used to sign certificates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#cert_sign PrivatecaCaPool#cert_sign}
    */
    readonly certSign?: boolean | cdktf.IResolvable;
    /**
    * The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#content_commitment PrivatecaCaPool#content_commitment}
    */
    readonly contentCommitment?: boolean | cdktf.IResolvable;
    /**
    * The key may be used sign certificate revocation lists.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#crl_sign PrivatecaCaPool#crl_sign}
    */
    readonly crlSign?: boolean | cdktf.IResolvable;
    /**
    * The key may be used to encipher data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#data_encipherment PrivatecaCaPool#data_encipherment}
    */
    readonly dataEncipherment?: boolean | cdktf.IResolvable;
    /**
    * The key may be used to decipher only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#decipher_only PrivatecaCaPool#decipher_only}
    */
    readonly decipherOnly?: boolean | cdktf.IResolvable;
    /**
    * The key may be used for digital signatures.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#digital_signature PrivatecaCaPool#digital_signature}
    */
    readonly digitalSignature?: boolean | cdktf.IResolvable;
    /**
    * The key may be used to encipher only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#encipher_only PrivatecaCaPool#encipher_only}
    */
    readonly encipherOnly?: boolean | cdktf.IResolvable;
    /**
    * The key may be used in a key agreement protocol.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#key_agreement PrivatecaCaPool#key_agreement}
    */
    readonly keyAgreement?: boolean | cdktf.IResolvable;
    /**
    * The key may be used to encipher other keys.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#key_encipherment PrivatecaCaPool#key_encipherment}
    */
    readonly keyEncipherment?: boolean | cdktf.IResolvable;
}
export declare function privatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsageToTerraform(struct?: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsageOutputReference | PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage): any;
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage | undefined;
    set internalValue(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage | undefined);
    private _certSign?;
    get certSign(): boolean | cdktf.IResolvable;
    set certSign(value: boolean | cdktf.IResolvable);
    resetCertSign(): void;
    get certSignInput(): boolean | cdktf.IResolvable | undefined;
    private _contentCommitment?;
    get contentCommitment(): boolean | cdktf.IResolvable;
    set contentCommitment(value: boolean | cdktf.IResolvable);
    resetContentCommitment(): void;
    get contentCommitmentInput(): boolean | cdktf.IResolvable | undefined;
    private _crlSign?;
    get crlSign(): boolean | cdktf.IResolvable;
    set crlSign(value: boolean | cdktf.IResolvable);
    resetCrlSign(): void;
    get crlSignInput(): boolean | cdktf.IResolvable | undefined;
    private _dataEncipherment?;
    get dataEncipherment(): boolean | cdktf.IResolvable;
    set dataEncipherment(value: boolean | cdktf.IResolvable);
    resetDataEncipherment(): void;
    get dataEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
    private _decipherOnly?;
    get decipherOnly(): boolean | cdktf.IResolvable;
    set decipherOnly(value: boolean | cdktf.IResolvable);
    resetDecipherOnly(): void;
    get decipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _digitalSignature?;
    get digitalSignature(): boolean | cdktf.IResolvable;
    set digitalSignature(value: boolean | cdktf.IResolvable);
    resetDigitalSignature(): void;
    get digitalSignatureInput(): boolean | cdktf.IResolvable | undefined;
    private _encipherOnly?;
    get encipherOnly(): boolean | cdktf.IResolvable;
    set encipherOnly(value: boolean | cdktf.IResolvable);
    resetEncipherOnly(): void;
    get encipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _keyAgreement?;
    get keyAgreement(): boolean | cdktf.IResolvable;
    set keyAgreement(value: boolean | cdktf.IResolvable);
    resetKeyAgreement(): void;
    get keyAgreementInput(): boolean | cdktf.IResolvable | undefined;
    private _keyEncipherment?;
    get keyEncipherment(): boolean | cdktf.IResolvable;
    set keyEncipherment(value: boolean | cdktf.IResolvable);
    resetKeyEncipherment(): void;
    get keyEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage {
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#client_auth PrivatecaCaPool#client_auth}
    */
    readonly clientAuth?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#code_signing PrivatecaCaPool#code_signing}
    */
    readonly codeSigning?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#email_protection PrivatecaCaPool#email_protection}
    */
    readonly emailProtection?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#ocsp_signing PrivatecaCaPool#ocsp_signing}
    */
    readonly ocspSigning?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#server_auth PrivatecaCaPool#server_auth}
    */
    readonly serverAuth?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#time_stamping PrivatecaCaPool#time_stamping}
    */
    readonly timeStamping?: boolean | cdktf.IResolvable;
}
export declare function privatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsageToTerraform(struct?: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsageOutputReference | PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage): any;
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage | undefined;
    set internalValue(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage | undefined);
    private _clientAuth?;
    get clientAuth(): boolean | cdktf.IResolvable;
    set clientAuth(value: boolean | cdktf.IResolvable);
    resetClientAuth(): void;
    get clientAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _codeSigning?;
    get codeSigning(): boolean | cdktf.IResolvable;
    set codeSigning(value: boolean | cdktf.IResolvable);
    resetCodeSigning(): void;
    get codeSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _emailProtection?;
    get emailProtection(): boolean | cdktf.IResolvable;
    set emailProtection(value: boolean | cdktf.IResolvable);
    resetEmailProtection(): void;
    get emailProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _ocspSigning?;
    get ocspSigning(): boolean | cdktf.IResolvable;
    set ocspSigning(value: boolean | cdktf.IResolvable);
    resetOcspSigning(): void;
    get ocspSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _serverAuth?;
    get serverAuth(): boolean | cdktf.IResolvable;
    set serverAuth(value: boolean | cdktf.IResolvable);
    resetServerAuth(): void;
    get serverAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _timeStamping?;
    get timeStamping(): boolean | cdktf.IResolvable;
    set timeStamping(value: boolean | cdktf.IResolvable);
    resetTimeStamping(): void;
    get timeStampingInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages {
    /**
    * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#object_id_path PrivatecaCaPool#object_id_path}
    */
    readonly objectIdPath: number[];
}
export declare function privatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsagesToTerraform(struct?: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages | cdktf.IResolvable): any;
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages | cdktf.IResolvable | undefined;
    set internalValue(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages | cdktf.IResolvable | undefined);
    private _objectIdPath?;
    get objectIdPath(): number[];
    set objectIdPath(value: number[]);
    get objectIdPathInput(): number[] | undefined;
}
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsagesOutputReference;
}
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage {
    /**
    * base_key_usage block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#base_key_usage PrivatecaCaPool#base_key_usage}
    */
    readonly baseKeyUsage: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage;
    /**
    * extended_key_usage block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#extended_key_usage PrivatecaCaPool#extended_key_usage}
    */
    readonly extendedKeyUsage: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage;
    /**
    * unknown_extended_key_usages block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#unknown_extended_key_usages PrivatecaCaPool#unknown_extended_key_usages}
    */
    readonly unknownExtendedKeyUsages?: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages[] | cdktf.IResolvable;
}
export declare function privatecaCaPoolIssuancePolicyBaselineValuesKeyUsageToTerraform(struct?: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageOutputReference | PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage): any;
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage | undefined;
    set internalValue(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage | undefined);
    private _baseKeyUsage;
    get baseKeyUsage(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsageOutputReference;
    putBaseKeyUsage(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage): void;
    get baseKeyUsageInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage | undefined;
    private _extendedKeyUsage;
    get extendedKeyUsage(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsageOutputReference;
    putExtendedKeyUsage(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage): void;
    get extendedKeyUsageInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage | undefined;
    private _unknownExtendedKeyUsages;
    get unknownExtendedKeyUsages(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsagesList;
    putUnknownExtendedKeyUsages(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages[] | cdktf.IResolvable): void;
    resetUnknownExtendedKeyUsages(): void;
    get unknownExtendedKeyUsagesInput(): cdktf.IResolvable | PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages[] | undefined;
}
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds {
    /**
    * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#object_id_path PrivatecaCaPool#object_id_path}
    */
    readonly objectIdPath: number[];
}
export declare function privatecaCaPoolIssuancePolicyBaselineValuesPolicyIdsToTerraform(struct?: PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds | cdktf.IResolvable): any;
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIdsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds | cdktf.IResolvable | undefined;
    set internalValue(value: PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds | cdktf.IResolvable | undefined);
    private _objectIdPath?;
    get objectIdPath(): number[];
    set objectIdPath(value: number[]);
    get objectIdPathInput(): number[] | undefined;
}
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIdsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIdsOutputReference;
}
export interface PrivatecaCaPoolIssuancePolicyBaselineValues {
    /**
    * Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the
  "Authority Information Access" extension in the certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#aia_ocsp_servers PrivatecaCaPool#aia_ocsp_servers}
    */
    readonly aiaOcspServers?: string[];
    /**
    * additional_extensions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#additional_extensions PrivatecaCaPool#additional_extensions}
    */
    readonly additionalExtensions?: PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions[] | cdktf.IResolvable;
    /**
    * ca_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#ca_options PrivatecaCaPool#ca_options}
    */
    readonly caOptions: PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions;
    /**
    * key_usage block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#key_usage PrivatecaCaPool#key_usage}
    */
    readonly keyUsage: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage;
    /**
    * policy_ids block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#policy_ids PrivatecaCaPool#policy_ids}
    */
    readonly policyIds?: PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds[] | cdktf.IResolvable;
}
export declare function privatecaCaPoolIssuancePolicyBaselineValuesToTerraform(struct?: PrivatecaCaPoolIssuancePolicyBaselineValuesOutputReference | PrivatecaCaPoolIssuancePolicyBaselineValues): any;
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCaPoolIssuancePolicyBaselineValues | undefined;
    set internalValue(value: PrivatecaCaPoolIssuancePolicyBaselineValues | undefined);
    private _aiaOcspServers?;
    get aiaOcspServers(): string[];
    set aiaOcspServers(value: string[]);
    resetAiaOcspServers(): void;
    get aiaOcspServersInput(): string[] | undefined;
    private _additionalExtensions;
    get additionalExtensions(): PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsList;
    putAdditionalExtensions(value: PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions[] | cdktf.IResolvable): void;
    resetAdditionalExtensions(): void;
    get additionalExtensionsInput(): cdktf.IResolvable | PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions[] | undefined;
    private _caOptions;
    get caOptions(): PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptionsOutputReference;
    putCaOptions(value: PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions): void;
    get caOptionsInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions | undefined;
    private _keyUsage;
    get keyUsage(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageOutputReference;
    putKeyUsage(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage): void;
    get keyUsageInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage | undefined;
    private _policyIds;
    get policyIds(): PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIdsList;
    putPolicyIds(value: PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds[] | cdktf.IResolvable): void;
    resetPolicyIds(): void;
    get policyIdsInput(): cdktf.IResolvable | PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds[] | undefined;
}
export interface PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression {
    /**
    * Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#description PrivatecaCaPool#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#expression PrivatecaCaPool#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#location PrivatecaCaPool#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#title PrivatecaCaPool#title}
    */
    readonly title?: string;
}
export declare function privatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionToTerraform(struct?: PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionOutputReference | PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression): any;
export declare class PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression | undefined;
    set internalValue(value: PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface PrivatecaCaPoolIssuancePolicyIdentityConstraints {
    /**
    * If this is set, the SubjectAltNames extension may be copied from a certificate request into the signed certificate.
  Otherwise, the requested SubjectAltNames will be discarded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#allow_subject_alt_names_passthrough PrivatecaCaPool#allow_subject_alt_names_passthrough}
    */
    readonly allowSubjectAltNamesPassthrough: boolean | cdktf.IResolvable;
    /**
    * If this is set, the Subject field may be copied from a certificate request into the signed certificate.
  Otherwise, the requested Subject will be discarded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#allow_subject_passthrough PrivatecaCaPool#allow_subject_passthrough}
    */
    readonly allowSubjectPassthrough: boolean | cdktf.IResolvable;
    /**
    * cel_expression block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#cel_expression PrivatecaCaPool#cel_expression}
    */
    readonly celExpression?: PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression;
}
export declare function privatecaCaPoolIssuancePolicyIdentityConstraintsToTerraform(struct?: PrivatecaCaPoolIssuancePolicyIdentityConstraintsOutputReference | PrivatecaCaPoolIssuancePolicyIdentityConstraints): any;
export declare class PrivatecaCaPoolIssuancePolicyIdentityConstraintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCaPoolIssuancePolicyIdentityConstraints | undefined;
    set internalValue(value: PrivatecaCaPoolIssuancePolicyIdentityConstraints | undefined);
    private _allowSubjectAltNamesPassthrough?;
    get allowSubjectAltNamesPassthrough(): boolean | cdktf.IResolvable;
    set allowSubjectAltNamesPassthrough(value: boolean | cdktf.IResolvable);
    get allowSubjectAltNamesPassthroughInput(): boolean | cdktf.IResolvable | undefined;
    private _allowSubjectPassthrough?;
    get allowSubjectPassthrough(): boolean | cdktf.IResolvable;
    set allowSubjectPassthrough(value: boolean | cdktf.IResolvable);
    get allowSubjectPassthroughInput(): boolean | cdktf.IResolvable | undefined;
    private _celExpression;
    get celExpression(): PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionOutputReference;
    putCelExpression(value: PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression): void;
    resetCelExpression(): void;
    get celExpressionInput(): PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression | undefined;
}
export interface PrivatecaCaPoolIssuancePolicy {
    /**
    * The maximum lifetime allowed for issued Certificates. Note that if the issuing CertificateAuthority
  expires before a Certificate's requested maximumLifetime, the effective lifetime will be explicitly truncated to match it.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#maximum_lifetime PrivatecaCaPool#maximum_lifetime}
    */
    readonly maximumLifetime?: string;
    /**
    * allowed_issuance_modes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#allowed_issuance_modes PrivatecaCaPool#allowed_issuance_modes}
    */
    readonly allowedIssuanceModes?: PrivatecaCaPoolIssuancePolicyAllowedIssuanceModes;
    /**
    * allowed_key_types block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#allowed_key_types PrivatecaCaPool#allowed_key_types}
    */
    readonly allowedKeyTypes?: PrivatecaCaPoolIssuancePolicyAllowedKeyTypes[] | cdktf.IResolvable;
    /**
    * baseline_values block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#baseline_values PrivatecaCaPool#baseline_values}
    */
    readonly baselineValues?: PrivatecaCaPoolIssuancePolicyBaselineValues;
    /**
    * identity_constraints block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#identity_constraints PrivatecaCaPool#identity_constraints}
    */
    readonly identityConstraints?: PrivatecaCaPoolIssuancePolicyIdentityConstraints;
}
export declare function privatecaCaPoolIssuancePolicyToTerraform(struct?: PrivatecaCaPoolIssuancePolicyOutputReference | PrivatecaCaPoolIssuancePolicy): any;
export declare class PrivatecaCaPoolIssuancePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCaPoolIssuancePolicy | undefined;
    set internalValue(value: PrivatecaCaPoolIssuancePolicy | undefined);
    private _maximumLifetime?;
    get maximumLifetime(): string;
    set maximumLifetime(value: string);
    resetMaximumLifetime(): void;
    get maximumLifetimeInput(): string | undefined;
    private _allowedIssuanceModes;
    get allowedIssuanceModes(): PrivatecaCaPoolIssuancePolicyAllowedIssuanceModesOutputReference;
    putAllowedIssuanceModes(value: PrivatecaCaPoolIssuancePolicyAllowedIssuanceModes): void;
    resetAllowedIssuanceModes(): void;
    get allowedIssuanceModesInput(): PrivatecaCaPoolIssuancePolicyAllowedIssuanceModes | undefined;
    private _allowedKeyTypes;
    get allowedKeyTypes(): PrivatecaCaPoolIssuancePolicyAllowedKeyTypesList;
    putAllowedKeyTypes(value: PrivatecaCaPoolIssuancePolicyAllowedKeyTypes[] | cdktf.IResolvable): void;
    resetAllowedKeyTypes(): void;
    get allowedKeyTypesInput(): cdktf.IResolvable | PrivatecaCaPoolIssuancePolicyAllowedKeyTypes[] | undefined;
    private _baselineValues;
    get baselineValues(): PrivatecaCaPoolIssuancePolicyBaselineValuesOutputReference;
    putBaselineValues(value: PrivatecaCaPoolIssuancePolicyBaselineValues): void;
    resetBaselineValues(): void;
    get baselineValuesInput(): PrivatecaCaPoolIssuancePolicyBaselineValues | undefined;
    private _identityConstraints;
    get identityConstraints(): PrivatecaCaPoolIssuancePolicyIdentityConstraintsOutputReference;
    putIdentityConstraints(value: PrivatecaCaPoolIssuancePolicyIdentityConstraints): void;
    resetIdentityConstraints(): void;
    get identityConstraintsInput(): PrivatecaCaPoolIssuancePolicyIdentityConstraints | undefined;
}
export interface PrivatecaCaPoolPublishingOptions {
    /**
    * When true, publishes each CertificateAuthority's CA certificate and includes its URL in the "Authority Information Access"
  X.509 extension in all issued Certificates. If this is false, the CA certificate will not be published and the corresponding
  X.509 extension will not be written in issued certificates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#publish_ca_cert PrivatecaCaPool#publish_ca_cert}
    */
    readonly publishCaCert: boolean | cdktf.IResolvable;
    /**
    * When true, publishes each CertificateAuthority's CRL and includes its URL in the "CRL Distribution Points" X.509 extension
  in all issued Certificates. If this is false, CRLs will not be published and the corresponding X.509 extension will not
  be written in issued certificates. CRLs will expire 7 days from their creation. However, we will rebuild daily. CRLs are
  also rebuilt shortly after a certificate is revoked.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#publish_crl PrivatecaCaPool#publish_crl}
    */
    readonly publishCrl: boolean | cdktf.IResolvable;
}
export declare function privatecaCaPoolPublishingOptionsToTerraform(struct?: PrivatecaCaPoolPublishingOptionsOutputReference | PrivatecaCaPoolPublishingOptions): any;
export declare class PrivatecaCaPoolPublishingOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCaPoolPublishingOptions | undefined;
    set internalValue(value: PrivatecaCaPoolPublishingOptions | undefined);
    private _publishCaCert?;
    get publishCaCert(): boolean | cdktf.IResolvable;
    set publishCaCert(value: boolean | cdktf.IResolvable);
    get publishCaCertInput(): boolean | cdktf.IResolvable | undefined;
    private _publishCrl?;
    get publishCrl(): boolean | cdktf.IResolvable;
    set publishCrl(value: boolean | cdktf.IResolvable);
    get publishCrlInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PrivatecaCaPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#create PrivatecaCaPool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#delete PrivatecaCaPool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#update PrivatecaCaPool#update}
    */
    readonly update?: string;
}
export declare function privatecaCaPoolTimeoutsToTerraform(struct?: PrivatecaCaPoolTimeoutsOutputReference | PrivatecaCaPoolTimeouts | cdktf.IResolvable): any;
export declare class PrivatecaCaPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCaPoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PrivatecaCaPoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool google_privateca_ca_pool}
*/
export declare class PrivatecaCaPool extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_privateca_ca_pool";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool google_privateca_ca_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PrivatecaCaPoolConfig
    */
    constructor(scope: Construct, id: string, config: PrivatecaCaPoolConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    get tierInput(): string | undefined;
    private _issuancePolicy;
    get issuancePolicy(): PrivatecaCaPoolIssuancePolicyOutputReference;
    putIssuancePolicy(value: PrivatecaCaPoolIssuancePolicy): void;
    resetIssuancePolicy(): void;
    get issuancePolicyInput(): PrivatecaCaPoolIssuancePolicy | undefined;
    private _publishingOptions;
    get publishingOptions(): PrivatecaCaPoolPublishingOptionsOutputReference;
    putPublishingOptions(value: PrivatecaCaPoolPublishingOptions): void;
    resetPublishingOptions(): void;
    get publishingOptionsInput(): PrivatecaCaPoolPublishingOptions | undefined;
    private _timeouts;
    get timeouts(): PrivatecaCaPoolTimeoutsOutputReference;
    putTimeouts(value: PrivatecaCaPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PrivatecaCaPoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
