"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PubsubSubscription = exports.PubsubSubscriptionTimeoutsOutputReference = exports.pubsubSubscriptionTimeoutsToTerraform = exports.PubsubSubscriptionRetryPolicyOutputReference = exports.pubsubSubscriptionRetryPolicyToTerraform = exports.PubsubSubscriptionPushConfigOutputReference = exports.pubsubSubscriptionPushConfigToTerraform = exports.PubsubSubscriptionPushConfigOidcTokenOutputReference = exports.pubsubSubscriptionPushConfigOidcTokenToTerraform = exports.PubsubSubscriptionExpirationPolicyOutputReference = exports.pubsubSubscriptionExpirationPolicyToTerraform = exports.PubsubSubscriptionDeadLetterPolicyOutputReference = exports.pubsubSubscriptionDeadLetterPolicyToTerraform = exports.PubsubSubscriptionBigqueryConfigOutputReference = exports.pubsubSubscriptionBigqueryConfigToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function pubsubSubscriptionBigqueryConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        drop_unknown_fields: cdktf.booleanToTerraform(struct.dropUnknownFields),
        table: cdktf.stringToTerraform(struct.table),
        use_topic_schema: cdktf.booleanToTerraform(struct.useTopicSchema),
        write_metadata: cdktf.booleanToTerraform(struct.writeMetadata),
    };
}
exports.pubsubSubscriptionBigqueryConfigToTerraform = pubsubSubscriptionBigqueryConfigToTerraform;
class PubsubSubscriptionBigqueryConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._dropUnknownFields !== undefined) {
            hasAnyValues = true;
            internalValueResult.dropUnknownFields = this._dropUnknownFields;
        }
        if (this._table !== undefined) {
            hasAnyValues = true;
            internalValueResult.table = this._table;
        }
        if (this._useTopicSchema !== undefined) {
            hasAnyValues = true;
            internalValueResult.useTopicSchema = this._useTopicSchema;
        }
        if (this._writeMetadata !== undefined) {
            hasAnyValues = true;
            internalValueResult.writeMetadata = this._writeMetadata;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._dropUnknownFields = undefined;
            this._table = undefined;
            this._useTopicSchema = undefined;
            this._writeMetadata = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._dropUnknownFields = value.dropUnknownFields;
            this._table = value.table;
            this._useTopicSchema = value.useTopicSchema;
            this._writeMetadata = value.writeMetadata;
        }
    }
    get dropUnknownFields() {
        return this.getBooleanAttribute('drop_unknown_fields');
    }
    set dropUnknownFields(value) {
        this._dropUnknownFields = value;
    }
    resetDropUnknownFields() {
        this._dropUnknownFields = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dropUnknownFieldsInput() {
        return this._dropUnknownFields;
    }
    get table() {
        return this.getStringAttribute('table');
    }
    set table(value) {
        this._table = value;
    }
    // Temporarily expose input value. Use with caution.
    get tableInput() {
        return this._table;
    }
    get useTopicSchema() {
        return this.getBooleanAttribute('use_topic_schema');
    }
    set useTopicSchema(value) {
        this._useTopicSchema = value;
    }
    resetUseTopicSchema() {
        this._useTopicSchema = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useTopicSchemaInput() {
        return this._useTopicSchema;
    }
    get writeMetadata() {
        return this.getBooleanAttribute('write_metadata');
    }
    set writeMetadata(value) {
        this._writeMetadata = value;
    }
    resetWriteMetadata() {
        this._writeMetadata = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get writeMetadataInput() {
        return this._writeMetadata;
    }
}
exports.PubsubSubscriptionBigqueryConfigOutputReference = PubsubSubscriptionBigqueryConfigOutputReference;
_a = JSII_RTTI_SYMBOL_1;
PubsubSubscriptionBigqueryConfigOutputReference[_a] = { fqn: "@cdktf/provider-google.PubsubSubscriptionBigqueryConfigOutputReference", version: "2.0.15" };
function pubsubSubscriptionDeadLetterPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        dead_letter_topic: cdktf.stringToTerraform(struct.deadLetterTopic),
        max_delivery_attempts: cdktf.numberToTerraform(struct.maxDeliveryAttempts),
    };
}
exports.pubsubSubscriptionDeadLetterPolicyToTerraform = pubsubSubscriptionDeadLetterPolicyToTerraform;
class PubsubSubscriptionDeadLetterPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._deadLetterTopic !== undefined) {
            hasAnyValues = true;
            internalValueResult.deadLetterTopic = this._deadLetterTopic;
        }
        if (this._maxDeliveryAttempts !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxDeliveryAttempts = this._maxDeliveryAttempts;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._deadLetterTopic = undefined;
            this._maxDeliveryAttempts = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._deadLetterTopic = value.deadLetterTopic;
            this._maxDeliveryAttempts = value.maxDeliveryAttempts;
        }
    }
    get deadLetterTopic() {
        return this.getStringAttribute('dead_letter_topic');
    }
    set deadLetterTopic(value) {
        this._deadLetterTopic = value;
    }
    resetDeadLetterTopic() {
        this._deadLetterTopic = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deadLetterTopicInput() {
        return this._deadLetterTopic;
    }
    get maxDeliveryAttempts() {
        return this.getNumberAttribute('max_delivery_attempts');
    }
    set maxDeliveryAttempts(value) {
        this._maxDeliveryAttempts = value;
    }
    resetMaxDeliveryAttempts() {
        this._maxDeliveryAttempts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxDeliveryAttemptsInput() {
        return this._maxDeliveryAttempts;
    }
}
exports.PubsubSubscriptionDeadLetterPolicyOutputReference = PubsubSubscriptionDeadLetterPolicyOutputReference;
_b = JSII_RTTI_SYMBOL_1;
PubsubSubscriptionDeadLetterPolicyOutputReference[_b] = { fqn: "@cdktf/provider-google.PubsubSubscriptionDeadLetterPolicyOutputReference", version: "2.0.15" };
function pubsubSubscriptionExpirationPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        ttl: cdktf.stringToTerraform(struct.ttl),
    };
}
exports.pubsubSubscriptionExpirationPolicyToTerraform = pubsubSubscriptionExpirationPolicyToTerraform;
class PubsubSubscriptionExpirationPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._ttl !== undefined) {
            hasAnyValues = true;
            internalValueResult.ttl = this._ttl;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._ttl = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._ttl = value.ttl;
        }
    }
    get ttl() {
        return this.getStringAttribute('ttl');
    }
    set ttl(value) {
        this._ttl = value;
    }
    // Temporarily expose input value. Use with caution.
    get ttlInput() {
        return this._ttl;
    }
}
exports.PubsubSubscriptionExpirationPolicyOutputReference = PubsubSubscriptionExpirationPolicyOutputReference;
_c = JSII_RTTI_SYMBOL_1;
PubsubSubscriptionExpirationPolicyOutputReference[_c] = { fqn: "@cdktf/provider-google.PubsubSubscriptionExpirationPolicyOutputReference", version: "2.0.15" };
function pubsubSubscriptionPushConfigOidcTokenToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        audience: cdktf.stringToTerraform(struct.audience),
        service_account_email: cdktf.stringToTerraform(struct.serviceAccountEmail),
    };
}
exports.pubsubSubscriptionPushConfigOidcTokenToTerraform = pubsubSubscriptionPushConfigOidcTokenToTerraform;
class PubsubSubscriptionPushConfigOidcTokenOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._audience !== undefined) {
            hasAnyValues = true;
            internalValueResult.audience = this._audience;
        }
        if (this._serviceAccountEmail !== undefined) {
            hasAnyValues = true;
            internalValueResult.serviceAccountEmail = this._serviceAccountEmail;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._audience = undefined;
            this._serviceAccountEmail = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._audience = value.audience;
            this._serviceAccountEmail = value.serviceAccountEmail;
        }
    }
    get audience() {
        return this.getStringAttribute('audience');
    }
    set audience(value) {
        this._audience = value;
    }
    resetAudience() {
        this._audience = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get audienceInput() {
        return this._audience;
    }
    get serviceAccountEmail() {
        return this.getStringAttribute('service_account_email');
    }
    set serviceAccountEmail(value) {
        this._serviceAccountEmail = value;
    }
    // Temporarily expose input value. Use with caution.
    get serviceAccountEmailInput() {
        return this._serviceAccountEmail;
    }
}
exports.PubsubSubscriptionPushConfigOidcTokenOutputReference = PubsubSubscriptionPushConfigOidcTokenOutputReference;
_d = JSII_RTTI_SYMBOL_1;
PubsubSubscriptionPushConfigOidcTokenOutputReference[_d] = { fqn: "@cdktf/provider-google.PubsubSubscriptionPushConfigOidcTokenOutputReference", version: "2.0.15" };
function pubsubSubscriptionPushConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        attributes: cdktf.hashMapper(cdktf.stringToTerraform)(struct.attributes),
        push_endpoint: cdktf.stringToTerraform(struct.pushEndpoint),
        oidc_token: pubsubSubscriptionPushConfigOidcTokenToTerraform(struct.oidcToken),
    };
}
exports.pubsubSubscriptionPushConfigToTerraform = pubsubSubscriptionPushConfigToTerraform;
class PubsubSubscriptionPushConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // oidc_token - computed: false, optional: true, required: false
        this._oidcToken = new PubsubSubscriptionPushConfigOidcTokenOutputReference(this, "oidc_token");
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._attributes !== undefined) {
            hasAnyValues = true;
            internalValueResult.attributes = this._attributes;
        }
        if (this._pushEndpoint !== undefined) {
            hasAnyValues = true;
            internalValueResult.pushEndpoint = this._pushEndpoint;
        }
        if (this._oidcToken?.internalValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.oidcToken = this._oidcToken?.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._attributes = undefined;
            this._pushEndpoint = undefined;
            this._oidcToken.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._attributes = value.attributes;
            this._pushEndpoint = value.pushEndpoint;
            this._oidcToken.internalValue = value.oidcToken;
        }
    }
    get attributes() {
        return this.getStringMapAttribute('attributes');
    }
    set attributes(value) {
        this._attributes = value;
    }
    resetAttributes() {
        this._attributes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get attributesInput() {
        return this._attributes;
    }
    get pushEndpoint() {
        return this.getStringAttribute('push_endpoint');
    }
    set pushEndpoint(value) {
        this._pushEndpoint = value;
    }
    // Temporarily expose input value. Use with caution.
    get pushEndpointInput() {
        return this._pushEndpoint;
    }
    get oidcToken() {
        return this._oidcToken;
    }
    putOidcToken(value) {
        this._oidcToken.internalValue = value;
    }
    resetOidcToken() {
        this._oidcToken.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcTokenInput() {
        return this._oidcToken.internalValue;
    }
}
exports.PubsubSubscriptionPushConfigOutputReference = PubsubSubscriptionPushConfigOutputReference;
_e = JSII_RTTI_SYMBOL_1;
PubsubSubscriptionPushConfigOutputReference[_e] = { fqn: "@cdktf/provider-google.PubsubSubscriptionPushConfigOutputReference", version: "2.0.15" };
function pubsubSubscriptionRetryPolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        maximum_backoff: cdktf.stringToTerraform(struct.maximumBackoff),
        minimum_backoff: cdktf.stringToTerraform(struct.minimumBackoff),
    };
}
exports.pubsubSubscriptionRetryPolicyToTerraform = pubsubSubscriptionRetryPolicyToTerraform;
class PubsubSubscriptionRetryPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._maximumBackoff !== undefined) {
            hasAnyValues = true;
            internalValueResult.maximumBackoff = this._maximumBackoff;
        }
        if (this._minimumBackoff !== undefined) {
            hasAnyValues = true;
            internalValueResult.minimumBackoff = this._minimumBackoff;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._maximumBackoff = undefined;
            this._minimumBackoff = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._maximumBackoff = value.maximumBackoff;
            this._minimumBackoff = value.minimumBackoff;
        }
    }
    get maximumBackoff() {
        return this.getStringAttribute('maximum_backoff');
    }
    set maximumBackoff(value) {
        this._maximumBackoff = value;
    }
    resetMaximumBackoff() {
        this._maximumBackoff = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maximumBackoffInput() {
        return this._maximumBackoff;
    }
    get minimumBackoff() {
        return this.getStringAttribute('minimum_backoff');
    }
    set minimumBackoff(value) {
        this._minimumBackoff = value;
    }
    resetMinimumBackoff() {
        this._minimumBackoff = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minimumBackoffInput() {
        return this._minimumBackoff;
    }
}
exports.PubsubSubscriptionRetryPolicyOutputReference = PubsubSubscriptionRetryPolicyOutputReference;
_f = JSII_RTTI_SYMBOL_1;
PubsubSubscriptionRetryPolicyOutputReference[_f] = { fqn: "@cdktf/provider-google.PubsubSubscriptionRetryPolicyOutputReference", version: "2.0.15" };
function pubsubSubscriptionTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.pubsubSubscriptionTimeoutsToTerraform = pubsubSubscriptionTimeoutsToTerraform;
class PubsubSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.PubsubSubscriptionTimeoutsOutputReference = PubsubSubscriptionTimeoutsOutputReference;
_g = JSII_RTTI_SYMBOL_1;
PubsubSubscriptionTimeoutsOutputReference[_g] = { fqn: "@cdktf/provider-google.PubsubSubscriptionTimeoutsOutputReference", version: "2.0.15" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription google_pubsub_subscription}
*/
class PubsubSubscription extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/pubsub_subscription google_pubsub_subscription} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PubsubSubscriptionConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'google_pubsub_subscription',
            terraformGeneratorMetadata: {
                providerName: 'google',
                providerVersion: '4.34.0',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // bigquery_config - computed: false, optional: true, required: false
        this._bigqueryConfig = new PubsubSubscriptionBigqueryConfigOutputReference(this, "bigquery_config");
        // dead_letter_policy - computed: false, optional: true, required: false
        this._deadLetterPolicy = new PubsubSubscriptionDeadLetterPolicyOutputReference(this, "dead_letter_policy");
        // expiration_policy - computed: false, optional: true, required: false
        this._expirationPolicy = new PubsubSubscriptionExpirationPolicyOutputReference(this, "expiration_policy");
        // push_config - computed: false, optional: true, required: false
        this._pushConfig = new PubsubSubscriptionPushConfigOutputReference(this, "push_config");
        // retry_policy - computed: false, optional: true, required: false
        this._retryPolicy = new PubsubSubscriptionRetryPolicyOutputReference(this, "retry_policy");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new PubsubSubscriptionTimeoutsOutputReference(this, "timeouts");
        this._ackDeadlineSeconds = config.ackDeadlineSeconds;
        this._enableExactlyOnceDelivery = config.enableExactlyOnceDelivery;
        this._enableMessageOrdering = config.enableMessageOrdering;
        this._filter = config.filter;
        this._id = config.id;
        this._labels = config.labels;
        this._messageRetentionDuration = config.messageRetentionDuration;
        this._name = config.name;
        this._project = config.project;
        this._retainAckedMessages = config.retainAckedMessages;
        this._topic = config.topic;
        this._bigqueryConfig.internalValue = config.bigqueryConfig;
        this._deadLetterPolicy.internalValue = config.deadLetterPolicy;
        this._expirationPolicy.internalValue = config.expirationPolicy;
        this._pushConfig.internalValue = config.pushConfig;
        this._retryPolicy.internalValue = config.retryPolicy;
        this._timeouts.internalValue = config.timeouts;
    }
    get ackDeadlineSeconds() {
        return this.getNumberAttribute('ack_deadline_seconds');
    }
    set ackDeadlineSeconds(value) {
        this._ackDeadlineSeconds = value;
    }
    resetAckDeadlineSeconds() {
        this._ackDeadlineSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ackDeadlineSecondsInput() {
        return this._ackDeadlineSeconds;
    }
    get enableExactlyOnceDelivery() {
        return this.getBooleanAttribute('enable_exactly_once_delivery');
    }
    set enableExactlyOnceDelivery(value) {
        this._enableExactlyOnceDelivery = value;
    }
    resetEnableExactlyOnceDelivery() {
        this._enableExactlyOnceDelivery = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableExactlyOnceDeliveryInput() {
        return this._enableExactlyOnceDelivery;
    }
    get enableMessageOrdering() {
        return this.getBooleanAttribute('enable_message_ordering');
    }
    set enableMessageOrdering(value) {
        this._enableMessageOrdering = value;
    }
    resetEnableMessageOrdering() {
        this._enableMessageOrdering = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableMessageOrderingInput() {
        return this._enableMessageOrdering;
    }
    get filter() {
        return this.getStringAttribute('filter');
    }
    set filter(value) {
        this._filter = value;
    }
    resetFilter() {
        this._filter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get filterInput() {
        return this._filter;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get labels() {
        return this.getStringMapAttribute('labels');
    }
    set labels(value) {
        this._labels = value;
    }
    resetLabels() {
        this._labels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get labelsInput() {
        return this._labels;
    }
    get messageRetentionDuration() {
        return this.getStringAttribute('message_retention_duration');
    }
    set messageRetentionDuration(value) {
        this._messageRetentionDuration = value;
    }
    resetMessageRetentionDuration() {
        this._messageRetentionDuration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get messageRetentionDurationInput() {
        return this._messageRetentionDuration;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get project() {
        return this.getStringAttribute('project');
    }
    set project(value) {
        this._project = value;
    }
    resetProject() {
        this._project = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get projectInput() {
        return this._project;
    }
    get retainAckedMessages() {
        return this.getBooleanAttribute('retain_acked_messages');
    }
    set retainAckedMessages(value) {
        this._retainAckedMessages = value;
    }
    resetRetainAckedMessages() {
        this._retainAckedMessages = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get retainAckedMessagesInput() {
        return this._retainAckedMessages;
    }
    get topic() {
        return this.getStringAttribute('topic');
    }
    set topic(value) {
        this._topic = value;
    }
    // Temporarily expose input value. Use with caution.
    get topicInput() {
        return this._topic;
    }
    get bigqueryConfig() {
        return this._bigqueryConfig;
    }
    putBigqueryConfig(value) {
        this._bigqueryConfig.internalValue = value;
    }
    resetBigqueryConfig() {
        this._bigqueryConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bigqueryConfigInput() {
        return this._bigqueryConfig.internalValue;
    }
    get deadLetterPolicy() {
        return this._deadLetterPolicy;
    }
    putDeadLetterPolicy(value) {
        this._deadLetterPolicy.internalValue = value;
    }
    resetDeadLetterPolicy() {
        this._deadLetterPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deadLetterPolicyInput() {
        return this._deadLetterPolicy.internalValue;
    }
    get expirationPolicy() {
        return this._expirationPolicy;
    }
    putExpirationPolicy(value) {
        this._expirationPolicy.internalValue = value;
    }
    resetExpirationPolicy() {
        this._expirationPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get expirationPolicyInput() {
        return this._expirationPolicy.internalValue;
    }
    get pushConfig() {
        return this._pushConfig;
    }
    putPushConfig(value) {
        this._pushConfig.internalValue = value;
    }
    resetPushConfig() {
        this._pushConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pushConfigInput() {
        return this._pushConfig.internalValue;
    }
    get retryPolicy() {
        return this._retryPolicy;
    }
    putRetryPolicy(value) {
        this._retryPolicy.internalValue = value;
    }
    resetRetryPolicy() {
        this._retryPolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get retryPolicyInput() {
        return this._retryPolicy.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            ack_deadline_seconds: cdktf.numberToTerraform(this._ackDeadlineSeconds),
            enable_exactly_once_delivery: cdktf.booleanToTerraform(this._enableExactlyOnceDelivery),
            enable_message_ordering: cdktf.booleanToTerraform(this._enableMessageOrdering),
            filter: cdktf.stringToTerraform(this._filter),
            id: cdktf.stringToTerraform(this._id),
            labels: cdktf.hashMapper(cdktf.stringToTerraform)(this._labels),
            message_retention_duration: cdktf.stringToTerraform(this._messageRetentionDuration),
            name: cdktf.stringToTerraform(this._name),
            project: cdktf.stringToTerraform(this._project),
            retain_acked_messages: cdktf.booleanToTerraform(this._retainAckedMessages),
            topic: cdktf.stringToTerraform(this._topic),
            bigquery_config: pubsubSubscriptionBigqueryConfigToTerraform(this._bigqueryConfig.internalValue),
            dead_letter_policy: pubsubSubscriptionDeadLetterPolicyToTerraform(this._deadLetterPolicy.internalValue),
            expiration_policy: pubsubSubscriptionExpirationPolicyToTerraform(this._expirationPolicy.internalValue),
            push_config: pubsubSubscriptionPushConfigToTerraform(this._pushConfig.internalValue),
            retry_policy: pubsubSubscriptionRetryPolicyToTerraform(this._retryPolicy.internalValue),
            timeouts: pubsubSubscriptionTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.PubsubSubscription = PubsubSubscription;
_h = JSII_RTTI_SYMBOL_1;
PubsubSubscription[_h] = { fqn: "@cdktf/provider-google.PubsubSubscription", version: "2.0.15" };
// =================
// STATIC PROPERTIES
// =================
PubsubSubscription.tfResourceType = "google_pubsub_subscription";
//# sourceMappingURL=data:application/json;base64,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