import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceNetworkingPeeredDnsDomainConfig extends cdktf.TerraformMetaArguments {
    /**
    * The DNS domain name suffix of the peered DNS domain.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain#dns_suffix ServiceNetworkingPeeredDnsDomain#dns_suffix}
    */
    readonly dnsSuffix: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain#id ServiceNetworkingPeeredDnsDomain#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the peered DNS domain.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain#name ServiceNetworkingPeeredDnsDomain#name}
    */
    readonly name: string;
    /**
    * Network in the consumer project to peer with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain#network ServiceNetworkingPeeredDnsDomain#network}
    */
    readonly network: string;
    /**
    * The ID of the project that the service account will be created in. Defaults to the provider project configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain#project ServiceNetworkingPeeredDnsDomain#project}
    */
    readonly project?: string;
    /**
    * The name of the service to create a peered DNS domain for, e.g. servicenetworking.googleapis.com
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain#service ServiceNetworkingPeeredDnsDomain#service}
    */
    readonly service?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain#timeouts ServiceNetworkingPeeredDnsDomain#timeouts}
    */
    readonly timeouts?: ServiceNetworkingPeeredDnsDomainTimeouts;
}
export interface ServiceNetworkingPeeredDnsDomainTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain#create ServiceNetworkingPeeredDnsDomain#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain#delete ServiceNetworkingPeeredDnsDomain#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain#read ServiceNetworkingPeeredDnsDomain#read}
    */
    readonly read?: string;
}
export declare function serviceNetworkingPeeredDnsDomainTimeoutsToTerraform(struct?: ServiceNetworkingPeeredDnsDomainTimeoutsOutputReference | ServiceNetworkingPeeredDnsDomainTimeouts | cdktf.IResolvable): any;
export declare class ServiceNetworkingPeeredDnsDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceNetworkingPeeredDnsDomainTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ServiceNetworkingPeeredDnsDomainTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain google_service_networking_peered_dns_domain}
*/
export declare class ServiceNetworkingPeeredDnsDomain extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_service_networking_peered_dns_domain";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/service_networking_peered_dns_domain google_service_networking_peered_dns_domain} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceNetworkingPeeredDnsDomainConfig
    */
    constructor(scope: Construct, id: string, config: ServiceNetworkingPeeredDnsDomainConfig);
    private _dnsSuffix?;
    get dnsSuffix(): string;
    set dnsSuffix(value: string);
    get dnsSuffixInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    get parent(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
    private _timeouts;
    get timeouts(): ServiceNetworkingPeeredDnsDomainTimeoutsOutputReference;
    putTimeouts(value: ServiceNetworkingPeeredDnsDomainTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ServiceNetworkingPeeredDnsDomainTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
