/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.dsi.core.utilities.impl.future;

import com.simba.googlebigquery.dsi.core.utilities.future.IntervalConverter;
import com.simba.googlebigquery.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.ArrayJDBCDataSinkAdapter;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.BinaryJDBCDataSinkAdapter;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.BitBooleanJDBCDataSinkAdapter;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.DateJDBCDataSinkAdapter;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.DecimalJDBCDataSinkAdapter;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.DoubleJDBCDataSinkAdapter;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.FloatJDBCDataSinkAdapter;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.GuidJDBCDataSinkAdapter;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.MonthSpanJDBCDataSinkAdapter;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.SignedBigIntJDBCDataSinkAdapter;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.SignedIntJDBCDataSinkAdapter;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.SignedSmallIntJDBCDataSinkAdapter;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.SignedTinyIntJDBCDataSinkAdapter;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.StringJDBCDataSinkAdapter;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.TimeJDBCDataSinkAdapter;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.TimeSpanJDBCDataSinkAdapter;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.TimestampJDBCDataSinkAdapter;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.UnsignedBigIntJDBCDataSinkAdapter;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.UnsignedIntJDBCDataSinkAdapter;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.UnsignedSmallIntJDBCDataSinkAdapter;
import com.simba.googlebigquery.dsi.core.utilities.impl.future.UnsignedTinyIntJDBCDataSinkAdapter;
import com.simba.googlebigquery.dsi.dataengine.interfaces.future.IJDBCArray;
import com.simba.googlebigquery.dsi.dataengine.interfaces.future.IJDBCDataSink;
import com.simba.googlebigquery.dsi.dataengine.interfaces.future.ISqlDataSink;
import com.simba.googlebigquery.dsi.dataengine.utilities.DSIMonthSpan;
import com.simba.googlebigquery.dsi.dataengine.utilities.DSITimeSpan;
import com.simba.googlebigquery.dsi.dataengine.utilities.SqlTypeWrapper;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeMetadata;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeUtilities;
import com.simba.googlebigquery.dsi.exceptions.IncorrectTypeException;
import com.simba.googlebigquery.dsi.exceptions.future.UnsupportedException;
import com.simba.googlebigquery.support.IWarningListener;
import com.simba.googlebigquery.support.Pair;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.UUID;

public abstract class ConvertingJDBCDataSink
implements IJDBCDataSink {
    private static final Map<Class<?>, Integer> s_finalClassToSqlTypeMap;
    private static final Pair<Class<?>, Integer>[] s_nonFinalClassToSqlTypeMappings;
    protected static final Charset s_asciiCharSet;
    protected static final Charset s_utf8CharSet;
    private final IWarningListener m_warningListener;
    private GregorianCalendar m_tempCalendar = null;
    private final NonTrivialJDBCConversions.SimpleListener m_listener = new NonTrivialJDBCConversions.SimpleListener();

    public static IJDBCDataSink wrapDataSinkIfNecessary(ISqlDataSink iSqlDataSink, TypeMetadata typeMetadata, IWarningListener iWarningListener) throws UnsupportedException {
        if (iSqlDataSink == null) {
            throw null;
        }
        if (iSqlDataSink instanceof IJDBCDataSink) {
            return (IJDBCDataSink)iSqlDataSink;
        }
        switch (typeMetadata.getType()) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                return new StringJDBCDataSinkAdapter(iSqlDataSink, iWarningListener);
            }
            case 2003: {
                return new ArrayJDBCDataSinkAdapter(iSqlDataSink, iWarningListener);
            }
            case -4: 
            case -3: 
            case -2: {
                return new BinaryJDBCDataSinkAdapter(iSqlDataSink, iWarningListener);
            }
            case -7: 
            case 16: {
                return new BitBooleanJDBCDataSinkAdapter(iSqlDataSink, iWarningListener);
            }
            case -11: {
                return new GuidJDBCDataSinkAdapter(iSqlDataSink, iWarningListener);
            }
            case -6: {
                if (typeMetadata.isSigned()) {
                    return new SignedTinyIntJDBCDataSinkAdapter(iSqlDataSink, iWarningListener);
                }
                return new UnsignedTinyIntJDBCDataSinkAdapter(iSqlDataSink, iWarningListener);
            }
            case 91: {
                return new DateJDBCDataSinkAdapter(iSqlDataSink, iWarningListener);
            }
            case 92: {
                return new TimeJDBCDataSinkAdapter(iSqlDataSink, typeMetadata, iWarningListener);
            }
            case 93: {
                return new TimestampJDBCDataSinkAdapter(iSqlDataSink, typeMetadata, iWarningListener);
            }
            case -5: {
                if (typeMetadata.isSigned()) {
                    return new SignedBigIntJDBCDataSinkAdapter(iSqlDataSink, iWarningListener);
                }
                return new UnsignedBigIntJDBCDataSinkAdapter(iSqlDataSink, iWarningListener);
            }
            case 6: 
            case 8: {
                return new DoubleJDBCDataSinkAdapter(iSqlDataSink, iWarningListener);
            }
            case 7: {
                return new FloatJDBCDataSinkAdapter(iSqlDataSink, iWarningListener);
            }
            case 5: {
                if (typeMetadata.isSigned()) {
                    return new SignedSmallIntJDBCDataSinkAdapter(iSqlDataSink, iWarningListener);
                }
                return new UnsignedSmallIntJDBCDataSinkAdapter(iSqlDataSink, iWarningListener);
            }
            case 4: {
                if (typeMetadata.isSigned()) {
                    return new SignedIntJDBCDataSinkAdapter(iSqlDataSink, iWarningListener);
                }
                return new UnsignedIntJDBCDataSinkAdapter(iSqlDataSink, iWarningListener);
            }
            case 2: 
            case 3: {
                return new DecimalJDBCDataSinkAdapter(iSqlDataSink, typeMetadata, iWarningListener);
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return new TimeSpanJDBCDataSinkAdapter(iSqlDataSink, typeMetadata, iWarningListener);
            }
            case 101: 
            case 102: 
            case 107: {
                return new MonthSpanJDBCDataSinkAdapter(iSqlDataSink, typeMetadata, iWarningListener);
            }
        }
        throw new UnsupportedException();
    }

    protected ConvertingJDBCDataSink(IWarningListener iWarningListener) {
        if (iWarningListener == null) {
            throw null;
        }
        this.m_warningListener = iWarningListener;
    }

    protected final IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    protected final GregorianCalendar getLocalCalendarForConversions() {
        if (this.m_tempCalendar == null) {
            this.m_tempCalendar = new GregorianCalendar();
        }
        return this.m_tempCalendar;
    }

    protected final NonTrivialJDBCConversions.SimpleListener getListener() {
        return this.m_listener;
    }

    protected final NonTrivialJDBCConversions.SimpleListener getAndClearListener() {
        this.m_listener.clearStatus();
        return this.m_listener;
    }

    protected void onOverflow(Object object, String string) {
    }

    protected void onFractionalTruncation(Object object, int n, String string) {
    }

    @Override
    public abstract void set(Object var1) throws IncorrectTypeException, ErrorException;

    @Override
    public final void setDefault() throws ErrorException {
        throw new RuntimeException("Should never be called in the context of a JDBC driver!");
    }

    @Override
    public void setReader(Reader reader) throws IncorrectTypeException, ErrorException {
        throw new IncorrectTypeException();
    }

    @Override
    public void setInputStream(InputStream inputStream) throws IncorrectTypeException {
        throw new IncorrectTypeException();
    }

    @Override
    public abstract void setNull(int var1) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException;

    @Override
    public void setBoolean(boolean bl) throws IncorrectTypeException, SQLException, ErrorException {
        throw new IncorrectTypeException();
    }

    @Override
    public void setByte(byte by) throws IncorrectTypeException, SQLException, ErrorException {
        throw new IncorrectTypeException();
    }

    @Override
    public void setShort(short s) throws IncorrectTypeException, SQLException, ErrorException {
        throw new IncorrectTypeException();
    }

    @Override
    public void setInt(int n) throws IncorrectTypeException, SQLException, ErrorException {
        throw new IncorrectTypeException();
    }

    @Override
    public void setLong(long l) throws IncorrectTypeException, SQLException, ErrorException {
        throw new IncorrectTypeException();
    }

    @Override
    public void setFloat(float f) throws IncorrectTypeException, SQLException, ErrorException {
        throw new IncorrectTypeException();
    }

    @Override
    public void setDouble(double d) throws IncorrectTypeException, SQLException, ErrorException {
        throw new IncorrectTypeException();
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws IncorrectTypeException, SQLException, ErrorException {
        throw new IncorrectTypeException();
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, SQLException, ErrorException {
        throw new IncorrectTypeException();
    }

    @Override
    public void setBytes(byte[] byArray) throws IncorrectTypeException, SQLException, ErrorException {
        throw new IncorrectTypeException();
    }

    @Override
    public void setDate(Date date) throws IncorrectTypeException, SQLException, ErrorException {
        this.setDate(date, this.getLocalCalendarForConversions());
    }

    @Override
    public void setTime(Time time) throws IncorrectTypeException, SQLException, ErrorException {
        this.setTime(time, this.getLocalCalendarForConversions());
    }

    @Override
    public void setTimestamp(Timestamp timestamp) throws IncorrectTypeException, SQLException, ErrorException {
        this.setTimestamp(timestamp, this.getLocalCalendarForConversions());
    }

    @Override
    public void setAsciiStream(InputStream inputStream, int n) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException {
        this.setAsciiStream(inputStream, (long)n);
    }

    @Override
    public void setUnicodeStream(InputStream inputStream, int n) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException {
        this.setReader(inputStream == null ? null : new InputStreamReader((InputStream)new SizedInputStream(inputStream, n), s_utf8CharSet));
    }

    @Override
    public void setBinaryStream(InputStream inputStream, int n) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException {
        this.setBinaryStream(inputStream, (long)n);
    }

    @Override
    public final void setObject(Object object, int n) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException {
        this.doSetObject(object, n, null, null);
    }

    @Override
    public final void setObjectWithScaleOrLength(Object object, int n) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException {
        this.doSetObject(object, null, null, n);
    }

    @Override
    public final void setObject(Object object) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException {
        this.doSetObject(object, null, null, null);
    }

    @Override
    public void setCharacterStream(Reader reader, int n) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException {
        this.setCharacterStream(reader, (long)n);
    }

    @Override
    public void setRef(Ref ref) throws IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public void setBlob(Blob blob) throws IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public void setClob(Clob clob) throws IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public void setArray(IJDBCArray iJDBCArray) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public void setDate(Date date, Calendar calendar) throws IncorrectTypeException, SQLException, ErrorException {
        throw new IncorrectTypeException();
    }

    @Override
    public void setTime(Time time, Calendar calendar) throws IncorrectTypeException, SQLException, ErrorException {
        throw new IncorrectTypeException();
    }

    @Override
    public void setTimestamp(Timestamp timestamp, Calendar calendar) throws IncorrectTypeException, SQLException, ErrorException {
        throw new IncorrectTypeException();
    }

    @Override
    public void setNull(int n, String string) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException {
        this.setNull(n);
    }

    @Override
    public void setURL(URL uRL) throws IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public void setRowId(RowId rowId) throws IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public void setNString(String string) throws IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public void setNCharacterStream(Reader reader, long l) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException {
        this.setNCharacterStream(reader == null ? null : new SizedReader(reader, l));
    }

    @Override
    public void setNClob(NClob nClob) throws IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public void setClob(Reader reader, long l) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException {
        this.setClob(reader == null ? null : new SizedReader(reader, l));
    }

    @Override
    public void setBlob(InputStream inputStream, long l) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException {
        this.setBlob(inputStream == null ? null : new SizedInputStream(inputStream, l));
    }

    @Override
    public void setNClob(Reader reader, long l) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException {
        this.setNClob(reader == null ? null : new SizedReader(reader, l));
    }

    @Override
    public void setSQLXML(SQLXML sQLXML) throws IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public void setAsciiStream(InputStream inputStream, long l) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException {
        this.setAsciiStream(inputStream == null ? null : new SizedInputStream(inputStream, l));
    }

    @Override
    public void setBinaryStream(InputStream inputStream, long l) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException {
        this.setBinaryStream(inputStream == null ? null : new SizedInputStream(inputStream, l));
    }

    @Override
    public void setCharacterStream(Reader reader, long l) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException {
        this.setCharacterStream(reader == null ? null : new SizedReader(reader, l));
    }

    @Override
    public void setAsciiStream(InputStream inputStream) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException {
        this.setReader(inputStream == null ? null : new InputStreamReader(inputStream, s_asciiCharSet));
    }

    @Override
    public void setBinaryStream(InputStream inputStream) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public void setCharacterStream(Reader reader) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public void setNCharacterStream(Reader reader) throws IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public void setClob(Reader reader) throws IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public void setBlob(InputStream inputStream) throws IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public void setNClob(Reader reader) throws IncorrectTypeException, SQLException, UnsupportedException {
        throw new UnsupportedException();
    }

    @Override
    public final void setObject(Object object, int n, int n2) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException {
        this.doSetObject(object, n, null, n2);
    }

    @Override
    public final void setObject(Object object, SqlTypeWrapper sqlTypeWrapper, int n) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException {
        this.doSetObject(object, null, sqlTypeWrapper, n);
    }

    @Override
    public final void setObject(Object object, SqlTypeWrapper sqlTypeWrapper) throws IncorrectTypeException, SQLException, ErrorException, UnsupportedException {
        this.doSetObject(object, null, sqlTypeWrapper, null);
    }

    protected void setReader(Reader reader, int n, Integer n2) throws IncorrectTypeException, ErrorException, SQLException, UnsupportedException {
        if (TypeUtilities.isCharacterType(n)) {
            if (n2 == null) {
                this.setCharacterStream(reader);
            } else {
                this.setCharacterStream(reader, n2);
            }
        } else {
            switch (n) {
                case -16: 
                case -15: 
                case -9: {
                    if (n2 == null) {
                        this.setNCharacterStream(reader);
                        break;
                    }
                    this.setNCharacterStream(reader, n2.intValue());
                    break;
                }
                case 2005: {
                    if (n2 == null) {
                        this.setClob(reader);
                        break;
                    }
                    this.setClob(reader, n2.intValue());
                    break;
                }
                case 2011: {
                    if (n2 == null) {
                        this.setNClob(reader);
                        break;
                    }
                    this.setNClob(reader, n2.intValue());
                    break;
                }
                default: {
                    throw new RuntimeException("Cannot convert instance of Reader to SQL type " + n);
                }
            }
        }
    }

    protected void setInputStream(InputStream inputStream, int n, Integer n2) throws IncorrectTypeException, ErrorException, SQLException, UnsupportedException {
        if (TypeUtilities.isCharacterOrBinaryType(n)) {
            if (n2 == null) {
                this.setBinaryStream(inputStream);
            } else {
                this.setBinaryStream(inputStream, n2);
            }
        } else if (n == 2004) {
            if (n2 == null) {
                this.setBlob(inputStream);
            } else {
                this.setBlob(inputStream, n2.intValue());
            }
        } else {
            throw new RuntimeException("Cannot convert instance of InputStream to SQL type " + n);
        }
    }

    private void checkConversionResult(Object object, Integer n) {
        switch (this.getListener().getStatus()) {
            case SUCCESS: {
                break;
            }
            case FRACTIONAL_TRUNCATION: {
                this.onFractionalTruncation(object, n == null ? 0 : n, "getObject");
                break;
            }
            case OVERFLOW: {
                this.onOverflow(object, "getObject");
            }
        }
    }

    protected void doSetObject(Object object, Integer n, SqlTypeWrapper sqlTypeWrapper, Integer n2) throws IncorrectTypeException, ErrorException, SQLException, UnsupportedException {
        int n3 = n == null && sqlTypeWrapper == null ? this.inferSqlType(object) : this.getSqlType(n, sqlTypeWrapper);
        if (object == null) {
            this.setNull(n3);
        } else {
            if (n3 == 0) {
                throw new IncorrectTypeException();
            }
            if (object instanceof Reader) {
                this.setReader((Reader)object, n3, n2);
            } else if (object instanceof InputStream) {
                this.setInputStream((InputStream)object, n3, n2);
            } else {
                switch (n3) {
                    case -6: {
                        short s = NonTrivialJDBCConversions.objectToShort(object, this.getAndClearListener());
                        this.checkConversionResult(object, null);
                        this.setShort(s);
                        break;
                    }
                    case 5: {
                        int n4 = NonTrivialJDBCConversions.objectToInt(object, this.getAndClearListener());
                        this.checkConversionResult(object, null);
                        this.setInt(n4);
                        break;
                    }
                    case 4: {
                        long l = NonTrivialJDBCConversions.objectToLong(object, this.getAndClearListener());
                        this.checkConversionResult(object, null);
                        this.setLong(l);
                        break;
                    }
                    case -5: {
                        Number number = NonTrivialJDBCConversions.objectToBigInt(object, this.getAndClearListener());
                        this.checkConversionResult(object, null);
                        if (number instanceof Long) {
                            this.setLong((Long)number);
                            break;
                        }
                        assert (number instanceof BigInteger);
                        this.set(number);
                        break;
                    }
                    case 7: {
                        this.setFloat((float)NonTrivialJDBCConversions.objectToDouble(object));
                        break;
                    }
                    case 6: 
                    case 8: {
                        this.setDouble(NonTrivialJDBCConversions.objectToDouble(object));
                        break;
                    }
                    case 2: 
                    case 3: {
                        BigDecimal bigDecimal = NonTrivialJDBCConversions.objectToBigDecimal(object, n2, this.getAndClearListener());
                        this.checkConversionResult(object, null);
                        this.setBigDecimal(bigDecimal);
                        break;
                    }
                    case -7: 
                    case 16: {
                        this.setBoolean(NonTrivialJDBCConversions.objectToBoolean(object));
                        break;
                    }
                    case -10: 
                    case -9: 
                    case -8: 
                    case -1: 
                    case 1: 
                    case 12: {
                        this.setString(NonTrivialJDBCConversions.objectToString(object, this.getIntervalConverter()));
                        break;
                    }
                    case -16: 
                    case -15: {
                        this.setNString(NonTrivialJDBCConversions.objectToString(object, this.getIntervalConverter()));
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        if (object instanceof byte[]) {
                            this.setBytes((byte[])object);
                            break;
                        }
                        throw new IncorrectTypeException();
                    }
                    case 91: {
                        this.setDate(NonTrivialJDBCConversions.objectToDate(object));
                        break;
                    }
                    case 92: {
                        this.setTime(NonTrivialJDBCConversions.objectToTime(object));
                        break;
                    }
                    case 93: {
                        this.setTimestamp(NonTrivialJDBCConversions.objectToTimestamp(object));
                        break;
                    }
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: {
                        DSIMonthSpan dSIMonthSpan = NonTrivialJDBCConversions.objectToMonthSpan(object, n3, this.getIntervalConverter(), this.getWarningListener(), this.getAndClearListener());
                        this.checkConversionResult(object, 0);
                        this.set(dSIMonthSpan);
                        break;
                    }
                    case 101: 
                    case 102: 
                    case 107: {
                        DSITimeSpan dSITimeSpan = NonTrivialJDBCConversions.objectToTimeSpan(object, n3, this.getIntervalConverter(), this.getWarningListener(), this.getAndClearListener());
                        this.checkConversionResult(object, 9);
                        this.set(dSITimeSpan);
                        break;
                    }
                    case -11: {
                        this.set(NonTrivialJDBCConversions.objectToGUID(object));
                        break;
                    }
                    case 2003: {
                        if (object instanceof IJDBCArray) {
                            this.setArray((IJDBCArray)object);
                            break;
                        }
                        throw new IncorrectTypeException();
                    }
                    case 2004: {
                        if (object instanceof Blob) {
                            this.setBlob((Blob)object);
                            break;
                        }
                        throw new IncorrectTypeException();
                    }
                    case 2005: {
                        if (object instanceof Clob) {
                            this.setClob((Clob)object);
                            break;
                        }
                        throw new IncorrectTypeException();
                    }
                    case 2011: {
                        if (object instanceof NClob) {
                            this.setNClob((NClob)object);
                            break;
                        }
                        throw new IncorrectTypeException();
                    }
                    case 2006: {
                        if (object instanceof Ref) {
                            this.setRef((Ref)object);
                            break;
                        }
                        throw new IncorrectTypeException();
                    }
                    case 2002: {
                        if (object instanceof Struct) {
                            this.set(object);
                            break;
                        }
                        throw new IncorrectTypeException();
                    }
                    case 2009: {
                        if (object instanceof SQLXML) {
                            this.setSQLXML((SQLXML)object);
                            break;
                        }
                        throw new IncorrectTypeException();
                    }
                    case 70: {
                        if (object instanceof URL) {
                            this.setURL((URL)object);
                            break;
                        }
                        throw new IncorrectTypeException();
                    }
                    case 2000: {
                        this.set(object);
                        break;
                    }
                    default: {
                        throw new UnsupportedException();
                    }
                }
            }
        }
    }

    protected int inferSqlType(Object object) {
        if (object == null) {
            return 0;
        }
        if (s_finalClassToSqlTypeMap.containsKey(object.getClass())) {
            return s_finalClassToSqlTypeMap.get(object.getClass());
        }
        if (object instanceof DSIMonthSpan) {
            return ((DSIMonthSpan)object).getIntervalType();
        }
        if (object instanceof DSITimeSpan) {
            return ((DSITimeSpan)object).getIntervalType();
        }
        for (Pair<Class<?>, Integer> pair : s_nonFinalClassToSqlTypeMappings) {
            if (!pair.key().isInstance(object)) continue;
            return pair.value();
        }
        return 2000;
    }

    protected IntervalConverter getIntervalConverter() {
        return IntervalConverter.INSTANCE;
    }

    protected int getSqlType(Integer n, SqlTypeWrapper sqlTypeWrapper) {
        assert (n == null != (sqlTypeWrapper == null));
        if (n != null) {
            return n;
        }
        return sqlTypeWrapper.getVendorTypeNumber();
    }

    static {
        IdentityHashMap identityHashMap = new IdentityHashMap();
        identityHashMap.put(byte[].class, -3);
        identityHashMap.put(Byte.class, -6);
        identityHashMap.put(Boolean.class, -7);
        identityHashMap.put(Double.class, 8);
        identityHashMap.put(Float.class, 7);
        identityHashMap.put(Integer.class, 4);
        identityHashMap.put(Long.class, -5);
        identityHashMap.put(Short.class, 5);
        identityHashMap.put(String.class, 12);
        identityHashMap.put(UUID.class, -11);
        for (Class clazz : identityHashMap.keySet()) {
            assert (Modifier.isFinal(clazz.getModifiers()));
        }
        s_finalClassToSqlTypeMap = identityHashMap;
        s_nonFinalClassToSqlTypeMappings = new Pair[]{new Pair<Class<BigDecimal>, Integer>(BigDecimal.class, 2), new Pair<Class<BigInteger>, Integer>(BigInteger.class, -5), new Pair<Class<Time>, Integer>(Time.class, 92), new Pair<Class<Time>, Integer>(Time.class, 92), new Pair<Class<Date>, Integer>(Date.class, 91), new Pair<Class<Calendar>, Integer>(Calendar.class, 93), new Pair<Class<java.util.Date>, Integer>(java.util.Date.class, 93), new Pair<Class<UUID>, Integer>(UUID.class, -11), new Pair<Class<Reader>, Integer>(Reader.class, -1), new Pair<Class<InputStream>, Integer>(InputStream.class, -4), new Pair<Class<Clob>, Integer>(Clob.class, 2005), new Pair<Class<Blob>, Integer>(Blob.class, 2004), new Pair<Class<Array>, Integer>(Array.class, 2003), new Pair<Class<Struct>, Integer>(Struct.class, 2002), new Pair<Class<Ref>, Integer>(Ref.class, 2006), new Pair<Class<URL>, Integer>(URL.class, 70), new Pair<Class<RowId>, Integer>(RowId.class, -8), new Pair<Class<NClob>, Integer>(NClob.class, 2011), new Pair<Class<SQLXML>, Integer>(SQLXML.class, 2009)};
        s_asciiCharSet = Charset.forName("US-ASCII");
        s_utf8CharSet = Charset.forName("UTF-8");
    }

    protected class SizedReader
    extends Reader {
        private Reader m_wrapped;
        private long m_remainingSize;
        private long m_remainingSizeAtLastMark = -1L;

        public SizedReader(Reader reader, long l) {
            if (reader == null) {
                throw null;
            }
            if (l < 0L) {
                throw new IllegalArgumentException();
            }
            this.m_wrapped = reader;
            this.m_remainingSize = l;
        }

        private void checkIfClosed() {
            if (this.m_wrapped == null) {
                throw new IllegalStateException("Stream is closed!");
            }
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            assert (n >= 0);
            assert (n2 <= cArray.length - n);
            this.checkIfClosed();
            if (cArray == null) {
                throw new NullPointerException();
            }
            if (n2 == 0) {
                return 0;
            }
            int n3 = this.m_wrapped.read(cArray, n, n2);
            assert (n3 != 0);
            assert (n3 <= n2);
            if (n3 == -1) {
                if (this.m_remainingSize > 0L) {
                    throw new RuntimeException(String.format("Expected there to be %d characters remaining, but wrapped reader has reached EOF.", this.m_remainingSize));
                }
                return -1;
            }
            if ((long)n3 > this.m_remainingSize) {
                throw new RuntimeException(String.format("Expected there to be %d characters remaining, but wrapped reader managed to return %d characters.", this.m_remainingSize, n3));
            }
            assert (n3 >= 0);
            this.m_remainingSize -= (long)n3;
            return n3;
        }

        @Override
        public long skip(long l) throws IOException {
            this.checkIfClosed();
            long l2 = this.m_wrapped.skip(l);
            if (l2 == 0L) {
                return l2;
            }
            if (l2 < 0L) {
                if (this.m_remainingSize > 0L) {
                    throw new RuntimeException(String.format("Expected there to be %d characters remaining, but wrapped reader has reached EOF after requesting to skip %d characters.", this.m_remainingSize, l));
                }
                return l2;
            }
            if (l2 > this.m_remainingSize) {
                throw new RuntimeException(String.format("Expected there to be %d characters remaining, but wrapped reader managed to skip %d characters.", this.m_remainingSize, l));
            }
            this.m_remainingSize -= l2;
            return l2;
        }

        @Override
        public boolean ready() throws IOException {
            this.checkIfClosed();
            return this.m_wrapped.ready();
        }

        @Override
        public boolean markSupported() {
            this.checkIfClosed();
            return this.m_wrapped.markSupported();
        }

        @Override
        public void mark(int n) throws IOException {
            this.checkIfClosed();
            this.m_wrapped.mark(n);
            this.m_remainingSizeAtLastMark = this.m_remainingSize;
        }

        @Override
        public void reset() throws IOException {
            this.checkIfClosed();
            this.m_wrapped.reset();
            this.m_remainingSize = this.m_remainingSizeAtLastMark;
        }

        @Override
        public void close() throws IOException {
            this.m_wrapped = null;
        }
    }

    protected static class SizedInputStream
    extends InputStream {
        private InputStream m_wrapped;
        private long m_remainingSize;
        private long m_remainingSizeAtLastMark = -1L;

        public SizedInputStream(InputStream inputStream, long l) {
            if (inputStream == null) {
                throw null;
            }
            if (l < 0L) {
                throw new IllegalArgumentException();
            }
            this.m_wrapped = inputStream;
            this.m_remainingSize = l;
        }

        private void checkIfClosed() {
            if (this.m_wrapped == null) {
                throw new IllegalStateException("Stream is closed!");
            }
        }

        @Override
        public int read() throws IOException {
            this.checkIfClosed();
            if (this.m_remainingSize == 0L) {
                return -1;
            }
            int n = this.m_wrapped.read();
            if (n == -1) {
                throw new RuntimeException(String.format("Expected there to be %d bytes remaining, but wrapped stream has reached EOF.", this.m_remainingSize));
            }
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            assert (n >= 0);
            assert (n2 <= byArray.length - n);
            this.checkIfClosed();
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n2 == 0) {
                return 0;
            }
            int n3 = this.m_wrapped.read(byArray, n, n2);
            assert (n3 != 0);
            assert (n3 <= n2);
            if (n3 == -1) {
                if (this.m_remainingSize > 0L) {
                    throw new RuntimeException(String.format("Expected there to be %d bytes remaining, but wrapped stream has reached EOF.", this.m_remainingSize));
                }
                return -1;
            }
            if ((long)n3 > this.m_remainingSize) {
                throw new RuntimeException(String.format("Expected there to be %d bytes remaining, but wrapped stream managed to return %d bytes.", this.m_remainingSize, n3));
            }
            assert (n3 >= 0);
            this.m_remainingSize -= (long)n3;
            return n3;
        }

        @Override
        public long skip(long l) throws IOException {
            this.checkIfClosed();
            long l2 = this.m_wrapped.skip(l);
            if (l2 == 0L) {
                return l2;
            }
            if (l2 < 0L) {
                if (this.m_remainingSize > 0L) {
                    throw new RuntimeException(String.format("Expected there to be %d bytes remaining, but wrapped stream has reached EOF after requesting to skip %d bytes.", this.m_remainingSize, l));
                }
                return l2;
            }
            if (l2 > this.m_remainingSize) {
                throw new RuntimeException(String.format("Expected there to be %d bytes remaining, but wrapped stream managed to skip %d bytes.", this.m_remainingSize, l));
            }
            this.m_remainingSize -= l2;
            return l2;
        }

        @Override
        public int available() throws IOException {
            this.checkIfClosed();
            return this.m_wrapped.available();
        }

        @Override
        public void close() throws IOException {
            this.m_wrapped = null;
        }

        @Override
        public synchronized void mark(int n) {
            this.checkIfClosed();
            this.m_wrapped.mark(n);
            this.m_remainingSizeAtLastMark = this.m_remainingSize;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.checkIfClosed();
            this.m_wrapped.reset();
            assert (this.m_remainingSizeAtLastMark >= 0L);
            this.m_remainingSize = this.m_remainingSizeAtLastMark;
        }

        @Override
        public boolean markSupported() {
            this.checkIfClosed();
            return this.m_wrapped.markSupported();
        }
    }
}

