/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine;

import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.common.base.Preconditions;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.dataengine.BQBufferManager;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;

public class BQAvroReader
implements Runnable {
    private final DatumReader<GenericRecord> m_datumReader;
    private BinaryDecoder m_decoder;
    private Iterator<ReadRowsResponse> m_currentReadRowsIterator;
    private BQBufferManager m_bufferManager;
    private ILogger m_logger;

    public BQAvroReader(Schema schema, ServerStream<ReadRowsResponse> serverStream, BQBufferManager bQBufferManager, ILogger iLogger) {
        Preconditions.checkNotNull((Object)schema);
        this.m_datumReader = new GenericDatumReader(schema);
        this.m_currentReadRowsIterator = serverStream.iterator();
        this.m_bufferManager = bQBufferManager;
        this.m_logger = iLogger;
    }

    private void processRows(ReadRowsResponse readRowsResponse) throws ErrorException {
        if (!readRowsResponse.hasAvroRows()) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.RESULT_STREAM_GET_ERR.name(), "Data not in AVRO format");
        }
        this.m_decoder = DecoderFactory.get().binaryDecoder(readRowsResponse.getAvroRows().getSerializedBinaryRows().toByteArray(), this.m_decoder);
    }

    @Override
    public void run() {
        try {
            while (this.m_currentReadRowsIterator.hasNext()) {
                this.processRows(this.m_currentReadRowsIterator.next());
                while (!this.m_decoder.isEnd()) {
                    GenericRecord genericRecord = (GenericRecord)this.m_datumReader.read(null, (Decoder)this.m_decoder);
                    this.m_bufferManager.addRow(genericRecord);
                }
            }
            this.m_bufferManager.addRow(null);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                if (exception.getCause().getClass() == InterruptedException.class) {
                    LogUtilities.logDebug("AvroReader stopped", this.m_logger);
                }
                throw (RuntimeException)exception;
            }
            LogUtilities.logError(exception, this.m_logger);
            this.m_bufferManager.stopOnError(exception);
        }
    }
}

