/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine;

import com.google.api.client.util.Data;
import com.google.api.services.bigquery.model.TableCell;
import com.simba.googlebigquery.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.googlebigquery.dsi.dataengine.utilities.DataWrapper;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeMetadata;
import com.simba.googlebigquery.googlebigquery.client.IBQResponse;
import com.simba.googlebigquery.googlebigquery.dataengine.BQBufferManager;
import com.simba.googlebigquery.googlebigquery.dataengine.BQRestParser;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQColumnMetadata;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.IWarningListener;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.List;

public class BQRestDataHandler {
    private IBQResponse m_bqResults;
    private BQBufferManager m_bufferManager;
    private int m_currPageRowNum;
    private final ILogger m_logger;
    private List<TableCell> m_rowData;
    private IWarningListener m_warningListener;

    public BQRestDataHandler(BQBufferManager bQBufferManager, IBQResponse iBQResponse, ILogger iLogger, IWarningListener iWarningListener) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_bqResults = iBQResponse;
        this.m_bufferManager = bQBufferManager;
        this.m_currPageRowNum = -1;
        this.m_logger = iLogger;
        this.m_warningListener = iWarningListener;
    }

    public boolean moveToNextRow() throws ErrorException {
        boolean bl;
        boolean bl2 = bl = this.m_bqResults.getRows().size() == this.m_currPageRowNum + 1;
        if (null == this.m_bqResults || bl) {
            this.m_bqResults = this.m_bufferManager.getNextBuffer();
            this.m_currPageRowNum = -1;
        }
        this.m_rowData = this.m_bqResults.getRows().get(++this.m_currPageRowNum).getF();
        return true;
    }

    public boolean retrieveData(int n, BQColumnMetadata bQColumnMetadata, long l, long l2, DataWrapper dataWrapper, short s, TypeMetadata typeMetadata) throws ErrorException {
        Object object = null;
        object = this.m_rowData.get(n).getV();
        if (null == object || Data.isNull((Object)object)) {
            dataWrapper.setNull(s);
            return false;
        }
        String string = object.toString();
        if (bQColumnMetadata.isRecord() && null != bQColumnMetadata.getNestedTypes() && !bQColumnMetadata.isRepeated()) {
            StringBuilder stringBuilder = new StringBuilder();
            BQRestParser.structToString(n, bQColumnMetadata, stringBuilder, this.m_rowData);
            return DSITypeUtilities.outputVarCharStringData(stringBuilder.toString(), dataWrapper, l, l2);
        }
        if (bQColumnMetadata.isRepeated()) {
            StringBuilder stringBuilder = new StringBuilder();
            BQRestParser.arrayToString(n, bQColumnMetadata, stringBuilder, this.m_rowData);
            return DSITypeUtilities.outputVarCharStringData(stringBuilder.toString(), dataWrapper, l, l2);
        }
        return BQRestParser.getDataOldAPI(s, typeMetadata.getTypeName(), l, l2, dataWrapper, string, this.m_logger, this.m_warningListener);
    }
}

