/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine.metadata;

import com.google.api.services.bigquery.model.Argument;
import com.google.api.services.bigquery.model.Routine;
import com.google.api.services.bigquery.model.StandardSqlDataType;
import com.simba.googlebigquery.dsi.dataengine.utilities.Nullable;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeMetadata;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeUtilities;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.googlebigquery.utils.BQCoreUtils;
import com.simba.googlebigquery.support.exceptions.ErrorException;

public class BQFunctionColumn {
    private int m_columnPosition;
    private final String m_catalogName;
    private final String m_schemaName;
    private final String m_functionName;
    private final String m_routineDef;
    private StandardSqlDataType m_returnType;
    private String m_colName;
    private String m_argMode;
    private int m_dataType = -1;
    private Nullable m_nullable = Nullable.UNKNOWN;
    private boolean m_isCharacterType;
    private boolean m_isBinaryType;
    private long m_colByteLength;
    private long m_colLength;
    private TypeMetadata m_metadata = null;

    public BQFunctionColumn(Argument argument, Routine routine) throws ErrorException {
        this(argument, routine, 0L);
    }

    public BQFunctionColumn(Argument argument, Routine routine, long l) throws ErrorException {
        this.m_catalogName = routine.getRoutineReference().getProjectId();
        this.m_schemaName = routine.getRoutineReference().getDatasetId();
        this.m_functionName = routine.getRoutineReference().getRoutineId();
        this.m_routineDef = routine.getDefinitionBody();
        this.m_returnType = routine.getReturnType();
        this.m_colName = argument.getName();
        this.m_colLength = 0L;
        this.m_colByteLength = 0L;
        this.m_argMode = argument.getMode();
        StandardSqlDataType standardSqlDataType = argument.getDataType();
        if (null != standardSqlDataType) {
            try {
                this.m_dataType = BQCoreUtils.bigqueryToSqlTypeConverter(standardSqlDataType.getTypeKind());
                this.m_isCharacterType = TypeUtilities.isCharacterType(this.m_dataType);
                this.m_isBinaryType = TypeUtilities.isBinaryType(this.m_dataType);
                if (this.m_isCharacterType) {
                    this.m_colLength = l;
                } else if (this.m_isBinaryType) {
                    this.m_colLength = 65535L;
                }
                this.m_colByteLength = -8 == this.m_dataType || -9 == this.m_dataType || -10 == this.m_dataType ? this.m_colLength * 2L : (this.isCharacterOrBinaryType() ? this.m_colLength : (long)TypeUtilities.getSizeInBytes(this.m_dataType));
            }
            catch (ErrorException errorException) {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.METADATA_FUNC_COL_ERR.name(), (Throwable)errorException);
            }
        }
        try {
            if (-1 != this.m_dataType) {
                this.m_metadata = TypeMetadata.createTypeMetadata(this.m_dataType);
            }
        }
        catch (ErrorException errorException) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.METADATA_FUNC_COL_ERR.name(), (Throwable)errorException);
        }
    }

    public boolean isCharacterOrBinaryType() {
        return this.m_isCharacterType || this.m_isBinaryType;
    }

    public int getColumnPosition() {
        return this.m_columnPosition;
    }

    public String getCatalogName() {
        return this.m_catalogName;
    }

    public String getSchemaName() {
        return this.m_schemaName;
    }

    public String getFunctionName() {
        return this.m_functionName;
    }

    public String getRoutineDef() {
        return this.m_routineDef;
    }

    public String getName() {
        return this.m_colName;
    }

    public short getColType() {
        if (null == this.m_argMode) {
            return 0;
        }
        if (this.m_argMode.toLowerCase().contains("inout")) {
            return 2;
        }
        if (this.m_argMode.toLowerCase().contains("out")) {
            return 3;
        }
        if (this.m_argMode.toLowerCase().contains("in")) {
            return 1;
        }
        return 0;
    }

    public int getDataType() {
        return this.m_dataType;
    }

    public String getTypeName() {
        if (-1 == this.m_dataType) {
            return null;
        }
        String string = TypeUtilities.sqlTypeToString((short)this.m_dataType);
        if (string.startsWith("SQL_")) {
            string = string.substring(4);
        }
        return string;
    }

    public Nullable getNullable() {
        return this.m_nullable;
    }

    public long getByteLength() {
        return this.m_colByteLength;
    }

    public long getColumnLength() {
        return this.m_colLength;
    }

    public TypeMetadata getTypeMetadata() {
        return this.m_metadata;
    }

    public void setColumnPosition(int n) {
        this.m_columnPosition = n;
    }
}

