/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.jdbc.common;

import com.simba.googlebigquery.dsi.core.interfaces.IStatement;
import com.simba.googlebigquery.dsi.dataengine.interfaces.IResults;
import com.simba.googlebigquery.dsi.dataengine.utilities.DataWrapper;
import com.simba.googlebigquery.dsi.dataengine.utilities.ExecutionContexts;
import com.simba.googlebigquery.dsi.dataengine.utilities.ParameterGeneratedValues;
import com.simba.googlebigquery.dsi.dataengine.utilities.ParameterInputValue;
import com.simba.googlebigquery.dsi.dataengine.utilities.ParameterMetadata;
import com.simba.googlebigquery.dsi.dataengine.utilities.ParameterType;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeUtilities;
import com.simba.googlebigquery.dsi.exceptions.IncorrectTypeException;
import com.simba.googlebigquery.exceptions.ExceptionConverter;
import com.simba.googlebigquery.exceptions.JDBCMessageKey;
import com.simba.googlebigquery.jdbc.common.SConnection;
import com.simba.googlebigquery.jdbc.common.SPreparedStatement;
import com.simba.googlebigquery.jdbc.common.SStatement;
import com.simba.googlebigquery.jdbc.interfaces.IJDBCCallableStatement;
import com.simba.googlebigquery.streams.IStream;
import com.simba.googlebigquery.streams.parametersoutput.CharacterParameterDataStream;
import com.simba.googlebigquery.support.IWarningListener;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ExceptionType;
import com.simba.googlebigquery.utilities.FunctionID;
import com.simba.googlebigquery.utilities.TypeNames;
import com.simba.googlebigquery.utilities.conversion.TypeConverter;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class SCallableStatement
extends SPreparedStatement
implements IJDBCCallableStatement {
    private boolean m_wasLastParameterNull = false;
    private List<DataWrapper> m_parameterOutputValues = new ArrayList<DataWrapper>();
    protected List<Boolean> m_parameterRegistered = new ArrayList<Boolean>();
    protected Map<Integer, Integer> m_parameterScale = new HashMap<Integer, Integer>();
    private IStream m_currentStream = null;

    protected SCallableStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(string, iStatement, sConnection, n);
        LogUtilities.logFunctionEntrance(this.m_logger, string, iStatement, sConnection);
        this.resetRegisteredParameters();
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        super.clearParameters();
        if (null != this.m_parameterRegistered) {
            this.resetRegisteredParameters();
        }
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.allOutputParametersRegistered()) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NOT_OUTPUT_REGISTERED, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        return super.execute();
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (this.m_parameterRegistered.contains(Boolean.TRUE)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            return super.executeBatch();
        }
        catch (SQLException sQLException) {
            throw ExceptionConverter.getInstance().toSQLException(sQLException, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.allOutputParametersRegistered()) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NOT_OUTPUT_REGISTERED, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        return super.executeQuery();
    }

    @Override
    public Array getArray(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public Array getArray(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getArray(this.getParameterIndex(string));
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                BigDecimal bigDecimal = TypeConverter.toBigDecimal(dataWrapper, this.m_warningListener);
                Integer n2 = this.m_parameterScale.get(n);
                if (null != n2) {
                    bigDecimal = bigDecimal.setScale((int)n2, RoundingMode.HALF_UP);
                }
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return bigDecimal;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(2));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, n2);
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (null != bigDecimal) {
            return bigDecimal.setScale(n2, RoundingMode.HALF_UP);
        }
        return null;
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getBigDecimal(this.getParameterIndex(string));
    }

    @Override
    public synchronized Blob getBlob(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public synchronized Blob getBlob(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getBlob(this.getParameterIndex(string));
    }

    @Override
    public synchronized boolean getBoolean(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                boolean bl = TypeConverter.toBoolean(dataWrapper, this.m_warningListener);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return bl;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(16));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean getBoolean(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getBoolean(this.getParameterIndex(string));
    }

    @Override
    public synchronized byte getByte(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                byte by = TypeConverter.toByte(dataWrapper, this.m_warningListener);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return by;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(-6));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized byte getByte(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getByte(this.getParameterIndex(string));
    }

    @Override
    public synchronized byte[] getBytes(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                byte[] byArray = TypeConverter.toBytes(dataWrapper);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return byArray;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(-2));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized byte[] getBytes(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getBytes(this.getParameterIndex(string));
    }

    @Override
    public synchronized Clob getClob(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public synchronized Clob getClob(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getClob(this.getParameterIndex(string));
    }

    @Override
    public synchronized Date getDate(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        return this.getDate(n, null);
    }

    @Override
    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                Date date = TypeConverter.toDate(dataWrapper, calendar, this.m_warningListener);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return date;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(91));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized Date getDate(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getDate(this.getParameterIndex(string));
    }

    @Override
    public synchronized Date getDate(String string, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, calendar);
        return this.getDate(this.getParameterIndex(string), calendar);
    }

    @Override
    public synchronized double getDouble(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                double d = TypeConverter.toDouble(dataWrapper, this.m_warningListener);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return d;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(8));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized double getDouble(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getDouble(this.getParameterIndex(string));
    }

    @Override
    public synchronized float getFloat(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                float f = TypeConverter.toFloat(dataWrapper, this.m_warningListener);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return f;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(7));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized float getFloat(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getFloat(this.getParameterIndex(string));
    }

    @Override
    public synchronized int getInt(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                int n2 = TypeConverter.toInt(dataWrapper, this.m_warningListener);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return n2;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(4));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int getInt(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getInt(this.getParameterIndex(string));
    }

    @Override
    public synchronized long getLong(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                long l = TypeConverter.toLong(dataWrapper, this.m_warningListener);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return l;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(-5));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long getLong(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getLong(this.getParameterIndex(string));
    }

    @Override
    public synchronized Object getObject(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                ParameterMetadata parameterMetadata = (ParameterMetadata)this.m_parameterMetadata.get(n - 1);
                Object object = TypeConverter.toObject(dataWrapper, parameterMetadata.getTypeMetadata(), this.m_warningListener);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return object;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(2000));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, map);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public synchronized Object getObject(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getObject(this.getParameterIndex(string));
    }

    @Override
    public synchronized Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, map);
        return this.getObject(this.getParameterIndex(string), map);
    }

    @Override
    public synchronized Ref getRef(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public synchronized Ref getRef(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getRef(this.getParameterIndex(string));
    }

    @Override
    public synchronized short getShort(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                short s = TypeConverter.toShort(dataWrapper, this.m_warningListener);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return s;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(5));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized short getShort(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getShort(this.getParameterIndex(string));
    }

    @Override
    public synchronized String getString(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                ParameterMetadata parameterMetadata = (ParameterMetadata)this.m_parameterMetadata.get(n - 1);
                String string = TypeConverter.toString(dataWrapper, parameterMetadata.getTypeMetadata());
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return string;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(12));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized String getString(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getString(this.getParameterIndex(string));
    }

    @Override
    public synchronized Time getTime(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        return this.getTime(n, null);
    }

    @Override
    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                Time time = TypeConverter.toTime(dataWrapper, calendar, ((ParameterMetadata)this.m_parameterMetadata.get(n - 1)).getTypeMetadata(), this.m_warningListener);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return time;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(92));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized Time getTime(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getTime(this.getParameterIndex(string));
    }

    @Override
    public synchronized Time getTime(String string, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, calendar);
        return this.getTime(this.getParameterIndex(string), calendar);
    }

    @Override
    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        return this.getTimestamp(n, null);
    }

    @Override
    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            try {
                Timestamp timestamp = TypeConverter.toTimestamp(dataWrapper, calendar, ((ParameterMetadata)this.m_parameterMetadata.get(n - 1)).getTypeMetadata(), this.m_warningListener);
                this.m_wasLastParameterNull = dataWrapper.isNull();
                return timestamp;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(93));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized Timestamp getTimestamp(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getTimestamp(this.getParameterIndex(string));
    }

    @Override
    public synchronized Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, calendar);
        return this.getTimestamp(this.getParameterIndex(string), calendar);
    }

    @Override
    public synchronized URL getURL(int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public synchronized URL getURL(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getURL(this.getParameterIndex(string));
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException, SQLFeatureNotSupportedException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper dataWrapper = this.getOutputParameterValue(n);
            if (TypeConverter.canConvertStreamFrom(dataWrapper.getType(), -1)) {
                if (dataWrapper.isNull()) {
                    return null;
                }
                CharacterParameterDataStream characterParameterDataStream = new CharacterParameterDataStream(dataWrapper.getLongVarChar().getBytes("UTF-16"));
                this.m_currentStream = characterParameterDataStream;
                return characterParameterDataStream;
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), "CharacterStream");
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getCharacterStream(this.getParameterIndex(string));
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getNCharacterStream(this.getParameterIndex(string));
    }

    @Override
    public NClob getNClob(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public NClob getNClob(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getNClob(this.getParameterIndex(string));
    }

    @Override
    public String getNString(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public String getNString(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getNString(this.getParameterIndex(string));
    }

    @Override
    public RowId getRowId(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public RowId getRowId(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getRowId(this.getParameterIndex(string));
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return this.getSQLXML(this.getParameterIndex(string));
    }

    @Override
    public synchronized void registerOutParameter(int n, int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, n2);
        this.registerOutParameter(n, n2, 0);
        if (TypeUtilities.isExactNumericType(n2)) {
            this.m_parameterScale.remove(n);
        }
    }

    @Override
    public synchronized void registerOutParameter(int n, int n2, int n3) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, n2, n3);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            this.checkTypeSupported(n2);
            if (0 > n3) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_SCALE, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(n3), "0");
            }
            if (ParameterType.INPUT == this.m_parameterTypes.get(n - 1)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_REGISTER_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(n));
            }
            ParameterMetadata parameterMetadata = (ParameterMetadata)this.m_parameterMetadata.get(n - 1);
            short s = parameterMetadata.getTypeMetadata().getType();
            if (!TypeConverter.canConvert(s, n2)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), TypeNames.getTypeName(n2));
            }
            if (TypeUtilities.isExactNumericType(n2)) {
                this.m_parameterScale.put(n, n3);
            }
            int n4 = this.getOutputParameterOnlyIndex(n);
            this.m_parameterRegistered.set(n4 - 1, Boolean.TRUE);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void registerOutParameter(int n, int n2, String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, n2, string);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        this.registerOutParameter(n, n2, 0);
        if (TypeUtilities.isExactNumericType(n2)) {
            this.m_parameterScale.remove(n);
        }
    }

    @Override
    public synchronized void registerOutParameter(String string, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, n);
        this.registerOutParameter(this.getParameterIndex(string), n);
    }

    @Override
    public synchronized void registerOutParameter(String string, int n, int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, n, n2);
        this.registerOutParameter(this.getParameterIndex(string), n, n2);
    }

    @Override
    public synchronized void registerOutParameter(String string, int n, String string2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, n, string2);
        this.registerOutParameter(this.getParameterIndex(string), n, string2);
    }

    @Override
    public synchronized void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, inputStream, n);
        this.setAsciiStream(this.getParameterIndex(string), inputStream, n);
    }

    @Override
    public synchronized void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, bigDecimal);
        this.setBigDecimal(this.getParameterIndex(string), bigDecimal);
    }

    @Override
    public synchronized void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, inputStream, n);
        this.setBinaryStream(this.getParameterIndex(string), inputStream, n);
    }

    @Override
    public synchronized void setBoolean(String string, boolean bl) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, bl);
        this.setBoolean(this.getParameterIndex(string), bl);
    }

    @Override
    public synchronized void setByte(String string, byte by) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, by);
        this.setByte(this.getParameterIndex(string), by);
    }

    @Override
    public synchronized void setBytes(String string, byte[] byArray) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, byArray);
        this.setBytes(this.getParameterIndex(string), byArray);
    }

    @Override
    public synchronized void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader, n);
        this.setCharacterStream(this.getParameterIndex(string), reader, n);
    }

    @Override
    public synchronized void setDate(String string, Date date) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, date);
        this.setDate(this.getParameterIndex(string), date);
    }

    @Override
    public synchronized void setDate(String string, Date date, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, date, calendar);
        this.setDate(this.getParameterIndex(string), date, calendar);
    }

    @Override
    public synchronized void setDouble(String string, double d) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, d);
        this.setDouble(this.getParameterIndex(string), d);
    }

    @Override
    public synchronized void setFloat(String string, float f) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, Float.valueOf(f));
        this.setFloat(this.getParameterIndex(string), f);
    }

    @Override
    public synchronized void setInt(String string, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, n);
        this.setInt(this.getParameterIndex(string), n);
    }

    @Override
    public synchronized void setLong(String string, long l) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, l);
        this.setLong(this.getParameterIndex(string), l);
    }

    @Override
    public synchronized void setNull(String string, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, n);
        this.setNull(this.getParameterIndex(string), n);
    }

    @Override
    public synchronized void setNull(String string, int n, String string2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, n, string2);
        this.setNull(this.getParameterIndex(string), n, string2);
    }

    @Override
    public synchronized void setObject(String string, Object object) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, object);
        this.setObject(this.getParameterIndex(string), object);
    }

    @Override
    public synchronized void setObject(String string, Object object, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, object, n);
        this.setObject(this.getParameterIndex(string), object, n);
    }

    @Override
    public synchronized void setObject(String string, Object object, int n, int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, object, n, n2);
        this.setObject(this.getParameterIndex(string), object, n, n2);
    }

    @Override
    public synchronized void setShort(String string, short s) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, s);
        this.setShort(this.getParameterIndex(string), s);
    }

    @Override
    public synchronized void setString(String string, String string2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, string2);
        this.setString(this.getParameterIndex(string), string2);
    }

    @Override
    public synchronized void setTime(String string, Time time) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, time);
        this.setTime(this.getParameterIndex(string), time);
    }

    @Override
    public synchronized void setTime(String string, Time time, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, time, calendar);
        this.setTime(this.getParameterIndex(string), time, calendar);
    }

    @Override
    public synchronized void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, timestamp);
        this.setTimestamp(this.getParameterIndex(string), timestamp);
    }

    @Override
    public synchronized void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, timestamp, calendar);
        this.setTimestamp(this.getParameterIndex(string), timestamp, calendar);
    }

    @Override
    public synchronized void setURL(String string, URL uRL) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, uRL);
        this.setURL(this.getParameterIndex(string), uRL);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        this.setAsciiStream(this.getParameterIndex(string), inputStream);
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        this.setAsciiStream(this.getParameterIndex(string), inputStream, l);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, inputStream);
        this.setBinaryStream(this.getParameterIndex(string), inputStream);
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, inputStream);
        this.setBinaryStream(this.getParameterIndex(string), inputStream, l);
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, blob);
        this.setBlob(this.getParameterIndex(string), blob);
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, inputStream);
        this.setBlob(this.getParameterIndex(string), inputStream);
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, inputStream, l);
        this.setBlob(this.getParameterIndex(string), inputStream, l);
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader);
        this.setCharacterStream(this.getParameterIndex(string), reader);
    }

    @Override
    public void setCharacterStream(String string, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader, l);
        this.setCharacterStream(this.getParameterIndex(string), reader, l);
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, clob);
        this.checkIfOpen();
        this.getParameterIndex(string);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.m_logger);
        throw sQLException;
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader);
        this.setClob(this.getParameterIndex(string), reader);
    }

    @Override
    public void setClob(String string, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader, l);
        this.setClob(this.getParameterIndex(string), reader, l);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader);
        this.setNCharacterStream(this.getParameterIndex(string), reader);
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader, l);
        this.setNCharacterStream(this.getParameterIndex(string), reader, l);
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, nClob);
        this.setNClob(this.getParameterIndex(string), nClob);
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader);
        this.setNClob(this.getParameterIndex(string), reader);
    }

    @Override
    public void setNClob(String string, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, reader, l);
        this.setNClob(this.getParameterIndex(string), reader, l);
    }

    @Override
    public void setNString(String string, String string2) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, string2);
        this.setNString(this.getParameterIndex(string), string2);
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, rowId);
        this.setRowId(this.getParameterIndex(string), rowId);
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, sQLXML);
        this.setSQLXML(this.getParameterIndex(string), sQLXML);
    }

    @Override
    public boolean wasNull() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        return this.m_wasLastParameterNull;
    }

    @Override
    protected boolean allInputParameterValuesPopulated() {
        int n = this.m_parameterInputStreamData.size() + this.m_parameterInputValues.size();
        int n2 = 0;
        for (ParameterMetadata parameterMetadata : this.m_parameterMetadata) {
            if (ParameterType.OUTPUT != parameterMetadata.getParameterType() && ParameterType.RETURN_VALUE != parameterMetadata.getParameterType()) continue;
            ++n2;
        }
        return n + n2 == this.m_parameterMetadata.size();
    }

    @Override
    protected void checkParameters(List<ParameterMetadata> list) throws SQLException {
    }

    @Override
    protected void checkTypeSupported(int n) throws SQLException {
        switch (n) {
            case -11: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: 
            case 2000: {
                break;
            }
            default: {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IResults executeWithParams(ArrayList<ParameterMetadata> arrayList, ArrayList<ArrayList<ParameterInputValue>> arrayList2, ParameterGeneratedValues parameterGeneratedValues, SStatement.ThrowCondition throwCondition) throws SQLException {
        try {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isInCancelableFunction = true;
            }
            this.checkCondition(this.m_preparedSql, throwCondition);
            object = new ExecutionContexts(arrayList, arrayList2, this.m_generatedParams);
            Iterator<ArrayList<DataWrapper>> iterator = this.m_cancelLock;
            synchronized (iterator) {
                if (this.m_isCanceled) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.OPERATION_CANCELED, (IWarningListener)this.m_warningListener, ExceptionType.TRANSIENT, new Object[0]);
                }
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.m_queryExecutor.execute((ExecutionContexts)object, this.m_warningListener);
            iterator = ((ExecutionContexts)object).outputIterator();
            if (iterator.hasNext()) {
                this.m_parameterOutputValues = iterator.next();
            }
            IResults iResults = this.m_queryExecutor.getResults();
            return iResults;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
        finally {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isInCancelableFunction = false;
                this.m_isCanceled = false;
            }
        }
    }

    protected int getOutputParameterOnlyIndex(int n) throws SQLException {
        this.checkValidParameterIndex(n);
        if (ParameterType.INPUT == this.m_parameterTypes.get(n - 1)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_RETRIEVE_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n));
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (ParameterType.INPUT == this.m_parameterTypes.get(i)) continue;
            ++n2;
        }
        if (0 == n2) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_OUTPUT_INDEX, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(n));
        }
        return n2;
    }

    protected DataWrapper getOutputParameterValue(int n) throws SQLException {
        int n2 = this.getOutputParameterOnlyIndex(n);
        return this.m_parameterOutputValues.get(n2 - 1);
    }

    protected int getParameterIndex(String string) throws SQLException {
        for (int i = 0; i < this.m_parameterMetadata.size(); ++i) {
            ParameterMetadata parameterMetadata = (ParameterMetadata)this.m_parameterMetadata.get(i);
            if (!parameterMetadata.getName().equals(string)) continue;
            return i + 1;
        }
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_NAME, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, string);
    }

    private boolean allOutputParametersRegistered() {
        return !this.m_parameterRegistered.contains(Boolean.FALSE);
    }

    private void resetRegisteredParameters() {
        this.m_parameterRegistered.clear();
        for (int i = 0; i < this.m_numParameters; ++i) {
            if (ParameterType.INPUT == this.m_parameterTypes.get(i)) continue;
            this.m_parameterRegistered.add(Boolean.FALSE);
        }
        this.m_parameterScale.clear();
    }

    private void closeCurrentStream() throws SQLException {
        if (null == this.m_currentStream) {
            return;
        }
        try {
            this.m_currentStream.close();
            this.m_currentStream = null;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }
}

