/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.jdbc.jdbc41;

import com.simba.googlebigquery.dsi.core.interfaces.IStatement;
import com.simba.googlebigquery.dsi.dataengine.interfaces.IResultSet;
import com.simba.googlebigquery.exceptions.ExceptionConverter;
import com.simba.googlebigquery.jdbc.common.SConnection;
import com.simba.googlebigquery.jdbc.common.SForwardResultSet;
import com.simba.googlebigquery.jdbc.common.SStatement;
import com.simba.googlebigquery.jdbc.jdbc41.S41ForwardResultSet;
import com.simba.googlebigquery.jdbc.jdbc41.S41UpdatableForwardResultSet;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.utilities.JDBCVersion;
import java.sql.ResultSet;
import java.sql.SQLException;

public class S41Statement
extends SStatement {
    public S41Statement(IStatement iStatement, SConnection sConnection, int n) {
        super(iStatement, sConnection, n);
        this.m_jdbcVersion = JDBCVersion.JDBC41;
    }

    @Override
    protected ResultSet createResultSet(IResultSet iResultSet, boolean bl, int n) throws SQLException {
        SForwardResultSet sForwardResultSet = bl ? new S41UpdatableForwardResultSet(this, iResultSet, this.getLogger()) : new S41ForwardResultSet(this, iResultSet, this.getLogger());
        sForwardResultSet.setFetchSize(n);
        return sForwardResultSet;
    }

    @Override
    public synchronized void closeOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            this.m_closeOnCompletion = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized boolean isCloseOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            return this.m_closeOnCompletion;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }
}

