/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.license.interfaces;

import com.simba.googlebigquery.commons.codec.binary.Base64;
import com.simba.googlebigquery.license.interfaces.SimbaLicenseException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LicenseInfo {
    public static final String EVALUATION_STRING = "Evaluation";
    public static final int BITMASK_LENGTH = 64;
    private static final int BITMASK_BYTES = 8;
    private static final int FOUR_BYTES = 4;
    private static final int INTERLEAVED_BYTES = 16;
    private static final String NODE_NAME_INFO = "Info";
    private static final String NODE_NAME_LICENSE_TYPE = "LicenseType";
    private static final String NODE_NAME_PRODUCT_NAME = "Product";
    private static final String NODE_NAME_PRODUCT_PLATFORM = "Platform";
    private static final String NODE_NAME_PRODUCT_VERSION = "ProductVersion";
    private static final String NODE_NAME_LICENSE_KEY = "Key";
    private static final String NODE_NAME_LICENSE_EXPIRY = "Expiry";
    private static final String LICENSE_DATE_FORMAT_STRING = "yyyy-MM-dd";
    private SimpleDateFormat licenseDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private Document mDoc = null;
    private String mLicenseString = null;
    private byte[] mSignature = null;
    private byte[] mBitMask = new byte[8];
    private Date mExpiry = null;
    private XPath mXpath = XPathFactory.newInstance().newXPath();

    public LicenseInfo(String string) throws SimbaLicenseException {
        this.mLicenseString = string;
        this.parseLicense();
    }

    public final String getLicenseInfoAsText() {
        String string = "No Info tag found in license";
        Pattern pattern = Pattern.compile("<Info.*</Info>", 32);
        Matcher matcher = pattern.matcher(this.mLicenseString);
        if (matcher.find()) {
            string = matcher.group(0);
        }
        return string;
    }

    public final byte[] getBitMask() {
        return (byte[])this.mBitMask.clone();
    }

    public final byte[] getLicenseSignature() {
        return (byte[])this.mSignature.clone();
    }

    public final String getLicenseType() {
        return this.getNodeTextContent(NODE_NAME_LICENSE_TYPE);
    }

    public final String getLicenseVersion() {
        return this.getAttributeValue(NODE_NAME_INFO, "version");
    }

    public final String getProduct() {
        return this.getNodeTextContent(NODE_NAME_PRODUCT_NAME);
    }

    public final String getProductPlatform() {
        return this.getNodeTextContent(NODE_NAME_PRODUCT_PLATFORM);
    }

    public final String getProductVersion() {
        return this.getNodeTextContent(NODE_NAME_PRODUCT_VERSION);
    }

    public final Date getExpiry() {
        return this.mExpiry;
    }

    private void parseLicense() throws SimbaLicenseException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            documentBuilderFactory.setXIncludeAware(false);
            documentBuilderFactory.setExpandEntityReferences(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            String string = LicenseInfo.removeUTF8BOM(this.mLicenseString.trim());
            this.mDoc = documentBuilder.parse(new InputSource(new ByteArrayInputStream(string.getBytes("utf-8"))));
        }
        catch (SAXException sAXException) {
            String string = String.format("Invalid license text format, failed XML parsing. Exception reason: %s", sAXException.getMessage());
            throw new SimbaLicenseException(string);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = String.format("Internal Licensing error: %s", parserConfigurationException.getMessage());
            throw new SimbaLicenseException(string);
        }
        catch (IOException iOException) {
            String string = String.format("Internal Licensing error: %s", iOException.getMessage());
            throw new SimbaLicenseException(string);
        }
        this.parseKeyString();
        this.setExpiry();
    }

    private static String removeUTF8BOM(String string) {
        int n = string.indexOf("<");
        if (n > 0) {
            string = string.substring(n);
        }
        return string;
    }

    private Node getXpathObject(String string) {
        Object object = null;
        if (this.mDoc != null) {
            try {
                object = this.mXpath.evaluate(string, this.mDoc, XPathConstants.NODE);
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        return (Node)object;
    }

    private Node findNode(String string, NodeList nodeList) {
        if (null != nodeList) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node;
                Node node2 = nodeList.item(i);
                if (null != node2 && null != node2.getNodeName() && string.equals(node2.getNodeName())) {
                    return node2;
                }
                if (!node2.hasChildNodes() || null == (node = this.findNode(string, node2.getChildNodes()))) continue;
                return node;
            }
        }
        return null;
    }

    private String getNodeTextContent(String string) {
        Node node = this.findNode(string, this.mDoc.getChildNodes());
        if (node != null) {
            return node.getTextContent();
        }
        return "";
    }

    private String getAttributeValue(String string, String string2) {
        NamedNodeMap namedNodeMap;
        Node node;
        Node node2 = this.findNode(string, this.mDoc.getChildNodes());
        Element element = (Element)this.getXpathObject(string);
        if (null != node2 && null != (node = (namedNodeMap = node2.getAttributes()).getNamedItem(string2))) {
            return node.getTextContent();
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseKeyString() throws SimbaLicenseException {
        String string = this.getNodeTextContent(NODE_NAME_LICENSE_KEY);
        byte[] byArray = string.getBytes();
        if (string.length() > 16 && byArray.length % 4 == 0) {
            int n;
            byte[] byArray2 = Base64.decodeBase64(byArray);
            if (byArray2 == null) {
                String string2 = "Cannot find valid key string in license";
                throw new SimbaLicenseException(string2);
            }
            this.mSignature = new byte[byArray2.length - 8];
            for (n = 0; n < 16; n += 2) {
                this.mSignature[n / 2] = byArray2[n];
                this.mBitMask[n / 2] = byArray2[n + 1];
            }
            n = 16;
            while (true) {
                if (n >= byArray2.length) {
                    return;
                }
                this.mSignature[n - 8] = byArray2[n];
                ++n;
            }
        }
        String string3 = "Cannot find valid key string in license";
        throw new SimbaLicenseException(string3);
    }

    private void setExpiry() throws SimbaLicenseException {
        String string = this.getNodeTextContent(NODE_NAME_LICENSE_EXPIRY);
        if (string.equals("")) {
            this.mExpiry = new Date();
        } else if (string.length() == LICENSE_DATE_FORMAT_STRING.length()) {
            try {
                Date date = this.licenseDateFormat.parse(string);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.set(11, 23);
                calendar.set(12, 59);
                calendar.set(13, 59);
                calendar.set(14, 999);
                this.mExpiry = calendar.getTime();
            }
            catch (ParseException parseException) {
                String string2 = "Invalid_expiry format";
                throw new SimbaLicenseException(string2);
            }
        } else {
            String string3 = "Invalid_expiry format";
            throw new SimbaLicenseException(string3);
        }
    }
}

