/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.streams.resultset;

import com.simba.googlebigquery.dsi.dataengine.interfaces.IResultSet;
import com.simba.googlebigquery.dsi.dataengine.utilities.DataWrapper;
import com.simba.googlebigquery.dsi.exceptions.InputOutputException;
import com.simba.googlebigquery.exceptions.JDBCMessageKey;
import com.simba.googlebigquery.streams.IStream;
import java.io.IOException;
import java.io.Reader;

public class CharacterStream
extends Reader
implements IStream {
    private IResultSet m_result = null;
    private int m_column = 0;
    private int m_resultSetOffset = 0;
    private boolean m_hasMoreData = true;
    private int m_stringOffset = 0;
    private String m_stringBuffer = "";
    private int m_bufferSize = 0;
    private DataWrapper m_data = new DataWrapper();

    public CharacterStream(IResultSet iResultSet, int n, int n2) {
        this.m_result = iResultSet;
        this.m_column = n;
        this.m_bufferSize = n2;
    }

    @Override
    public void close() throws IOException {
        this.m_result = null;
        this.m_stringBuffer = null;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (null == cArray) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_INVALID_BUFFER.name());
        }
        if (0 > n || n != 0 && cArray.length <= n) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_INVALID_OFFSET.name(), new String[]{String.valueOf(n), String.valueOf(cArray.length)});
        }
        int n3 = 0;
        int n4 = Math.min(cArray.length - n, n2);
        do {
            if (this.m_stringOffset >= this.m_stringBuffer.length() && !this.fetchMoreData()) {
                if (n3 == 0) {
                    return -1;
                }
                return n3;
            }
            cArray[n3++ + n] = this.m_stringBuffer.charAt(this.m_stringOffset++);
        } while (n3 < n4);
        return n3;
    }

    private boolean fetchMoreData() throws InputOutputException {
        if (!this.m_hasMoreData) {
            return false;
        }
        try {
            this.m_hasMoreData = this.m_result.getData(this.m_column, this.m_resultSetOffset, this.m_bufferSize, this.m_data);
            this.m_stringOffset = 0;
            this.m_stringBuffer = (String)this.m_data.getObject();
            this.m_resultSetOffset += this.m_stringBuffer.length() * 2;
        }
        catch (Exception exception) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_READ_ERROR.name());
        }
        return 0 != this.m_stringBuffer.length();
    }
}

