/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.bigquery.sqlgenerator;

import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.datatype.DataTypeFactory;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.CreateDatabaseChangeLogLockTableGenerator;
import liquibase.statement.ColumnConstraint;
import liquibase.statement.NotNullConstraint;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateDatabaseChangeLogLockTableStatement;
import liquibase.statement.core.CreateTableStatement;

public class BigqueryCreateDatabaseChangeLogLockTableGenerator
extends CreateDatabaseChangeLogLockTableGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sql[] generateSql(CreateDatabaseChangeLogLockTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String charTypeName = this.getCharTypeName(database);
        String dateTimeTypeString = this.getDateTimeTypeString(database);
        CreateTableStatement createTableStatement = new CreateTableStatement(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), database.getDatabaseChangeLogLockTableName()).setTablespace(database.getLiquibaseTablespaceName()).addColumn("ID", DataTypeFactory.getInstance().fromDescription("int", database), null, null, new ColumnConstraint[]{new NotNullConstraint()}).addColumn("LOCKED", DataTypeFactory.getInstance().fromDescription("bool", database), null, null, new ColumnConstraint[]{new NotNullConstraint()}).addColumn("LOCKGRANTED", DataTypeFactory.getInstance().fromDescription(dateTimeTypeString, database)).addColumn("LOCKEDBY", DataTypeFactory.getInstance().fromDescription(charTypeName + "(255)", database));
        ObjectQuotingStrategy currentStrategy = database.getObjectQuotingStrategy();
        database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
        try {
            Sql[] sqlArray = SqlGeneratorFactory.getInstance().generateSql((SqlStatement)createTableStatement, database);
            return sqlArray;
        }
        finally {
            database.setObjectQuotingStrategy(currentStrategy);
        }
    }

    protected String getCharTypeName(Database database) {
        return "string";
    }
}

