/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.http;

import com.amazon.redshift.amazonaws.annotation.Immutable;
import com.amazon.redshift.amazonaws.http.HttpResponse;
import java.util.Collections;
import java.util.Map;

@Immutable
public class SdkHttpMetadata {
    private final Map<String, String> httpHeaders;
    private final int httpStatusCode;

    private SdkHttpMetadata(Map<String, String> httpHeaders, int httpStatusCode) {
        this.httpHeaders = Collections.unmodifiableMap(httpHeaders);
        this.httpStatusCode = httpStatusCode;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public static SdkHttpMetadata from(HttpResponse httpResponse) {
        return new SdkHttpMetadata(httpResponse.getHeaders(), httpResponse.getStatusCode());
    }
}

