/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.http.timers.client;

import com.amazon.redshift.amazonaws.annotation.SdkInternalApi;
import com.amazon.redshift.amazonaws.http.timers.client.ClientExecutionAbortTask;
import com.amazon.redshift.amazonaws.http.timers.client.ClientExecutionAbortTrackerTask;
import com.amazon.redshift.amazonaws.util.ValidationUtils;
import com.amazon.redshift.shaded.apache.http.client.methods.HttpRequestBase;
import java.util.concurrent.ScheduledFuture;

@SdkInternalApi
public class ClientExecutionAbortTrackerTaskImpl
implements ClientExecutionAbortTrackerTask {
    private final ClientExecutionAbortTask task;
    private final ScheduledFuture<?> future;

    public ClientExecutionAbortTrackerTaskImpl(ClientExecutionAbortTask task, ScheduledFuture<?> future) {
        this.task = ValidationUtils.assertNotNull(task, "task");
        this.future = ValidationUtils.assertNotNull(future, "future");
    }

    @Override
    public void setCurrentHttpRequest(HttpRequestBase newRequest) {
        this.task.setCurrentHttpRequest(newRequest);
    }

    @Override
    public boolean hasTimeoutExpired() {
        return this.task.hasClientExecutionAborted();
    }

    @Override
    public boolean isEnabled() {
        return this.task.isEnabled();
    }

    @Override
    public void cancelTask() {
        this.future.cancel(false);
    }
}

