/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.internal.auth;

import com.amazon.redshift.amazonaws.AmazonWebServiceClient;
import com.amazon.redshift.amazonaws.AmazonWebServiceRequest;
import com.amazon.redshift.amazonaws.Request;
import com.amazon.redshift.amazonaws.auth.Signer;
import com.amazon.redshift.amazonaws.auth.SignerFactory;
import com.amazon.redshift.amazonaws.auth.SignerParams;
import com.amazon.redshift.amazonaws.auth.SignerTypeAware;
import com.amazon.redshift.amazonaws.internal.auth.SignerProvider;
import com.amazon.redshift.amazonaws.internal.auth.SignerProviderContext;
import com.amazon.redshift.amazonaws.util.AwsHostNameUtils;
import java.net.URI;

public class DefaultSignerProvider
extends SignerProvider {
    private final AmazonWebServiceClient awsClient;
    private final Signer defaultSigner;

    public DefaultSignerProvider(AmazonWebServiceClient awsClient, Signer defaultSigner) {
        this.awsClient = awsClient;
        this.defaultSigner = defaultSigner;
    }

    @Override
    public Signer getSigner(SignerProviderContext context) {
        Request<?> request = context.getRequest();
        if (request == null || this.shouldUseDefaultSigner(request.getOriginalRequest())) {
            if (context.isRedirect()) {
                return this.awsClient.getSignerByURI(context.getUri());
            }
            return this.defaultSigner;
        }
        SignerTypeAware signerTypeAware = (SignerTypeAware)((Object)request.getOriginalRequest());
        SignerParams params = new SignerParams(this.awsClient.getServiceName(), this.getSigningRegionForRequestURI(request.getEndpoint()));
        return SignerFactory.createSigner(signerTypeAware.getSignerType(), params);
    }

    private boolean shouldUseDefaultSigner(AmazonWebServiceRequest originalRequest) {
        return !(originalRequest instanceof SignerTypeAware) || this.isSignerOverridden();
    }

    private boolean isSignerOverridden() {
        return this.awsClient.getSignerOverride() != null;
    }

    private String getSigningRegionForRequestURI(URI uri) {
        String regionName = this.awsClient.getSignerRegionOverride();
        if (regionName == null) {
            regionName = AwsHostNameUtils.parseRegion(uri.getHost(), this.awsClient.getServiceName());
        }
        return regionName;
    }
}

