/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.util;

import com.amazon.redshift.amazonaws.log.InternalLogApi;
import com.amazon.redshift.amazonaws.log.InternalLogFactory;
import com.amazon.redshift.amazonaws.util.Base64Codec;
import com.amazon.redshift.amazonaws.util.CodecUtils;
import java.util.HashMap;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

public enum Base64 {

    private static final InternalLogApi LOG = InternalLogFactory.getLog(Base64.class);
    private static final Base64Codec codec = new Base64Codec();

    public static String encodeAsString(byte ... bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return DatatypeConverter.printBase64Binary((byte[])bytes);
        }
        catch (NullPointerException ex) {
            LOG.debug("Recovering from JAXB bug: https://netbeans.org/bugzilla/show_bug.cgi?id=224923", ex);
            return bytes.length == 0 ? "" : CodecUtils.toStringDirect(codec.encode(bytes));
        }
    }

    public static byte[] encode(byte[] bytes) {
        return bytes == null || bytes.length == 0 ? bytes : codec.encode(bytes);
    }

    public static byte[] decode(String b64) {
        if (b64 == null) {
            return null;
        }
        if (b64.length() == 0) {
            return new byte[0];
        }
        byte[] buf = new byte[b64.length()];
        int len = CodecUtils.sanitize(b64, buf);
        return codec.decode(buf, len);
    }

    public static byte[] decode(byte[] b64) {
        return b64 == null || b64.length == 0 ? b64 : codec.decode(b64, b64.length);
    }

    static {
        HashMap<String, String> inconsistentJaxbImpls = new HashMap<String, String>();
        inconsistentJaxbImpls.put("org.apache.ws.jaxme.impl.JAXBContextImpl", "Apache JaxMe");
        try {
            String className = JAXBContext.newInstance((Class[])new Class[0]).getClass().getName();
            if (inconsistentJaxbImpls.values().contains(className)) {
                LOG.warn("A JAXB implementation known to produce base64 encodings that are inconsistent with the reference implementation has been detected. The results of the encodeAsString() method may be incorrect. Implementation: " + (String)inconsistentJaxbImpls.get(className));
            }
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
    }
}

