/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.support.exceptions.ErrorException;
import java.nio.ByteBuffer;

public class CommandComplete
extends AbstractInboundMessage
implements PGConstants {
    private static final byte TAG_R = 82;
    private static final byte TAG_I = 73;
    private static final byte TAG_D = 68;
    private static final byte TAG_P = 80;
    private static final byte TAG_U = 85;
    private static final byte TAG_S = 83;
    private static final byte TAG_E = 69;
    private static final byte TAG_L = 76;
    private static final byte TAG_M = 77;
    private static final byte TAG_F = 70;
    private static final byte TAG_C = 67;
    private static final byte TAG_A = 65;
    private static final byte TAG_B = 66;
    private static final byte TAG_T = 84;
    private final byte[] m_commandTag;
    private boolean m_isInsert = false;
    private boolean m_isCreate = false;
    private boolean m_isDelete = false;
    private boolean m_isDrop = false;
    private boolean m_isUpdate = false;
    private boolean m_isSelect = false;
    private boolean m_isMove = false;
    private boolean m_isFetch = false;
    private boolean m_isCopy = false;
    private boolean m_isSavepoint = false;
    private boolean m_isBegin = false;
    private boolean m_isPrepare = false;
    private boolean m_isDeclareCursor = false;
    private boolean m_isCloseCursor = false;
    private boolean m_isTruncate = false;
    private boolean m_isCommit = false;
    private boolean m_isRollback = false;
    private boolean m_isRevoke = false;
    private int m_insertTableOID;
    private long m_numRows;

    protected CommandComplete() {
        this.m_commandTag = null;
    }

    public CommandComplete(ByteBuffer byteBuffer, int n, IPGLogger iPGLogger) throws ErrorException {
        this.m_commandTag = new byte[n - 1 - 4];
        this.m_numRows = 0L;
        byteBuffer.get(this.m_commandTag);
        byteBuffer.position(byteBuffer.position() + 1);
        String string = PGDataTypeUtilities.toUTF8String(this.m_commandTag);
        String[] stringArray = string.split(" ");
        switch (this.m_commandTag[0]) {
            case 73: {
                if (6 != stringArray[0].length() || !stringArray[0].equals("INSERT")) break;
                this.m_isInsert = true;
                if (1 < stringArray.length) {
                    this.m_insertTableOID = Integer.parseInt(stringArray[1]);
                }
                if (2 >= stringArray.length) break;
                this.m_numRows = Long.parseLong(stringArray[2]);
                break;
            }
            case 68: {
                if (4 == stringArray[0].length() && stringArray[0].equals("DROP")) {
                    this.m_isDrop = true;
                    if (1 >= stringArray.length) break;
                    this.m_numRows = 0L;
                    break;
                }
                if (6 == stringArray[0].length() && stringArray[0].equals("DELETE")) {
                    this.m_isDelete = true;
                    if (1 >= stringArray.length) break;
                    this.m_numRows = Long.parseLong(stringArray[1]);
                    break;
                }
                if (7 != stringArray[0].length() || !stringArray[0].equals("DECLARE") || 1 >= stringArray.length || 6 != stringArray[1].length() || !stringArray[1].equals("CURSOR")) break;
                this.m_isDeclareCursor = true;
                this.m_numRows = 0L;
                break;
            }
            case 85: {
                if (6 != stringArray[0].length() || !stringArray[0].equals("UPDATE")) break;
                this.m_isUpdate = true;
                if (1 >= stringArray.length) break;
                this.m_numRows = Long.parseLong(stringArray[1]);
                break;
            }
            case 83: {
                switch (this.m_commandTag[1]) {
                    case 65: {
                        if (9 != stringArray[0].length() || !stringArray[0].equals("SAVEPOINT")) break;
                        this.m_isSavepoint = true;
                        break;
                    }
                    case 69: {
                        if (6 != stringArray[0].length() || !stringArray[0].equals("SELECT")) break;
                        this.m_isSelect = true;
                        if (1 >= stringArray.length) break;
                        this.m_numRows = Long.parseLong(stringArray[1]);
                        break;
                    }
                    case 84: {
                        if (5 != stringArray[0].length() || !stringArray[0].equals("START") || 11 != stringArray[1].length() || !stringArray[1].equals("TRANSACTION")) break;
                        this.m_isBegin = true;
                    }
                }
                break;
            }
            case 77: {
                if (4 != stringArray[0].length() || !stringArray[0].equals("MOVE")) break;
                this.m_isMove = true;
                if (1 >= stringArray.length) break;
                this.m_numRows = Long.parseLong(stringArray[1]);
                break;
            }
            case 70: {
                if (5 != stringArray[0].length() || !stringArray[0].equals("FETCH")) break;
                this.m_isFetch = true;
                if (1 >= stringArray.length) break;
                this.m_numRows = Long.parseLong(stringArray[1]);
                break;
            }
            case 67: {
                if (6 == stringArray[0].length() && stringArray[0].equals("CREATE")) {
                    this.m_isCreate = true;
                    if (1 >= stringArray.length) break;
                    this.m_numRows = 0L;
                    break;
                }
                if (5 == stringArray[0].length() && stringArray[0].equals("CLOSE") && 1 < stringArray.length && 6 == stringArray[1].length() && stringArray[1].equals("CURSOR")) {
                    this.m_isCloseCursor = true;
                    this.m_numRows = 0L;
                    break;
                }
                if (6 == stringArray[0].length() && stringArray[0].equals("COMMIT")) {
                    this.m_isCommit = true;
                    break;
                }
                if (4 != stringArray[0].length() || !stringArray[0].equals("COPY")) break;
                this.m_isCopy = true;
                if (1 >= stringArray.length) break;
                this.m_numRows = Long.parseLong(stringArray[1]);
                break;
            }
            case 66: {
                if (5 != stringArray[0].length() || !stringArray[0].equals("BEGIN")) break;
                this.m_isBegin = true;
                break;
            }
            case 80: {
                if (7 != stringArray[0].length() || !stringArray[0].equals("PREPARE")) break;
                this.m_isPrepare = true;
                break;
            }
            case 84: {
                if (8 != stringArray[0].length() || !stringArray[0].equals("TRUNCATE")) break;
                this.m_isTruncate = true;
                break;
            }
            case 82: {
                if (6 == stringArray[0].length() && stringArray[0].equals("REVOKE")) {
                    this.m_isRevoke = true;
                    break;
                }
                if (8 != stringArray[0].length() || !stringArray[0].equals("ROLLBACK")) break;
                this.m_isRollback = true;
            }
        }
        if (iPGLogger.isExternalLoggerEnabled()) {
            this.logMessageContent(iPGLogger);
        }
    }

    public boolean isPrepare() {
        return this.m_isPrepare;
    }

    public boolean isInsert() {
        return this.m_isInsert;
    }

    public boolean isCreate() {
        return this.m_isCreate;
    }

    public boolean isDelete() {
        return this.m_isDelete;
    }

    public boolean isDrop() {
        return this.m_isDrop;
    }

    public boolean isUpdate() {
        return this.m_isUpdate;
    }

    public boolean isSelect() {
        return this.m_isSelect;
    }

    public boolean isMove() {
        return this.m_isMove;
    }

    public boolean isFetch() {
        return this.m_isFetch;
    }

    public boolean isCopy() {
        return this.m_isCopy;
    }

    public boolean isSavepoint() {
        return this.m_isSavepoint;
    }

    public boolean isBegin() {
        return this.m_isBegin;
    }

    public int getInsertTableOID() {
        return this.m_insertTableOID;
    }

    public boolean isTruncate() {
        return this.m_isTruncate;
    }

    public boolean isCommit() {
        return this.m_isCommit;
    }

    public boolean isRollback() {
        return this.m_isRollback;
    }

    public boolean isRevoke() {
        return this.m_isRevoke;
    }

    public long getNumRows() {
        return this.m_numRows;
    }

    public void logMessageContent(IPGLogger iPGLogger) {
        String string = "<=BE CommandStatus(" + new String(this.m_commandTag) + ")";
        iPGLogger.logDebugExternal(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nCommandComplete: getCommandTag - ");
        stringBuilder.append(new String(this.m_commandTag));
        stringBuilder.append(" - numRows :");
        stringBuilder.append(this.getNumRows());
        stringBuilder.append(" - isInsert :");
        stringBuilder.append(this.isInsert());
        stringBuilder.append(" - isCreate :");
        stringBuilder.append(this.isCreate());
        stringBuilder.append(" - isUpdate :");
        stringBuilder.append(this.isUpdate());
        stringBuilder.append(" - isSelect :");
        stringBuilder.append(this.isSelect());
        stringBuilder.append(" - isDelete :");
        stringBuilder.append(this.isDelete());
        stringBuilder.append(" - isDrop :");
        stringBuilder.append(this.isDrop());
        stringBuilder.append(" - isFetch :");
        stringBuilder.append(this.isFetch());
        stringBuilder.append(" - isMove :");
        stringBuilder.append(this.isMove());
        stringBuilder.append(" - isCopy :");
        stringBuilder.append(this.isCopy());
        stringBuilder.append(" - isSavepoint :");
        stringBuilder.append(this.isSavepoint());
        stringBuilder.append(" - isBegin :");
        stringBuilder.append(this.isBegin());
        stringBuilder.append(" - isPrepare :");
        stringBuilder.append(this.isPrepare());
        return stringBuilder.toString();
    }
}

