/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin.httpserver;

import com.amazon.redshift.plugin.httpserver.InvalidHttpRequestHandler;
import com.amazon.redshift.plugin.httpserver.ValidHttpRequestHandler;
import com.amazon.redshift.shaded.apache.http.HttpException;
import com.amazon.redshift.shaded.apache.http.HttpRequest;
import com.amazon.redshift.shaded.apache.http.HttpResponse;
import com.amazon.redshift.shaded.apache.http.NameValuePair;
import com.amazon.redshift.shaded.apache.http.RequestLine;
import com.amazon.redshift.shaded.apache.http.client.utils.URLEncodedUtils;
import com.amazon.redshift.shaded.apache.http.message.BasicHttpEntityEnclosingRequest;
import com.amazon.redshift.shaded.apache.http.protocol.HttpContext;
import com.amazon.redshift.shaded.apache.http.protocol.HttpRequestHandler;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;

public class RequestHandler
implements HttpRequestHandler {
    public static final String REDSHIFT_PATH = "/redshift/";
    private static final String SUPPORTED_METHOD = "POST";
    private final Function<List<NameValuePair>, Object> m_requestProcessLogic;
    private final HttpRequestHandler m_invalidRequestHandler;
    private final HttpRequestHandler m_validRequestHandler;
    private Object m_result;

    public RequestHandler(Function<List<NameValuePair>, Object> function) {
        this.m_requestProcessLogic = function;
        this.m_invalidRequestHandler = new InvalidHttpRequestHandler();
        this.m_validRequestHandler = new ValidHttpRequestHandler();
    }

    @Override
    public void handle(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        if (this.isRequestValid(httpRequest)) {
            this.m_result = this.m_requestProcessLogic.apply(URLEncodedUtils.parse(((BasicHttpEntityEnclosingRequest)httpRequest).getEntity()));
            this.m_validRequestHandler.handle(httpRequest, httpResponse, httpContext);
        } else {
            this.m_invalidRequestHandler.handle(httpRequest, httpResponse, httpContext);
        }
    }

    private boolean isRequestValid(HttpRequest httpRequest) {
        RequestLine requestLine = httpRequest.getRequestLine();
        if (!SUPPORTED_METHOD.equalsIgnoreCase(requestLine.getMethod())) {
            return false;
        }
        return requestLine.getUri().startsWith(REDSHIFT_PATH);
    }

    public Object getResult() {
        return this.m_result;
    }

    public boolean hasResult() {
        return this.m_result != null;
    }
}

