/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.shaded.apache.http.client.protocol;

import com.amazon.redshift.shaded.apache.commons.logging.Log;
import com.amazon.redshift.shaded.apache.commons.logging.LogFactory;
import com.amazon.redshift.shaded.apache.http.HttpException;
import com.amazon.redshift.shaded.apache.http.HttpRequest;
import com.amazon.redshift.shaded.apache.http.HttpRequestInterceptor;
import com.amazon.redshift.shaded.apache.http.annotation.Immutable;
import com.amazon.redshift.shaded.apache.http.client.protocol.HttpClientContext;
import com.amazon.redshift.shaded.apache.http.conn.routing.RouteInfo;
import com.amazon.redshift.shaded.apache.http.protocol.HttpContext;
import com.amazon.redshift.shaded.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String PROXY_CONN_DIRECTIVE = "Proxy-Connection";

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            request.setHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            this.log.debug("Connection route not set in the context");
            return;
        }
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
        if (route.getHopCount() == 2 && !route.isTunnelled() && !request.containsHeader(PROXY_CONN_DIRECTIVE)) {
            request.addHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
        }
    }
}

