/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.shaded.apache.http.protocol;

import com.amazon.redshift.shaded.apache.http.HttpEntity;
import com.amazon.redshift.shaded.apache.http.HttpEntityEnclosingRequest;
import com.amazon.redshift.shaded.apache.http.HttpException;
import com.amazon.redshift.shaded.apache.http.HttpRequest;
import com.amazon.redshift.shaded.apache.http.HttpRequestInterceptor;
import com.amazon.redshift.shaded.apache.http.HttpVersion;
import com.amazon.redshift.shaded.apache.http.ProtocolVersion;
import com.amazon.redshift.shaded.apache.http.annotation.Immutable;
import com.amazon.redshift.shaded.apache.http.protocol.HttpContext;
import com.amazon.redshift.shaded.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

