#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['yaqd_thorlabs']

package_data = \
{'': ['*']}

install_requires = \
['yaqd-core>=2020.10.1', 'thorlabs-apt-protocol', 'pyserial']

extras_require = \
{'dev': ['black', 'pre-commit']}

entry_points = \
{'console_scripts': ['yaqd-thorlabs-bsc201 = '
                     'yaqd_thorlabs._thorlabs_bsc201:ThorlabsBSC201.main',
                     'yaqd-thorlabs-k10cr1 = '
                     'yaqd_thorlabs._thorlabs_k10cr1:ThorlabsK10CR1.main',
                     'yaqd-thorlabs-kdc101 = '
                     'yaqd_thorlabs._thorlabs_kdc101:ThorlabsKDC101.main',
                     'yaqd-thorlabs-kst101 = '
                     'yaqd_thorlabs._thorlabs_kst101:ThorlabsKST101.main',
                     'yaqd-thorlabs-lts150 = '
                     'yaqd_thorlabs._thorlabs_lts150:ThorlabsLTS150.main',
                     'yaqd-thorlabs-lts300 = '
                     'yaqd_thorlabs._thorlabs_lts300:ThorlabsLTS300.main']}

setup(name='yaqd-thorlabs',
      version='2021.2.0',
      description='yaq daemons for thorlabs hardware',
      author='yaq Developers',
      author_email='git@ksunden.space',
      url='https://yaq.fyi',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.7',
     )
