import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
import { Listener, ListenerOptions } from './listener';
/**
 * The interface of the Accelerator.
 *
 * @stability stable
 */
export interface IAccelerator extends cdk.IResource {
    /**
     * The ARN of the accelerator.
     *
     * @stability stable
     * @attribute true
     */
    readonly acceleratorArn: string;
    /**
     * The Domain Name System (DNS) name that Global Accelerator creates that points to your accelerator's static IP addresses.
     *
     * @stability stable
     * @attribute true
     */
    readonly dnsName: string;
}
/**
 * Construct properties of the Accelerator.
 *
 * @stability stable
 */
export interface AcceleratorProps {
    /**
     * The name of the accelerator.
     *
     * @default - resource ID
     * @stability stable
     */
    readonly acceleratorName?: string;
    /**
     * Indicates whether the accelerator is enabled.
     *
     * @default true
     * @stability stable
     */
    readonly enabled?: boolean;
}
/**
 * Attributes required to import an existing accelerator to the stack.
 *
 * @stability stable
 */
export interface AcceleratorAttributes {
    /**
     * The ARN of the accelerator.
     *
     * @stability stable
     */
    readonly acceleratorArn: string;
    /**
     * The DNS name of the accelerator.
     *
     * @stability stable
     */
    readonly dnsName: string;
}
/**
 * The Accelerator construct.
 *
 * @stability stable
 */
export declare class Accelerator extends cdk.Resource implements IAccelerator {
    /**
     * import from attributes.
     *
     * @stability stable
     */
    static fromAcceleratorAttributes(scope: Construct, id: string, attrs: AcceleratorAttributes): IAccelerator;
    /**
     * The ARN of the accelerator.
     *
     * @stability stable
     */
    readonly acceleratorArn: string;
    /**
     * The Domain Name System (DNS) name that Global Accelerator creates that points to your accelerator's static IP addresses.
     *
     * @stability stable
     */
    readonly dnsName: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: AcceleratorProps);
    /**
     * Add a listener to the accelerator.
     *
     * @stability stable
     */
    addListener(id: string, options: ListenerOptions): Listener;
}
