<a id="mypy-boto3-ec2"></a>

# mypy-boto3-ec2

[![PyPI - mypy-boto3-ec2](https://img.shields.io/pypi/v/mypy-boto3-ec2.svg?color=blue)](https://pypi.org/project/mypy-boto3-ec2)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ec2.svg?color=blue)](https://pypi.org/project/mypy-boto3-ec2)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/mypy-boto3-ec2?color=blue)](https://pypistats.org/packages/mypy-boto3-ec2)

![boto3.typed](https://github.com/youtype/mypy_boto3_builder/raw/main/logo.png)

Type annotations for
[boto3.EC2 1.22.0](https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/ec2.html#EC2)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 7.5.9](https://github.com/youtype/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-ec2 docs](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ec2/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/youtype/mypy_boto3_builder/raw/main/demo.gif)

- [mypy-boto3-ec2](#mypy-boto3-ec2)
  - [How to install](#how-to-install)
    - [VSCode extension](#vscode-extension)
    - [From PyPI with pip](#from-pypi-with-pip)
    - [From conda-forge](#from-conda-forge)
  - [How to uninstall](#how-to-uninstall)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Emacs](#emacs)
    - [Sublime Text](#sublime-text)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [How it works](#how-it-works)
  - [What's new](#what's-new)
    - [Implemented features](#implemented-features)
    - [Latest changes](#latest-changes)
  - [Versioning](#versioning)
  - [Thank you](#thank-you)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

<a id="vscode-extension"></a>

### VSCode extension

Add
[AWS Boto3](https://marketplace.visualstudio.com/items?itemName=Boto3typed.boto3-ide)
extension to your VSCode and run `AWS boto3: Quick Start` command.

Click `Modify` and select `boto3 common` and `EC2`.

<a id="from-pypi-with-pip"></a>

### From PyPI with pip

Install `boto3-stubs` for `EC2` service.

```bash
# install with boto3 type annotations
python -m pip install 'boto3-stubs[ec2]'


# Lite version does not provide session.client/resource overloads
# it is more RAM-friendly, but requires explicit type annotations
python -m pip install 'boto3-stubs-lite[ec2]'


# standalone installation
python -m pip install mypy-boto3-ec2
```

<a id="from-conda-forge"></a>

### From conda-forge

Installing `mypy-boto3-ec2` from the `conda-forge` channel can be achieved by
adding `conda-forge` to your channels with:

```bash
conda config --add channels conda-forge
conda config --set channel_priority strict
```

Once the `conda-forge` channel has been enabled, `mypy-boto3-ec2` can be
installed with:

```bash
conda install mypy-boto3-ec2
```

It is possible to list all of the versions of `mypy-boto3-ec2` available on
your platform with:

```bash
conda search mypy-boto3-ec2 --channel conda-forge
```

<a id="how-to-uninstall"></a>

## How to uninstall

```bash
python -m pip uninstall -y mypy-boto3-ec2
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto3-stubs[ec2]` in your environment:

```bash
python -m pip install 'boto3-stubs[ec2]'
```

Both type checking and code completion should now work. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

Install `boto3-stubs-lite[ec2]` in your environment:

```bash
python -m pip install 'boto3-stubs-lite[ec2]'`
```

Both type checking and code completion should now work. Explicit type
annotations **are required**.

Use `boto3-stubs` package instead for implicit type discovery.

<a id="emacs"></a>

### Emacs

- Install `boto3-stubs` with services you use in your environment:

```bash
python -m pip install 'boto3-stubs[ec2]'
```

- Install [use-package](https://github.com/jwiegley/use-package),
  [lsp](https://github.com/emacs-lsp/lsp-mode/),
  [company](https://github.com/company-mode/company-mode) and
  [flycheck](https://github.com/flycheck/flycheck) packages
- Install [lsp-pyright](https://github.com/emacs-lsp/lsp-pyright) package

```elisp
(use-package lsp-pyright
  :ensure t
  :hook (python-mode . (lambda ()
                          (require 'lsp-pyright)
                          (lsp)))  ; or lsp-deferred
  :init (when (executable-find "python3")
          (setq lsp-pyright-python-executable-cmd "python3"))
  )
```

- Make sure emacs uses the environment where you have installed `boto3-stubs`

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="sublime-text"></a>

### Sublime Text

- Install `boto3-stubs[ec2]` with services you use in your environment:

```bash
python -m pip install 'boto3-stubs[ec2]'
```

- Install [LSP-pyright](https://github.com/sublimelsp/LSP-pyright) package

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto3-stubs[ec2]` in your environment:

```bash
python -m pip install 'boto3-stubs[ec2]'`
```

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `npm i -g pyright`
- Install `boto3-stubs[ec2]` in your environment:

```bash
python -m pip install 'boto3-stubs[ec2]'
```

Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should now work. No explicit type annotations required, write
your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`EC2Client` provides annotations for `boto3.client("ec2")`.

```python
from boto3.session import Session

from mypy_boto3_ec2 import EC2Client

client: EC2Client = Session().client("ec2")

# now client usage is checked by mypy and IDE should provide code completion
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_ec2.paginator` module contains type annotations for all paginators.

```python
from boto3.session import Session

from mypy_boto3_ec2 import EC2Client
from mypy_boto3_ec2.paginator import (
    DescribeAddressesAttributePaginator,
    DescribeByoipCidrsPaginator,
    DescribeCapacityReservationFleetsPaginator,
    DescribeCapacityReservationsPaginator,
    DescribeCarrierGatewaysPaginator,
    DescribeClassicLinkInstancesPaginator,
    DescribeClientVpnAuthorizationRulesPaginator,
    DescribeClientVpnConnectionsPaginator,
    DescribeClientVpnEndpointsPaginator,
    DescribeClientVpnRoutesPaginator,
    DescribeClientVpnTargetNetworksPaginator,
    DescribeCoipPoolsPaginator,
    DescribeDhcpOptionsPaginator,
    DescribeEgressOnlyInternetGatewaysPaginator,
    DescribeExportImageTasksPaginator,
    DescribeFastLaunchImagesPaginator,
    DescribeFastSnapshotRestoresPaginator,
    DescribeFleetsPaginator,
    DescribeFlowLogsPaginator,
    DescribeFpgaImagesPaginator,
    DescribeHostReservationOfferingsPaginator,
    DescribeHostReservationsPaginator,
    DescribeHostsPaginator,
    DescribeIamInstanceProfileAssociationsPaginator,
    DescribeImportImageTasksPaginator,
    DescribeImportSnapshotTasksPaginator,
    DescribeInstanceCreditSpecificationsPaginator,
    DescribeInstanceEventWindowsPaginator,
    DescribeInstanceStatusPaginator,
    DescribeInstanceTypeOfferingsPaginator,
    DescribeInstanceTypesPaginator,
    DescribeInstancesPaginator,
    DescribeInternetGatewaysPaginator,
    DescribeIpamPoolsPaginator,
    DescribeIpamScopesPaginator,
    DescribeIpamsPaginator,
    DescribeIpv6PoolsPaginator,
    DescribeLaunchTemplateVersionsPaginator,
    DescribeLaunchTemplatesPaginator,
    DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginator,
    DescribeLocalGatewayRouteTableVpcAssociationsPaginator,
    DescribeLocalGatewayRouteTablesPaginator,
    DescribeLocalGatewayVirtualInterfaceGroupsPaginator,
    DescribeLocalGatewayVirtualInterfacesPaginator,
    DescribeLocalGatewaysPaginator,
    DescribeManagedPrefixListsPaginator,
    DescribeMovingAddressesPaginator,
    DescribeNatGatewaysPaginator,
    DescribeNetworkAclsPaginator,
    DescribeNetworkInsightsAccessScopeAnalysesPaginator,
    DescribeNetworkInsightsAccessScopesPaginator,
    DescribeNetworkInsightsAnalysesPaginator,
    DescribeNetworkInsightsPathsPaginator,
    DescribeNetworkInterfacePermissionsPaginator,
    DescribeNetworkInterfacesPaginator,
    DescribePrefixListsPaginator,
    DescribePrincipalIdFormatPaginator,
    DescribePublicIpv4PoolsPaginator,
    DescribeReplaceRootVolumeTasksPaginator,
    DescribeReservedInstancesModificationsPaginator,
    DescribeReservedInstancesOfferingsPaginator,
    DescribeRouteTablesPaginator,
    DescribeScheduledInstanceAvailabilityPaginator,
    DescribeScheduledInstancesPaginator,
    DescribeSecurityGroupRulesPaginator,
    DescribeSecurityGroupsPaginator,
    DescribeSnapshotTierStatusPaginator,
    DescribeSnapshotsPaginator,
    DescribeSpotFleetInstancesPaginator,
    DescribeSpotFleetRequestsPaginator,
    DescribeSpotInstanceRequestsPaginator,
    DescribeSpotPriceHistoryPaginator,
    DescribeStaleSecurityGroupsPaginator,
    DescribeStoreImageTasksPaginator,
    DescribeSubnetsPaginator,
    DescribeTagsPaginator,
    DescribeTrafficMirrorFiltersPaginator,
    DescribeTrafficMirrorSessionsPaginator,
    DescribeTrafficMirrorTargetsPaginator,
    DescribeTransitGatewayAttachmentsPaginator,
    DescribeTransitGatewayConnectPeersPaginator,
    DescribeTransitGatewayConnectsPaginator,
    DescribeTransitGatewayMulticastDomainsPaginator,
    DescribeTransitGatewayPeeringAttachmentsPaginator,
    DescribeTransitGatewayRouteTablesPaginator,
    DescribeTransitGatewayVpcAttachmentsPaginator,
    DescribeTransitGatewaysPaginator,
    DescribeTrunkInterfaceAssociationsPaginator,
    DescribeVolumeStatusPaginator,
    DescribeVolumesPaginator,
    DescribeVolumesModificationsPaginator,
    DescribeVpcClassicLinkDnsSupportPaginator,
    DescribeVpcEndpointConnectionNotificationsPaginator,
    DescribeVpcEndpointConnectionsPaginator,
    DescribeVpcEndpointServiceConfigurationsPaginator,
    DescribeVpcEndpointServicePermissionsPaginator,
    DescribeVpcEndpointServicesPaginator,
    DescribeVpcEndpointsPaginator,
    DescribeVpcPeeringConnectionsPaginator,
    DescribeVpcsPaginator,
    GetAssociatedIpv6PoolCidrsPaginator,
    GetGroupsForCapacityReservationPaginator,
    GetInstanceTypesFromInstanceRequirementsPaginator,
    GetIpamAddressHistoryPaginator,
    GetIpamPoolAllocationsPaginator,
    GetIpamPoolCidrsPaginator,
    GetIpamResourceCidrsPaginator,
    GetManagedPrefixListAssociationsPaginator,
    GetManagedPrefixListEntriesPaginator,
    GetSpotPlacementScoresPaginator,
    GetTransitGatewayAttachmentPropagationsPaginator,
    GetTransitGatewayMulticastDomainAssociationsPaginator,
    GetTransitGatewayPrefixListReferencesPaginator,
    GetTransitGatewayRouteTableAssociationsPaginator,
    GetTransitGatewayRouteTablePropagationsPaginator,
    GetVpnConnectionDeviceTypesPaginator,
    ListImagesInRecycleBinPaginator,
    ListSnapshotsInRecycleBinPaginator,
    SearchLocalGatewayRoutesPaginator,
    SearchTransitGatewayMulticastGroupsPaginator,
)

client: EC2Client = Session().client("ec2")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_addresses_attribute_paginator: DescribeAddressesAttributePaginator = client.get_paginator("describe_addresses_attribute")
describe_byoip_cidrs_paginator: DescribeByoipCidrsPaginator = client.get_paginator("describe_byoip_cidrs")
describe_capacity_reservation_fleets_paginator: DescribeCapacityReservationFleetsPaginator = client.get_paginator("describe_capacity_reservation_fleets")
describe_capacity_reservations_paginator: DescribeCapacityReservationsPaginator = client.get_paginator("describe_capacity_reservations")
describe_carrier_gateways_paginator: DescribeCarrierGatewaysPaginator = client.get_paginator("describe_carrier_gateways")
describe_classic_link_instances_paginator: DescribeClassicLinkInstancesPaginator = client.get_paginator("describe_classic_link_instances")
describe_client_vpn_authorization_rules_paginator: DescribeClientVpnAuthorizationRulesPaginator = client.get_paginator("describe_client_vpn_authorization_rules")
describe_client_vpn_connections_paginator: DescribeClientVpnConnectionsPaginator = client.get_paginator("describe_client_vpn_connections")
describe_client_vpn_endpoints_paginator: DescribeClientVpnEndpointsPaginator = client.get_paginator("describe_client_vpn_endpoints")
describe_client_vpn_routes_paginator: DescribeClientVpnRoutesPaginator = client.get_paginator("describe_client_vpn_routes")
describe_client_vpn_target_networks_paginator: DescribeClientVpnTargetNetworksPaginator = client.get_paginator("describe_client_vpn_target_networks")
describe_coip_pools_paginator: DescribeCoipPoolsPaginator = client.get_paginator("describe_coip_pools")
describe_dhcp_options_paginator: DescribeDhcpOptionsPaginator = client.get_paginator("describe_dhcp_options")
describe_egress_only_internet_gateways_paginator: DescribeEgressOnlyInternetGatewaysPaginator = client.get_paginator("describe_egress_only_internet_gateways")
describe_export_image_tasks_paginator: DescribeExportImageTasksPaginator = client.get_paginator("describe_export_image_tasks")
describe_fast_launch_images_paginator: DescribeFastLaunchImagesPaginator = client.get_paginator("describe_fast_launch_images")
describe_fast_snapshot_restores_paginator: DescribeFastSnapshotRestoresPaginator = client.get_paginator("describe_fast_snapshot_restores")
describe_fleets_paginator: DescribeFleetsPaginator = client.get_paginator("describe_fleets")
describe_flow_logs_paginator: DescribeFlowLogsPaginator = client.get_paginator("describe_flow_logs")
describe_fpga_images_paginator: DescribeFpgaImagesPaginator = client.get_paginator("describe_fpga_images")
describe_host_reservation_offerings_paginator: DescribeHostReservationOfferingsPaginator = client.get_paginator("describe_host_reservation_offerings")
describe_host_reservations_paginator: DescribeHostReservationsPaginator = client.get_paginator("describe_host_reservations")
describe_hosts_paginator: DescribeHostsPaginator = client.get_paginator("describe_hosts")
describe_iam_instance_profile_associations_paginator: DescribeIamInstanceProfileAssociationsPaginator = client.get_paginator("describe_iam_instance_profile_associations")
describe_import_image_tasks_paginator: DescribeImportImageTasksPaginator = client.get_paginator("describe_import_image_tasks")
describe_import_snapshot_tasks_paginator: DescribeImportSnapshotTasksPaginator = client.get_paginator("describe_import_snapshot_tasks")
describe_instance_credit_specifications_paginator: DescribeInstanceCreditSpecificationsPaginator = client.get_paginator("describe_instance_credit_specifications")
describe_instance_event_windows_paginator: DescribeInstanceEventWindowsPaginator = client.get_paginator("describe_instance_event_windows")
describe_instance_status_paginator: DescribeInstanceStatusPaginator = client.get_paginator("describe_instance_status")
describe_instance_type_offerings_paginator: DescribeInstanceTypeOfferingsPaginator = client.get_paginator("describe_instance_type_offerings")
describe_instance_types_paginator: DescribeInstanceTypesPaginator = client.get_paginator("describe_instance_types")
describe_instances_paginator: DescribeInstancesPaginator = client.get_paginator("describe_instances")
describe_internet_gateways_paginator: DescribeInternetGatewaysPaginator = client.get_paginator("describe_internet_gateways")
describe_ipam_pools_paginator: DescribeIpamPoolsPaginator = client.get_paginator("describe_ipam_pools")
describe_ipam_scopes_paginator: DescribeIpamScopesPaginator = client.get_paginator("describe_ipam_scopes")
describe_ipams_paginator: DescribeIpamsPaginator = client.get_paginator("describe_ipams")
describe_ipv6_pools_paginator: DescribeIpv6PoolsPaginator = client.get_paginator("describe_ipv6_pools")
describe_launch_template_versions_paginator: DescribeLaunchTemplateVersionsPaginator = client.get_paginator("describe_launch_template_versions")
describe_launch_templates_paginator: DescribeLaunchTemplatesPaginator = client.get_paginator("describe_launch_templates")
describe_local_gateway_route_table_virtual_interface_group_associations_paginator: DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginator = client.get_paginator("describe_local_gateway_route_table_virtual_interface_group_associations")
describe_local_gateway_route_table_vpc_associations_paginator: DescribeLocalGatewayRouteTableVpcAssociationsPaginator = client.get_paginator("describe_local_gateway_route_table_vpc_associations")
describe_local_gateway_route_tables_paginator: DescribeLocalGatewayRouteTablesPaginator = client.get_paginator("describe_local_gateway_route_tables")
describe_local_gateway_virtual_interface_groups_paginator: DescribeLocalGatewayVirtualInterfaceGroupsPaginator = client.get_paginator("describe_local_gateway_virtual_interface_groups")
describe_local_gateway_virtual_interfaces_paginator: DescribeLocalGatewayVirtualInterfacesPaginator = client.get_paginator("describe_local_gateway_virtual_interfaces")
describe_local_gateways_paginator: DescribeLocalGatewaysPaginator = client.get_paginator("describe_local_gateways")
describe_managed_prefix_lists_paginator: DescribeManagedPrefixListsPaginator = client.get_paginator("describe_managed_prefix_lists")
describe_moving_addresses_paginator: DescribeMovingAddressesPaginator = client.get_paginator("describe_moving_addresses")
describe_nat_gateways_paginator: DescribeNatGatewaysPaginator = client.get_paginator("describe_nat_gateways")
describe_network_acls_paginator: DescribeNetworkAclsPaginator = client.get_paginator("describe_network_acls")
describe_network_insights_access_scope_analyses_paginator: DescribeNetworkInsightsAccessScopeAnalysesPaginator = client.get_paginator("describe_network_insights_access_scope_analyses")
describe_network_insights_access_scopes_paginator: DescribeNetworkInsightsAccessScopesPaginator = client.get_paginator("describe_network_insights_access_scopes")
describe_network_insights_analyses_paginator: DescribeNetworkInsightsAnalysesPaginator = client.get_paginator("describe_network_insights_analyses")
describe_network_insights_paths_paginator: DescribeNetworkInsightsPathsPaginator = client.get_paginator("describe_network_insights_paths")
describe_network_interface_permissions_paginator: DescribeNetworkInterfacePermissionsPaginator = client.get_paginator("describe_network_interface_permissions")
describe_network_interfaces_paginator: DescribeNetworkInterfacesPaginator = client.get_paginator("describe_network_interfaces")
describe_prefix_lists_paginator: DescribePrefixListsPaginator = client.get_paginator("describe_prefix_lists")
describe_principal_id_format_paginator: DescribePrincipalIdFormatPaginator = client.get_paginator("describe_principal_id_format")
describe_public_ipv4_pools_paginator: DescribePublicIpv4PoolsPaginator = client.get_paginator("describe_public_ipv4_pools")
describe_replace_root_volume_tasks_paginator: DescribeReplaceRootVolumeTasksPaginator = client.get_paginator("describe_replace_root_volume_tasks")
describe_reserved_instances_modifications_paginator: DescribeReservedInstancesModificationsPaginator = client.get_paginator("describe_reserved_instances_modifications")
describe_reserved_instances_offerings_paginator: DescribeReservedInstancesOfferingsPaginator = client.get_paginator("describe_reserved_instances_offerings")
describe_route_tables_paginator: DescribeRouteTablesPaginator = client.get_paginator("describe_route_tables")
describe_scheduled_instance_availability_paginator: DescribeScheduledInstanceAvailabilityPaginator = client.get_paginator("describe_scheduled_instance_availability")
describe_scheduled_instances_paginator: DescribeScheduledInstancesPaginator = client.get_paginator("describe_scheduled_instances")
describe_security_group_rules_paginator: DescribeSecurityGroupRulesPaginator = client.get_paginator("describe_security_group_rules")
describe_security_groups_paginator: DescribeSecurityGroupsPaginator = client.get_paginator("describe_security_groups")
describe_snapshot_tier_status_paginator: DescribeSnapshotTierStatusPaginator = client.get_paginator("describe_snapshot_tier_status")
describe_snapshots_paginator: DescribeSnapshotsPaginator = client.get_paginator("describe_snapshots")
describe_spot_fleet_instances_paginator: DescribeSpotFleetInstancesPaginator = client.get_paginator("describe_spot_fleet_instances")
describe_spot_fleet_requests_paginator: DescribeSpotFleetRequestsPaginator = client.get_paginator("describe_spot_fleet_requests")
describe_spot_instance_requests_paginator: DescribeSpotInstanceRequestsPaginator = client.get_paginator("describe_spot_instance_requests")
describe_spot_price_history_paginator: DescribeSpotPriceHistoryPaginator = client.get_paginator("describe_spot_price_history")
describe_stale_security_groups_paginator: DescribeStaleSecurityGroupsPaginator = client.get_paginator("describe_stale_security_groups")
describe_store_image_tasks_paginator: DescribeStoreImageTasksPaginator = client.get_paginator("describe_store_image_tasks")
describe_subnets_paginator: DescribeSubnetsPaginator = client.get_paginator("describe_subnets")
describe_tags_paginator: DescribeTagsPaginator = client.get_paginator("describe_tags")
describe_traffic_mirror_filters_paginator: DescribeTrafficMirrorFiltersPaginator = client.get_paginator("describe_traffic_mirror_filters")
describe_traffic_mirror_sessions_paginator: DescribeTrafficMirrorSessionsPaginator = client.get_paginator("describe_traffic_mirror_sessions")
describe_traffic_mirror_targets_paginator: DescribeTrafficMirrorTargetsPaginator = client.get_paginator("describe_traffic_mirror_targets")
describe_transit_gateway_attachments_paginator: DescribeTransitGatewayAttachmentsPaginator = client.get_paginator("describe_transit_gateway_attachments")
describe_transit_gateway_connect_peers_paginator: DescribeTransitGatewayConnectPeersPaginator = client.get_paginator("describe_transit_gateway_connect_peers")
describe_transit_gateway_connects_paginator: DescribeTransitGatewayConnectsPaginator = client.get_paginator("describe_transit_gateway_connects")
describe_transit_gateway_multicast_domains_paginator: DescribeTransitGatewayMulticastDomainsPaginator = client.get_paginator("describe_transit_gateway_multicast_domains")
describe_transit_gateway_peering_attachments_paginator: DescribeTransitGatewayPeeringAttachmentsPaginator = client.get_paginator("describe_transit_gateway_peering_attachments")
describe_transit_gateway_route_tables_paginator: DescribeTransitGatewayRouteTablesPaginator = client.get_paginator("describe_transit_gateway_route_tables")
describe_transit_gateway_vpc_attachments_paginator: DescribeTransitGatewayVpcAttachmentsPaginator = client.get_paginator("describe_transit_gateway_vpc_attachments")
describe_transit_gateways_paginator: DescribeTransitGatewaysPaginator = client.get_paginator("describe_transit_gateways")
describe_trunk_interface_associations_paginator: DescribeTrunkInterfaceAssociationsPaginator = client.get_paginator("describe_trunk_interface_associations")
describe_volume_status_paginator: DescribeVolumeStatusPaginator = client.get_paginator("describe_volume_status")
describe_volumes_paginator: DescribeVolumesPaginator = client.get_paginator("describe_volumes")
describe_volumes_modifications_paginator: DescribeVolumesModificationsPaginator = client.get_paginator("describe_volumes_modifications")
describe_vpc_classic_link_dns_support_paginator: DescribeVpcClassicLinkDnsSupportPaginator = client.get_paginator("describe_vpc_classic_link_dns_support")
describe_vpc_endpoint_connection_notifications_paginator: DescribeVpcEndpointConnectionNotificationsPaginator = client.get_paginator("describe_vpc_endpoint_connection_notifications")
describe_vpc_endpoint_connections_paginator: DescribeVpcEndpointConnectionsPaginator = client.get_paginator("describe_vpc_endpoint_connections")
describe_vpc_endpoint_service_configurations_paginator: DescribeVpcEndpointServiceConfigurationsPaginator = client.get_paginator("describe_vpc_endpoint_service_configurations")
describe_vpc_endpoint_service_permissions_paginator: DescribeVpcEndpointServicePermissionsPaginator = client.get_paginator("describe_vpc_endpoint_service_permissions")
describe_vpc_endpoint_services_paginator: DescribeVpcEndpointServicesPaginator = client.get_paginator("describe_vpc_endpoint_services")
describe_vpc_endpoints_paginator: DescribeVpcEndpointsPaginator = client.get_paginator("describe_vpc_endpoints")
describe_vpc_peering_connections_paginator: DescribeVpcPeeringConnectionsPaginator = client.get_paginator("describe_vpc_peering_connections")
describe_vpcs_paginator: DescribeVpcsPaginator = client.get_paginator("describe_vpcs")
get_associated_ipv6_pool_cidrs_paginator: GetAssociatedIpv6PoolCidrsPaginator = client.get_paginator("get_associated_ipv6_pool_cidrs")
get_groups_for_capacity_reservation_paginator: GetGroupsForCapacityReservationPaginator = client.get_paginator("get_groups_for_capacity_reservation")
get_instance_types_from_instance_requirements_paginator: GetInstanceTypesFromInstanceRequirementsPaginator = client.get_paginator("get_instance_types_from_instance_requirements")
get_ipam_address_history_paginator: GetIpamAddressHistoryPaginator = client.get_paginator("get_ipam_address_history")
get_ipam_pool_allocations_paginator: GetIpamPoolAllocationsPaginator = client.get_paginator("get_ipam_pool_allocations")
get_ipam_pool_cidrs_paginator: GetIpamPoolCidrsPaginator = client.get_paginator("get_ipam_pool_cidrs")
get_ipam_resource_cidrs_paginator: GetIpamResourceCidrsPaginator = client.get_paginator("get_ipam_resource_cidrs")
get_managed_prefix_list_associations_paginator: GetManagedPrefixListAssociationsPaginator = client.get_paginator("get_managed_prefix_list_associations")
get_managed_prefix_list_entries_paginator: GetManagedPrefixListEntriesPaginator = client.get_paginator("get_managed_prefix_list_entries")
get_spot_placement_scores_paginator: GetSpotPlacementScoresPaginator = client.get_paginator("get_spot_placement_scores")
get_transit_gateway_attachment_propagations_paginator: GetTransitGatewayAttachmentPropagationsPaginator = client.get_paginator("get_transit_gateway_attachment_propagations")
get_transit_gateway_multicast_domain_associations_paginator: GetTransitGatewayMulticastDomainAssociationsPaginator = client.get_paginator("get_transit_gateway_multicast_domain_associations")
get_transit_gateway_prefix_list_references_paginator: GetTransitGatewayPrefixListReferencesPaginator = client.get_paginator("get_transit_gateway_prefix_list_references")
get_transit_gateway_route_table_associations_paginator: GetTransitGatewayRouteTableAssociationsPaginator = client.get_paginator("get_transit_gateway_route_table_associations")
get_transit_gateway_route_table_propagations_paginator: GetTransitGatewayRouteTablePropagationsPaginator = client.get_paginator("get_transit_gateway_route_table_propagations")
get_vpn_connection_device_types_paginator: GetVpnConnectionDeviceTypesPaginator = client.get_paginator("get_vpn_connection_device_types")
list_images_in_recycle_bin_paginator: ListImagesInRecycleBinPaginator = client.get_paginator("list_images_in_recycle_bin")
list_snapshots_in_recycle_bin_paginator: ListSnapshotsInRecycleBinPaginator = client.get_paginator("list_snapshots_in_recycle_bin")
search_local_gateway_routes_paginator: SearchLocalGatewayRoutesPaginator = client.get_paginator("search_local_gateway_routes")
search_transit_gateway_multicast_groups_paginator: SearchTransitGatewayMulticastGroupsPaginator = client.get_paginator("search_transit_gateway_multicast_groups")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_ec2.waiter` module contains type annotations for all waiters.

```python
from boto3.session import Session

from mypy_boto3_ec2 import EC2Client
from mypy_boto3_ec2.waiter import (
    BundleTaskCompleteWaiter,
    ConversionTaskCancelledWaiter,
    ConversionTaskCompletedWaiter,
    ConversionTaskDeletedWaiter,
    CustomerGatewayAvailableWaiter,
    ExportTaskCancelledWaiter,
    ExportTaskCompletedWaiter,
    ImageAvailableWaiter,
    ImageExistsWaiter,
    InstanceExistsWaiter,
    InstanceRunningWaiter,
    InstanceStatusOkWaiter,
    InstanceStoppedWaiter,
    InstanceTerminatedWaiter,
    InternetGatewayExistsWaiter,
    KeyPairExistsWaiter,
    NatGatewayAvailableWaiter,
    NatGatewayDeletedWaiter,
    NetworkInterfaceAvailableWaiter,
    PasswordDataAvailableWaiter,
    SecurityGroupExistsWaiter,
    SnapshotCompletedWaiter,
    SpotInstanceRequestFulfilledWaiter,
    SubnetAvailableWaiter,
    SystemStatusOkWaiter,
    VolumeAvailableWaiter,
    VolumeDeletedWaiter,
    VolumeInUseWaiter,
    VpcAvailableWaiter,
    VpcExistsWaiter,
    VpcPeeringConnectionDeletedWaiter,
    VpcPeeringConnectionExistsWaiter,
    VpnConnectionAvailableWaiter,
    VpnConnectionDeletedWaiter,
)

client: EC2Client = Session().client("ec2")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
bundle_task_complete_waiter: BundleTaskCompleteWaiter = client.get_waiter("bundle_task_complete")
conversion_task_cancelled_waiter: ConversionTaskCancelledWaiter = client.get_waiter("conversion_task_cancelled")
conversion_task_completed_waiter: ConversionTaskCompletedWaiter = client.get_waiter("conversion_task_completed")
conversion_task_deleted_waiter: ConversionTaskDeletedWaiter = client.get_waiter("conversion_task_deleted")
customer_gateway_available_waiter: CustomerGatewayAvailableWaiter = client.get_waiter("customer_gateway_available")
export_task_cancelled_waiter: ExportTaskCancelledWaiter = client.get_waiter("export_task_cancelled")
export_task_completed_waiter: ExportTaskCompletedWaiter = client.get_waiter("export_task_completed")
image_available_waiter: ImageAvailableWaiter = client.get_waiter("image_available")
image_exists_waiter: ImageExistsWaiter = client.get_waiter("image_exists")
instance_exists_waiter: InstanceExistsWaiter = client.get_waiter("instance_exists")
instance_running_waiter: InstanceRunningWaiter = client.get_waiter("instance_running")
instance_status_ok_waiter: InstanceStatusOkWaiter = client.get_waiter("instance_status_ok")
instance_stopped_waiter: InstanceStoppedWaiter = client.get_waiter("instance_stopped")
instance_terminated_waiter: InstanceTerminatedWaiter = client.get_waiter("instance_terminated")
internet_gateway_exists_waiter: InternetGatewayExistsWaiter = client.get_waiter("internet_gateway_exists")
key_pair_exists_waiter: KeyPairExistsWaiter = client.get_waiter("key_pair_exists")
nat_gateway_available_waiter: NatGatewayAvailableWaiter = client.get_waiter("nat_gateway_available")
nat_gateway_deleted_waiter: NatGatewayDeletedWaiter = client.get_waiter("nat_gateway_deleted")
network_interface_available_waiter: NetworkInterfaceAvailableWaiter = client.get_waiter("network_interface_available")
password_data_available_waiter: PasswordDataAvailableWaiter = client.get_waiter("password_data_available")
security_group_exists_waiter: SecurityGroupExistsWaiter = client.get_waiter("security_group_exists")
snapshot_completed_waiter: SnapshotCompletedWaiter = client.get_waiter("snapshot_completed")
spot_instance_request_fulfilled_waiter: SpotInstanceRequestFulfilledWaiter = client.get_waiter("spot_instance_request_fulfilled")
subnet_available_waiter: SubnetAvailableWaiter = client.get_waiter("subnet_available")
system_status_ok_waiter: SystemStatusOkWaiter = client.get_waiter("system_status_ok")
volume_available_waiter: VolumeAvailableWaiter = client.get_waiter("volume_available")
volume_deleted_waiter: VolumeDeletedWaiter = client.get_waiter("volume_deleted")
volume_in_use_waiter: VolumeInUseWaiter = client.get_waiter("volume_in_use")
vpc_available_waiter: VpcAvailableWaiter = client.get_waiter("vpc_available")
vpc_exists_waiter: VpcExistsWaiter = client.get_waiter("vpc_exists")
vpc_peering_connection_deleted_waiter: VpcPeeringConnectionDeletedWaiter = client.get_waiter("vpc_peering_connection_deleted")
vpc_peering_connection_exists_waiter: VpcPeeringConnectionExistsWaiter = client.get_waiter("vpc_peering_connection_exists")
vpn_connection_available_waiter: VpnConnectionAvailableWaiter = client.get_waiter("vpn_connection_available")
vpn_connection_deleted_waiter: VpnConnectionDeletedWaiter = client.get_waiter("vpn_connection_deleted")
```

<a id="service-resource-annotations"></a>

### Service Resource annotations

`EC2ServiceResource` provides annotations for `boto3.resource("ec2")`.

```python
from boto3.session import Session

from mypy_boto3_ec2 import EC2ServiceResource

resource: EC2ServiceResource = Session().resource("ec2")

# now resource usage is checked by mypy and IDE should provide code completion
```

<a id="other-resources-annotations"></a>

### Other resources annotations

`mypy_boto3_ec2.service_resource` module contains type annotations for all
resources.

```python
from boto3.session import Session

from mypy_boto3_ec2 import EC2ServiceResource
from mypy_boto3_ec2.service_resource import (
    ClassicAddress,
    DhcpOptions,
    Image,
    Instance,
    InternetGateway,
    KeyPair,
    KeyPairInfo,
    NetworkAcl,
    NetworkInterface,
    NetworkInterfaceAssociation,
    PlacementGroup,
    Route,
    RouteTable,
    RouteTableAssociation,
    SecurityGroup,
    Snapshot,
    Subnet,
    Tag,
    Volume,
    Vpc,
    VpcPeeringConnection,
    VpcAddress,
)

resource: EC2ServiceResource = Session().resource("ec2")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
my_classic_address: ClassicAddress = resource.ClassicAddress(...)
my_dhcp_options: DhcpOptions = resource.DhcpOptions(...)
my_image: Image = resource.Image(...)
my_instance: Instance = resource.Instance(...)
my_internet_gateway: InternetGateway = resource.InternetGateway(...)
my_key_pair: KeyPair = resource.KeyPair(...)
my_key_pair_info: KeyPairInfo = resource.KeyPairInfo(...)
my_network_acl: NetworkAcl = resource.NetworkAcl(...)
my_network_interface: NetworkInterface = resource.NetworkInterface(...)
my_network_interface_association: NetworkInterfaceAssociation = resource.NetworkInterfaceAssociation(...)
my_placement_group: PlacementGroup = resource.PlacementGroup(...)
my_route: Route = resource.Route(...)
my_route_table: RouteTable = resource.RouteTable(...)
my_route_table_association: RouteTableAssociation = resource.RouteTableAssociation(...)
my_security_group: SecurityGroup = resource.SecurityGroup(...)
my_snapshot: Snapshot = resource.Snapshot(...)
my_subnet: Subnet = resource.Subnet(...)
my_tag: Tag = resource.Tag(...)
my_volume: Volume = resource.Volume(...)
my_vpc: Vpc = resource.Vpc(...)
my_vpc_peering_connection: VpcPeeringConnection = resource.VpcPeeringConnection(...)
my_vpc_address: VpcAddress = resource.VpcAddress(...)
```

<a id="collections-annotations"></a>

### Collections annotations

`mypy_boto3_ec2.service_resource` module contains type annotations for all
`EC2ServiceResource` collections.

```python
from boto3.session import Session

from mypy_boto3_ec2 import EC2ServiceResource
from mypy_boto3_ec2.service_resource import (
    ServiceResourceClassicAddressesCollection,
    ServiceResourceDhcpOptionsSetsCollection,
    ServiceResourceImagesCollection,
    ServiceResourceInstancesCollection,
    ServiceResourceInternetGatewaysCollection,
    ServiceResourceKeyPairsCollection,
    ServiceResourceNetworkAclsCollection,
    ServiceResourceNetworkInterfacesCollection,
    ServiceResourcePlacementGroupsCollection,
    ServiceResourceRouteTablesCollection,
    ServiceResourceSecurityGroupsCollection,
    ServiceResourceSnapshotsCollection,
    ServiceResourceSubnetsCollection,
    ServiceResourceVolumesCollection,
    ServiceResourceVpcAddressesCollection,
    ServiceResourceVpcPeeringConnectionsCollection,
    ServiceResourceVpcsCollection,
)

resource: EC2ServiceResource = Session().resource("ec2")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
classic_addresses: ec2_resources.ServiceResourceClassicAddressesCollection = resource.classic_addresses
dhcp_options_sets: ec2_resources.ServiceResourceDhcpOptionsSetsCollection = resource.dhcp_options_sets
images: ec2_resources.ServiceResourceImagesCollection = resource.images
instances: ec2_resources.ServiceResourceInstancesCollection = resource.instances
internet_gateways: ec2_resources.ServiceResourceInternetGatewaysCollection = resource.internet_gateways
key_pairs: ec2_resources.ServiceResourceKeyPairsCollection = resource.key_pairs
network_acls: ec2_resources.ServiceResourceNetworkAclsCollection = resource.network_acls
network_interfaces: ec2_resources.ServiceResourceNetworkInterfacesCollection = resource.network_interfaces
placement_groups: ec2_resources.ServiceResourcePlacementGroupsCollection = resource.placement_groups
route_tables: ec2_resources.ServiceResourceRouteTablesCollection = resource.route_tables
security_groups: ec2_resources.ServiceResourceSecurityGroupsCollection = resource.security_groups
snapshots: ec2_resources.ServiceResourceSnapshotsCollection = resource.snapshots
subnets: ec2_resources.ServiceResourceSubnetsCollection = resource.subnets
volumes: ec2_resources.ServiceResourceVolumesCollection = resource.volumes
vpc_addresses: ec2_resources.ServiceResourceVpcAddressesCollection = resource.vpc_addresses
vpc_peering_connections: ec2_resources.ServiceResourceVpcPeeringConnectionsCollection = resource.vpc_peering_connections
vpcs: ec2_resources.ServiceResourceVpcsCollection = resource.vpcs
```

<a id="literals"></a>

### Literals

`mypy_boto3_ec2.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_ec2.literals import (
    AcceleratorManufacturerType,
    AcceleratorNameType,
    AcceleratorTypeType,
    AccountAttributeNameType,
    ActivityStatusType,
    AddressAttributeNameType,
    AddressFamilyType,
    AffinityType,
    AllocationStateType,
    AllocationStrategyType,
    AllowsMultipleInstanceTypesType,
    AnalysisStatusType,
    ApplianceModeSupportValueType,
    ArchitectureTypeType,
    ArchitectureValuesType,
    AssociatedNetworkTypeType,
    AssociationStatusCodeType,
    AttachmentStatusType,
    AutoAcceptSharedAssociationsValueType,
    AutoAcceptSharedAttachmentsValueType,
    AutoPlacementType,
    AvailabilityZoneOptInStatusType,
    AvailabilityZoneStateType,
    BareMetalType,
    BatchStateType,
    BgpStatusType,
    BootModeTypeType,
    BootModeValuesType,
    BundleTaskCompleteWaiterName,
    BundleTaskStateType,
    BurstablePerformanceType,
    ByoipCidrStateType,
    CancelBatchErrorCodeType,
    CancelSpotInstanceRequestStateType,
    CapacityReservationFleetStateType,
    CapacityReservationInstancePlatformType,
    CapacityReservationPreferenceType,
    CapacityReservationStateType,
    CapacityReservationTenancyType,
    CarrierGatewayStateType,
    ClientCertificateRevocationListStatusCodeType,
    ClientVpnAuthenticationTypeType,
    ClientVpnAuthorizationRuleStatusCodeType,
    ClientVpnConnectionStatusCodeType,
    ClientVpnEndpointAttributeStatusCodeType,
    ClientVpnEndpointStatusCodeType,
    ClientVpnRouteStatusCodeType,
    ConnectionNotificationStateType,
    ConnectionNotificationTypeType,
    ConnectivityTypeType,
    ContainerFormatType,
    ConversionTaskCancelledWaiterName,
    ConversionTaskCompletedWaiterName,
    ConversionTaskDeletedWaiterName,
    ConversionTaskStateType,
    CopyTagsFromSourceType,
    CpuManufacturerType,
    CurrencyCodeValuesType,
    CustomerGatewayAvailableWaiterName,
    DatafeedSubscriptionStateType,
    DefaultRouteTableAssociationValueType,
    DefaultRouteTablePropagationValueType,
    DefaultTargetCapacityTypeType,
    DeleteFleetErrorCodeType,
    DeleteQueuedReservedInstancesErrorCodeType,
    DescribeAddressesAttributePaginatorName,
    DescribeByoipCidrsPaginatorName,
    DescribeCapacityReservationFleetsPaginatorName,
    DescribeCapacityReservationsPaginatorName,
    DescribeCarrierGatewaysPaginatorName,
    DescribeClassicLinkInstancesPaginatorName,
    DescribeClientVpnAuthorizationRulesPaginatorName,
    DescribeClientVpnConnectionsPaginatorName,
    DescribeClientVpnEndpointsPaginatorName,
    DescribeClientVpnRoutesPaginatorName,
    DescribeClientVpnTargetNetworksPaginatorName,
    DescribeCoipPoolsPaginatorName,
    DescribeDhcpOptionsPaginatorName,
    DescribeEgressOnlyInternetGatewaysPaginatorName,
    DescribeExportImageTasksPaginatorName,
    DescribeFastLaunchImagesPaginatorName,
    DescribeFastSnapshotRestoresPaginatorName,
    DescribeFleetsPaginatorName,
    DescribeFlowLogsPaginatorName,
    DescribeFpgaImagesPaginatorName,
    DescribeHostReservationOfferingsPaginatorName,
    DescribeHostReservationsPaginatorName,
    DescribeHostsPaginatorName,
    DescribeIamInstanceProfileAssociationsPaginatorName,
    DescribeImportImageTasksPaginatorName,
    DescribeImportSnapshotTasksPaginatorName,
    DescribeInstanceCreditSpecificationsPaginatorName,
    DescribeInstanceEventWindowsPaginatorName,
    DescribeInstanceStatusPaginatorName,
    DescribeInstanceTypeOfferingsPaginatorName,
    DescribeInstanceTypesPaginatorName,
    DescribeInstancesPaginatorName,
    DescribeInternetGatewaysPaginatorName,
    DescribeIpamPoolsPaginatorName,
    DescribeIpamScopesPaginatorName,
    DescribeIpamsPaginatorName,
    DescribeIpv6PoolsPaginatorName,
    DescribeLaunchTemplateVersionsPaginatorName,
    DescribeLaunchTemplatesPaginatorName,
    DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginatorName,
    DescribeLocalGatewayRouteTableVpcAssociationsPaginatorName,
    DescribeLocalGatewayRouteTablesPaginatorName,
    DescribeLocalGatewayVirtualInterfaceGroupsPaginatorName,
    DescribeLocalGatewayVirtualInterfacesPaginatorName,
    DescribeLocalGatewaysPaginatorName,
    DescribeManagedPrefixListsPaginatorName,
    DescribeMovingAddressesPaginatorName,
    DescribeNatGatewaysPaginatorName,
    DescribeNetworkAclsPaginatorName,
    DescribeNetworkInsightsAccessScopeAnalysesPaginatorName,
    DescribeNetworkInsightsAccessScopesPaginatorName,
    DescribeNetworkInsightsAnalysesPaginatorName,
    DescribeNetworkInsightsPathsPaginatorName,
    DescribeNetworkInterfacePermissionsPaginatorName,
    DescribeNetworkInterfacesPaginatorName,
    DescribePrefixListsPaginatorName,
    DescribePrincipalIdFormatPaginatorName,
    DescribePublicIpv4PoolsPaginatorName,
    DescribeReplaceRootVolumeTasksPaginatorName,
    DescribeReservedInstancesModificationsPaginatorName,
    DescribeReservedInstancesOfferingsPaginatorName,
    DescribeRouteTablesPaginatorName,
    DescribeScheduledInstanceAvailabilityPaginatorName,
    DescribeScheduledInstancesPaginatorName,
    DescribeSecurityGroupRulesPaginatorName,
    DescribeSecurityGroupsPaginatorName,
    DescribeSnapshotTierStatusPaginatorName,
    DescribeSnapshotsPaginatorName,
    DescribeSpotFleetInstancesPaginatorName,
    DescribeSpotFleetRequestsPaginatorName,
    DescribeSpotInstanceRequestsPaginatorName,
    DescribeSpotPriceHistoryPaginatorName,
    DescribeStaleSecurityGroupsPaginatorName,
    DescribeStoreImageTasksPaginatorName,
    DescribeSubnetsPaginatorName,
    DescribeTagsPaginatorName,
    DescribeTrafficMirrorFiltersPaginatorName,
    DescribeTrafficMirrorSessionsPaginatorName,
    DescribeTrafficMirrorTargetsPaginatorName,
    DescribeTransitGatewayAttachmentsPaginatorName,
    DescribeTransitGatewayConnectPeersPaginatorName,
    DescribeTransitGatewayConnectsPaginatorName,
    DescribeTransitGatewayMulticastDomainsPaginatorName,
    DescribeTransitGatewayPeeringAttachmentsPaginatorName,
    DescribeTransitGatewayRouteTablesPaginatorName,
    DescribeTransitGatewayVpcAttachmentsPaginatorName,
    DescribeTransitGatewaysPaginatorName,
    DescribeTrunkInterfaceAssociationsPaginatorName,
    DescribeVolumeStatusPaginatorName,
    DescribeVolumesModificationsPaginatorName,
    DescribeVolumesPaginatorName,
    DescribeVpcClassicLinkDnsSupportPaginatorName,
    DescribeVpcEndpointConnectionNotificationsPaginatorName,
    DescribeVpcEndpointConnectionsPaginatorName,
    DescribeVpcEndpointServiceConfigurationsPaginatorName,
    DescribeVpcEndpointServicePermissionsPaginatorName,
    DescribeVpcEndpointServicesPaginatorName,
    DescribeVpcEndpointsPaginatorName,
    DescribeVpcPeeringConnectionsPaginatorName,
    DescribeVpcsPaginatorName,
    DestinationFileFormatType,
    DeviceTypeType,
    DiskImageFormatType,
    DiskTypeType,
    DnsNameStateType,
    DnsSupportValueType,
    DomainTypeType,
    EbsEncryptionSupportType,
    EbsNvmeSupportType,
    EbsOptimizedSupportType,
    ElasticGpuStateType,
    ElasticGpuStatusType,
    EnaSupportType,
    EndDateTypeType,
    EphemeralNvmeSupportType,
    EventCodeType,
    EventTypeType,
    ExcessCapacityTerminationPolicyType,
    ExportEnvironmentType,
    ExportTaskCancelledWaiterName,
    ExportTaskCompletedWaiterName,
    ExportTaskStateType,
    FastLaunchResourceTypeType,
    FastLaunchStateCodeType,
    FastSnapshotRestoreStateCodeType,
    FindingsFoundType,
    FleetActivityStatusType,
    FleetCapacityReservationTenancyType,
    FleetCapacityReservationUsageStrategyType,
    FleetEventTypeType,
    FleetExcessCapacityTerminationPolicyType,
    FleetInstanceMatchCriteriaType,
    FleetOnDemandAllocationStrategyType,
    FleetReplacementStrategyType,
    FleetStateCodeType,
    FleetTypeType,
    FlowLogsResourceTypeType,
    FpgaImageAttributeNameType,
    FpgaImageStateCodeType,
    GatewayAssociationStateType,
    GatewayTypeType,
    GetAssociatedIpv6PoolCidrsPaginatorName,
    GetGroupsForCapacityReservationPaginatorName,
    GetInstanceTypesFromInstanceRequirementsPaginatorName,
    GetIpamAddressHistoryPaginatorName,
    GetIpamPoolAllocationsPaginatorName,
    GetIpamPoolCidrsPaginatorName,
    GetIpamResourceCidrsPaginatorName,
    GetManagedPrefixListAssociationsPaginatorName,
    GetManagedPrefixListEntriesPaginatorName,
    GetSpotPlacementScoresPaginatorName,
    GetTransitGatewayAttachmentPropagationsPaginatorName,
    GetTransitGatewayMulticastDomainAssociationsPaginatorName,
    GetTransitGatewayPrefixListReferencesPaginatorName,
    GetTransitGatewayRouteTableAssociationsPaginatorName,
    GetTransitGatewayRouteTablePropagationsPaginatorName,
    GetVpnConnectionDeviceTypesPaginatorName,
    HostRecoveryType,
    HostTenancyType,
    HostnameTypeType,
    HttpTokensStateType,
    HypervisorTypeType,
    IamInstanceProfileAssociationStateType,
    Igmpv2SupportValueType,
    ImageAttributeNameType,
    ImageAvailableWaiterName,
    ImageExistsWaiterName,
    ImageStateType,
    ImageTypeValuesType,
    InstanceAttributeNameType,
    InstanceAutoRecoveryStateType,
    InstanceEventWindowStateType,
    InstanceExistsWaiterName,
    InstanceGenerationType,
    InstanceHealthStatusType,
    InstanceInterruptionBehaviorType,
    InstanceLifecycleType,
    InstanceLifecycleTypeType,
    InstanceMatchCriteriaType,
    InstanceMetadataEndpointStateType,
    InstanceMetadataOptionsStateType,
    InstanceMetadataProtocolStateType,
    InstanceMetadataTagsStateType,
    InstanceRunningWaiterName,
    InstanceStateNameType,
    InstanceStatusOkWaiterName,
    InstanceStoppedWaiterName,
    InstanceStorageEncryptionSupportType,
    InstanceTerminatedWaiterName,
    InstanceTypeHypervisorType,
    InstanceTypeType,
    InterfacePermissionTypeType,
    InterfaceProtocolTypeType,
    InternetGatewayExistsWaiterName,
    IpamAddressHistoryResourceTypeType,
    IpamComplianceStatusType,
    IpamManagementStateType,
    IpamOverlapStatusType,
    IpamPoolAllocationResourceTypeType,
    IpamPoolAwsServiceType,
    IpamPoolCidrFailureCodeType,
    IpamPoolCidrStateType,
    IpamPoolStateType,
    IpamResourceTypeType,
    IpamScopeStateType,
    IpamScopeTypeType,
    IpamStateType,
    Ipv6SupportValueType,
    KeyPairExistsWaiterName,
    KeyTypeType,
    LaunchTemplateAutoRecoveryStateType,
    LaunchTemplateErrorCodeType,
    LaunchTemplateHttpTokensStateType,
    LaunchTemplateInstanceMetadataEndpointStateType,
    LaunchTemplateInstanceMetadataOptionsStateType,
    LaunchTemplateInstanceMetadataProtocolIpv6Type,
    LaunchTemplateInstanceMetadataTagsStateType,
    ListImagesInRecycleBinPaginatorName,
    ListSnapshotsInRecycleBinPaginatorName,
    ListingStateType,
    ListingStatusType,
    LocalGatewayRouteStateType,
    LocalGatewayRouteTypeType,
    LocalStorageType,
    LocalStorageTypeType,
    LocationTypeType,
    LogDestinationTypeType,
    MarketTypeType,
    MembershipTypeType,
    ModifyAvailabilityZoneOptInStatusType,
    MonitoringStateType,
    MoveStatusType,
    MulticastSupportValueType,
    NatGatewayAvailableWaiterName,
    NatGatewayDeletedWaiterName,
    NatGatewayStateType,
    NetworkInterfaceAttributeType,
    NetworkInterfaceAvailableWaiterName,
    NetworkInterfaceCreationTypeType,
    NetworkInterfacePermissionStateCodeType,
    NetworkInterfaceStatusType,
    NetworkInterfaceTypeType,
    OfferingClassTypeType,
    OfferingTypeValuesType,
    OnDemandAllocationStrategyType,
    OperationTypeType,
    PartitionLoadFrequencyType,
    PasswordDataAvailableWaiterName,
    PayerResponsibilityType,
    PaymentOptionType,
    PermissionGroupType,
    PlacementGroupStateType,
    PlacementGroupStrategyType,
    PlacementStrategyType,
    PlatformValuesType,
    PrefixListStateType,
    PrincipalTypeType,
    ProductCodeValuesType,
    ProtocolType,
    ProtocolValueType,
    RIProductDescriptionType,
    RecurringChargeFrequencyType,
    ReplaceRootVolumeTaskStateType,
    ReplacementStrategyType,
    ReportInstanceReasonCodesType,
    ReportStatusTypeType,
    ReservationStateType,
    ReservedInstanceStateType,
    ResetFpgaImageAttributeNameType,
    ResetImageAttributeNameType,
    ResourceTypeType,
    RootDeviceTypeType,
    RouteOriginType,
    RouteStateType,
    RouteTableAssociationStateCodeType,
    RuleActionType,
    SearchLocalGatewayRoutesPaginatorName,
    SearchTransitGatewayMulticastGroupsPaginatorName,
    SecurityGroupExistsWaiterName,
    SelfServicePortalType,
    ServiceStateType,
    ServiceTypeType,
    ShutdownBehaviorType,
    SnapshotAttributeNameType,
    SnapshotCompletedWaiterName,
    SnapshotStateType,
    SpotAllocationStrategyType,
    SpotInstanceInterruptionBehaviorType,
    SpotInstanceRequestFulfilledWaiterName,
    SpotInstanceStateType,
    SpotInstanceTypeType,
    StateType,
    StaticSourcesSupportValueType,
    StatusNameType,
    StatusType,
    StatusTypeType,
    StorageTierType,
    SubnetAvailableWaiterName,
    SubnetCidrBlockStateCodeType,
    SubnetCidrReservationTypeType,
    SubnetStateType,
    SummaryStatusType,
    SystemStatusOkWaiterName,
    TargetCapacityUnitTypeType,
    TargetStorageTierType,
    TelemetryStatusType,
    TenancyType,
    TieringOperationStatusType,
    TrafficDirectionType,
    TrafficMirrorFilterRuleFieldType,
    TrafficMirrorNetworkServiceType,
    TrafficMirrorRuleActionType,
    TrafficMirrorSessionFieldType,
    TrafficMirrorTargetTypeType,
    TrafficTypeType,
    TransitGatewayAssociationStateType,
    TransitGatewayAttachmentResourceTypeType,
    TransitGatewayAttachmentStateType,
    TransitGatewayConnectPeerStateType,
    TransitGatewayMulitcastDomainAssociationStateType,
    TransitGatewayMulticastDomainStateType,
    TransitGatewayPrefixListReferenceStateType,
    TransitGatewayPropagationStateType,
    TransitGatewayRouteStateType,
    TransitGatewayRouteTableStateType,
    TransitGatewayRouteTypeType,
    TransitGatewayStateType,
    TransportProtocolType,
    TunnelInsideIpVersionType,
    UnlimitedSupportedInstanceFamilyType,
    UnsuccessfulInstanceCreditSpecificationErrorCodeType,
    UsageClassTypeType,
    VirtualizationTypeType,
    VolumeAttachmentStateType,
    VolumeAttributeNameType,
    VolumeAvailableWaiterName,
    VolumeDeletedWaiterName,
    VolumeInUseWaiterName,
    VolumeModificationStateType,
    VolumeStateType,
    VolumeStatusInfoStatusType,
    VolumeStatusNameType,
    VolumeTypeType,
    VpcAttributeNameType,
    VpcAvailableWaiterName,
    VpcCidrBlockStateCodeType,
    VpcEndpointTypeType,
    VpcExistsWaiterName,
    VpcPeeringConnectionDeletedWaiterName,
    VpcPeeringConnectionExistsWaiterName,
    VpcPeeringConnectionStateReasonCodeType,
    VpcStateType,
    VpcTenancyType,
    VpnConnectionAvailableWaiterName,
    VpnConnectionDeletedWaiterName,
    VpnEcmpSupportValueType,
    VpnProtocolType,
    VpnStateType,
    VpnStaticRouteSourceType,
    WeekDayType,
    scopeType,
    EC2ServiceName,
    ServiceName,
    ResourceServiceName,
    PaginatorName,
    WaiterName,
    RegionName,
)

def check_value(value: AcceleratorManufacturerType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_ec2.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_ec2.type_defs import (
    AcceleratorCountRequestTypeDef,
    AcceleratorCountTypeDef,
    AcceleratorTotalMemoryMiBRequestTypeDef,
    AcceleratorTotalMemoryMiBTypeDef,
    AcceptReservedInstancesExchangeQuoteRequestRequestTypeDef,
    AcceptReservedInstancesExchangeQuoteResultTypeDef,
    AcceptTransitGatewayMulticastDomainAssociationsRequestRequestTypeDef,
    AcceptTransitGatewayMulticastDomainAssociationsResultTypeDef,
    AcceptTransitGatewayPeeringAttachmentRequestRequestTypeDef,
    AcceptTransitGatewayPeeringAttachmentResultTypeDef,
    AcceptTransitGatewayVpcAttachmentRequestRequestTypeDef,
    AcceptTransitGatewayVpcAttachmentResultTypeDef,
    AcceptVpcEndpointConnectionsRequestRequestTypeDef,
    AcceptVpcEndpointConnectionsResultTypeDef,
    AcceptVpcPeeringConnectionRequestRequestTypeDef,
    AcceptVpcPeeringConnectionRequestVpcPeeringConnectionAcceptTypeDef,
    AcceptVpcPeeringConnectionResultTypeDef,
    AccessScopeAnalysisFindingTypeDef,
    AccessScopePathRequestTypeDef,
    AccessScopePathTypeDef,
    AccountAttributeTypeDef,
    AccountAttributeValueTypeDef,
    ActiveInstanceTypeDef,
    AddIpamOperatingRegionTypeDef,
    AddPrefixListEntryTypeDef,
    AdditionalDetailTypeDef,
    AddressAttributeTypeDef,
    AddressTypeDef,
    AdvertiseByoipCidrRequestRequestTypeDef,
    AdvertiseByoipCidrResultTypeDef,
    AllocateAddressRequestRequestTypeDef,
    AllocateAddressResultTypeDef,
    AllocateHostsRequestRequestTypeDef,
    AllocateHostsResultTypeDef,
    AllocateIpamPoolCidrRequestRequestTypeDef,
    AllocateIpamPoolCidrResultTypeDef,
    AllowedPrincipalTypeDef,
    AlternatePathHintTypeDef,
    AnalysisAclRuleTypeDef,
    AnalysisComponentTypeDef,
    AnalysisLoadBalancerListenerTypeDef,
    AnalysisLoadBalancerTargetTypeDef,
    AnalysisPacketHeaderTypeDef,
    AnalysisRouteTableRouteTypeDef,
    AnalysisSecurityGroupRuleTypeDef,
    ApplySecurityGroupsToClientVpnTargetNetworkRequestRequestTypeDef,
    ApplySecurityGroupsToClientVpnTargetNetworkResultTypeDef,
    AssignIpv6AddressesRequestRequestTypeDef,
    AssignIpv6AddressesResultTypeDef,
    AssignPrivateIpAddressesRequestNetworkInterfaceAssignPrivateIpAddressesTypeDef,
    AssignPrivateIpAddressesRequestRequestTypeDef,
    AssignPrivateIpAddressesResultTypeDef,
    AssignedPrivateIpAddressTypeDef,
    AssociateAddressRequestClassicAddressAssociateTypeDef,
    AssociateAddressRequestRequestTypeDef,
    AssociateAddressRequestVpcAddressAssociateTypeDef,
    AssociateAddressResultTypeDef,
    AssociateClientVpnTargetNetworkRequestRequestTypeDef,
    AssociateClientVpnTargetNetworkResultTypeDef,
    AssociateDhcpOptionsRequestDhcpOptionsAssociateWithVpcTypeDef,
    AssociateDhcpOptionsRequestRequestTypeDef,
    AssociateDhcpOptionsRequestVpcAssociateDhcpOptionsTypeDef,
    AssociateEnclaveCertificateIamRoleRequestRequestTypeDef,
    AssociateEnclaveCertificateIamRoleResultTypeDef,
    AssociateIamInstanceProfileRequestRequestTypeDef,
    AssociateIamInstanceProfileResultTypeDef,
    AssociateInstanceEventWindowRequestRequestTypeDef,
    AssociateInstanceEventWindowResultTypeDef,
    AssociateRouteTableRequestRequestTypeDef,
    AssociateRouteTableRequestRouteTableAssociateWithSubnetTypeDef,
    AssociateRouteTableResultTypeDef,
    AssociateSubnetCidrBlockRequestRequestTypeDef,
    AssociateSubnetCidrBlockResultTypeDef,
    AssociateTransitGatewayMulticastDomainRequestRequestTypeDef,
    AssociateTransitGatewayMulticastDomainResultTypeDef,
    AssociateTransitGatewayRouteTableRequestRequestTypeDef,
    AssociateTransitGatewayRouteTableResultTypeDef,
    AssociateTrunkInterfaceRequestRequestTypeDef,
    AssociateTrunkInterfaceResultTypeDef,
    AssociateVpcCidrBlockRequestRequestTypeDef,
    AssociateVpcCidrBlockResultTypeDef,
    AssociatedRoleTypeDef,
    AssociatedTargetNetworkTypeDef,
    AssociationStatusTypeDef,
    AthenaIntegrationTypeDef,
    AttachClassicLinkVpcRequestInstanceAttachClassicLinkVpcTypeDef,
    AttachClassicLinkVpcRequestRequestTypeDef,
    AttachClassicLinkVpcRequestVpcAttachClassicLinkInstanceTypeDef,
    AttachClassicLinkVpcResultTypeDef,
    AttachInternetGatewayRequestInternetGatewayAttachToVpcTypeDef,
    AttachInternetGatewayRequestRequestTypeDef,
    AttachInternetGatewayRequestVpcAttachInternetGatewayTypeDef,
    AttachNetworkInterfaceRequestNetworkInterfaceAttachTypeDef,
    AttachNetworkInterfaceRequestRequestTypeDef,
    AttachNetworkInterfaceResultTypeDef,
    AttachVolumeRequestInstanceAttachVolumeTypeDef,
    AttachVolumeRequestRequestTypeDef,
    AttachVolumeRequestVolumeAttachToInstanceTypeDef,
    AttachVpnGatewayRequestRequestTypeDef,
    AttachVpnGatewayResultTypeDef,
    AttributeBooleanValueTypeDef,
    AttributeValueTypeDef,
    AuthorizationRuleTypeDef,
    AuthorizeClientVpnIngressRequestRequestTypeDef,
    AuthorizeClientVpnIngressResultTypeDef,
    AuthorizeSecurityGroupEgressRequestRequestTypeDef,
    AuthorizeSecurityGroupEgressRequestSecurityGroupAuthorizeEgressTypeDef,
    AuthorizeSecurityGroupEgressResultTypeDef,
    AuthorizeSecurityGroupIngressRequestRequestTypeDef,
    AuthorizeSecurityGroupIngressRequestSecurityGroupAuthorizeIngressTypeDef,
    AuthorizeSecurityGroupIngressResultTypeDef,
    AvailabilityZoneMessageTypeDef,
    AvailabilityZoneTypeDef,
    AvailableCapacityTypeDef,
    BaselineEbsBandwidthMbpsRequestTypeDef,
    BaselineEbsBandwidthMbpsTypeDef,
    BlobAttributeValueTypeDef,
    BlockDeviceMappingTypeDef,
    BundleInstanceRequestRequestTypeDef,
    BundleInstanceResultTypeDef,
    BundleTaskErrorTypeDef,
    BundleTaskTypeDef,
    ByoipCidrTypeDef,
    CancelBundleTaskRequestRequestTypeDef,
    CancelBundleTaskResultTypeDef,
    CancelCapacityReservationFleetErrorTypeDef,
    CancelCapacityReservationFleetsRequestRequestTypeDef,
    CancelCapacityReservationFleetsResultTypeDef,
    CancelCapacityReservationRequestRequestTypeDef,
    CancelCapacityReservationResultTypeDef,
    CancelConversionRequestRequestTypeDef,
    CancelExportTaskRequestRequestTypeDef,
    CancelImportTaskRequestRequestTypeDef,
    CancelImportTaskResultTypeDef,
    CancelReservedInstancesListingRequestRequestTypeDef,
    CancelReservedInstancesListingResultTypeDef,
    CancelSpotFleetRequestsErrorItemTypeDef,
    CancelSpotFleetRequestsErrorTypeDef,
    CancelSpotFleetRequestsRequestRequestTypeDef,
    CancelSpotFleetRequestsResponseTypeDef,
    CancelSpotFleetRequestsSuccessItemTypeDef,
    CancelSpotInstanceRequestsRequestRequestTypeDef,
    CancelSpotInstanceRequestsResultTypeDef,
    CancelledSpotInstanceRequestTypeDef,
    CapacityReservationFleetCancellationStateTypeDef,
    CapacityReservationFleetTypeDef,
    CapacityReservationGroupTypeDef,
    CapacityReservationOptionsRequestTypeDef,
    CapacityReservationOptionsTypeDef,
    CapacityReservationSpecificationResponseResponseMetadataTypeDef,
    CapacityReservationSpecificationResponseTypeDef,
    CapacityReservationSpecificationTypeDef,
    CapacityReservationTargetResponseTypeDef,
    CapacityReservationTargetTypeDef,
    CapacityReservationTypeDef,
    CarrierGatewayTypeDef,
    CertificateAuthenticationRequestTypeDef,
    CertificateAuthenticationTypeDef,
    CidrAuthorizationContextTypeDef,
    CidrBlockTypeDef,
    ClassicLinkDnsSupportTypeDef,
    ClassicLinkInstanceTypeDef,
    ClassicLoadBalancerTypeDef,
    ClassicLoadBalancersConfigTypeDef,
    ClientCertificateRevocationListStatusTypeDef,
    ClientConnectOptionsTypeDef,
    ClientConnectResponseOptionsTypeDef,
    ClientDataTypeDef,
    ClientLoginBannerOptionsTypeDef,
    ClientLoginBannerResponseOptionsTypeDef,
    ClientVpnAuthenticationRequestTypeDef,
    ClientVpnAuthenticationTypeDef,
    ClientVpnAuthorizationRuleStatusTypeDef,
    ClientVpnConnectionStatusTypeDef,
    ClientVpnConnectionTypeDef,
    ClientVpnEndpointAttributeStatusTypeDef,
    ClientVpnEndpointStatusTypeDef,
    ClientVpnEndpointTypeDef,
    ClientVpnRouteStatusTypeDef,
    ClientVpnRouteTypeDef,
    CoipAddressUsageTypeDef,
    CoipPoolTypeDef,
    ConfirmProductInstanceRequestRequestTypeDef,
    ConfirmProductInstanceResultTypeDef,
    ConnectionLogOptionsTypeDef,
    ConnectionLogResponseOptionsTypeDef,
    ConnectionNotificationTypeDef,
    ConversionTaskTypeDef,
    CopyFpgaImageRequestRequestTypeDef,
    CopyFpgaImageResultTypeDef,
    CopyImageRequestRequestTypeDef,
    CopyImageResultTypeDef,
    CopySnapshotRequestRequestTypeDef,
    CopySnapshotRequestSnapshotCopyTypeDef,
    CopySnapshotResultTypeDef,
    CpuOptionsRequestTypeDef,
    CpuOptionsResponseMetadataTypeDef,
    CpuOptionsTypeDef,
    CreateCapacityReservationFleetRequestRequestTypeDef,
    CreateCapacityReservationFleetResultTypeDef,
    CreateCapacityReservationRequestRequestTypeDef,
    CreateCapacityReservationResultTypeDef,
    CreateCarrierGatewayRequestRequestTypeDef,
    CreateCarrierGatewayResultTypeDef,
    CreateClientVpnEndpointRequestRequestTypeDef,
    CreateClientVpnEndpointResultTypeDef,
    CreateClientVpnRouteRequestRequestTypeDef,
    CreateClientVpnRouteResultTypeDef,
    CreateCustomerGatewayRequestRequestTypeDef,
    CreateCustomerGatewayResultTypeDef,
    CreateDefaultSubnetRequestRequestTypeDef,
    CreateDefaultSubnetResultTypeDef,
    CreateDefaultVpcRequestRequestTypeDef,
    CreateDefaultVpcResultTypeDef,
    CreateDhcpOptionsRequestRequestTypeDef,
    CreateDhcpOptionsRequestServiceResourceCreateDhcpOptionsTypeDef,
    CreateDhcpOptionsResultTypeDef,
    CreateEgressOnlyInternetGatewayRequestRequestTypeDef,
    CreateEgressOnlyInternetGatewayResultTypeDef,
    CreateFleetErrorTypeDef,
    CreateFleetInstanceTypeDef,
    CreateFleetRequestRequestTypeDef,
    CreateFleetResultTypeDef,
    CreateFlowLogsRequestRequestTypeDef,
    CreateFlowLogsResultTypeDef,
    CreateFpgaImageRequestRequestTypeDef,
    CreateFpgaImageResultTypeDef,
    CreateImageRequestInstanceCreateImageTypeDef,
    CreateImageRequestRequestTypeDef,
    CreateImageResultTypeDef,
    CreateInstanceEventWindowRequestRequestTypeDef,
    CreateInstanceEventWindowResultTypeDef,
    CreateInstanceExportTaskRequestRequestTypeDef,
    CreateInstanceExportTaskResultTypeDef,
    CreateInternetGatewayRequestRequestTypeDef,
    CreateInternetGatewayRequestServiceResourceCreateInternetGatewayTypeDef,
    CreateInternetGatewayResultTypeDef,
    CreateIpamPoolRequestRequestTypeDef,
    CreateIpamPoolResultTypeDef,
    CreateIpamRequestRequestTypeDef,
    CreateIpamResultTypeDef,
    CreateIpamScopeRequestRequestTypeDef,
    CreateIpamScopeResultTypeDef,
    CreateKeyPairRequestRequestTypeDef,
    CreateKeyPairRequestServiceResourceCreateKeyPairTypeDef,
    CreateLaunchTemplateRequestRequestTypeDef,
    CreateLaunchTemplateResultTypeDef,
    CreateLaunchTemplateVersionRequestRequestTypeDef,
    CreateLaunchTemplateVersionResultTypeDef,
    CreateLocalGatewayRouteRequestRequestTypeDef,
    CreateLocalGatewayRouteResultTypeDef,
    CreateLocalGatewayRouteTableVpcAssociationRequestRequestTypeDef,
    CreateLocalGatewayRouteTableVpcAssociationResultTypeDef,
    CreateManagedPrefixListRequestRequestTypeDef,
    CreateManagedPrefixListResultTypeDef,
    CreateNatGatewayRequestRequestTypeDef,
    CreateNatGatewayResultTypeDef,
    CreateNetworkAclEntryRequestNetworkAclCreateEntryTypeDef,
    CreateNetworkAclEntryRequestRequestTypeDef,
    CreateNetworkAclRequestRequestTypeDef,
    CreateNetworkAclRequestServiceResourceCreateNetworkAclTypeDef,
    CreateNetworkAclRequestVpcCreateNetworkAclTypeDef,
    CreateNetworkAclResultTypeDef,
    CreateNetworkInsightsAccessScopeRequestRequestTypeDef,
    CreateNetworkInsightsAccessScopeResultTypeDef,
    CreateNetworkInsightsPathRequestRequestTypeDef,
    CreateNetworkInsightsPathResultTypeDef,
    CreateNetworkInterfacePermissionRequestRequestTypeDef,
    CreateNetworkInterfacePermissionResultTypeDef,
    CreateNetworkInterfaceRequestRequestTypeDef,
    CreateNetworkInterfaceRequestServiceResourceCreateNetworkInterfaceTypeDef,
    CreateNetworkInterfaceRequestSubnetCreateNetworkInterfaceTypeDef,
    CreateNetworkInterfaceResultTypeDef,
    CreatePlacementGroupRequestRequestTypeDef,
    CreatePlacementGroupRequestServiceResourceCreatePlacementGroupTypeDef,
    CreatePlacementGroupResultTypeDef,
    CreatePublicIpv4PoolRequestRequestTypeDef,
    CreatePublicIpv4PoolResultTypeDef,
    CreateReplaceRootVolumeTaskRequestRequestTypeDef,
    CreateReplaceRootVolumeTaskResultTypeDef,
    CreateReservedInstancesListingRequestRequestTypeDef,
    CreateReservedInstancesListingResultTypeDef,
    CreateRestoreImageTaskRequestRequestTypeDef,
    CreateRestoreImageTaskResultTypeDef,
    CreateRouteRequestRequestTypeDef,
    CreateRouteRequestRouteTableCreateRouteTypeDef,
    CreateRouteResultTypeDef,
    CreateRouteTableRequestRequestTypeDef,
    CreateRouteTableRequestServiceResourceCreateRouteTableTypeDef,
    CreateRouteTableRequestVpcCreateRouteTableTypeDef,
    CreateRouteTableResultTypeDef,
    CreateSecurityGroupRequestRequestTypeDef,
    CreateSecurityGroupRequestServiceResourceCreateSecurityGroupTypeDef,
    CreateSecurityGroupRequestVpcCreateSecurityGroupTypeDef,
    CreateSecurityGroupResultTypeDef,
    CreateSnapshotRequestRequestTypeDef,
    CreateSnapshotRequestServiceResourceCreateSnapshotTypeDef,
    CreateSnapshotRequestVolumeCreateSnapshotTypeDef,
    CreateSnapshotsRequestRequestTypeDef,
    CreateSnapshotsResultTypeDef,
    CreateSpotDatafeedSubscriptionRequestRequestTypeDef,
    CreateSpotDatafeedSubscriptionResultTypeDef,
    CreateStoreImageTaskRequestRequestTypeDef,
    CreateStoreImageTaskResultTypeDef,
    CreateSubnetCidrReservationRequestRequestTypeDef,
    CreateSubnetCidrReservationResultTypeDef,
    CreateSubnetRequestRequestTypeDef,
    CreateSubnetRequestServiceResourceCreateSubnetTypeDef,
    CreateSubnetRequestVpcCreateSubnetTypeDef,
    CreateSubnetResultTypeDef,
    CreateTagsRequestDhcpOptionsCreateTagsTypeDef,
    CreateTagsRequestImageCreateTagsTypeDef,
    CreateTagsRequestInstanceCreateTagsTypeDef,
    CreateTagsRequestInternetGatewayCreateTagsTypeDef,
    CreateTagsRequestNetworkAclCreateTagsTypeDef,
    CreateTagsRequestNetworkInterfaceCreateTagsTypeDef,
    CreateTagsRequestRequestTypeDef,
    CreateTagsRequestRouteTableCreateTagsTypeDef,
    CreateTagsRequestSecurityGroupCreateTagsTypeDef,
    CreateTagsRequestServiceResourceCreateTagsTypeDef,
    CreateTagsRequestSnapshotCreateTagsTypeDef,
    CreateTagsRequestSubnetCreateTagsTypeDef,
    CreateTagsRequestVolumeCreateTagsTypeDef,
    CreateTagsRequestVpcCreateTagsTypeDef,
    CreateTrafficMirrorFilterRequestRequestTypeDef,
    CreateTrafficMirrorFilterResultTypeDef,
    CreateTrafficMirrorFilterRuleRequestRequestTypeDef,
    CreateTrafficMirrorFilterRuleResultTypeDef,
    CreateTrafficMirrorSessionRequestRequestTypeDef,
    CreateTrafficMirrorSessionResultTypeDef,
    CreateTrafficMirrorTargetRequestRequestTypeDef,
    CreateTrafficMirrorTargetResultTypeDef,
    CreateTransitGatewayConnectPeerRequestRequestTypeDef,
    CreateTransitGatewayConnectPeerResultTypeDef,
    CreateTransitGatewayConnectRequestOptionsTypeDef,
    CreateTransitGatewayConnectRequestRequestTypeDef,
    CreateTransitGatewayConnectResultTypeDef,
    CreateTransitGatewayMulticastDomainRequestOptionsTypeDef,
    CreateTransitGatewayMulticastDomainRequestRequestTypeDef,
    CreateTransitGatewayMulticastDomainResultTypeDef,
    CreateTransitGatewayPeeringAttachmentRequestRequestTypeDef,
    CreateTransitGatewayPeeringAttachmentResultTypeDef,
    CreateTransitGatewayPrefixListReferenceRequestRequestTypeDef,
    CreateTransitGatewayPrefixListReferenceResultTypeDef,
    CreateTransitGatewayRequestRequestTypeDef,
    CreateTransitGatewayResultTypeDef,
    CreateTransitGatewayRouteRequestRequestTypeDef,
    CreateTransitGatewayRouteResultTypeDef,
    CreateTransitGatewayRouteTableRequestRequestTypeDef,
    CreateTransitGatewayRouteTableResultTypeDef,
    CreateTransitGatewayVpcAttachmentRequestOptionsTypeDef,
    CreateTransitGatewayVpcAttachmentRequestRequestTypeDef,
    CreateTransitGatewayVpcAttachmentResultTypeDef,
    CreateVolumePermissionModificationsTypeDef,
    CreateVolumePermissionTypeDef,
    CreateVolumeRequestRequestTypeDef,
    CreateVolumeRequestServiceResourceCreateVolumeTypeDef,
    CreateVpcEndpointConnectionNotificationRequestRequestTypeDef,
    CreateVpcEndpointConnectionNotificationResultTypeDef,
    CreateVpcEndpointRequestRequestTypeDef,
    CreateVpcEndpointResultTypeDef,
    CreateVpcEndpointServiceConfigurationRequestRequestTypeDef,
    CreateVpcEndpointServiceConfigurationResultTypeDef,
    CreateVpcPeeringConnectionRequestRequestTypeDef,
    CreateVpcPeeringConnectionRequestServiceResourceCreateVpcPeeringConnectionTypeDef,
    CreateVpcPeeringConnectionRequestVpcRequestVpcPeeringConnectionTypeDef,
    CreateVpcPeeringConnectionResultTypeDef,
    CreateVpcRequestRequestTypeDef,
    CreateVpcRequestServiceResourceCreateVpcTypeDef,
    CreateVpcResultTypeDef,
    CreateVpnConnectionRequestRequestTypeDef,
    CreateVpnConnectionResultTypeDef,
    CreateVpnConnectionRouteRequestRequestTypeDef,
    CreateVpnGatewayRequestRequestTypeDef,
    CreateVpnGatewayResultTypeDef,
    CreditSpecificationRequestTypeDef,
    CreditSpecificationTypeDef,
    CustomerGatewayTypeDef,
    DeleteCarrierGatewayRequestRequestTypeDef,
    DeleteCarrierGatewayResultTypeDef,
    DeleteClientVpnEndpointRequestRequestTypeDef,
    DeleteClientVpnEndpointResultTypeDef,
    DeleteClientVpnRouteRequestRequestTypeDef,
    DeleteClientVpnRouteResultTypeDef,
    DeleteCustomerGatewayRequestRequestTypeDef,
    DeleteDhcpOptionsRequestDhcpOptionsDeleteTypeDef,
    DeleteDhcpOptionsRequestRequestTypeDef,
    DeleteEgressOnlyInternetGatewayRequestRequestTypeDef,
    DeleteEgressOnlyInternetGatewayResultTypeDef,
    DeleteFleetErrorItemTypeDef,
    DeleteFleetErrorTypeDef,
    DeleteFleetSuccessItemTypeDef,
    DeleteFleetsRequestRequestTypeDef,
    DeleteFleetsResultTypeDef,
    DeleteFlowLogsRequestRequestTypeDef,
    DeleteFlowLogsResultTypeDef,
    DeleteFpgaImageRequestRequestTypeDef,
    DeleteFpgaImageResultTypeDef,
    DeleteInstanceEventWindowRequestRequestTypeDef,
    DeleteInstanceEventWindowResultTypeDef,
    DeleteInternetGatewayRequestInternetGatewayDeleteTypeDef,
    DeleteInternetGatewayRequestRequestTypeDef,
    DeleteIpamPoolRequestRequestTypeDef,
    DeleteIpamPoolResultTypeDef,
    DeleteIpamRequestRequestTypeDef,
    DeleteIpamResultTypeDef,
    DeleteIpamScopeRequestRequestTypeDef,
    DeleteIpamScopeResultTypeDef,
    DeleteKeyPairRequestKeyPairDeleteTypeDef,
    DeleteKeyPairRequestKeyPairInfoDeleteTypeDef,
    DeleteKeyPairRequestRequestTypeDef,
    DeleteLaunchTemplateRequestRequestTypeDef,
    DeleteLaunchTemplateResultTypeDef,
    DeleteLaunchTemplateVersionsRequestRequestTypeDef,
    DeleteLaunchTemplateVersionsResponseErrorItemTypeDef,
    DeleteLaunchTemplateVersionsResponseSuccessItemTypeDef,
    DeleteLaunchTemplateVersionsResultTypeDef,
    DeleteLocalGatewayRouteRequestRequestTypeDef,
    DeleteLocalGatewayRouteResultTypeDef,
    DeleteLocalGatewayRouteTableVpcAssociationRequestRequestTypeDef,
    DeleteLocalGatewayRouteTableVpcAssociationResultTypeDef,
    DeleteManagedPrefixListRequestRequestTypeDef,
    DeleteManagedPrefixListResultTypeDef,
    DeleteNatGatewayRequestRequestTypeDef,
    DeleteNatGatewayResultTypeDef,
    DeleteNetworkAclEntryRequestNetworkAclDeleteEntryTypeDef,
    DeleteNetworkAclEntryRequestRequestTypeDef,
    DeleteNetworkAclRequestNetworkAclDeleteTypeDef,
    DeleteNetworkAclRequestRequestTypeDef,
    DeleteNetworkInsightsAccessScopeAnalysisRequestRequestTypeDef,
    DeleteNetworkInsightsAccessScopeAnalysisResultTypeDef,
    DeleteNetworkInsightsAccessScopeRequestRequestTypeDef,
    DeleteNetworkInsightsAccessScopeResultTypeDef,
    DeleteNetworkInsightsAnalysisRequestRequestTypeDef,
    DeleteNetworkInsightsAnalysisResultTypeDef,
    DeleteNetworkInsightsPathRequestRequestTypeDef,
    DeleteNetworkInsightsPathResultTypeDef,
    DeleteNetworkInterfacePermissionRequestRequestTypeDef,
    DeleteNetworkInterfacePermissionResultTypeDef,
    DeleteNetworkInterfaceRequestNetworkInterfaceDeleteTypeDef,
    DeleteNetworkInterfaceRequestRequestTypeDef,
    DeletePlacementGroupRequestPlacementGroupDeleteTypeDef,
    DeletePlacementGroupRequestRequestTypeDef,
    DeletePublicIpv4PoolRequestRequestTypeDef,
    DeletePublicIpv4PoolResultTypeDef,
    DeleteQueuedReservedInstancesErrorTypeDef,
    DeleteQueuedReservedInstancesRequestRequestTypeDef,
    DeleteQueuedReservedInstancesResultTypeDef,
    DeleteRouteRequestRequestTypeDef,
    DeleteRouteRequestRouteDeleteTypeDef,
    DeleteRouteTableRequestRequestTypeDef,
    DeleteRouteTableRequestRouteTableDeleteTypeDef,
    DeleteSecurityGroupRequestRequestTypeDef,
    DeleteSecurityGroupRequestSecurityGroupDeleteTypeDef,
    DeleteSnapshotRequestRequestTypeDef,
    DeleteSnapshotRequestSnapshotDeleteTypeDef,
    DeleteSpotDatafeedSubscriptionRequestRequestTypeDef,
    DeleteSubnetCidrReservationRequestRequestTypeDef,
    DeleteSubnetCidrReservationResultTypeDef,
    DeleteSubnetRequestRequestTypeDef,
    DeleteSubnetRequestSubnetDeleteTypeDef,
    DeleteTagsRequestRequestTypeDef,
    DeleteTagsRequestTagDeleteTypeDef,
    DeleteTrafficMirrorFilterRequestRequestTypeDef,
    DeleteTrafficMirrorFilterResultTypeDef,
    DeleteTrafficMirrorFilterRuleRequestRequestTypeDef,
    DeleteTrafficMirrorFilterRuleResultTypeDef,
    DeleteTrafficMirrorSessionRequestRequestTypeDef,
    DeleteTrafficMirrorSessionResultTypeDef,
    DeleteTrafficMirrorTargetRequestRequestTypeDef,
    DeleteTrafficMirrorTargetResultTypeDef,
    DeleteTransitGatewayConnectPeerRequestRequestTypeDef,
    DeleteTransitGatewayConnectPeerResultTypeDef,
    DeleteTransitGatewayConnectRequestRequestTypeDef,
    DeleteTransitGatewayConnectResultTypeDef,
    DeleteTransitGatewayMulticastDomainRequestRequestTypeDef,
    DeleteTransitGatewayMulticastDomainResultTypeDef,
    DeleteTransitGatewayPeeringAttachmentRequestRequestTypeDef,
    DeleteTransitGatewayPeeringAttachmentResultTypeDef,
    DeleteTransitGatewayPrefixListReferenceRequestRequestTypeDef,
    DeleteTransitGatewayPrefixListReferenceResultTypeDef,
    DeleteTransitGatewayRequestRequestTypeDef,
    DeleteTransitGatewayResultTypeDef,
    DeleteTransitGatewayRouteRequestRequestTypeDef,
    DeleteTransitGatewayRouteResultTypeDef,
    DeleteTransitGatewayRouteTableRequestRequestTypeDef,
    DeleteTransitGatewayRouteTableResultTypeDef,
    DeleteTransitGatewayVpcAttachmentRequestRequestTypeDef,
    DeleteTransitGatewayVpcAttachmentResultTypeDef,
    DeleteVolumeRequestRequestTypeDef,
    DeleteVolumeRequestVolumeDeleteTypeDef,
    DeleteVpcEndpointConnectionNotificationsRequestRequestTypeDef,
    DeleteVpcEndpointConnectionNotificationsResultTypeDef,
    DeleteVpcEndpointServiceConfigurationsRequestRequestTypeDef,
    DeleteVpcEndpointServiceConfigurationsResultTypeDef,
    DeleteVpcEndpointsRequestRequestTypeDef,
    DeleteVpcEndpointsResultTypeDef,
    DeleteVpcPeeringConnectionRequestRequestTypeDef,
    DeleteVpcPeeringConnectionRequestVpcPeeringConnectionDeleteTypeDef,
    DeleteVpcPeeringConnectionResultTypeDef,
    DeleteVpcRequestRequestTypeDef,
    DeleteVpcRequestVpcDeleteTypeDef,
    DeleteVpnConnectionRequestRequestTypeDef,
    DeleteVpnConnectionRouteRequestRequestTypeDef,
    DeleteVpnGatewayRequestRequestTypeDef,
    DeprovisionByoipCidrRequestRequestTypeDef,
    DeprovisionByoipCidrResultTypeDef,
    DeprovisionIpamPoolCidrRequestRequestTypeDef,
    DeprovisionIpamPoolCidrResultTypeDef,
    DeprovisionPublicIpv4PoolCidrRequestRequestTypeDef,
    DeprovisionPublicIpv4PoolCidrResultTypeDef,
    DeregisterImageRequestImageDeregisterTypeDef,
    DeregisterImageRequestRequestTypeDef,
    DeregisterInstanceEventNotificationAttributesRequestRequestTypeDef,
    DeregisterInstanceEventNotificationAttributesResultTypeDef,
    DeregisterInstanceTagAttributeRequestTypeDef,
    DeregisterTransitGatewayMulticastGroupMembersRequestRequestTypeDef,
    DeregisterTransitGatewayMulticastGroupMembersResultTypeDef,
    DeregisterTransitGatewayMulticastGroupSourcesRequestRequestTypeDef,
    DeregisterTransitGatewayMulticastGroupSourcesResultTypeDef,
    DescribeAccountAttributesRequestRequestTypeDef,
    DescribeAccountAttributesResultTypeDef,
    DescribeAddressesAttributeRequestDescribeAddressesAttributePaginateTypeDef,
    DescribeAddressesAttributeRequestRequestTypeDef,
    DescribeAddressesAttributeResultTypeDef,
    DescribeAddressesRequestRequestTypeDef,
    DescribeAddressesResultTypeDef,
    DescribeAggregateIdFormatRequestRequestTypeDef,
    DescribeAggregateIdFormatResultTypeDef,
    DescribeAvailabilityZonesRequestRequestTypeDef,
    DescribeAvailabilityZonesResultTypeDef,
    DescribeBundleTasksRequestBundleTaskCompleteWaitTypeDef,
    DescribeBundleTasksRequestRequestTypeDef,
    DescribeBundleTasksResultTypeDef,
    DescribeByoipCidrsRequestDescribeByoipCidrsPaginateTypeDef,
    DescribeByoipCidrsRequestRequestTypeDef,
    DescribeByoipCidrsResultTypeDef,
    DescribeCapacityReservationFleetsRequestDescribeCapacityReservationFleetsPaginateTypeDef,
    DescribeCapacityReservationFleetsRequestRequestTypeDef,
    DescribeCapacityReservationFleetsResultTypeDef,
    DescribeCapacityReservationsRequestDescribeCapacityReservationsPaginateTypeDef,
    DescribeCapacityReservationsRequestRequestTypeDef,
    DescribeCapacityReservationsResultTypeDef,
    DescribeCarrierGatewaysRequestDescribeCarrierGatewaysPaginateTypeDef,
    DescribeCarrierGatewaysRequestRequestTypeDef,
    DescribeCarrierGatewaysResultTypeDef,
    DescribeClassicLinkInstancesRequestDescribeClassicLinkInstancesPaginateTypeDef,
    DescribeClassicLinkInstancesRequestRequestTypeDef,
    DescribeClassicLinkInstancesResultTypeDef,
    DescribeClientVpnAuthorizationRulesRequestDescribeClientVpnAuthorizationRulesPaginateTypeDef,
    DescribeClientVpnAuthorizationRulesRequestRequestTypeDef,
    DescribeClientVpnAuthorizationRulesResultTypeDef,
    DescribeClientVpnConnectionsRequestDescribeClientVpnConnectionsPaginateTypeDef,
    DescribeClientVpnConnectionsRequestRequestTypeDef,
    DescribeClientVpnConnectionsResultTypeDef,
    DescribeClientVpnEndpointsRequestDescribeClientVpnEndpointsPaginateTypeDef,
    DescribeClientVpnEndpointsRequestRequestTypeDef,
    DescribeClientVpnEndpointsResultTypeDef,
    DescribeClientVpnRoutesRequestDescribeClientVpnRoutesPaginateTypeDef,
    DescribeClientVpnRoutesRequestRequestTypeDef,
    DescribeClientVpnRoutesResultTypeDef,
    DescribeClientVpnTargetNetworksRequestDescribeClientVpnTargetNetworksPaginateTypeDef,
    DescribeClientVpnTargetNetworksRequestRequestTypeDef,
    DescribeClientVpnTargetNetworksResultTypeDef,
    DescribeCoipPoolsRequestDescribeCoipPoolsPaginateTypeDef,
    DescribeCoipPoolsRequestRequestTypeDef,
    DescribeCoipPoolsResultTypeDef,
    DescribeConversionTasksRequestConversionTaskCancelledWaitTypeDef,
    DescribeConversionTasksRequestConversionTaskCompletedWaitTypeDef,
    DescribeConversionTasksRequestConversionTaskDeletedWaitTypeDef,
    DescribeConversionTasksRequestRequestTypeDef,
    DescribeConversionTasksResultTypeDef,
    DescribeCustomerGatewaysRequestCustomerGatewayAvailableWaitTypeDef,
    DescribeCustomerGatewaysRequestRequestTypeDef,
    DescribeCustomerGatewaysResultTypeDef,
    DescribeDhcpOptionsRequestDescribeDhcpOptionsPaginateTypeDef,
    DescribeDhcpOptionsRequestRequestTypeDef,
    DescribeDhcpOptionsResultTypeDef,
    DescribeEgressOnlyInternetGatewaysRequestDescribeEgressOnlyInternetGatewaysPaginateTypeDef,
    DescribeEgressOnlyInternetGatewaysRequestRequestTypeDef,
    DescribeEgressOnlyInternetGatewaysResultTypeDef,
    DescribeElasticGpusRequestRequestTypeDef,
    DescribeElasticGpusResultTypeDef,
    DescribeExportImageTasksRequestDescribeExportImageTasksPaginateTypeDef,
    DescribeExportImageTasksRequestRequestTypeDef,
    DescribeExportImageTasksResultTypeDef,
    DescribeExportTasksRequestExportTaskCancelledWaitTypeDef,
    DescribeExportTasksRequestExportTaskCompletedWaitTypeDef,
    DescribeExportTasksRequestRequestTypeDef,
    DescribeExportTasksResultTypeDef,
    DescribeFastLaunchImagesRequestDescribeFastLaunchImagesPaginateTypeDef,
    DescribeFastLaunchImagesRequestRequestTypeDef,
    DescribeFastLaunchImagesResultTypeDef,
    DescribeFastLaunchImagesSuccessItemTypeDef,
    DescribeFastSnapshotRestoreSuccessItemTypeDef,
    DescribeFastSnapshotRestoresRequestDescribeFastSnapshotRestoresPaginateTypeDef,
    DescribeFastSnapshotRestoresRequestRequestTypeDef,
    DescribeFastSnapshotRestoresResultTypeDef,
    DescribeFleetErrorTypeDef,
    DescribeFleetHistoryRequestRequestTypeDef,
    DescribeFleetHistoryResultTypeDef,
    DescribeFleetInstancesRequestRequestTypeDef,
    DescribeFleetInstancesResultTypeDef,
    DescribeFleetsInstancesTypeDef,
    DescribeFleetsRequestDescribeFleetsPaginateTypeDef,
    DescribeFleetsRequestRequestTypeDef,
    DescribeFleetsResultTypeDef,
    DescribeFlowLogsRequestDescribeFlowLogsPaginateTypeDef,
    DescribeFlowLogsRequestRequestTypeDef,
    DescribeFlowLogsResultTypeDef,
    DescribeFpgaImageAttributeRequestRequestTypeDef,
    DescribeFpgaImageAttributeResultTypeDef,
    DescribeFpgaImagesRequestDescribeFpgaImagesPaginateTypeDef,
    DescribeFpgaImagesRequestRequestTypeDef,
    DescribeFpgaImagesResultTypeDef,
    DescribeHostReservationOfferingsRequestDescribeHostReservationOfferingsPaginateTypeDef,
    DescribeHostReservationOfferingsRequestRequestTypeDef,
    DescribeHostReservationOfferingsResultTypeDef,
    DescribeHostReservationsRequestDescribeHostReservationsPaginateTypeDef,
    DescribeHostReservationsRequestRequestTypeDef,
    DescribeHostReservationsResultTypeDef,
    DescribeHostsRequestDescribeHostsPaginateTypeDef,
    DescribeHostsRequestRequestTypeDef,
    DescribeHostsResultTypeDef,
    DescribeIamInstanceProfileAssociationsRequestDescribeIamInstanceProfileAssociationsPaginateTypeDef,
    DescribeIamInstanceProfileAssociationsRequestRequestTypeDef,
    DescribeIamInstanceProfileAssociationsResultTypeDef,
    DescribeIdFormatRequestRequestTypeDef,
    DescribeIdFormatResultTypeDef,
    DescribeIdentityIdFormatRequestRequestTypeDef,
    DescribeIdentityIdFormatResultTypeDef,
    DescribeImageAttributeRequestImageDescribeAttributeTypeDef,
    DescribeImageAttributeRequestRequestTypeDef,
    DescribeImagesRequestImageAvailableWaitTypeDef,
    DescribeImagesRequestImageExistsWaitTypeDef,
    DescribeImagesRequestRequestTypeDef,
    DescribeImagesResultTypeDef,
    DescribeImportImageTasksRequestDescribeImportImageTasksPaginateTypeDef,
    DescribeImportImageTasksRequestRequestTypeDef,
    DescribeImportImageTasksResultTypeDef,
    DescribeImportSnapshotTasksRequestDescribeImportSnapshotTasksPaginateTypeDef,
    DescribeImportSnapshotTasksRequestRequestTypeDef,
    DescribeImportSnapshotTasksResultTypeDef,
    DescribeInstanceAttributeRequestInstanceDescribeAttributeTypeDef,
    DescribeInstanceAttributeRequestRequestTypeDef,
    DescribeInstanceCreditSpecificationsRequestDescribeInstanceCreditSpecificationsPaginateTypeDef,
    DescribeInstanceCreditSpecificationsRequestRequestTypeDef,
    DescribeInstanceCreditSpecificationsResultTypeDef,
    DescribeInstanceEventNotificationAttributesRequestRequestTypeDef,
    DescribeInstanceEventNotificationAttributesResultTypeDef,
    DescribeInstanceEventWindowsRequestDescribeInstanceEventWindowsPaginateTypeDef,
    DescribeInstanceEventWindowsRequestRequestTypeDef,
    DescribeInstanceEventWindowsResultTypeDef,
    DescribeInstanceStatusRequestDescribeInstanceStatusPaginateTypeDef,
    DescribeInstanceStatusRequestInstanceStatusOkWaitTypeDef,
    DescribeInstanceStatusRequestRequestTypeDef,
    DescribeInstanceStatusRequestSystemStatusOkWaitTypeDef,
    DescribeInstanceStatusResultTypeDef,
    DescribeInstanceTypeOfferingsRequestDescribeInstanceTypeOfferingsPaginateTypeDef,
    DescribeInstanceTypeOfferingsRequestRequestTypeDef,
    DescribeInstanceTypeOfferingsResultTypeDef,
    DescribeInstanceTypesRequestDescribeInstanceTypesPaginateTypeDef,
    DescribeInstanceTypesRequestRequestTypeDef,
    DescribeInstanceTypesResultTypeDef,
    DescribeInstancesRequestDescribeInstancesPaginateTypeDef,
    DescribeInstancesRequestInstanceExistsWaitTypeDef,
    DescribeInstancesRequestInstanceRunningWaitTypeDef,
    DescribeInstancesRequestInstanceStoppedWaitTypeDef,
    DescribeInstancesRequestInstanceTerminatedWaitTypeDef,
    DescribeInstancesRequestRequestTypeDef,
    DescribeInstancesResultTypeDef,
    DescribeInternetGatewaysRequestDescribeInternetGatewaysPaginateTypeDef,
    DescribeInternetGatewaysRequestInternetGatewayExistsWaitTypeDef,
    DescribeInternetGatewaysRequestRequestTypeDef,
    DescribeInternetGatewaysResultTypeDef,
    DescribeIpamPoolsRequestDescribeIpamPoolsPaginateTypeDef,
    DescribeIpamPoolsRequestRequestTypeDef,
    DescribeIpamPoolsResultTypeDef,
    DescribeIpamScopesRequestDescribeIpamScopesPaginateTypeDef,
    DescribeIpamScopesRequestRequestTypeDef,
    DescribeIpamScopesResultTypeDef,
    DescribeIpamsRequestDescribeIpamsPaginateTypeDef,
    DescribeIpamsRequestRequestTypeDef,
    DescribeIpamsResultTypeDef,
    DescribeIpv6PoolsRequestDescribeIpv6PoolsPaginateTypeDef,
    DescribeIpv6PoolsRequestRequestTypeDef,
    DescribeIpv6PoolsResultTypeDef,
    DescribeKeyPairsRequestKeyPairExistsWaitTypeDef,
    DescribeKeyPairsRequestRequestTypeDef,
    DescribeKeyPairsResultTypeDef,
    DescribeLaunchTemplateVersionsRequestDescribeLaunchTemplateVersionsPaginateTypeDef,
    DescribeLaunchTemplateVersionsRequestRequestTypeDef,
    DescribeLaunchTemplateVersionsResultTypeDef,
    DescribeLaunchTemplatesRequestDescribeLaunchTemplatesPaginateTypeDef,
    DescribeLaunchTemplatesRequestRequestTypeDef,
    DescribeLaunchTemplatesResultTypeDef,
    DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequestDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginateTypeDef,
    DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequestRequestTypeDef,
    DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResultTypeDef,
    DescribeLocalGatewayRouteTableVpcAssociationsRequestDescribeLocalGatewayRouteTableVpcAssociationsPaginateTypeDef,
    DescribeLocalGatewayRouteTableVpcAssociationsRequestRequestTypeDef,
    DescribeLocalGatewayRouteTableVpcAssociationsResultTypeDef,
    DescribeLocalGatewayRouteTablesRequestDescribeLocalGatewayRouteTablesPaginateTypeDef,
    DescribeLocalGatewayRouteTablesRequestRequestTypeDef,
    DescribeLocalGatewayRouteTablesResultTypeDef,
    DescribeLocalGatewayVirtualInterfaceGroupsRequestDescribeLocalGatewayVirtualInterfaceGroupsPaginateTypeDef,
    DescribeLocalGatewayVirtualInterfaceGroupsRequestRequestTypeDef,
    DescribeLocalGatewayVirtualInterfaceGroupsResultTypeDef,
    DescribeLocalGatewayVirtualInterfacesRequestDescribeLocalGatewayVirtualInterfacesPaginateTypeDef,
    DescribeLocalGatewayVirtualInterfacesRequestRequestTypeDef,
    DescribeLocalGatewayVirtualInterfacesResultTypeDef,
    DescribeLocalGatewaysRequestDescribeLocalGatewaysPaginateTypeDef,
    DescribeLocalGatewaysRequestRequestTypeDef,
    DescribeLocalGatewaysResultTypeDef,
    DescribeManagedPrefixListsRequestDescribeManagedPrefixListsPaginateTypeDef,
    DescribeManagedPrefixListsRequestRequestTypeDef,
    DescribeManagedPrefixListsResultTypeDef,
    DescribeMovingAddressesRequestDescribeMovingAddressesPaginateTypeDef,
    DescribeMovingAddressesRequestRequestTypeDef,
    DescribeMovingAddressesResultTypeDef,
    DescribeNatGatewaysRequestDescribeNatGatewaysPaginateTypeDef,
    DescribeNatGatewaysRequestNatGatewayAvailableWaitTypeDef,
    DescribeNatGatewaysRequestNatGatewayDeletedWaitTypeDef,
    DescribeNatGatewaysRequestRequestTypeDef,
    DescribeNatGatewaysResultTypeDef,
    DescribeNetworkAclsRequestDescribeNetworkAclsPaginateTypeDef,
    DescribeNetworkAclsRequestRequestTypeDef,
    DescribeNetworkAclsResultTypeDef,
    DescribeNetworkInsightsAccessScopeAnalysesRequestDescribeNetworkInsightsAccessScopeAnalysesPaginateTypeDef,
    DescribeNetworkInsightsAccessScopeAnalysesRequestRequestTypeDef,
    DescribeNetworkInsightsAccessScopeAnalysesResultTypeDef,
    DescribeNetworkInsightsAccessScopesRequestDescribeNetworkInsightsAccessScopesPaginateTypeDef,
    DescribeNetworkInsightsAccessScopesRequestRequestTypeDef,
    DescribeNetworkInsightsAccessScopesResultTypeDef,
    DescribeNetworkInsightsAnalysesRequestDescribeNetworkInsightsAnalysesPaginateTypeDef,
    DescribeNetworkInsightsAnalysesRequestRequestTypeDef,
    DescribeNetworkInsightsAnalysesResultTypeDef,
    DescribeNetworkInsightsPathsRequestDescribeNetworkInsightsPathsPaginateTypeDef,
    DescribeNetworkInsightsPathsRequestRequestTypeDef,
    DescribeNetworkInsightsPathsResultTypeDef,
    DescribeNetworkInterfaceAttributeRequestNetworkInterfaceDescribeAttributeTypeDef,
    DescribeNetworkInterfaceAttributeRequestRequestTypeDef,
    DescribeNetworkInterfaceAttributeResultTypeDef,
    DescribeNetworkInterfacePermissionsRequestDescribeNetworkInterfacePermissionsPaginateTypeDef,
    DescribeNetworkInterfacePermissionsRequestRequestTypeDef,
    DescribeNetworkInterfacePermissionsResultTypeDef,
    DescribeNetworkInterfacesRequestDescribeNetworkInterfacesPaginateTypeDef,
    DescribeNetworkInterfacesRequestNetworkInterfaceAvailableWaitTypeDef,
    DescribeNetworkInterfacesRequestRequestTypeDef,
    DescribeNetworkInterfacesResultTypeDef,
    DescribePlacementGroupsRequestRequestTypeDef,
    DescribePlacementGroupsResultTypeDef,
    DescribePrefixListsRequestDescribePrefixListsPaginateTypeDef,
    DescribePrefixListsRequestRequestTypeDef,
    DescribePrefixListsResultTypeDef,
    DescribePrincipalIdFormatRequestDescribePrincipalIdFormatPaginateTypeDef,
    DescribePrincipalIdFormatRequestRequestTypeDef,
    DescribePrincipalIdFormatResultTypeDef,
    DescribePublicIpv4PoolsRequestDescribePublicIpv4PoolsPaginateTypeDef,
    DescribePublicIpv4PoolsRequestRequestTypeDef,
    DescribePublicIpv4PoolsResultTypeDef,
    DescribeRegionsRequestRequestTypeDef,
    DescribeRegionsResultTypeDef,
    DescribeReplaceRootVolumeTasksRequestDescribeReplaceRootVolumeTasksPaginateTypeDef,
    DescribeReplaceRootVolumeTasksRequestRequestTypeDef,
    DescribeReplaceRootVolumeTasksResultTypeDef,
    DescribeReservedInstancesListingsRequestRequestTypeDef,
    DescribeReservedInstancesListingsResultTypeDef,
    DescribeReservedInstancesModificationsRequestDescribeReservedInstancesModificationsPaginateTypeDef,
    DescribeReservedInstancesModificationsRequestRequestTypeDef,
    DescribeReservedInstancesModificationsResultTypeDef,
    DescribeReservedInstancesOfferingsRequestDescribeReservedInstancesOfferingsPaginateTypeDef,
    DescribeReservedInstancesOfferingsRequestRequestTypeDef,
    DescribeReservedInstancesOfferingsResultTypeDef,
    DescribeReservedInstancesRequestRequestTypeDef,
    DescribeReservedInstancesResultTypeDef,
    DescribeRouteTablesRequestDescribeRouteTablesPaginateTypeDef,
    DescribeRouteTablesRequestRequestTypeDef,
    DescribeRouteTablesResultTypeDef,
    DescribeScheduledInstanceAvailabilityRequestDescribeScheduledInstanceAvailabilityPaginateTypeDef,
    DescribeScheduledInstanceAvailabilityRequestRequestTypeDef,
    DescribeScheduledInstanceAvailabilityResultTypeDef,
    DescribeScheduledInstancesRequestDescribeScheduledInstancesPaginateTypeDef,
    DescribeScheduledInstancesRequestRequestTypeDef,
    DescribeScheduledInstancesResultTypeDef,
    DescribeSecurityGroupReferencesRequestRequestTypeDef,
    DescribeSecurityGroupReferencesResultTypeDef,
    DescribeSecurityGroupRulesRequestDescribeSecurityGroupRulesPaginateTypeDef,
    DescribeSecurityGroupRulesRequestRequestTypeDef,
    DescribeSecurityGroupRulesResultTypeDef,
    DescribeSecurityGroupsRequestDescribeSecurityGroupsPaginateTypeDef,
    DescribeSecurityGroupsRequestRequestTypeDef,
    DescribeSecurityGroupsRequestSecurityGroupExistsWaitTypeDef,
    DescribeSecurityGroupsResultTypeDef,
    DescribeSnapshotAttributeRequestRequestTypeDef,
    DescribeSnapshotAttributeRequestSnapshotDescribeAttributeTypeDef,
    DescribeSnapshotAttributeResultTypeDef,
    DescribeSnapshotTierStatusRequestDescribeSnapshotTierStatusPaginateTypeDef,
    DescribeSnapshotTierStatusRequestRequestTypeDef,
    DescribeSnapshotTierStatusResultTypeDef,
    DescribeSnapshotsRequestDescribeSnapshotsPaginateTypeDef,
    DescribeSnapshotsRequestRequestTypeDef,
    DescribeSnapshotsRequestSnapshotCompletedWaitTypeDef,
    DescribeSnapshotsResultTypeDef,
    DescribeSpotDatafeedSubscriptionRequestRequestTypeDef,
    DescribeSpotDatafeedSubscriptionResultTypeDef,
    DescribeSpotFleetInstancesRequestDescribeSpotFleetInstancesPaginateTypeDef,
    DescribeSpotFleetInstancesRequestRequestTypeDef,
    DescribeSpotFleetInstancesResponseTypeDef,
    DescribeSpotFleetRequestHistoryRequestRequestTypeDef,
    DescribeSpotFleetRequestHistoryResponseTypeDef,
    DescribeSpotFleetRequestsRequestDescribeSpotFleetRequestsPaginateTypeDef,
    DescribeSpotFleetRequestsRequestRequestTypeDef,
    DescribeSpotFleetRequestsResponseTypeDef,
    DescribeSpotInstanceRequestsRequestDescribeSpotInstanceRequestsPaginateTypeDef,
    DescribeSpotInstanceRequestsRequestRequestTypeDef,
    DescribeSpotInstanceRequestsRequestSpotInstanceRequestFulfilledWaitTypeDef,
    DescribeSpotInstanceRequestsResultTypeDef,
    DescribeSpotPriceHistoryRequestDescribeSpotPriceHistoryPaginateTypeDef,
    DescribeSpotPriceHistoryRequestRequestTypeDef,
    DescribeSpotPriceHistoryResultTypeDef,
    DescribeStaleSecurityGroupsRequestDescribeStaleSecurityGroupsPaginateTypeDef,
    DescribeStaleSecurityGroupsRequestRequestTypeDef,
    DescribeStaleSecurityGroupsResultTypeDef,
    DescribeStoreImageTasksRequestDescribeStoreImageTasksPaginateTypeDef,
    DescribeStoreImageTasksRequestRequestTypeDef,
    DescribeStoreImageTasksResultTypeDef,
    DescribeSubnetsRequestDescribeSubnetsPaginateTypeDef,
    DescribeSubnetsRequestRequestTypeDef,
    DescribeSubnetsRequestSubnetAvailableWaitTypeDef,
    DescribeSubnetsResultTypeDef,
    DescribeTagsRequestDescribeTagsPaginateTypeDef,
    DescribeTagsRequestRequestTypeDef,
    DescribeTagsResultTypeDef,
    DescribeTrafficMirrorFiltersRequestDescribeTrafficMirrorFiltersPaginateTypeDef,
    DescribeTrafficMirrorFiltersRequestRequestTypeDef,
    DescribeTrafficMirrorFiltersResultTypeDef,
    DescribeTrafficMirrorSessionsRequestDescribeTrafficMirrorSessionsPaginateTypeDef,
    DescribeTrafficMirrorSessionsRequestRequestTypeDef,
    DescribeTrafficMirrorSessionsResultTypeDef,
    DescribeTrafficMirrorTargetsRequestDescribeTrafficMirrorTargetsPaginateTypeDef,
    DescribeTrafficMirrorTargetsRequestRequestTypeDef,
    DescribeTrafficMirrorTargetsResultTypeDef,
    DescribeTransitGatewayAttachmentsRequestDescribeTransitGatewayAttachmentsPaginateTypeDef,
    DescribeTransitGatewayAttachmentsRequestRequestTypeDef,
    DescribeTransitGatewayAttachmentsResultTypeDef,
    DescribeTransitGatewayConnectPeersRequestDescribeTransitGatewayConnectPeersPaginateTypeDef,
    DescribeTransitGatewayConnectPeersRequestRequestTypeDef,
    DescribeTransitGatewayConnectPeersResultTypeDef,
    DescribeTransitGatewayConnectsRequestDescribeTransitGatewayConnectsPaginateTypeDef,
    DescribeTransitGatewayConnectsRequestRequestTypeDef,
    DescribeTransitGatewayConnectsResultTypeDef,
    DescribeTransitGatewayMulticastDomainsRequestDescribeTransitGatewayMulticastDomainsPaginateTypeDef,
    DescribeTransitGatewayMulticastDomainsRequestRequestTypeDef,
    DescribeTransitGatewayMulticastDomainsResultTypeDef,
    DescribeTransitGatewayPeeringAttachmentsRequestDescribeTransitGatewayPeeringAttachmentsPaginateTypeDef,
    DescribeTransitGatewayPeeringAttachmentsRequestRequestTypeDef,
    DescribeTransitGatewayPeeringAttachmentsResultTypeDef,
    DescribeTransitGatewayRouteTablesRequestDescribeTransitGatewayRouteTablesPaginateTypeDef,
    DescribeTransitGatewayRouteTablesRequestRequestTypeDef,
    DescribeTransitGatewayRouteTablesResultTypeDef,
    DescribeTransitGatewayVpcAttachmentsRequestDescribeTransitGatewayVpcAttachmentsPaginateTypeDef,
    DescribeTransitGatewayVpcAttachmentsRequestRequestTypeDef,
    DescribeTransitGatewayVpcAttachmentsResultTypeDef,
    DescribeTransitGatewaysRequestDescribeTransitGatewaysPaginateTypeDef,
    DescribeTransitGatewaysRequestRequestTypeDef,
    DescribeTransitGatewaysResultTypeDef,
    DescribeTrunkInterfaceAssociationsRequestDescribeTrunkInterfaceAssociationsPaginateTypeDef,
    DescribeTrunkInterfaceAssociationsRequestRequestTypeDef,
    DescribeTrunkInterfaceAssociationsResultTypeDef,
    DescribeVolumeAttributeRequestRequestTypeDef,
    DescribeVolumeAttributeRequestVolumeDescribeAttributeTypeDef,
    DescribeVolumeAttributeResultTypeDef,
    DescribeVolumeStatusRequestDescribeVolumeStatusPaginateTypeDef,
    DescribeVolumeStatusRequestRequestTypeDef,
    DescribeVolumeStatusRequestVolumeDescribeStatusTypeDef,
    DescribeVolumeStatusResultTypeDef,
    DescribeVolumesModificationsRequestDescribeVolumesModificationsPaginateTypeDef,
    DescribeVolumesModificationsRequestRequestTypeDef,
    DescribeVolumesModificationsResultTypeDef,
    DescribeVolumesRequestDescribeVolumesPaginateTypeDef,
    DescribeVolumesRequestRequestTypeDef,
    DescribeVolumesRequestVolumeAvailableWaitTypeDef,
    DescribeVolumesRequestVolumeDeletedWaitTypeDef,
    DescribeVolumesRequestVolumeInUseWaitTypeDef,
    DescribeVolumesResultTypeDef,
    DescribeVpcAttributeRequestRequestTypeDef,
    DescribeVpcAttributeRequestVpcDescribeAttributeTypeDef,
    DescribeVpcAttributeResultTypeDef,
    DescribeVpcClassicLinkDnsSupportRequestDescribeVpcClassicLinkDnsSupportPaginateTypeDef,
    DescribeVpcClassicLinkDnsSupportRequestRequestTypeDef,
    DescribeVpcClassicLinkDnsSupportResultTypeDef,
    DescribeVpcClassicLinkRequestRequestTypeDef,
    DescribeVpcClassicLinkResultTypeDef,
    DescribeVpcEndpointConnectionNotificationsRequestDescribeVpcEndpointConnectionNotificationsPaginateTypeDef,
    DescribeVpcEndpointConnectionNotificationsRequestRequestTypeDef,
    DescribeVpcEndpointConnectionNotificationsResultTypeDef,
    DescribeVpcEndpointConnectionsRequestDescribeVpcEndpointConnectionsPaginateTypeDef,
    DescribeVpcEndpointConnectionsRequestRequestTypeDef,
    DescribeVpcEndpointConnectionsResultTypeDef,
    DescribeVpcEndpointServiceConfigurationsRequestDescribeVpcEndpointServiceConfigurationsPaginateTypeDef,
    DescribeVpcEndpointServiceConfigurationsRequestRequestTypeDef,
    DescribeVpcEndpointServiceConfigurationsResultTypeDef,
    DescribeVpcEndpointServicePermissionsRequestDescribeVpcEndpointServicePermissionsPaginateTypeDef,
    DescribeVpcEndpointServicePermissionsRequestRequestTypeDef,
    DescribeVpcEndpointServicePermissionsResultTypeDef,
    DescribeVpcEndpointServicesRequestDescribeVpcEndpointServicesPaginateTypeDef,
    DescribeVpcEndpointServicesRequestRequestTypeDef,
    DescribeVpcEndpointServicesResultTypeDef,
    DescribeVpcEndpointsRequestDescribeVpcEndpointsPaginateTypeDef,
    DescribeVpcEndpointsRequestRequestTypeDef,
    DescribeVpcEndpointsResultTypeDef,
    DescribeVpcPeeringConnectionsRequestDescribeVpcPeeringConnectionsPaginateTypeDef,
    DescribeVpcPeeringConnectionsRequestRequestTypeDef,
    DescribeVpcPeeringConnectionsRequestVpcPeeringConnectionDeletedWaitTypeDef,
    DescribeVpcPeeringConnectionsRequestVpcPeeringConnectionExistsWaitTypeDef,
    DescribeVpcPeeringConnectionsResultTypeDef,
    DescribeVpcsRequestDescribeVpcsPaginateTypeDef,
    DescribeVpcsRequestRequestTypeDef,
    DescribeVpcsRequestVpcAvailableWaitTypeDef,
    DescribeVpcsRequestVpcExistsWaitTypeDef,
    DescribeVpcsResultTypeDef,
    DescribeVpnConnectionsRequestRequestTypeDef,
    DescribeVpnConnectionsRequestVpnConnectionAvailableWaitTypeDef,
    DescribeVpnConnectionsRequestVpnConnectionDeletedWaitTypeDef,
    DescribeVpnConnectionsResultTypeDef,
    DescribeVpnGatewaysRequestRequestTypeDef,
    DescribeVpnGatewaysResultTypeDef,
    DestinationOptionsRequestTypeDef,
    DestinationOptionsResponseTypeDef,
    DetachClassicLinkVpcRequestInstanceDetachClassicLinkVpcTypeDef,
    DetachClassicLinkVpcRequestRequestTypeDef,
    DetachClassicLinkVpcRequestVpcDetachClassicLinkInstanceTypeDef,
    DetachClassicLinkVpcResultTypeDef,
    DetachInternetGatewayRequestInternetGatewayDetachFromVpcTypeDef,
    DetachInternetGatewayRequestRequestTypeDef,
    DetachInternetGatewayRequestVpcDetachInternetGatewayTypeDef,
    DetachNetworkInterfaceRequestNetworkInterfaceDetachTypeDef,
    DetachNetworkInterfaceRequestRequestTypeDef,
    DetachVolumeRequestInstanceDetachVolumeTypeDef,
    DetachVolumeRequestRequestTypeDef,
    DetachVolumeRequestVolumeDetachFromInstanceTypeDef,
    DetachVpnGatewayRequestRequestTypeDef,
    DhcpConfigurationTypeDef,
    DhcpOptionsTypeDef,
    DirectoryServiceAuthenticationRequestTypeDef,
    DirectoryServiceAuthenticationTypeDef,
    DisableEbsEncryptionByDefaultRequestRequestTypeDef,
    DisableEbsEncryptionByDefaultResultTypeDef,
    DisableFastLaunchRequestRequestTypeDef,
    DisableFastLaunchResultTypeDef,
    DisableFastSnapshotRestoreErrorItemTypeDef,
    DisableFastSnapshotRestoreStateErrorItemTypeDef,
    DisableFastSnapshotRestoreStateErrorTypeDef,
    DisableFastSnapshotRestoreSuccessItemTypeDef,
    DisableFastSnapshotRestoresRequestRequestTypeDef,
    DisableFastSnapshotRestoresResultTypeDef,
    DisableImageDeprecationRequestRequestTypeDef,
    DisableImageDeprecationResultTypeDef,
    DisableIpamOrganizationAdminAccountRequestRequestTypeDef,
    DisableIpamOrganizationAdminAccountResultTypeDef,
    DisableSerialConsoleAccessRequestRequestTypeDef,
    DisableSerialConsoleAccessResultTypeDef,
    DisableTransitGatewayRouteTablePropagationRequestRequestTypeDef,
    DisableTransitGatewayRouteTablePropagationResultTypeDef,
    DisableVgwRoutePropagationRequestRequestTypeDef,
    DisableVpcClassicLinkDnsSupportRequestRequestTypeDef,
    DisableVpcClassicLinkDnsSupportResultTypeDef,
    DisableVpcClassicLinkRequestRequestTypeDef,
    DisableVpcClassicLinkRequestVpcDisableClassicLinkTypeDef,
    DisableVpcClassicLinkResultTypeDef,
    DisassociateAddressRequestClassicAddressDisassociateTypeDef,
    DisassociateAddressRequestNetworkInterfaceAssociationDeleteTypeDef,
    DisassociateAddressRequestRequestTypeDef,
    DisassociateClientVpnTargetNetworkRequestRequestTypeDef,
    DisassociateClientVpnTargetNetworkResultTypeDef,
    DisassociateEnclaveCertificateIamRoleRequestRequestTypeDef,
    DisassociateEnclaveCertificateIamRoleResultTypeDef,
    DisassociateIamInstanceProfileRequestRequestTypeDef,
    DisassociateIamInstanceProfileResultTypeDef,
    DisassociateInstanceEventWindowRequestRequestTypeDef,
    DisassociateInstanceEventWindowResultTypeDef,
    DisassociateRouteTableRequestRequestTypeDef,
    DisassociateRouteTableRequestRouteTableAssociationDeleteTypeDef,
    DisassociateRouteTableRequestServiceResourceDisassociateRouteTableTypeDef,
    DisassociateSubnetCidrBlockRequestRequestTypeDef,
    DisassociateSubnetCidrBlockResultTypeDef,
    DisassociateTransitGatewayMulticastDomainRequestRequestTypeDef,
    DisassociateTransitGatewayMulticastDomainResultTypeDef,
    DisassociateTransitGatewayRouteTableRequestRequestTypeDef,
    DisassociateTransitGatewayRouteTableResultTypeDef,
    DisassociateTrunkInterfaceRequestRequestTypeDef,
    DisassociateTrunkInterfaceResultTypeDef,
    DisassociateVpcCidrBlockRequestRequestTypeDef,
    DisassociateVpcCidrBlockResultTypeDef,
    DiskImageDescriptionTypeDef,
    DiskImageDetailTypeDef,
    DiskImageTypeDef,
    DiskImageVolumeDescriptionTypeDef,
    DiskInfoTypeDef,
    DnsEntryTypeDef,
    DnsServersOptionsModifyStructureTypeDef,
    EbsBlockDeviceTypeDef,
    EbsInfoTypeDef,
    EbsInstanceBlockDeviceSpecificationTypeDef,
    EbsInstanceBlockDeviceTypeDef,
    EbsOptimizedInfoTypeDef,
    EfaInfoTypeDef,
    EgressOnlyInternetGatewayTypeDef,
    ElasticGpuAssociationTypeDef,
    ElasticGpuHealthTypeDef,
    ElasticGpuSpecificationResponseTypeDef,
    ElasticGpuSpecificationTypeDef,
    ElasticGpusTypeDef,
    ElasticInferenceAcceleratorAssociationTypeDef,
    ElasticInferenceAcceleratorTypeDef,
    EnableEbsEncryptionByDefaultRequestRequestTypeDef,
    EnableEbsEncryptionByDefaultResultTypeDef,
    EnableFastLaunchRequestRequestTypeDef,
    EnableFastLaunchResultTypeDef,
    EnableFastSnapshotRestoreErrorItemTypeDef,
    EnableFastSnapshotRestoreStateErrorItemTypeDef,
    EnableFastSnapshotRestoreStateErrorTypeDef,
    EnableFastSnapshotRestoreSuccessItemTypeDef,
    EnableFastSnapshotRestoresRequestRequestTypeDef,
    EnableFastSnapshotRestoresResultTypeDef,
    EnableImageDeprecationRequestRequestTypeDef,
    EnableImageDeprecationResultTypeDef,
    EnableIpamOrganizationAdminAccountRequestRequestTypeDef,
    EnableIpamOrganizationAdminAccountResultTypeDef,
    EnableSerialConsoleAccessRequestRequestTypeDef,
    EnableSerialConsoleAccessResultTypeDef,
    EnableTransitGatewayRouteTablePropagationRequestRequestTypeDef,
    EnableTransitGatewayRouteTablePropagationResultTypeDef,
    EnableVgwRoutePropagationRequestRequestTypeDef,
    EnableVolumeIORequestRequestTypeDef,
    EnableVolumeIORequestVolumeEnableIoTypeDef,
    EnableVpcClassicLinkDnsSupportRequestRequestTypeDef,
    EnableVpcClassicLinkDnsSupportResultTypeDef,
    EnableVpcClassicLinkRequestRequestTypeDef,
    EnableVpcClassicLinkRequestVpcEnableClassicLinkTypeDef,
    EnableVpcClassicLinkResultTypeDef,
    EnclaveOptionsRequestTypeDef,
    EnclaveOptionsResponseMetadataTypeDef,
    EnclaveOptionsTypeDef,
    EventInformationTypeDef,
    ExplanationTypeDef,
    ExportClientVpnClientCertificateRevocationListRequestRequestTypeDef,
    ExportClientVpnClientCertificateRevocationListResultTypeDef,
    ExportClientVpnClientConfigurationRequestRequestTypeDef,
    ExportClientVpnClientConfigurationResultTypeDef,
    ExportImageRequestRequestTypeDef,
    ExportImageResultTypeDef,
    ExportImageTaskTypeDef,
    ExportTaskS3LocationRequestTypeDef,
    ExportTaskS3LocationTypeDef,
    ExportTaskTypeDef,
    ExportToS3TaskSpecificationTypeDef,
    ExportToS3TaskTypeDef,
    ExportTransitGatewayRoutesRequestRequestTypeDef,
    ExportTransitGatewayRoutesResultTypeDef,
    FailedCapacityReservationFleetCancellationResultTypeDef,
    FailedQueuedPurchaseDeletionTypeDef,
    FastLaunchLaunchTemplateSpecificationRequestTypeDef,
    FastLaunchLaunchTemplateSpecificationResponseTypeDef,
    FastLaunchSnapshotConfigurationRequestTypeDef,
    FastLaunchSnapshotConfigurationResponseTypeDef,
    FederatedAuthenticationRequestTypeDef,
    FederatedAuthenticationTypeDef,
    FilterTypeDef,
    FleetCapacityReservationTypeDef,
    FleetDataTypeDef,
    FleetLaunchTemplateConfigRequestTypeDef,
    FleetLaunchTemplateConfigTypeDef,
    FleetLaunchTemplateOverridesRequestTypeDef,
    FleetLaunchTemplateOverridesTypeDef,
    FleetLaunchTemplateSpecificationRequestTypeDef,
    FleetLaunchTemplateSpecificationTypeDef,
    FleetSpotCapacityRebalanceRequestTypeDef,
    FleetSpotCapacityRebalanceTypeDef,
    FleetSpotMaintenanceStrategiesRequestTypeDef,
    FleetSpotMaintenanceStrategiesTypeDef,
    FlowLogTypeDef,
    FpgaDeviceInfoTypeDef,
    FpgaDeviceMemoryInfoTypeDef,
    FpgaImageAttributeTypeDef,
    FpgaImageStateTypeDef,
    FpgaImageTypeDef,
    FpgaInfoTypeDef,
    GetAssociatedEnclaveCertificateIamRolesRequestRequestTypeDef,
    GetAssociatedEnclaveCertificateIamRolesResultTypeDef,
    GetAssociatedIpv6PoolCidrsRequestGetAssociatedIpv6PoolCidrsPaginateTypeDef,
    GetAssociatedIpv6PoolCidrsRequestRequestTypeDef,
    GetAssociatedIpv6PoolCidrsResultTypeDef,
    GetCapacityReservationUsageRequestRequestTypeDef,
    GetCapacityReservationUsageResultTypeDef,
    GetCoipPoolUsageRequestRequestTypeDef,
    GetCoipPoolUsageResultTypeDef,
    GetConsoleOutputRequestInstanceConsoleOutputTypeDef,
    GetConsoleOutputRequestRequestTypeDef,
    GetConsoleOutputResultTypeDef,
    GetConsoleScreenshotRequestRequestTypeDef,
    GetConsoleScreenshotResultTypeDef,
    GetDefaultCreditSpecificationRequestRequestTypeDef,
    GetDefaultCreditSpecificationResultTypeDef,
    GetEbsDefaultKmsKeyIdRequestRequestTypeDef,
    GetEbsDefaultKmsKeyIdResultTypeDef,
    GetEbsEncryptionByDefaultRequestRequestTypeDef,
    GetEbsEncryptionByDefaultResultTypeDef,
    GetFlowLogsIntegrationTemplateRequestRequestTypeDef,
    GetFlowLogsIntegrationTemplateResultTypeDef,
    GetGroupsForCapacityReservationRequestGetGroupsForCapacityReservationPaginateTypeDef,
    GetGroupsForCapacityReservationRequestRequestTypeDef,
    GetGroupsForCapacityReservationResultTypeDef,
    GetHostReservationPurchasePreviewRequestRequestTypeDef,
    GetHostReservationPurchasePreviewResultTypeDef,
    GetInstanceTypesFromInstanceRequirementsRequestGetInstanceTypesFromInstanceRequirementsPaginateTypeDef,
    GetInstanceTypesFromInstanceRequirementsRequestRequestTypeDef,
    GetInstanceTypesFromInstanceRequirementsResultTypeDef,
    GetIpamAddressHistoryRequestGetIpamAddressHistoryPaginateTypeDef,
    GetIpamAddressHistoryRequestRequestTypeDef,
    GetIpamAddressHistoryResultTypeDef,
    GetIpamPoolAllocationsRequestGetIpamPoolAllocationsPaginateTypeDef,
    GetIpamPoolAllocationsRequestRequestTypeDef,
    GetIpamPoolAllocationsResultTypeDef,
    GetIpamPoolCidrsRequestGetIpamPoolCidrsPaginateTypeDef,
    GetIpamPoolCidrsRequestRequestTypeDef,
    GetIpamPoolCidrsResultTypeDef,
    GetIpamResourceCidrsRequestGetIpamResourceCidrsPaginateTypeDef,
    GetIpamResourceCidrsRequestRequestTypeDef,
    GetIpamResourceCidrsResultTypeDef,
    GetLaunchTemplateDataRequestRequestTypeDef,
    GetLaunchTemplateDataResultTypeDef,
    GetManagedPrefixListAssociationsRequestGetManagedPrefixListAssociationsPaginateTypeDef,
    GetManagedPrefixListAssociationsRequestRequestTypeDef,
    GetManagedPrefixListAssociationsResultTypeDef,
    GetManagedPrefixListEntriesRequestGetManagedPrefixListEntriesPaginateTypeDef,
    GetManagedPrefixListEntriesRequestRequestTypeDef,
    GetManagedPrefixListEntriesResultTypeDef,
    GetNetworkInsightsAccessScopeAnalysisFindingsRequestRequestTypeDef,
    GetNetworkInsightsAccessScopeAnalysisFindingsResultTypeDef,
    GetNetworkInsightsAccessScopeContentRequestRequestTypeDef,
    GetNetworkInsightsAccessScopeContentResultTypeDef,
    GetPasswordDataRequestInstancePasswordDataTypeDef,
    GetPasswordDataRequestPasswordDataAvailableWaitTypeDef,
    GetPasswordDataRequestRequestTypeDef,
    GetPasswordDataResultTypeDef,
    GetReservedInstancesExchangeQuoteRequestRequestTypeDef,
    GetReservedInstancesExchangeQuoteResultTypeDef,
    GetSerialConsoleAccessStatusRequestRequestTypeDef,
    GetSerialConsoleAccessStatusResultTypeDef,
    GetSpotPlacementScoresRequestGetSpotPlacementScoresPaginateTypeDef,
    GetSpotPlacementScoresRequestRequestTypeDef,
    GetSpotPlacementScoresResultTypeDef,
    GetSubnetCidrReservationsRequestRequestTypeDef,
    GetSubnetCidrReservationsResultTypeDef,
    GetTransitGatewayAttachmentPropagationsRequestGetTransitGatewayAttachmentPropagationsPaginateTypeDef,
    GetTransitGatewayAttachmentPropagationsRequestRequestTypeDef,
    GetTransitGatewayAttachmentPropagationsResultTypeDef,
    GetTransitGatewayMulticastDomainAssociationsRequestGetTransitGatewayMulticastDomainAssociationsPaginateTypeDef,
    GetTransitGatewayMulticastDomainAssociationsRequestRequestTypeDef,
    GetTransitGatewayMulticastDomainAssociationsResultTypeDef,
    GetTransitGatewayPrefixListReferencesRequestGetTransitGatewayPrefixListReferencesPaginateTypeDef,
    GetTransitGatewayPrefixListReferencesRequestRequestTypeDef,
    GetTransitGatewayPrefixListReferencesResultTypeDef,
    GetTransitGatewayRouteTableAssociationsRequestGetTransitGatewayRouteTableAssociationsPaginateTypeDef,
    GetTransitGatewayRouteTableAssociationsRequestRequestTypeDef,
    GetTransitGatewayRouteTableAssociationsResultTypeDef,
    GetTransitGatewayRouteTablePropagationsRequestGetTransitGatewayRouteTablePropagationsPaginateTypeDef,
    GetTransitGatewayRouteTablePropagationsRequestRequestTypeDef,
    GetTransitGatewayRouteTablePropagationsResultTypeDef,
    GetVpnConnectionDeviceSampleConfigurationRequestRequestTypeDef,
    GetVpnConnectionDeviceSampleConfigurationResultTypeDef,
    GetVpnConnectionDeviceTypesRequestGetVpnConnectionDeviceTypesPaginateTypeDef,
    GetVpnConnectionDeviceTypesRequestRequestTypeDef,
    GetVpnConnectionDeviceTypesResultTypeDef,
    GpuDeviceInfoTypeDef,
    GpuDeviceMemoryInfoTypeDef,
    GpuInfoTypeDef,
    GroupIdentifierTypeDef,
    HibernationOptionsRequestTypeDef,
    HibernationOptionsResponseMetadataTypeDef,
    HibernationOptionsTypeDef,
    HistoryRecordEntryTypeDef,
    HistoryRecordTypeDef,
    HostInstanceTypeDef,
    HostOfferingTypeDef,
    HostPropertiesTypeDef,
    HostReservationTypeDef,
    HostTypeDef,
    IKEVersionsListValueTypeDef,
    IKEVersionsRequestListValueTypeDef,
    IamInstanceProfileAssociationTypeDef,
    IamInstanceProfileResponseMetadataTypeDef,
    IamInstanceProfileSpecificationTypeDef,
    IamInstanceProfileTypeDef,
    IcmpTypeCodeTypeDef,
    IdFormatTypeDef,
    ImageAttributeTypeDef,
    ImageDiskContainerTypeDef,
    ImageRecycleBinInfoTypeDef,
    ImageTypeDef,
    ImportClientVpnClientCertificateRevocationListRequestRequestTypeDef,
    ImportClientVpnClientCertificateRevocationListResultTypeDef,
    ImportImageLicenseConfigurationRequestTypeDef,
    ImportImageLicenseConfigurationResponseTypeDef,
    ImportImageRequestRequestTypeDef,
    ImportImageResultTypeDef,
    ImportImageTaskTypeDef,
    ImportInstanceLaunchSpecificationTypeDef,
    ImportInstanceRequestRequestTypeDef,
    ImportInstanceResultTypeDef,
    ImportInstanceTaskDetailsTypeDef,
    ImportInstanceVolumeDetailItemTypeDef,
    ImportKeyPairRequestRequestTypeDef,
    ImportKeyPairRequestServiceResourceImportKeyPairTypeDef,
    ImportKeyPairResultTypeDef,
    ImportSnapshotRequestRequestTypeDef,
    ImportSnapshotResultTypeDef,
    ImportSnapshotTaskTypeDef,
    ImportVolumeRequestRequestTypeDef,
    ImportVolumeResultTypeDef,
    ImportVolumeTaskDetailsTypeDef,
    InferenceAcceleratorInfoTypeDef,
    InferenceDeviceInfoTypeDef,
    InstanceAttributeTypeDef,
    InstanceBlockDeviceMappingSpecificationTypeDef,
    InstanceBlockDeviceMappingTypeDef,
    InstanceCapacityTypeDef,
    InstanceCountTypeDef,
    InstanceCreditSpecificationRequestTypeDef,
    InstanceCreditSpecificationTypeDef,
    InstanceDeleteTagsRequestTypeDef,
    InstanceEventWindowAssociationRequestTypeDef,
    InstanceEventWindowAssociationTargetTypeDef,
    InstanceEventWindowDisassociationRequestTypeDef,
    InstanceEventWindowStateChangeTypeDef,
    InstanceEventWindowTimeRangeRequestTypeDef,
    InstanceEventWindowTimeRangeTypeDef,
    InstanceEventWindowTypeDef,
    InstanceExportDetailsTypeDef,
    InstanceFamilyCreditSpecificationTypeDef,
    InstanceIpv4PrefixTypeDef,
    InstanceIpv6AddressRequestTypeDef,
    InstanceIpv6AddressTypeDef,
    InstanceIpv6PrefixTypeDef,
    InstanceMaintenanceOptionsRequestTypeDef,
    InstanceMaintenanceOptionsResponseMetadataTypeDef,
    InstanceMaintenanceOptionsTypeDef,
    InstanceMarketOptionsRequestTypeDef,
    InstanceMetadataOptionsRequestTypeDef,
    InstanceMetadataOptionsResponseResponseMetadataTypeDef,
    InstanceMetadataOptionsResponseTypeDef,
    InstanceMonitoringTypeDef,
    InstanceNetworkInterfaceAssociationTypeDef,
    InstanceNetworkInterfaceAttachmentTypeDef,
    InstanceNetworkInterfaceSpecificationTypeDef,
    InstanceNetworkInterfaceTypeDef,
    InstancePrivateIpAddressTypeDef,
    InstanceRequirementsRequestTypeDef,
    InstanceRequirementsTypeDef,
    InstanceRequirementsWithMetadataRequestTypeDef,
    InstanceSpecificationTypeDef,
    InstanceStateChangeTypeDef,
    InstanceStateResponseMetadataTypeDef,
    InstanceStateTypeDef,
    InstanceStatusDetailsTypeDef,
    InstanceStatusEventTypeDef,
    InstanceStatusSummaryTypeDef,
    InstanceStatusTypeDef,
    InstanceStorageInfoTypeDef,
    InstanceTagNotificationAttributeTypeDef,
    InstanceTypeDef,
    InstanceTypeInfoFromInstanceRequirementsTypeDef,
    InstanceTypeInfoTypeDef,
    InstanceTypeOfferingTypeDef,
    InstanceUsageTypeDef,
    IntegrateServicesTypeDef,
    InternetGatewayAttachmentTypeDef,
    InternetGatewayTypeDef,
    IpPermissionTypeDef,
    IpRangeTypeDef,
    IpamAddressHistoryRecordTypeDef,
    IpamCidrAuthorizationContextTypeDef,
    IpamOperatingRegionTypeDef,
    IpamPoolAllocationTypeDef,
    IpamPoolCidrFailureReasonTypeDef,
    IpamPoolCidrTypeDef,
    IpamPoolTypeDef,
    IpamResourceCidrTypeDef,
    IpamResourceTagTypeDef,
    IpamScopeTypeDef,
    IpamTypeDef,
    Ipv4PrefixSpecificationRequestTypeDef,
    Ipv4PrefixSpecificationResponseTypeDef,
    Ipv4PrefixSpecificationTypeDef,
    Ipv6CidrAssociationTypeDef,
    Ipv6CidrBlockTypeDef,
    Ipv6PoolTypeDef,
    Ipv6PrefixSpecificationRequestTypeDef,
    Ipv6PrefixSpecificationResponseTypeDef,
    Ipv6PrefixSpecificationTypeDef,
    Ipv6RangeTypeDef,
    KeyPairInfoTypeDef,
    KeyPairTypeDef,
    LastErrorTypeDef,
    LaunchPermissionModificationsTypeDef,
    LaunchPermissionTypeDef,
    LaunchSpecificationTypeDef,
    LaunchTemplateAndOverridesResponseTypeDef,
    LaunchTemplateBlockDeviceMappingRequestTypeDef,
    LaunchTemplateBlockDeviceMappingTypeDef,
    LaunchTemplateCapacityReservationSpecificationRequestTypeDef,
    LaunchTemplateCapacityReservationSpecificationResponseTypeDef,
    LaunchTemplateConfigTypeDef,
    LaunchTemplateCpuOptionsRequestTypeDef,
    LaunchTemplateCpuOptionsTypeDef,
    LaunchTemplateEbsBlockDeviceRequestTypeDef,
    LaunchTemplateEbsBlockDeviceTypeDef,
    LaunchTemplateElasticInferenceAcceleratorResponseTypeDef,
    LaunchTemplateElasticInferenceAcceleratorTypeDef,
    LaunchTemplateEnclaveOptionsRequestTypeDef,
    LaunchTemplateEnclaveOptionsTypeDef,
    LaunchTemplateHibernationOptionsRequestTypeDef,
    LaunchTemplateHibernationOptionsTypeDef,
    LaunchTemplateIamInstanceProfileSpecificationRequestTypeDef,
    LaunchTemplateIamInstanceProfileSpecificationTypeDef,
    LaunchTemplateInstanceMaintenanceOptionsRequestTypeDef,
    LaunchTemplateInstanceMaintenanceOptionsTypeDef,
    LaunchTemplateInstanceMarketOptionsRequestTypeDef,
    LaunchTemplateInstanceMarketOptionsTypeDef,
    LaunchTemplateInstanceMetadataOptionsRequestTypeDef,
    LaunchTemplateInstanceMetadataOptionsTypeDef,
    LaunchTemplateInstanceNetworkInterfaceSpecificationRequestTypeDef,
    LaunchTemplateInstanceNetworkInterfaceSpecificationTypeDef,
    LaunchTemplateLicenseConfigurationRequestTypeDef,
    LaunchTemplateLicenseConfigurationTypeDef,
    LaunchTemplateOverridesTypeDef,
    LaunchTemplatePlacementRequestTypeDef,
    LaunchTemplatePlacementTypeDef,
    LaunchTemplatePrivateDnsNameOptionsRequestTypeDef,
    LaunchTemplatePrivateDnsNameOptionsTypeDef,
    LaunchTemplateSpecificationTypeDef,
    LaunchTemplateSpotMarketOptionsRequestTypeDef,
    LaunchTemplateSpotMarketOptionsTypeDef,
    LaunchTemplateTagSpecificationRequestTypeDef,
    LaunchTemplateTagSpecificationTypeDef,
    LaunchTemplateTypeDef,
    LaunchTemplateVersionTypeDef,
    LaunchTemplatesMonitoringRequestTypeDef,
    LaunchTemplatesMonitoringTypeDef,
    LicenseConfigurationRequestTypeDef,
    LicenseConfigurationTypeDef,
    ListImagesInRecycleBinRequestListImagesInRecycleBinPaginateTypeDef,
    ListImagesInRecycleBinRequestRequestTypeDef,
    ListImagesInRecycleBinResultTypeDef,
    ListSnapshotsInRecycleBinRequestListSnapshotsInRecycleBinPaginateTypeDef,
    ListSnapshotsInRecycleBinRequestRequestTypeDef,
    ListSnapshotsInRecycleBinResultTypeDef,
    LoadBalancersConfigTypeDef,
    LoadPermissionModificationsTypeDef,
    LoadPermissionRequestTypeDef,
    LoadPermissionTypeDef,
    LocalGatewayRouteTableTypeDef,
    LocalGatewayRouteTableVirtualInterfaceGroupAssociationTypeDef,
    LocalGatewayRouteTableVpcAssociationTypeDef,
    LocalGatewayRouteTypeDef,
    LocalGatewayTypeDef,
    LocalGatewayVirtualInterfaceGroupTypeDef,
    LocalGatewayVirtualInterfaceTypeDef,
    ManagedPrefixListTypeDef,
    MemoryGiBPerVCpuRequestTypeDef,
    MemoryGiBPerVCpuTypeDef,
    MemoryInfoTypeDef,
    MemoryMiBRequestTypeDef,
    MemoryMiBTypeDef,
    ModifyAddressAttributeRequestRequestTypeDef,
    ModifyAddressAttributeResultTypeDef,
    ModifyAvailabilityZoneGroupRequestRequestTypeDef,
    ModifyAvailabilityZoneGroupResultTypeDef,
    ModifyCapacityReservationFleetRequestRequestTypeDef,
    ModifyCapacityReservationFleetResultTypeDef,
    ModifyCapacityReservationRequestRequestTypeDef,
    ModifyCapacityReservationResultTypeDef,
    ModifyClientVpnEndpointRequestRequestTypeDef,
    ModifyClientVpnEndpointResultTypeDef,
    ModifyDefaultCreditSpecificationRequestRequestTypeDef,
    ModifyDefaultCreditSpecificationResultTypeDef,
    ModifyEbsDefaultKmsKeyIdRequestRequestTypeDef,
    ModifyEbsDefaultKmsKeyIdResultTypeDef,
    ModifyFleetRequestRequestTypeDef,
    ModifyFleetResultTypeDef,
    ModifyFpgaImageAttributeRequestRequestTypeDef,
    ModifyFpgaImageAttributeResultTypeDef,
    ModifyHostsRequestRequestTypeDef,
    ModifyHostsResultTypeDef,
    ModifyIdFormatRequestRequestTypeDef,
    ModifyIdentityIdFormatRequestRequestTypeDef,
    ModifyImageAttributeRequestImageModifyAttributeTypeDef,
    ModifyImageAttributeRequestRequestTypeDef,
    ModifyInstanceAttributeRequestInstanceModifyAttributeTypeDef,
    ModifyInstanceAttributeRequestRequestTypeDef,
    ModifyInstanceCapacityReservationAttributesRequestRequestTypeDef,
    ModifyInstanceCapacityReservationAttributesResultTypeDef,
    ModifyInstanceCreditSpecificationRequestRequestTypeDef,
    ModifyInstanceCreditSpecificationResultTypeDef,
    ModifyInstanceEventStartTimeRequestRequestTypeDef,
    ModifyInstanceEventStartTimeResultTypeDef,
    ModifyInstanceEventWindowRequestRequestTypeDef,
    ModifyInstanceEventWindowResultTypeDef,
    ModifyInstanceMaintenanceOptionsRequestRequestTypeDef,
    ModifyInstanceMaintenanceOptionsResultTypeDef,
    ModifyInstanceMetadataOptionsRequestRequestTypeDef,
    ModifyInstanceMetadataOptionsResultTypeDef,
    ModifyInstancePlacementRequestRequestTypeDef,
    ModifyInstancePlacementResultTypeDef,
    ModifyIpamPoolRequestRequestTypeDef,
    ModifyIpamPoolResultTypeDef,
    ModifyIpamRequestRequestTypeDef,
    ModifyIpamResourceCidrRequestRequestTypeDef,
    ModifyIpamResourceCidrResultTypeDef,
    ModifyIpamResultTypeDef,
    ModifyIpamScopeRequestRequestTypeDef,
    ModifyIpamScopeResultTypeDef,
    ModifyLaunchTemplateRequestRequestTypeDef,
    ModifyLaunchTemplateResultTypeDef,
    ModifyManagedPrefixListRequestRequestTypeDef,
    ModifyManagedPrefixListResultTypeDef,
    ModifyNetworkInterfaceAttributeRequestNetworkInterfaceModifyAttributeTypeDef,
    ModifyNetworkInterfaceAttributeRequestRequestTypeDef,
    ModifyPrivateDnsNameOptionsRequestRequestTypeDef,
    ModifyPrivateDnsNameOptionsResultTypeDef,
    ModifyReservedInstancesRequestRequestTypeDef,
    ModifyReservedInstancesResultTypeDef,
    ModifySecurityGroupRulesRequestRequestTypeDef,
    ModifySecurityGroupRulesResultTypeDef,
    ModifySnapshotAttributeRequestRequestTypeDef,
    ModifySnapshotAttributeRequestSnapshotModifyAttributeTypeDef,
    ModifySnapshotTierRequestRequestTypeDef,
    ModifySnapshotTierResultTypeDef,
    ModifySpotFleetRequestRequestRequestTypeDef,
    ModifySpotFleetRequestResponseTypeDef,
    ModifySubnetAttributeRequestRequestTypeDef,
    ModifyTrafficMirrorFilterNetworkServicesRequestRequestTypeDef,
    ModifyTrafficMirrorFilterNetworkServicesResultTypeDef,
    ModifyTrafficMirrorFilterRuleRequestRequestTypeDef,
    ModifyTrafficMirrorFilterRuleResultTypeDef,
    ModifyTrafficMirrorSessionRequestRequestTypeDef,
    ModifyTrafficMirrorSessionResultTypeDef,
    ModifyTransitGatewayOptionsTypeDef,
    ModifyTransitGatewayPrefixListReferenceRequestRequestTypeDef,
    ModifyTransitGatewayPrefixListReferenceResultTypeDef,
    ModifyTransitGatewayRequestRequestTypeDef,
    ModifyTransitGatewayResultTypeDef,
    ModifyTransitGatewayVpcAttachmentRequestOptionsTypeDef,
    ModifyTransitGatewayVpcAttachmentRequestRequestTypeDef,
    ModifyTransitGatewayVpcAttachmentResultTypeDef,
    ModifyVolumeAttributeRequestRequestTypeDef,
    ModifyVolumeAttributeRequestVolumeModifyAttributeTypeDef,
    ModifyVolumeRequestRequestTypeDef,
    ModifyVolumeResultTypeDef,
    ModifyVpcAttributeRequestRequestTypeDef,
    ModifyVpcAttributeRequestVpcModifyAttributeTypeDef,
    ModifyVpcEndpointConnectionNotificationRequestRequestTypeDef,
    ModifyVpcEndpointConnectionNotificationResultTypeDef,
    ModifyVpcEndpointRequestRequestTypeDef,
    ModifyVpcEndpointResultTypeDef,
    ModifyVpcEndpointServiceConfigurationRequestRequestTypeDef,
    ModifyVpcEndpointServiceConfigurationResultTypeDef,
    ModifyVpcEndpointServicePayerResponsibilityRequestRequestTypeDef,
    ModifyVpcEndpointServicePayerResponsibilityResultTypeDef,
    ModifyVpcEndpointServicePermissionsRequestRequestTypeDef,
    ModifyVpcEndpointServicePermissionsResultTypeDef,
    ModifyVpcPeeringConnectionOptionsRequestRequestTypeDef,
    ModifyVpcPeeringConnectionOptionsResultTypeDef,
    ModifyVpcTenancyRequestRequestTypeDef,
    ModifyVpcTenancyResultTypeDef,
    ModifyVpnConnectionOptionsRequestRequestTypeDef,
    ModifyVpnConnectionOptionsResultTypeDef,
    ModifyVpnConnectionRequestRequestTypeDef,
    ModifyVpnConnectionResultTypeDef,
    ModifyVpnTunnelCertificateRequestRequestTypeDef,
    ModifyVpnTunnelCertificateResultTypeDef,
    ModifyVpnTunnelOptionsRequestRequestTypeDef,
    ModifyVpnTunnelOptionsResultTypeDef,
    ModifyVpnTunnelOptionsSpecificationTypeDef,
    MonitorInstancesRequestInstanceMonitorTypeDef,
    MonitorInstancesRequestRequestTypeDef,
    MonitorInstancesResultTypeDef,
    MonitoringResponseMetadataTypeDef,
    MonitoringTypeDef,
    MoveAddressToVpcRequestRequestTypeDef,
    MoveAddressToVpcResultTypeDef,
    MoveByoipCidrToIpamRequestRequestTypeDef,
    MoveByoipCidrToIpamResultTypeDef,
    MovingAddressStatusTypeDef,
    NatGatewayAddressTypeDef,
    NatGatewayTypeDef,
    NetworkAclAssociationTypeDef,
    NetworkAclEntryTypeDef,
    NetworkAclTypeDef,
    NetworkCardInfoTypeDef,
    NetworkInfoTypeDef,
    NetworkInsightsAccessScopeAnalysisTypeDef,
    NetworkInsightsAccessScopeContentTypeDef,
    NetworkInsightsAccessScopeTypeDef,
    NetworkInsightsAnalysisTypeDef,
    NetworkInsightsPathTypeDef,
    NetworkInterfaceAssociationResponseMetadataTypeDef,
    NetworkInterfaceAssociationTypeDef,
    NetworkInterfaceAttachmentChangesTypeDef,
    NetworkInterfaceAttachmentResponseMetadataTypeDef,
    NetworkInterfaceAttachmentTypeDef,
    NetworkInterfaceCountRequestTypeDef,
    NetworkInterfaceCountTypeDef,
    NetworkInterfaceIpv6AddressTypeDef,
    NetworkInterfacePermissionStateTypeDef,
    NetworkInterfacePermissionTypeDef,
    NetworkInterfacePrivateIpAddressTypeDef,
    NetworkInterfaceTypeDef,
    NewDhcpConfigurationTypeDef,
    OnDemandOptionsRequestTypeDef,
    OnDemandOptionsTypeDef,
    PacketHeaderStatementRequestTypeDef,
    PacketHeaderStatementTypeDef,
    PaginatorConfigTypeDef,
    PathComponentTypeDef,
    PathStatementRequestTypeDef,
    PathStatementTypeDef,
    PciIdTypeDef,
    PeeringAttachmentStatusTypeDef,
    PeeringConnectionOptionsRequestTypeDef,
    PeeringConnectionOptionsTypeDef,
    PeeringTgwInfoTypeDef,
    Phase1DHGroupNumbersListValueTypeDef,
    Phase1DHGroupNumbersRequestListValueTypeDef,
    Phase1EncryptionAlgorithmsListValueTypeDef,
    Phase1EncryptionAlgorithmsRequestListValueTypeDef,
    Phase1IntegrityAlgorithmsListValueTypeDef,
    Phase1IntegrityAlgorithmsRequestListValueTypeDef,
    Phase2DHGroupNumbersListValueTypeDef,
    Phase2DHGroupNumbersRequestListValueTypeDef,
    Phase2EncryptionAlgorithmsListValueTypeDef,
    Phase2EncryptionAlgorithmsRequestListValueTypeDef,
    Phase2IntegrityAlgorithmsListValueTypeDef,
    Phase2IntegrityAlgorithmsRequestListValueTypeDef,
    PlacementGroupInfoTypeDef,
    PlacementGroupTypeDef,
    PlacementResponseMetadataTypeDef,
    PlacementResponseTypeDef,
    PlacementTypeDef,
    PoolCidrBlockTypeDef,
    PortRangeTypeDef,
    PrefixListAssociationTypeDef,
    PrefixListEntryTypeDef,
    PrefixListIdTypeDef,
    PrefixListTypeDef,
    PriceScheduleSpecificationTypeDef,
    PriceScheduleTypeDef,
    PricingDetailTypeDef,
    PrincipalIdFormatTypeDef,
    PrivateDnsDetailsTypeDef,
    PrivateDnsNameConfigurationTypeDef,
    PrivateDnsNameOptionsOnLaunchResponseMetadataTypeDef,
    PrivateDnsNameOptionsOnLaunchTypeDef,
    PrivateDnsNameOptionsRequestTypeDef,
    PrivateDnsNameOptionsResponseResponseMetadataTypeDef,
    PrivateDnsNameOptionsResponseTypeDef,
    PrivateIpAddressSpecificationTypeDef,
    ProcessorInfoTypeDef,
    ProductCodeTypeDef,
    PropagatingVgwTypeDef,
    ProvisionByoipCidrRequestRequestTypeDef,
    ProvisionByoipCidrResultTypeDef,
    ProvisionIpamPoolCidrRequestRequestTypeDef,
    ProvisionIpamPoolCidrResultTypeDef,
    ProvisionPublicIpv4PoolCidrRequestRequestTypeDef,
    ProvisionPublicIpv4PoolCidrResultTypeDef,
    ProvisionedBandwidthTypeDef,
    PtrUpdateStatusTypeDef,
    PublicIpv4PoolRangeTypeDef,
    PublicIpv4PoolTypeDef,
    PurchaseHostReservationRequestRequestTypeDef,
    PurchaseHostReservationResultTypeDef,
    PurchaseRequestTypeDef,
    PurchaseReservedInstancesOfferingRequestRequestTypeDef,
    PurchaseReservedInstancesOfferingResultTypeDef,
    PurchaseScheduledInstancesRequestRequestTypeDef,
    PurchaseScheduledInstancesResultTypeDef,
    PurchaseTypeDef,
    RebootInstancesRequestInstanceRebootTypeDef,
    RebootInstancesRequestRequestTypeDef,
    RecurringChargeTypeDef,
    ReferencedSecurityGroupTypeDef,
    RegionTypeDef,
    RegisterImageRequestRequestTypeDef,
    RegisterImageRequestServiceResourceRegisterImageTypeDef,
    RegisterImageResultTypeDef,
    RegisterInstanceEventNotificationAttributesRequestRequestTypeDef,
    RegisterInstanceEventNotificationAttributesResultTypeDef,
    RegisterInstanceTagAttributeRequestTypeDef,
    RegisterTransitGatewayMulticastGroupMembersRequestRequestTypeDef,
    RegisterTransitGatewayMulticastGroupMembersResultTypeDef,
    RegisterTransitGatewayMulticastGroupSourcesRequestRequestTypeDef,
    RegisterTransitGatewayMulticastGroupSourcesResultTypeDef,
    RejectTransitGatewayMulticastDomainAssociationsRequestRequestTypeDef,
    RejectTransitGatewayMulticastDomainAssociationsResultTypeDef,
    RejectTransitGatewayPeeringAttachmentRequestRequestTypeDef,
    RejectTransitGatewayPeeringAttachmentResultTypeDef,
    RejectTransitGatewayVpcAttachmentRequestRequestTypeDef,
    RejectTransitGatewayVpcAttachmentResultTypeDef,
    RejectVpcEndpointConnectionsRequestRequestTypeDef,
    RejectVpcEndpointConnectionsResultTypeDef,
    RejectVpcPeeringConnectionRequestRequestTypeDef,
    RejectVpcPeeringConnectionRequestVpcPeeringConnectionRejectTypeDef,
    RejectVpcPeeringConnectionResultTypeDef,
    ReleaseAddressRequestClassicAddressReleaseTypeDef,
    ReleaseAddressRequestRequestTypeDef,
    ReleaseAddressRequestVpcAddressReleaseTypeDef,
    ReleaseHostsRequestRequestTypeDef,
    ReleaseHostsResultTypeDef,
    ReleaseIpamPoolAllocationRequestRequestTypeDef,
    ReleaseIpamPoolAllocationResultTypeDef,
    RemoveIpamOperatingRegionTypeDef,
    RemovePrefixListEntryTypeDef,
    ReplaceIamInstanceProfileAssociationRequestRequestTypeDef,
    ReplaceIamInstanceProfileAssociationResultTypeDef,
    ReplaceNetworkAclAssociationRequestNetworkAclReplaceAssociationTypeDef,
    ReplaceNetworkAclAssociationRequestRequestTypeDef,
    ReplaceNetworkAclAssociationResultTypeDef,
    ReplaceNetworkAclEntryRequestNetworkAclReplaceEntryTypeDef,
    ReplaceNetworkAclEntryRequestRequestTypeDef,
    ReplaceRootVolumeTaskTypeDef,
    ReplaceRouteRequestRequestTypeDef,
    ReplaceRouteRequestRouteReplaceTypeDef,
    ReplaceRouteTableAssociationRequestRequestTypeDef,
    ReplaceRouteTableAssociationRequestRouteTableAssociationReplaceSubnetTypeDef,
    ReplaceRouteTableAssociationResultTypeDef,
    ReplaceTransitGatewayRouteRequestRequestTypeDef,
    ReplaceTransitGatewayRouteResultTypeDef,
    ReportInstanceStatusRequestInstanceReportStatusTypeDef,
    ReportInstanceStatusRequestRequestTypeDef,
    RequestIpamResourceTagTypeDef,
    RequestLaunchTemplateDataTypeDef,
    RequestSpotFleetRequestRequestTypeDef,
    RequestSpotFleetResponseTypeDef,
    RequestSpotInstancesRequestRequestTypeDef,
    RequestSpotInstancesResultTypeDef,
    RequestSpotLaunchSpecificationTypeDef,
    ReservationFleetInstanceSpecificationTypeDef,
    ReservationResponseMetadataTypeDef,
    ReservationTypeDef,
    ReservationValueTypeDef,
    ReservedInstanceLimitPriceTypeDef,
    ReservedInstanceReservationValueTypeDef,
    ReservedInstancesConfigurationTypeDef,
    ReservedInstancesIdTypeDef,
    ReservedInstancesListingTypeDef,
    ReservedInstancesModificationResultTypeDef,
    ReservedInstancesModificationTypeDef,
    ReservedInstancesOfferingTypeDef,
    ReservedInstancesTypeDef,
    ResetAddressAttributeRequestRequestTypeDef,
    ResetAddressAttributeResultTypeDef,
    ResetEbsDefaultKmsKeyIdRequestRequestTypeDef,
    ResetEbsDefaultKmsKeyIdResultTypeDef,
    ResetFpgaImageAttributeRequestRequestTypeDef,
    ResetFpgaImageAttributeResultTypeDef,
    ResetImageAttributeRequestImageResetAttributeTypeDef,
    ResetImageAttributeRequestRequestTypeDef,
    ResetInstanceAttributeRequestInstanceResetAttributeTypeDef,
    ResetInstanceAttributeRequestInstanceResetKernelTypeDef,
    ResetInstanceAttributeRequestInstanceResetRamdiskTypeDef,
    ResetInstanceAttributeRequestInstanceResetSourceDestCheckTypeDef,
    ResetInstanceAttributeRequestRequestTypeDef,
    ResetNetworkInterfaceAttributeRequestNetworkInterfaceResetAttributeTypeDef,
    ResetNetworkInterfaceAttributeRequestRequestTypeDef,
    ResetSnapshotAttributeRequestRequestTypeDef,
    ResetSnapshotAttributeRequestSnapshotResetAttributeTypeDef,
    ResourceStatementRequestTypeDef,
    ResourceStatementTypeDef,
    ResponseErrorTypeDef,
    ResponseLaunchTemplateDataTypeDef,
    ResponseMetadataTypeDef,
    RestoreAddressToClassicRequestRequestTypeDef,
    RestoreAddressToClassicResultTypeDef,
    RestoreImageFromRecycleBinRequestRequestTypeDef,
    RestoreImageFromRecycleBinResultTypeDef,
    RestoreManagedPrefixListVersionRequestRequestTypeDef,
    RestoreManagedPrefixListVersionResultTypeDef,
    RestoreSnapshotFromRecycleBinRequestRequestTypeDef,
    RestoreSnapshotFromRecycleBinResultTypeDef,
    RestoreSnapshotTierRequestRequestTypeDef,
    RestoreSnapshotTierResultTypeDef,
    RevokeClientVpnIngressRequestRequestTypeDef,
    RevokeClientVpnIngressResultTypeDef,
    RevokeSecurityGroupEgressRequestRequestTypeDef,
    RevokeSecurityGroupEgressRequestSecurityGroupRevokeEgressTypeDef,
    RevokeSecurityGroupEgressResultTypeDef,
    RevokeSecurityGroupIngressRequestRequestTypeDef,
    RevokeSecurityGroupIngressRequestSecurityGroupRevokeIngressTypeDef,
    RevokeSecurityGroupIngressResultTypeDef,
    RouteTableAssociationStateResponseMetadataTypeDef,
    RouteTableAssociationStateTypeDef,
    RouteTableAssociationTypeDef,
    RouteTableTypeDef,
    RouteTypeDef,
    RunInstancesMonitoringEnabledTypeDef,
    RunInstancesRequestRequestTypeDef,
    RunInstancesRequestServiceResourceCreateInstancesTypeDef,
    RunInstancesRequestSubnetCreateInstancesTypeDef,
    RunScheduledInstancesRequestRequestTypeDef,
    RunScheduledInstancesResultTypeDef,
    S3ObjectTagTypeDef,
    S3StorageTypeDef,
    ScheduledInstanceAvailabilityTypeDef,
    ScheduledInstanceRecurrenceRequestTypeDef,
    ScheduledInstanceRecurrenceTypeDef,
    ScheduledInstanceTypeDef,
    ScheduledInstancesBlockDeviceMappingTypeDef,
    ScheduledInstancesEbsTypeDef,
    ScheduledInstancesIamInstanceProfileTypeDef,
    ScheduledInstancesIpv6AddressTypeDef,
    ScheduledInstancesLaunchSpecificationTypeDef,
    ScheduledInstancesMonitoringTypeDef,
    ScheduledInstancesNetworkInterfaceTypeDef,
    ScheduledInstancesPlacementTypeDef,
    ScheduledInstancesPrivateIpAddressConfigTypeDef,
    SearchLocalGatewayRoutesRequestRequestTypeDef,
    SearchLocalGatewayRoutesRequestSearchLocalGatewayRoutesPaginateTypeDef,
    SearchLocalGatewayRoutesResultTypeDef,
    SearchTransitGatewayMulticastGroupsRequestRequestTypeDef,
    SearchTransitGatewayMulticastGroupsRequestSearchTransitGatewayMulticastGroupsPaginateTypeDef,
    SearchTransitGatewayMulticastGroupsResultTypeDef,
    SearchTransitGatewayRoutesRequestRequestTypeDef,
    SearchTransitGatewayRoutesResultTypeDef,
    SecurityGroupIdentifierTypeDef,
    SecurityGroupReferenceTypeDef,
    SecurityGroupRuleDescriptionTypeDef,
    SecurityGroupRuleRequestTypeDef,
    SecurityGroupRuleTypeDef,
    SecurityGroupRuleUpdateTypeDef,
    SecurityGroupTypeDef,
    SendDiagnosticInterruptRequestRequestTypeDef,
    ServiceConfigurationTypeDef,
    ServiceDetailTypeDef,
    ServiceResourceClassicAddressRequestTypeDef,
    ServiceResourceDhcpOptionsRequestTypeDef,
    ServiceResourceImageRequestTypeDef,
    ServiceResourceInstanceRequestTypeDef,
    ServiceResourceInternetGatewayRequestTypeDef,
    ServiceResourceKeyPairRequestTypeDef,
    ServiceResourceNetworkAclRequestTypeDef,
    ServiceResourceNetworkInterfaceAssociationRequestTypeDef,
    ServiceResourceNetworkInterfaceRequestTypeDef,
    ServiceResourcePlacementGroupRequestTypeDef,
    ServiceResourceRouteRequestTypeDef,
    ServiceResourceRouteTableAssociationRequestTypeDef,
    ServiceResourceRouteTableRequestTypeDef,
    ServiceResourceSecurityGroupRequestTypeDef,
    ServiceResourceSnapshotRequestTypeDef,
    ServiceResourceSubnetRequestTypeDef,
    ServiceResourceTagRequestTypeDef,
    ServiceResourceVolumeRequestTypeDef,
    ServiceResourceVpcAddressRequestTypeDef,
    ServiceResourceVpcPeeringConnectionRequestTypeDef,
    ServiceResourceVpcRequestTypeDef,
    ServiceTypeDetailTypeDef,
    SlotDateTimeRangeRequestTypeDef,
    SlotStartTimeRangeRequestTypeDef,
    SnapshotDetailTypeDef,
    SnapshotDiskContainerTypeDef,
    SnapshotInfoTypeDef,
    SnapshotRecycleBinInfoTypeDef,
    SnapshotResponseMetadataTypeDef,
    SnapshotTaskDetailTypeDef,
    SnapshotTierStatusTypeDef,
    SnapshotTypeDef,
    SpotCapacityRebalanceTypeDef,
    SpotDatafeedSubscriptionTypeDef,
    SpotFleetLaunchSpecificationTypeDef,
    SpotFleetMonitoringTypeDef,
    SpotFleetRequestConfigDataTypeDef,
    SpotFleetRequestConfigTypeDef,
    SpotFleetTagSpecificationTypeDef,
    SpotInstanceRequestTypeDef,
    SpotInstanceStateFaultTypeDef,
    SpotInstanceStatusTypeDef,
    SpotMaintenanceStrategiesTypeDef,
    SpotMarketOptionsTypeDef,
    SpotOptionsRequestTypeDef,
    SpotOptionsTypeDef,
    SpotPlacementScoreTypeDef,
    SpotPlacementTypeDef,
    SpotPriceTypeDef,
    StaleIpPermissionTypeDef,
    StaleSecurityGroupTypeDef,
    StartInstancesRequestInstanceStartTypeDef,
    StartInstancesRequestRequestTypeDef,
    StartInstancesResultTypeDef,
    StartNetworkInsightsAccessScopeAnalysisRequestRequestTypeDef,
    StartNetworkInsightsAccessScopeAnalysisResultTypeDef,
    StartNetworkInsightsAnalysisRequestRequestTypeDef,
    StartNetworkInsightsAnalysisResultTypeDef,
    StartVpcEndpointServicePrivateDnsVerificationRequestRequestTypeDef,
    StartVpcEndpointServicePrivateDnsVerificationResultTypeDef,
    StateReasonResponseMetadataTypeDef,
    StateReasonTypeDef,
    StopInstancesRequestInstanceStopTypeDef,
    StopInstancesRequestRequestTypeDef,
    StopInstancesResultTypeDef,
    StorageLocationTypeDef,
    StorageTypeDef,
    StoreImageTaskResultTypeDef,
    SubnetAssociationTypeDef,
    SubnetCidrBlockStateTypeDef,
    SubnetCidrReservationTypeDef,
    SubnetIpv6CidrBlockAssociationTypeDef,
    SubnetTypeDef,
    SuccessfulInstanceCreditSpecificationItemTypeDef,
    SuccessfulQueuedPurchaseDeletionTypeDef,
    TagDescriptionTypeDef,
    TagSpecificationTypeDef,
    TagTypeDef,
    TargetCapacitySpecificationRequestTypeDef,
    TargetCapacitySpecificationTypeDef,
    TargetConfigurationRequestTypeDef,
    TargetConfigurationTypeDef,
    TargetGroupTypeDef,
    TargetGroupsConfigTypeDef,
    TargetNetworkTypeDef,
    TargetReservationValueTypeDef,
    TerminateClientVpnConnectionsRequestRequestTypeDef,
    TerminateClientVpnConnectionsResultTypeDef,
    TerminateConnectionStatusTypeDef,
    TerminateInstancesRequestInstanceTerminateTypeDef,
    TerminateInstancesRequestRequestTypeDef,
    TerminateInstancesResultTypeDef,
    ThroughResourcesStatementRequestTypeDef,
    ThroughResourcesStatementTypeDef,
    TotalLocalStorageGBRequestTypeDef,
    TotalLocalStorageGBTypeDef,
    TrafficMirrorFilterRuleTypeDef,
    TrafficMirrorFilterTypeDef,
    TrafficMirrorPortRangeRequestTypeDef,
    TrafficMirrorPortRangeTypeDef,
    TrafficMirrorSessionTypeDef,
    TrafficMirrorTargetTypeDef,
    TransitGatewayAssociationTypeDef,
    TransitGatewayAttachmentAssociationTypeDef,
    TransitGatewayAttachmentBgpConfigurationTypeDef,
    TransitGatewayAttachmentPropagationTypeDef,
    TransitGatewayAttachmentTypeDef,
    TransitGatewayConnectOptionsTypeDef,
    TransitGatewayConnectPeerConfigurationTypeDef,
    TransitGatewayConnectPeerTypeDef,
    TransitGatewayConnectRequestBgpOptionsTypeDef,
    TransitGatewayConnectTypeDef,
    TransitGatewayMulticastDeregisteredGroupMembersTypeDef,
    TransitGatewayMulticastDeregisteredGroupSourcesTypeDef,
    TransitGatewayMulticastDomainAssociationTypeDef,
    TransitGatewayMulticastDomainAssociationsTypeDef,
    TransitGatewayMulticastDomainOptionsTypeDef,
    TransitGatewayMulticastDomainTypeDef,
    TransitGatewayMulticastGroupTypeDef,
    TransitGatewayMulticastRegisteredGroupMembersTypeDef,
    TransitGatewayMulticastRegisteredGroupSourcesTypeDef,
    TransitGatewayOptionsTypeDef,
    TransitGatewayPeeringAttachmentTypeDef,
    TransitGatewayPrefixListAttachmentTypeDef,
    TransitGatewayPrefixListReferenceTypeDef,
    TransitGatewayPropagationTypeDef,
    TransitGatewayRequestOptionsTypeDef,
    TransitGatewayRouteAttachmentTypeDef,
    TransitGatewayRouteTableAssociationTypeDef,
    TransitGatewayRouteTablePropagationTypeDef,
    TransitGatewayRouteTableRouteTypeDef,
    TransitGatewayRouteTableTypeDef,
    TransitGatewayRouteTypeDef,
    TransitGatewayTypeDef,
    TransitGatewayVpcAttachmentOptionsTypeDef,
    TransitGatewayVpcAttachmentTypeDef,
    TrunkInterfaceAssociationTypeDef,
    TunnelOptionTypeDef,
    UnassignIpv6AddressesRequestRequestTypeDef,
    UnassignIpv6AddressesResultTypeDef,
    UnassignPrivateIpAddressesRequestNetworkInterfaceUnassignPrivateIpAddressesTypeDef,
    UnassignPrivateIpAddressesRequestRequestTypeDef,
    UnmonitorInstancesRequestInstanceUnmonitorTypeDef,
    UnmonitorInstancesRequestRequestTypeDef,
    UnmonitorInstancesResultTypeDef,
    UnsuccessfulInstanceCreditSpecificationItemErrorTypeDef,
    UnsuccessfulInstanceCreditSpecificationItemTypeDef,
    UnsuccessfulItemErrorTypeDef,
    UnsuccessfulItemTypeDef,
    UpdateSecurityGroupRuleDescriptionsEgressRequestRequestTypeDef,
    UpdateSecurityGroupRuleDescriptionsEgressResultTypeDef,
    UpdateSecurityGroupRuleDescriptionsIngressRequestRequestTypeDef,
    UpdateSecurityGroupRuleDescriptionsIngressResultTypeDef,
    UserBucketDetailsTypeDef,
    UserBucketTypeDef,
    UserDataTypeDef,
    UserIdGroupPairTypeDef,
    VCpuCountRangeRequestTypeDef,
    VCpuCountRangeTypeDef,
    VCpuInfoTypeDef,
    ValidationErrorTypeDef,
    ValidationWarningTypeDef,
    VgwTelemetryTypeDef,
    VolumeAttachmentResponseMetadataTypeDef,
    VolumeAttachmentTypeDef,
    VolumeDetailTypeDef,
    VolumeModificationTypeDef,
    VolumeResponseMetadataTypeDef,
    VolumeStatusActionTypeDef,
    VolumeStatusAttachmentStatusTypeDef,
    VolumeStatusDetailsTypeDef,
    VolumeStatusEventTypeDef,
    VolumeStatusInfoTypeDef,
    VolumeStatusItemTypeDef,
    VolumeTypeDef,
    VpcAttachmentTypeDef,
    VpcCidrBlockAssociationTypeDef,
    VpcCidrBlockStateTypeDef,
    VpcClassicLinkTypeDef,
    VpcEndpointConnectionTypeDef,
    VpcEndpointTypeDef,
    VpcIpv6CidrBlockAssociationTypeDef,
    VpcPeeringConnectionOptionsDescriptionTypeDef,
    VpcPeeringConnectionStateReasonResponseMetadataTypeDef,
    VpcPeeringConnectionStateReasonTypeDef,
    VpcPeeringConnectionTypeDef,
    VpcPeeringConnectionVpcInfoResponseMetadataTypeDef,
    VpcPeeringConnectionVpcInfoTypeDef,
    VpcTypeDef,
    VpnConnectionDeviceTypeTypeDef,
    VpnConnectionOptionsSpecificationTypeDef,
    VpnConnectionOptionsTypeDef,
    VpnConnectionTypeDef,
    VpnGatewayTypeDef,
    VpnStaticRouteTypeDef,
    VpnTunnelOptionsSpecificationTypeDef,
    WaiterConfigTypeDef,
    WithdrawByoipCidrRequestRequestTypeDef,
    WithdrawByoipCidrResultTypeDef,
)

def get_structure() -> AcceleratorCountRequestTypeDef:
    return {
      ...
    }
```

<a id="how-it-works"></a>

## How it works

Fully automated
[mypy-boto3-builder](https://github.com/youtype/mypy_boto3_builder) carefully
generates type annotations for each service, patiently waiting for `boto3`
updates. It delivers a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type
  annotations extracted from the documentation (blame `botocore` docs if types
  are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) and
  [isort](https://github.com/PyCQA/isort) for readability.

<a id="what's-new"></a>

## What's new

<a id="implemented-features"></a>

### Implemented features

- Fully type annotated `boto3`, `botocore` and `aiobotocore` libraries
- `mypy`, `pyright`, `VSCode`, `PyCharm`, `Sublime Text` and `Emacs`
  compatibility
- `Client`, `ServiceResource`, `Resource`, `Waiter` `Paginator` type
  annotations for each service
- Generated `TypeDefs` for each service
- Generated `Literals` for each service
- Auto discovery of types for `boto3.client` and `boto3.session` calls
- Auto discovery of types for `session.client` and `session.session` calls
- Auto discovery of types for `client.get_waiter` and `client.get_paginator`
  calls
- Auto discovery of types for `ServiceResource` and `Resource` collections
- Auto discovery of types for `aiobotocore.Session.create_client` calls

<a id="latest-changes"></a>

### Latest changes

Builder changelog can be found in
[Releases](https://github.com/youtype/mypy_boto3_builder/releases).

<a id="versioning"></a>

## Versioning

`mypy-boto3-ec2` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="thank-you"></a>

## Thank you

- [Allie Fitter](https://github.com/alliefitter) for
  [boto3-type-annotations](https://pypi.org/project/boto3-type-annotations/),
  this package is based on top of his work
- [black](https://github.com/psf/black) developers for an awesome formatting
  tool
- [Timothy Edmund Crosley](https://github.com/timothycrosley) for
  [isort](https://github.com/PyCQA/isort) and how flexible it is
- [mypy](https://github.com/python/mypy) developers for doing all dirty work
  for us
- [pyright](https://github.com/microsoft/pyright) team for the new era of typed
  Python

<a id="documentation"></a>

## Documentation

All services type annotations can be found in
[boto3 docs](https://youtype.github.io/boto3_stubs_docs/mypy_boto3_ec2/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/youtype/mypy_boto3_builder/issues/)
repository.
