# mypy-boto3-machinelearning<a id="mypy-boto3-machinelearning"></a>

[![PyPI - mypy-boto3-machinelearning](https://img.shields.io/pypi/v/mypy-boto3-machinelearning.svg?color=blue)](https://pypi.org/project/mypy-boto3-machinelearning)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-machinelearning.svg?color=blue)](https://pypi.org/project/mypy-boto3-machinelearning)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-machinelearning?color=blue)](https://pypistats.org/packages/mypy-boto3-machinelearning)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.MachineLearning 1.17.75](https://boto3.amazonaws.com/v1/documentation/api/1.17.75/reference/services/machinelearning.html#MachineLearning)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.13.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-machinelearning docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_machinelearning/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-machinelearning](#mypy-boto3-machinelearning)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `MachineLearning` service.

```bash
python -m pip install boto3-stubs[machinelearning]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[machinelearning]` in your environment:
  `python -m pip install 'boto3-stubs[machinelearning]'`

Both type checking and auto-complete should work for `MachineLearning` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[machinelearning]` in your environment:
  `python -m pip install 'boto3-stubs[machinelearning]'`

Both type checking and auto-complete should work for `MachineLearning` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[machinelearning]` in your environment:
  `python -m pip install 'boto3-stubs[machinelearning]'`
- Run `mypy` as usual

Type checking should work for `MachineLearning` service. No explicit type
annotations required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[machinelearning]` in your environment:
  `python -m pip install 'boto3-stubs[machinelearning]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `MachineLearning` service. No explicit type
annotations required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`MachineLearningClient` provides annotations for
`boto3.client("machinelearning")`.

```python
import boto3

from mypy_boto3_machinelearning import MachineLearningClient

client: MachineLearningClient = boto3.client("machinelearning")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: MachineLearningClient = session.client("machinelearning")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_machinelearning.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_machinelearning import MachineLearningClient
from mypy_boto3_machinelearning.paginator import (
    DescribeBatchPredictionsPaginator,
    DescribeDataSourcesPaginator,
    DescribeEvaluationsPaginator,
    DescribeMLModelsPaginator,
)

client: MachineLearningClient = boto3.client("machinelearning")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_batch_predictions_paginator: DescribeBatchPredictionsPaginator = client.get_paginator("describe_batch_predictions")
describe_data_sources_paginator: DescribeDataSourcesPaginator = client.get_paginator("describe_data_sources")
describe_evaluations_paginator: DescribeEvaluationsPaginator = client.get_paginator("describe_evaluations")
describe_ml_models_paginator: DescribeMLModelsPaginator = client.get_paginator("describe_ml_models")
```

### Waiters annotations<a id="waiters-annotations"></a>

`mypy_boto3_machinelearning.waiter` module contains type annotations for all
waiters.

```python
from mypy_boto3_machinelearning import MachineLearningClient
from mypy_boto3_machinelearning.waiter import (
    BatchPredictionAvailableWaiter,
    DataSourceAvailableWaiter,
    EvaluationAvailableWaiter,
    MLModelAvailableWaiter,
)

client: MachineLearningClient = boto3.client("machinelearning")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
batch_prediction_available_waiter: BatchPredictionAvailableWaiter = client.get_waiter("batch_prediction_available")
data_source_available_waiter: DataSourceAvailableWaiter = client.get_waiter("data_source_available")
evaluation_available_waiter: EvaluationAvailableWaiter = client.get_waiter("evaluation_available")
ml_model_available_waiter: MLModelAvailableWaiter = client.get_waiter("ml_model_available")
```

### Literals<a id="literals"></a>

`mypy_boto3_machinelearning.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_machinelearning.literals import (
    AlgorithmType,
    BatchPredictionAvailableWaiterName,
    BatchPredictionFilterVariableType,
    DataSourceAvailableWaiterName,
    DataSourceFilterVariableType,
    DescribeBatchPredictionsPaginatorName,
    DescribeDataSourcesPaginatorName,
    DescribeEvaluationsPaginatorName,
    DescribeMLModelsPaginatorName,
    DetailsAttributesType,
    EntityStatusType,
    EvaluationAvailableWaiterName,
    EvaluationFilterVariableType,
    MLModelAvailableWaiterName,
    MLModelFilterVariableType,
    MLModelTypeType,
    RealtimeEndpointStatusType,
    SortOrderType,
    TaggableResourceTypeType,
)

def check_value(value: AlgorithmType) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_machinelearning.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_machinelearning.type_defs import (
    AddTagsOutputTypeDef,
    BatchPredictionTypeDef,
    CreateBatchPredictionOutputTypeDef,
    CreateDataSourceFromRDSOutputTypeDef,
    CreateDataSourceFromRedshiftOutputTypeDef,
    CreateDataSourceFromS3OutputTypeDef,
    CreateEvaluationOutputTypeDef,
    CreateMLModelOutputTypeDef,
    CreateRealtimeEndpointOutputTypeDef,
    DataSourceTypeDef,
    DeleteBatchPredictionOutputTypeDef,
    DeleteDataSourceOutputTypeDef,
    DeleteEvaluationOutputTypeDef,
    DeleteMLModelOutputTypeDef,
    DeleteRealtimeEndpointOutputTypeDef,
    DeleteTagsOutputTypeDef,
    DescribeBatchPredictionsOutputTypeDef,
    DescribeDataSourcesOutputTypeDef,
    DescribeEvaluationsOutputTypeDef,
    DescribeMLModelsOutputTypeDef,
    DescribeTagsOutputTypeDef,
    EvaluationTypeDef,
    GetBatchPredictionOutputTypeDef,
    GetDataSourceOutputTypeDef,
    GetEvaluationOutputTypeDef,
    GetMLModelOutputTypeDef,
    MLModelTypeDef,
    PaginatorConfigTypeDef,
    PerformanceMetricsTypeDef,
    PredictOutputTypeDef,
    PredictionTypeDef,
    RDSDataSpecTypeDef,
    RDSDatabaseCredentialsTypeDef,
    RDSDatabaseTypeDef,
    RDSMetadataTypeDef,
    RealtimeEndpointInfoTypeDef,
    RedshiftDataSpecTypeDef,
    RedshiftDatabaseCredentialsTypeDef,
    RedshiftDatabaseTypeDef,
    RedshiftMetadataTypeDef,
    ResponseMetadataTypeDef,
    S3DataSpecTypeDef,
    TagTypeDef,
    UpdateBatchPredictionOutputTypeDef,
    UpdateDataSourceOutputTypeDef,
    UpdateEvaluationOutputTypeDef,
    UpdateMLModelOutputTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AddTagsOutputTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-machinelearning` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-machinelearning docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_machinelearning/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
