Pyxel detector simulation framework
===================================

[![pipeline status](https://gitlab.com/esa/pyxel/badges/master/pipeline.svg)](https://gitlab.esa.int/sci-fv/pyxel-mirror/pipelines)
[![License](https://img.shields.io/badge/license-MIT-green.svg)](https://gitlab.com/esa/pyxel/blob/master/LICENSE)
[![docs](https://esa.gitlab.io/pyxel/documentation.svg)](https://esa.gitlab.io/pyxel/doc)
[![gitter](https://badges.gitter.im/pyxel-framework/community.svg)](https://gitter.im/pyxel-framework/community)
[![Google Group](https://img.shields.io/badge/Google%20Group-Pyxel%20Detector%20Framework-blue.svg)](https://groups.google.com/g/pyxel-detector-framework)
[![coverage](https://gitlab.com/esa/pyxel/badges/master/coverage.svg)](http://sci-fv.io.esa.int/pyxel-mirror/coverage/)
[![doi](https://zenodo.org/badge/DOI/10.1117/12.2314047.svg)](https://doi.org/10.1117/12.2314047)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gl/esa%2Fpyxel-data/HEAD?urlpath=lab)

## What is it?

*Pyxel* is a general detector simulation framework.
An easy-to-use framework that can simulate a variety of imaging detector
effects combined on images (e.g. radiation and optical effects, noises)
made by CCD or CMOS-based detectors.

*Pyxel* is tested on Python 3.6+.

If you'd like to contribute to *Pyxel* you're most welcome.
Please read [the little guide](https://esa.gitlab.io/pyxel/doc/contributing.html) to get you started.

## Documentation

Learn more about *Pyxel* in its offical [blog](https://esa.gitlab.io/pyxel) and its official documentation at [https://esa.gitlab.io/pyxel/doc](https://esa.gitlab.io/pyxel/doc).


## Installation

Installation instructions can be found [here](https://esa.gitlab.io/pyxel/doc/install.html).

## Examples

Example notebooks of Pyxel can be found in a separate public repository [Pyxel Data](https://gitlab.com/esa/pyxel-data). Examples can either be downloaded and run locally or run in the cloud using Binder, by clicking on the badge above.


## Getting Help


* Report bugs, suggest features or view the source code on [GitLab](https://gitlab.com/esa/pyxel).
* For less well defined questions or ideas, or to announce other projets of interest to Pyxel users, use the *Pyxel* [mailing list](https://rssd-mgw.estec.esa.int:81/mailman/listinfo/pyxel).

## Discussion and Development

Most development discussion is taking place on GitLab in this repo.
Further, the *Pyxel* [mailing list](https://rssd-mgw.estec.esa.int:81/mailman/listinfo/pyxel) can also be used for specialized discussions or design issues, and a [Gitter channel](https://gitter.im/pyxel-framework/community) is available for quick development related questions.


## Contributing to *Pyxel*

All contributions, bug reports, bug fixes, documentation improvements, enhancements and ideas are welcome.

A detailed overview on how to contribute to *Pyxel* can be found in the
**[contributing guide](https://esa.gitlab.io/pyxel/doc/contributing.html)**.
There is also an [overview](.gitlab/CONTRIBUTING.md) on GitLab.

If you are simply looking to start working with the *Pyxel* codebase, navigate to the
[GitLab "issues" tab](https://gitlab.com/esa/pyxel/issues) and start looking through interesting issues.
There are a number of issues listed under [Docs](https://gitlab.com/esa/pyxel/issues?label_name%5B%5D=documentation) and [good first issue](https://gitlab.com/esa/pyxel/issues?label_name%5B%5D=good+first+issue) where you could start out.

Or maybe through using *Pyxel* you have an idea of your own or are looking for something in the documentation and thinking 'this can be improved'... you can do something about it !

Feel free to ask questions on the [mailing list](https://rssd-mgw.estec.esa.int:81/mailman/listinfo/pyxel) or on [Gitter](https://gitter.im/pyxel-framework/community).


## Changelog

The detailed changelog is available [here](https://esa.gitlab.io/pyxel/doc/changelog.html).


## License

*Pyxel* is released under MIT license, available [here](https://esa.gitlab.io/pyxel/doc/license.html).
