// Copyright (c) 2018 JGraph Ltd
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

export const grapheditorTxt = `# Resources from graph.properties
alreadyConnected=Nodes already connected
cancel=Cancel
close=Close
collapse-expand=Collapse/Expand
containsValidationErrors=Contains validation errors
done=Done
doubleClickOrientation=Doubleclick to Change Orientation
error=Error
errorSavingFile=Error saving file
ok=OK
updatingDocument=Updating Document. Please wait...
updatingSelection=Updating Selection. Please wait...
# Custom resources
about=About
actualSize=Actual Size
add=Add
addLayer=Add Layer
addProperty=Add Property
addToExistingDrawing=Add to Existing Drawing
addWaypoint=Add Waypoint
advanced=Advanced
align=Align
alignment=Alignment
allChangesLost=All changes will be lost!
angle=Angle
apply=Apply
arc=Arc
arrange=Arrange
arrow=Arrow
arrows=Arrows
automatic=Automatic
autosave=Autosave
autosize=Autosize
background=Background
backgroundColor=Background Color
backgroundImage=Background Image
basic=Basic
block=Block
blockquote=Blockquote
bold=Bold
borderWidth=Borderwidth
borderColor=Border Color
bottom=Bottom
bottomAlign=Bottom Align
bottomLeft=Bottom Left
bottomRight=Bottom Right
bulletedList=Bulleted List
cannotOpenFile=Cannot open file
center=Center
change=Change
changeOrientation=Change Orientation
circle=Circle
classic=Classic
clearDefaultStyle=Clear Default Style
clearWaypoints=Clear Waypoints
clipart=Clipart
collapse=Collapse
collapseExpand=Collapse/Expand
collapsible=Collapsible
comic=Comic
connect=Connect
connection=Connection
connectionPoints=Connection points
connectionArrows=Connection arrows
constrainProportions=Constrain Proportions
copy=Copy
copyConnect=Copy on Connect
create=Create
curved=Curved
custom=Custom
cut=Cut
dashed=Dashed
decreaseIndent=Decrease Indent
default=Default
delete=Delete
deleteColumn=Delete Column
deleteRow=Delete Row
diagram=Diagram
diamond=Diamond
diamondThin=Diamond (thin)
direction=Direction
distribute=Distribute
divider=Divider
documentProperties=Document Properties
dotted=Dotted
drawing=Drawing{1}
drawingEmpty=Drawing is empty
drawingTooLarge=Drawing is too large
duplicate=Duplicate
duplicateIt=Duplicate {1}
east=East
edit=Edit
editData=Edit Data
editDiagram=Edit Diagram
editImage=Edit Image
editLink=Edit Link
editStyle=Edit Style
editTooltip=Edit Tooltip
enterGroup=Enter Group
enterValue=Enter Value
enterName=Enter Name
enterPropertyName=Enter Property Name
entityRelation=Entity Relation
exitGroup=Exit Group
expand=Expand
export=Export
extras=Extras
file=File
fileNotFound=File not found
filename=Filename
fill=Fill
fillColor=Fill Color
fitPage=One Page
fitPageWidth=Page Width
fitTwoPages=Two Pages
fitWindow=Fit Window
flip=Flip
flipH=Flip Horizontal
flipV=Flip Vertical
font=Font
fontFamily=Font Family
fontColor=Font Color
fontSize=Font Size
format=Format
formatPanel=Format Panel
general=Allgemein
formatPdf=PDF
formatPng=PNG
formatGif=GIF
formatJpg=JPEG
formatSvg=SVG
formatXml=XML
formatted=Formatted
formattedText=Formatted Text
gap=Gap
general=General
glass=Glass
global=Global
gradient=Gradient
gradientColor=Color
grid=Grid
gridSize=Grid Size
group=Group
guides=Guides
heading=Heading
height=Height
help=Help
hide=Hide
hideIt=Hide {1}
hidden=Hidden
home=Home
horizontal=Horizontal
horizontalFlow=Horizontal Flow
horizontalTree=Horizontal Tree
html=HTML
image=Image
images=Images
import=Import
increaseIndent=Increase Indent
insert=Insert
insertColumnBefore=Insert Column Left
insertColumnAfter=Insert Column Right
insertHorizontalRule=Insert Horizontal Rule
insertImage=Insert Image
insertLink=Insert Link
insertRowBefore=Insert Row Above
insertRowAfter=Insert Row Below
invalidName=Invalid name
invalidOrMissingFile=Invalid or missing file
isometric=Isometric
italic=Italic
layers=Layers
landscape=Landscape
laneColor=Lanecolor
layout=Layout
left=Left
leftAlign=Left Align
leftToRight=Left to Right
line=Line
link=Link
lineJumps=Line jumps
lineend=Line End
lineheight=Line Height
linestart=Line Start
linewidth=Linewidth
loading=Loading
lockUnlock=Lock/Unlock
manual=Manual
middle=Middle
misc=Misc
more=More
moreResults=More Results
move=Move
moveSelectionTo=Move Selection to {1}
navigation=Navigation
new=New
noColor=No Color
noFiles=No files
noMoreResults=No more results
none=None
noResultsFor=No results for '{1}'
normal=Normal
north=North
numberedList=Numbered List
opacity=Opacity
open=Open
openArrow=Open Arrow
openFile=Open File
openLink=Open Link
openSupported=Supported format is .XML files saved from this software
openInNewWindow=Open in New Window
openInThisWindow=Open in this Window
options=Options
organic=Organic
orthogonal=Orthogonal
outline=Outline
oval=Oval
pages=Pages
pageView=Page View
pageScale=Page Scale
pageSetup=Page Setup
panTooltip=Space+Drag to Scroll
paperSize=Paper Size
paste=Paste
pasteHere=Paste Here
pattern=Pattern
perimeter=Perimeter
placeholders=Placeholders
plusTooltip=Click to connect and clone (ctrl+click to clone, shift+click to connect). Drag to connect (ctrl+drag to clone).
portrait=Portrait
position=Position
posterPrint=Poster Print
preview=Preview
print=Print
radialTree=Radial Tree
redo=Redo
removeFormat=Clear Formatting
removeFromGroup=Remove from Group
removeIt=Remove {1}
removeWaypoint=Remove Waypoint
rename=Rename
renameIt=Rename {1}
replace=Replace
replaceIt={1} already exists. Do you want to replace it?
replaceExistingDrawing=Replace existing drawing
reset=Reset
resetView=Reset View
reverse=Reverse
right=Right
rightAlign=Right Align
rightToLeft=Right to Left
rotate=Rotate
rotateTooltip=Click and drag to rotate, click to turn by 90 degrees
rotation=Rotation
rounded=Rounded
save=Save
saveAs=Save as
saved=Saved
scrollbars=Scrollbars
search=Search
searchShapes=Search Shapes
selectAll=Select All
selectEdges=Select Edges
selectFont=Select a Font
selectNone=Select None
selectVertices=Select Vertices
setAsDefaultStyle=Set as Default Style
shadow=Shadow
shape=Shape
sharp=Sharp
sidebarTooltip=Click to expand. Drag and drop shapes into the diagram. Shift+click to change selection. Alt+click to insert and connect.
simple=Simple
simpleArrow=Simple Arrow
size=Size
solid=Solid
sourceSpacing=Source Spacing
south=South
spacing=Spacing
straight=Straight
strokeColor=Line Color
style=Style
subscript=Subscript
superscript=Superscript
table=Table
targetSpacing=Target Spacing
text=Text
textAlignment=Text Alignment
textOpacity=Text Opacity
toBack=To Back
toFront=To Front
tooltips=Tooltips
top=Top
topAlign=Top Align
topLeft=Top Left
topRight=Top Right
transparent=Transparent
turn=Rotate 90°
uml=UML
underline=Underline
undo=Undo
ungroup=Ungroup
url=URL
untitledLayer=Untitled Layer
vertical=Vertical
verticalFlow=Vertical Flow
verticalTree=Vertical Tree
view=View
waypoints=Waypoints
west=West
width=Width
wordWrap=Word Wrap
writingDirection=Writing Direction
zoom=Zoom
zoomIn=Zoom In
zoomOut=Zoom Out`;

export const graphTxt = `askZoom=Enter zoom (%)
properties=Properties
outline=Outline
tasks=Tasks
help=Help`;

export const commonTxt = `alreadyConnected=Nodes already connected
containsValidationErrors=Contains validation errors
updatingDocument=Updating Document. Please wait...
updatingSelection=Updating Selection. Please wait...
collapse-expand=Collapse/Expand
doubleClickOrientation=Doubleclick to change orientation
close=Close
error=Error
done=Done
cancel=Cancel
ok=OK`;

export const defaultXml = `<mxStylesheet>
	<add as="defaultVertex">
		<add as="shape" value="label"/>
		<add as="perimeter" value="rectanglePerimeter"/>
		<add as="fontSize" value="12"/>
		<add as="fontFamily" value="Helvetica"/>
		<add as="align" value="center"/>
		<add as="verticalAlign" value="middle"/>
		<add as="fillColor" value="#ffffff"/>
		<add as="strokeColor" value="#000000"/>
		<add as="fontColor" value="#000000"/>
	</add>
	<add as="defaultEdge">
		<add as="shape" value="connector"/>
		<add as="labelBackgroundColor" value="#ffffff"/>
		<add as="endArrow" value="classic"/>
		<add as="fontSize" value="11"/>
		<add as="fontFamily" value="Helvetica"/>
		<add as="align" value="center"/>
		<add as="verticalAlign" value="middle"/>
		<add as="rounded" value="1"/>
		<add as="strokeColor" value="#000000"/>
		<add as="fontColor" value="#000000"/>
	</add>
	<add as="text">
		<add as="fillColor" value="none"/>
		<add as="gradientColor" value="none"/>
		<add as="strokeColor" value="none"/>
		<add as="align" value="left"/>
		<add as="verticalAlign" value="top"/>
	</add>
	<add as="label">
		<add as="fontStyle" value="1"/>
		<add as="align" value="left"/>
		<add as="verticalAlign" value="middle"/>
		<add as="spacing" value="2"/>
		<add as="spacingLeft" value="52"/>
		<add as="imageWidth" value="42"/>
		<add as="imageHeight" value="42"/>
		<add as="rounded" value="1"/>
	</add>
	<add as="icon" extend="label">
		<add as="align" value="center"/>
		<add as="imageAlign" value="center"/>
		<add as="verticalLabelPosition" value="bottom"/>
		<add as="verticalAlign" value="top"/>
		<add as="spacingTop" value="4"/>
		<add as="labelBackgroundColor" value="#ffffff"/>
		<add as="spacing" value="0"/>
		<add as="spacingLeft" value="0"/>
		<add as="spacingTop" value="6"/>
		<add as="fontStyle" value="0"/>
		<add as="imageWidth" value="48"/>
		<add as="imageHeight" value="48"/>
	</add>
	<add as="swimlane">
		<add as="shape" value="swimlane"/>
		<add as="fontSize" value="12"/>
		<add as="fontStyle" value="1"/>
		<add as="startSize" value="23"/>
	</add>
	<add as="group">
		<add as="verticalAlign" value="top"/>
		<add as="fillColor" value="none"/>
		<add as="strokeColor" value="none"/>
		<add as="gradientColor" value="none"/>
		<add as="pointerEvents" value="0"/>
	</add>
	<add as="ellipse">
		<add as="shape" value="ellipse"/>
		<add as="perimeter" value="ellipsePerimeter"/>
	</add>
	<add as="rhombus">
		<add as="shape" value="rhombus"/>
		<add as="perimeter" value="rhombusPerimeter"/>
	</add>
	<add as="triangle">
		<add as="shape" value="triangle"/>
		<add as="perimeter" value="trianglePerimeter"/>
	</add>
	<add as="line">
		<add as="shape" value="line"/>
		<add as="strokeWidth" value="4"/>
		<add as="labelBackgroundColor" value="#ffffff"/>
		<add as="verticalAlign" value="top"/>
		<add as="spacingTop" value="8"/>
	</add>
	<add as="image">
		<add as="shape" value="image"/>
		<add as="labelBackgroundColor" value="white"/>
		<add as="verticalAlign" value="top"/>
		<add as="verticalLabelPosition" value="bottom"/>
	</add>
	<add as="roundImage" extend="image">
		<add as="perimeter" value="ellipsePerimeter"/>
	</add>
	<add as="rhombusImage" extend="image">
		<add as="perimeter" value="rhombusPerimeter"/>
	</add>
	<add as="arrow">
		<add as="shape" value="arrow"/>
		<add as="edgeStyle" value="none"/>
		<add as="fillColor" value="#ffffff"/>
	</add>
</mxStylesheet>`;
