import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [mobileanalytics](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmobileanalytics.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Mobileanalytics extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    protected resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [mobileanalytics](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmobileanalytics.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grant access to financial metrics for an app
     *
     * Access Level: Read
     */
    getFinancialReports(): this;
    /**
     * Grant access to standard metrics for an app
     *
     * Access Level: Read
     */
    getReports(): this;
    /**
     * The PutEvents operation records one or more events
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mobileanalytics/latest/ug/PutEvents.html
     */
    putEvents(): this;
}
