import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [tag](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonresourcegrouptaggingapi.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Tag extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    protected resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [tag](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonresourcegrouptaggingapi.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Describe the status of the StartReportCreation operation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_DescribeReportCreation.html
     */
    describeReportCreation(): this;
    /**
     * Get a table that shows counts of resources that are noncompliant with their effective tag policies.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetComplianceSummary.html
     */
    getComplianceSummary(): this;
    /**
     * Get tagged AWS resources that match the given tag filters
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html
     */
    getResources(): this;
    /**
     * Get all tagKeys for the account in the specific region
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetTagKeys.html
     */
    getTagKeys(): this;
    /**
     * Get all tagValues for the account in the specific region
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetTagValues.html
     */
    getTagValues(): this;
    /**
     * Generate a report that lists all tagged resources in accounts across your organization, and whether each resource is compliant with the effective tag policy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_StartReportCreation.html
     */
    startReportCreation(): this;
    /**
     * Add tags to AWS resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_TagResources.html
     */
    tagResources(): this;
    /**
     * Remove tags from AWS resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_UntagResources.html
     */
    untagResources(): this;
}
