import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [account](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsaccounts.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Account extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    protected resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [account](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsaccounts.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to disable a region
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifTargetRegion()
     */
    disableRegion(): this;
    /**
     * Grants permission to enable a region
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifTargetRegion()
     */
    enableRegion(): this;
    /**
     * Grants permission to list regions
     *
     * Access Level: List
     */
    listRegions(): this;
    /**
     * Filters access by a list of regions
     *
     * Applies to actions:
     * - .disableRegion()
     * - .enableRegion()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTargetRegion(value: string | string[], operator?: string): this;
}
