import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [backup-storage](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsbackupstorage.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class BackupStorage extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    protected resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [backup-storage](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsbackupstorage.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Associates a KMS key to a backup vault
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CreateBackupVault.html
     */
    mountCapsule(): this;
}
