"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Servicecatalog = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [servicecatalog](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsservicecatalog.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Servicecatalog extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [servicecatalog](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsservicecatalog.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'servicecatalog';
        this.actionList = {
            "AcceptPortfolioShare": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AcceptPortfolioShare.html",
                "description": "Accepts a portfolio that has been shared with you",
                "accessLevel": "Write",
                "resourceTypes": {
                    "Portfolio": {
                        "required": true
                    }
                }
            },
            "AssociateBudgetWithResource": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociateBudgetWithResource.html",
                "description": "Associates a budget with a resource.",
                "accessLevel": "Write"
            },
            "AssociatePrincipalWithPortfolio": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociatePrincipalWithPortfolio.html",
                "description": "Associates an IAM principal with a portfolio, giving the specified principal access to any products associated with the specified portfolio",
                "accessLevel": "Write",
                "resourceTypes": {
                    "Portfolio": {
                        "required": true
                    }
                }
            },
            "AssociateProductWithPortfolio": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociateProductWithPortfolio.html",
                "description": "Associates a product with a portfolio",
                "accessLevel": "Write"
            },
            "AssociateServiceActionWithProvisioningArtifact": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociateServiceActionWithProvisioningArtifact.html",
                "description": "Associates an action with a provisioning artifact",
                "accessLevel": "Write",
                "resourceTypes": {
                    "Product": {
                        "required": true
                    }
                }
            },
            "AssociateTagOptionWithResource": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociateTagOptionWithResource.html",
                "description": "Associate the specified TagOption with the specified portfolio or product",
                "accessLevel": "Write",
                "resourceTypes": {
                    "Portfolio": {
                        "required": false
                    },
                    "Product": {
                        "required": false
                    }
                }
            },
            "BatchAssociateServiceActionWithProvisioningArtifact": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_BatchAssociateServiceActionWithProvisioningArtifact.html",
                "description": "Associates multiple self-service actions with provisioning artifacts.",
                "accessLevel": "Write"
            },
            "BatchDisassociateServiceActionFromProvisioningArtifact": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_BatchDisassociateServiceActionFromProvisioningArtifact.html",
                "description": "Disassociates a batch of self-service actions from the specified provisioning artifact.",
                "accessLevel": "Write"
            },
            "CopyProduct": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CopyProduct.html",
                "description": "Copies the specified source product to the specified target product or a new product.",
                "accessLevel": "Write"
            },
            "CreateConstraint": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateConstraint.html",
                "description": "Creates a constraint on an associated product and portfolio",
                "accessLevel": "Write",
                "resourceTypes": {
                    "Product": {
                        "required": true
                    }
                }
            },
            "CreatePortfolio": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreatePortfolio.html",
                "description": "Creates a portfolio",
                "accessLevel": "Write",
                "resourceTypes": {
                    "Portfolio": {
                        "required": true
                    }
                },
                "conditions": [
                    "aws:RequestTag/${TagKey}",
                    "aws:TagKeys"
                ]
            },
            "CreatePortfolioShare": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreatePortfolioShare.html",
                "description": "Shares a portfolio you own with another AWS account",
                "accessLevel": "Permissions management",
                "resourceTypes": {
                    "Portfolio": {
                        "required": true
                    }
                }
            },
            "CreateProduct": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateProduct.html",
                "description": "Creates a product and that product's first provisioning artifact",
                "accessLevel": "Write",
                "resourceTypes": {
                    "Product": {
                        "required": true
                    }
                },
                "conditions": [
                    "aws:RequestTag/${TagKey}",
                    "aws:TagKeys"
                ]
            },
            "CreateProvisionedProductPlan": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateProvisionedProductPlan.html",
                "description": "Adds a new provisioned product plan",
                "accessLevel": "Write"
            },
            "CreateProvisioningArtifact": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateProvisioningArtifact.html",
                "description": "Adds a new provisioning artifact to an existing product",
                "accessLevel": "Write",
                "resourceTypes": {
                    "Product": {
                        "required": true
                    }
                }
            },
            "CreateServiceAction": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateServiceAction.html",
                "description": "Creates a self-service action.",
                "accessLevel": "Write"
            },
            "CreateTagOption": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateTagOption.html",
                "description": "Creates a TagOption.",
                "accessLevel": "Write"
            },
            "DeleteConstraint": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteConstraint.html",
                "description": "Removes and deletes an existing constraint from an associated product and portfolio",
                "accessLevel": "Write"
            },
            "DeletePortfolio": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeletePortfolio.html",
                "description": "Deletes a portfolio if all associations and shares have been removed from the portfolio",
                "accessLevel": "Write",
                "resourceTypes": {
                    "Portfolio": {
                        "required": true
                    }
                }
            },
            "DeletePortfolioShare": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeletePortfolioShare.html",
                "description": "Unshares a portfolio you own from an AWS account you previously shared the portfolio with",
                "accessLevel": "Permissions management",
                "resourceTypes": {
                    "Portfolio": {
                        "required": true
                    }
                }
            },
            "DeleteProduct": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteProduct.html",
                "description": "Deletes a product if all associations have been removed from the product",
                "accessLevel": "Write",
                "resourceTypes": {
                    "Product": {
                        "required": true
                    }
                }
            },
            "DeleteProvisionedProductPlan": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteProvisionedProductPlan.html",
                "description": "Deletes a provisioned product plan",
                "accessLevel": "Write"
            },
            "DeleteProvisioningArtifact": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteProvisioningArtifact.html",
                "description": "Deletes a provisioning artifact from a product",
                "accessLevel": "Write",
                "resourceTypes": {
                    "Product": {
                        "required": true
                    }
                }
            },
            "DeleteServiceAction": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteServiceAction.html",
                "description": "Deletes a self-service action.",
                "accessLevel": "Write"
            },
            "DeleteTagOption": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteTagOption.html",
                "description": "Deletes the specified TagOption.",
                "accessLevel": "Write"
            },
            "DescribeConstraint": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeConstraint.html",
                "description": "Describes a constraint",
                "accessLevel": "Read"
            },
            "DescribeCopyProductStatus": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeCopyProductStatus.html",
                "description": "Gets the status of the specified copy product operation.",
                "accessLevel": "Read"
            },
            "DescribePortfolio": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribePortfolio.html",
                "description": "Describes a portfolio",
                "accessLevel": "Read",
                "resourceTypes": {
                    "Portfolio": {
                        "required": true
                    }
                }
            },
            "DescribePortfolioShareStatus": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribePortfolioShareStatus.html",
                "description": "Gets the status of the specified portfolio share operation.",
                "accessLevel": "Read"
            },
            "DescribeProduct": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProduct.html",
                "description": "Describes a product as an end-user",
                "accessLevel": "Read",
                "resourceTypes": {
                    "Product": {
                        "required": true
                    }
                }
            },
            "DescribeProductAsAdmin": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProductAsAdmin.html",
                "description": "Describes a product as an admin",
                "accessLevel": "Read",
                "resourceTypes": {
                    "Product": {
                        "required": true
                    }
                }
            },
            "DescribeProductView": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProductView.html",
                "description": "Describes a product as an end-user",
                "accessLevel": "Read"
            },
            "DescribeProvisionedProduct": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProvisionedProduct.html",
                "description": "Describes a provisioned product",
                "accessLevel": "Read"
            },
            "DescribeProvisionedProductPlan": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProvisionedProductPlan.html",
                "description": "Describes a provisioned product plan",
                "accessLevel": "Read"
            },
            "DescribeProvisioningArtifact": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProvisioningArtifact.html",
                "description": "Describes a provisioning artifact",
                "accessLevel": "Read",
                "resourceTypes": {
                    "Product": {
                        "required": true
                    }
                }
            },
            "DescribeProvisioningParameters": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProvisioningParameters.html",
                "description": "Describes the parameters that you need to specify to successfully provision a specified provisioning artifact",
                "accessLevel": "Read",
                "resourceTypes": {
                    "Product": {
                        "required": true
                    }
                }
            },
            "DescribeRecord": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeRecord.html",
                "description": "Describes a record and lists any outputs",
                "accessLevel": "Read",
                "conditions": [
                    "servicecatalog:accountLevel",
                    "servicecatalog:roleLevel",
                    "servicecatalog:userLevel"
                ]
            },
            "DescribeServiceAction": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeServiceAction.html",
                "description": "Describes a self-service action.",
                "accessLevel": "Read"
            },
            "DescribeServiceActionExecutionParameters": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeServiceActionExecutionParameters.html",
                "description": "Gets the default parameters if you executed the specified Service Action on the specified Provisioned Product.",
                "accessLevel": "Read"
            },
            "DescribeTagOption": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeTagOption.html",
                "description": "Gets information about the specified TagOption.",
                "accessLevel": "Read"
            },
            "DisableAWSOrganizationsAccess": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisableAWSOrganizationsAccess.html",
                "description": "Disable portfolio sharing through AWS Organizations feature.",
                "accessLevel": "Write"
            },
            "DisassociateBudgetFromResource": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociateBudgetFromResource.html",
                "description": "Disassociates a budget from a resource.",
                "accessLevel": "Write"
            },
            "DisassociatePrincipalFromPortfolio": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociatePrincipalFromPortfolio.html",
                "description": "Disassociates an IAM principal from a portfolio.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "Portfolio": {
                        "required": true
                    }
                }
            },
            "DisassociateProductFromPortfolio": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociateProductFromPortfolio.html",
                "description": "Disassociates a product from a portfolio",
                "accessLevel": "Write"
            },
            "DisassociateServiceActionFromProvisioningArtifact": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociateServiceActionFromProvisioningArtifact.html",
                "description": "Disassociates the specified self-service action association from the specified provisioning artifact.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "Product": {
                        "required": true
                    }
                }
            },
            "DisassociateTagOptionFromResource": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociateTagOptionFromResource.html",
                "description": "Disassociates the specified TagOption from the specified resource.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "Portfolio": {
                        "required": false
                    },
                    "Product": {
                        "required": false
                    }
                }
            },
            "EnableAWSOrganizationsAccess": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_EnableAWSOrganizationsAccess.html",
                "description": "Enable portfolio sharing feature through AWS Organizations.",
                "accessLevel": "Write"
            },
            "ExecuteProvisionedProductPlan": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ExecuteProvisionedProductPlan.html",
                "description": "Executes a provisioned product plan",
                "accessLevel": "Write"
            },
            "ExecuteProvisionedProductServiceAction": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ExecuteProvisionedProductServiceAction.html",
                "description": "Executes a provisioned product plan",
                "accessLevel": "Write"
            },
            "GetAWSOrganizationsAccessStatus": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_GetAWSOrganizationsAccessStatus.html",
                "description": "Get the Access Status for AWS Organization portfolio share feature.",
                "accessLevel": "Read"
            },
            "ListAcceptedPortfolioShares": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListAcceptedPortfolioShares.html",
                "description": "Lists the portfolios that have been shared with you and you have accepted",
                "accessLevel": "List"
            },
            "ListBudgetsForResource": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListBudgetsForResource.html",
                "description": "Lists all the budgets associated to a resource.",
                "accessLevel": "List"
            },
            "ListConstraintsForPortfolio": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListConstraintsForPortfolio.html",
                "description": "Lists constraints associated with a given portfolio",
                "accessLevel": "List"
            },
            "ListLaunchPaths": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListLaunchPaths.html",
                "description": "Lists the different ways to launch a given product as an end-user",
                "accessLevel": "List",
                "resourceTypes": {
                    "Product": {
                        "required": true
                    }
                }
            },
            "ListOrganizationPortfolioAccess": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListOrganizationPortfolioAccess.html",
                "description": "Lists the organization nodes that have access to the specified portfolio.",
                "accessLevel": "List"
            },
            "ListPortfolioAccess": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListPortfolioAccess.html",
                "description": "Lists the AWS accounts you have shared a given portfolio with",
                "accessLevel": "List",
                "resourceTypes": {
                    "Portfolio": {
                        "required": true
                    }
                }
            },
            "ListPortfolios": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListPortfolios.html",
                "description": "Lists the portfolios in your account",
                "accessLevel": "List"
            },
            "ListPortfoliosForProduct": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListPortfoliosForProduct.html",
                "description": "Lists the portfolios associated with a given product",
                "accessLevel": "List",
                "resourceTypes": {
                    "Product": {
                        "required": true
                    }
                }
            },
            "ListPrincipalsForPortfolio": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListPrincipalsForPortfolio.html",
                "description": "Lists the IAM principals associated with a given portfolio",
                "accessLevel": "List",
                "resourceTypes": {
                    "Portfolio": {
                        "required": true
                    }
                }
            },
            "ListProvisionedProductPlans": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListProvisionedProductPlans.html",
                "description": "Lists the provisioned product plans",
                "accessLevel": "List"
            },
            "ListProvisioningArtifacts": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListProvisioningArtifacts.html",
                "description": "Lists the provisioning artifacts associated with a given product",
                "accessLevel": "List",
                "resourceTypes": {
                    "Product": {
                        "required": true
                    }
                }
            },
            "ListProvisioningArtifactsForServiceAction": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListProvisioningArtifactsForServiceAction.html",
                "description": "Lists all provisioning artifacts for the specified self-service action.",
                "accessLevel": "List"
            },
            "ListRecordHistory": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListRecordHistory.html",
                "description": "Lists all the records in your account or all the records related to a given provisioned product",
                "accessLevel": "List",
                "conditions": [
                    "servicecatalog:accountLevel",
                    "servicecatalog:roleLevel",
                    "servicecatalog:userLevel"
                ]
            },
            "ListResourcesForTagOption": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListResourcesForTagOption.html",
                "description": "Lists the resources associated with the specified TagOption.",
                "accessLevel": "List"
            },
            "ListServiceActions": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListServiceActions.html",
                "description": "Lists all self-service actions.",
                "accessLevel": "List"
            },
            "ListServiceActionsForProvisioningArtifact": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListServiceActionsForProvisioningArtifact.html",
                "description": "Lists all the service actions associated with the specified provisioning artifact in your account",
                "accessLevel": "List",
                "resourceTypes": {
                    "Product": {
                        "required": true
                    }
                }
            },
            "ListStackInstancesForProvisionedProduct": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListStackInstancesForProvisionedProduct.html",
                "description": "Lists account, region and status of each stack instances that are associated with a CFN_STACKSET type provisioned product",
                "accessLevel": "List"
            },
            "ListTagOptions": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListTagOptions.html",
                "description": "Lists the specified TagOptions or all TagOptions.",
                "accessLevel": "List"
            },
            "ProvisionProduct": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProvisionProduct.html",
                "description": "Provisions a product with a specified provisioning artifact and launch parameters",
                "accessLevel": "Write",
                "resourceTypes": {
                    "Product": {
                        "required": true
                    }
                }
            },
            "RejectPortfolioShare": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_RejectPortfolioShare.html",
                "description": "Rejects a portfolio that has been shared with you that you previously accepted",
                "accessLevel": "Write",
                "resourceTypes": {
                    "Portfolio": {
                        "required": true
                    }
                }
            },
            "ScanProvisionedProducts": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ScanProvisionedProducts.html",
                "description": "Lists all the provisioned products in your account",
                "accessLevel": "List",
                "conditions": [
                    "servicecatalog:accountLevel",
                    "servicecatalog:roleLevel",
                    "servicecatalog:userLevel"
                ]
            },
            "SearchProducts": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_SearchProducts.html",
                "description": "Lists the products available to you as an end-user",
                "accessLevel": "List"
            },
            "SearchProductsAsAdmin": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_SearchProductsAsAdmin.html",
                "description": "Lists all the products in your account or all the products associated with a given portfolio",
                "accessLevel": "List"
            },
            "SearchProvisionedProducts": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_SearchProvisionedProducts.html",
                "description": "Lists all the provisioned products in your account",
                "accessLevel": "List",
                "conditions": [
                    "servicecatalog:accountLevel",
                    "servicecatalog:roleLevel",
                    "servicecatalog:userLevel"
                ]
            },
            "TerminateProvisionedProduct": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_TerminateProvisionedProduct.html",
                "description": "Terminates an existing provisioned product",
                "accessLevel": "Write",
                "conditions": [
                    "servicecatalog:accountLevel",
                    "servicecatalog:roleLevel",
                    "servicecatalog:userLevel"
                ]
            },
            "UpdateConstraint": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateConstraint.html",
                "description": "Updates the metadata fields of an existing constraint",
                "accessLevel": "Write"
            },
            "UpdatePortfolio": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdatePortfolio.html",
                "description": "Updates the metadata fields and/or tags of an existing portfolio",
                "accessLevel": "Write",
                "resourceTypes": {
                    "Portfolio": {
                        "required": true
                    }
                },
                "conditions": [
                    "aws:RequestTag/${TagKey}",
                    "aws:TagKeys"
                ]
            },
            "UpdateProduct": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateProduct.html",
                "description": "Updates the metadata fields and/or tags of an existing product",
                "accessLevel": "Write",
                "resourceTypes": {
                    "Product": {
                        "required": true
                    }
                },
                "conditions": [
                    "aws:RequestTag/${TagKey}",
                    "aws:TagKeys"
                ]
            },
            "UpdateProvisionedProduct": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateProvisionedProduct.html",
                "description": "Updates an existing provisioned product",
                "accessLevel": "Write",
                "conditions": [
                    "servicecatalog:accountLevel",
                    "servicecatalog:roleLevel",
                    "servicecatalog:userLevel"
                ]
            },
            "UpdateProvisionedProductProperties": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateProvisionedProductProperties.html",
                "description": "Updates the properties of an existing provisioned product",
                "accessLevel": "Write"
            },
            "UpdateProvisioningArtifact": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateProvisioningArtifact.html",
                "description": "Updates the metadata fields of an existing provisioning artifact",
                "accessLevel": "Write",
                "resourceTypes": {
                    "Product": {
                        "required": true
                    }
                }
            },
            "UpdateServiceAction": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateServiceAction.html",
                "description": "Updates a self-service action.",
                "accessLevel": "Write"
            },
            "UpdateTagOption": {
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateTagOption.html",
                "description": "Updates the specified TagOption.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {
            "Portfolio": {
                "name": "Portfolio",
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_PortfolioDetail.html",
                "arn": "arn:${Partition}:catalog:${Region}:${Account}:portfolio/${PortfolioId}",
                "conditionKeys": [
                    "aws:ResourceTag/${TagKey}"
                ]
            },
            "Product": {
                "name": "Product",
                "url": "https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProductViewDetail.html",
                "arn": "arn:${Partition}:catalog:${Region}:${Account}:product/${ProductId}",
                "conditionKeys": [
                    "aws:ResourceTag/${TagKey}"
                ]
            }
        };
    }
    /**
     * Accepts a portfolio that has been shared with you
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AcceptPortfolioShare.html
     */
    acceptPortfolioShare() {
        this.add('servicecatalog:AcceptPortfolioShare');
        return this;
    }
    /**
     * Associates a budget with a resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociateBudgetWithResource.html
     */
    associateBudgetWithResource() {
        this.add('servicecatalog:AssociateBudgetWithResource');
        return this;
    }
    /**
     * Associates an IAM principal with a portfolio, giving the specified principal access to any products associated with the specified portfolio
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociatePrincipalWithPortfolio.html
     */
    associatePrincipalWithPortfolio() {
        this.add('servicecatalog:AssociatePrincipalWithPortfolio');
        return this;
    }
    /**
     * Associates a product with a portfolio
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociateProductWithPortfolio.html
     */
    associateProductWithPortfolio() {
        this.add('servicecatalog:AssociateProductWithPortfolio');
        return this;
    }
    /**
     * Associates an action with a provisioning artifact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociateServiceActionWithProvisioningArtifact.html
     */
    associateServiceActionWithProvisioningArtifact() {
        this.add('servicecatalog:AssociateServiceActionWithProvisioningArtifact');
        return this;
    }
    /**
     * Associate the specified TagOption with the specified portfolio or product
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_AssociateTagOptionWithResource.html
     */
    associateTagOptionWithResource() {
        this.add('servicecatalog:AssociateTagOptionWithResource');
        return this;
    }
    /**
     * Associates multiple self-service actions with provisioning artifacts.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_BatchAssociateServiceActionWithProvisioningArtifact.html
     */
    batchAssociateServiceActionWithProvisioningArtifact() {
        this.add('servicecatalog:BatchAssociateServiceActionWithProvisioningArtifact');
        return this;
    }
    /**
     * Disassociates a batch of self-service actions from the specified provisioning artifact.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_BatchDisassociateServiceActionFromProvisioningArtifact.html
     */
    batchDisassociateServiceActionFromProvisioningArtifact() {
        this.add('servicecatalog:BatchDisassociateServiceActionFromProvisioningArtifact');
        return this;
    }
    /**
     * Copies the specified source product to the specified target product or a new product.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CopyProduct.html
     */
    copyProduct() {
        this.add('servicecatalog:CopyProduct');
        return this;
    }
    /**
     * Creates a constraint on an associated product and portfolio
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateConstraint.html
     */
    createConstraint() {
        this.add('servicecatalog:CreateConstraint');
        return this;
    }
    /**
     * Creates a portfolio
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreatePortfolio.html
     */
    createPortfolio() {
        this.add('servicecatalog:CreatePortfolio');
        return this;
    }
    /**
     * Shares a portfolio you own with another AWS account
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreatePortfolioShare.html
     */
    createPortfolioShare() {
        this.add('servicecatalog:CreatePortfolioShare');
        return this;
    }
    /**
     * Creates a product and that product's first provisioning artifact
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateProduct.html
     */
    createProduct() {
        this.add('servicecatalog:CreateProduct');
        return this;
    }
    /**
     * Adds a new provisioned product plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateProvisionedProductPlan.html
     */
    createProvisionedProductPlan() {
        this.add('servicecatalog:CreateProvisionedProductPlan');
        return this;
    }
    /**
     * Adds a new provisioning artifact to an existing product
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateProvisioningArtifact.html
     */
    createProvisioningArtifact() {
        this.add('servicecatalog:CreateProvisioningArtifact');
        return this;
    }
    /**
     * Creates a self-service action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateServiceAction.html
     */
    createServiceAction() {
        this.add('servicecatalog:CreateServiceAction');
        return this;
    }
    /**
     * Creates a TagOption.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateTagOption.html
     */
    createTagOption() {
        this.add('servicecatalog:CreateTagOption');
        return this;
    }
    /**
     * Removes and deletes an existing constraint from an associated product and portfolio
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteConstraint.html
     */
    deleteConstraint() {
        this.add('servicecatalog:DeleteConstraint');
        return this;
    }
    /**
     * Deletes a portfolio if all associations and shares have been removed from the portfolio
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeletePortfolio.html
     */
    deletePortfolio() {
        this.add('servicecatalog:DeletePortfolio');
        return this;
    }
    /**
     * Unshares a portfolio you own from an AWS account you previously shared the portfolio with
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeletePortfolioShare.html
     */
    deletePortfolioShare() {
        this.add('servicecatalog:DeletePortfolioShare');
        return this;
    }
    /**
     * Deletes a product if all associations have been removed from the product
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteProduct.html
     */
    deleteProduct() {
        this.add('servicecatalog:DeleteProduct');
        return this;
    }
    /**
     * Deletes a provisioned product plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteProvisionedProductPlan.html
     */
    deleteProvisionedProductPlan() {
        this.add('servicecatalog:DeleteProvisionedProductPlan');
        return this;
    }
    /**
     * Deletes a provisioning artifact from a product
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteProvisioningArtifact.html
     */
    deleteProvisioningArtifact() {
        this.add('servicecatalog:DeleteProvisioningArtifact');
        return this;
    }
    /**
     * Deletes a self-service action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteServiceAction.html
     */
    deleteServiceAction() {
        this.add('servicecatalog:DeleteServiceAction');
        return this;
    }
    /**
     * Deletes the specified TagOption.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DeleteTagOption.html
     */
    deleteTagOption() {
        this.add('servicecatalog:DeleteTagOption');
        return this;
    }
    /**
     * Describes a constraint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeConstraint.html
     */
    describeConstraint() {
        this.add('servicecatalog:DescribeConstraint');
        return this;
    }
    /**
     * Gets the status of the specified copy product operation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeCopyProductStatus.html
     */
    describeCopyProductStatus() {
        this.add('servicecatalog:DescribeCopyProductStatus');
        return this;
    }
    /**
     * Describes a portfolio
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribePortfolio.html
     */
    describePortfolio() {
        this.add('servicecatalog:DescribePortfolio');
        return this;
    }
    /**
     * Gets the status of the specified portfolio share operation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribePortfolioShareStatus.html
     */
    describePortfolioShareStatus() {
        this.add('servicecatalog:DescribePortfolioShareStatus');
        return this;
    }
    /**
     * Describes a product as an end-user
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProduct.html
     */
    describeProduct() {
        this.add('servicecatalog:DescribeProduct');
        return this;
    }
    /**
     * Describes a product as an admin
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProductAsAdmin.html
     */
    describeProductAsAdmin() {
        this.add('servicecatalog:DescribeProductAsAdmin');
        return this;
    }
    /**
     * Describes a product as an end-user
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProductView.html
     */
    describeProductView() {
        this.add('servicecatalog:DescribeProductView');
        return this;
    }
    /**
     * Describes a provisioned product
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProvisionedProduct.html
     */
    describeProvisionedProduct() {
        this.add('servicecatalog:DescribeProvisionedProduct');
        return this;
    }
    /**
     * Describes a provisioned product plan
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProvisionedProductPlan.html
     */
    describeProvisionedProductPlan() {
        this.add('servicecatalog:DescribeProvisionedProductPlan');
        return this;
    }
    /**
     * Describes a provisioning artifact
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProvisioningArtifact.html
     */
    describeProvisioningArtifact() {
        this.add('servicecatalog:DescribeProvisioningArtifact');
        return this;
    }
    /**
     * Describes the parameters that you need to specify to successfully provision a specified provisioning artifact
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeProvisioningParameters.html
     */
    describeProvisioningParameters() {
        this.add('servicecatalog:DescribeProvisioningParameters');
        return this;
    }
    /**
     * Describes a record and lists any outputs
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeRecord.html
     */
    describeRecord() {
        this.add('servicecatalog:DescribeRecord');
        return this;
    }
    /**
     * Describes a self-service action.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeServiceAction.html
     */
    describeServiceAction() {
        this.add('servicecatalog:DescribeServiceAction');
        return this;
    }
    /**
     * Gets the default parameters if you executed the specified Service Action on the specified Provisioned Product.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeServiceActionExecutionParameters.html
     */
    describeServiceActionExecutionParameters() {
        this.add('servicecatalog:DescribeServiceActionExecutionParameters');
        return this;
    }
    /**
     * Gets information about the specified TagOption.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DescribeTagOption.html
     */
    describeTagOption() {
        this.add('servicecatalog:DescribeTagOption');
        return this;
    }
    /**
     * Disable portfolio sharing through AWS Organizations feature.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisableAWSOrganizationsAccess.html
     */
    disableAWSOrganizationsAccess() {
        this.add('servicecatalog:DisableAWSOrganizationsAccess');
        return this;
    }
    /**
     * Disassociates a budget from a resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociateBudgetFromResource.html
     */
    disassociateBudgetFromResource() {
        this.add('servicecatalog:DisassociateBudgetFromResource');
        return this;
    }
    /**
     * Disassociates an IAM principal from a portfolio.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociatePrincipalFromPortfolio.html
     */
    disassociatePrincipalFromPortfolio() {
        this.add('servicecatalog:DisassociatePrincipalFromPortfolio');
        return this;
    }
    /**
     * Disassociates a product from a portfolio
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociateProductFromPortfolio.html
     */
    disassociateProductFromPortfolio() {
        this.add('servicecatalog:DisassociateProductFromPortfolio');
        return this;
    }
    /**
     * Disassociates the specified self-service action association from the specified provisioning artifact.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociateServiceActionFromProvisioningArtifact.html
     */
    disassociateServiceActionFromProvisioningArtifact() {
        this.add('servicecatalog:DisassociateServiceActionFromProvisioningArtifact');
        return this;
    }
    /**
     * Disassociates the specified TagOption from the specified resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_DisassociateTagOptionFromResource.html
     */
    disassociateTagOptionFromResource() {
        this.add('servicecatalog:DisassociateTagOptionFromResource');
        return this;
    }
    /**
     * Enable portfolio sharing feature through AWS Organizations.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_EnableAWSOrganizationsAccess.html
     */
    enableAWSOrganizationsAccess() {
        this.add('servicecatalog:EnableAWSOrganizationsAccess');
        return this;
    }
    /**
     * Executes a provisioned product plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ExecuteProvisionedProductPlan.html
     */
    executeProvisionedProductPlan() {
        this.add('servicecatalog:ExecuteProvisionedProductPlan');
        return this;
    }
    /**
     * Executes a provisioned product plan
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ExecuteProvisionedProductServiceAction.html
     */
    executeProvisionedProductServiceAction() {
        this.add('servicecatalog:ExecuteProvisionedProductServiceAction');
        return this;
    }
    /**
     * Get the Access Status for AWS Organization portfolio share feature.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_GetAWSOrganizationsAccessStatus.html
     */
    getAWSOrganizationsAccessStatus() {
        this.add('servicecatalog:GetAWSOrganizationsAccessStatus');
        return this;
    }
    /**
     * Lists the portfolios that have been shared with you and you have accepted
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListAcceptedPortfolioShares.html
     */
    listAcceptedPortfolioShares() {
        this.add('servicecatalog:ListAcceptedPortfolioShares');
        return this;
    }
    /**
     * Lists all the budgets associated to a resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListBudgetsForResource.html
     */
    listBudgetsForResource() {
        this.add('servicecatalog:ListBudgetsForResource');
        return this;
    }
    /**
     * Lists constraints associated with a given portfolio
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListConstraintsForPortfolio.html
     */
    listConstraintsForPortfolio() {
        this.add('servicecatalog:ListConstraintsForPortfolio');
        return this;
    }
    /**
     * Lists the different ways to launch a given product as an end-user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListLaunchPaths.html
     */
    listLaunchPaths() {
        this.add('servicecatalog:ListLaunchPaths');
        return this;
    }
    /**
     * Lists the organization nodes that have access to the specified portfolio.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListOrganizationPortfolioAccess.html
     */
    listOrganizationPortfolioAccess() {
        this.add('servicecatalog:ListOrganizationPortfolioAccess');
        return this;
    }
    /**
     * Lists the AWS accounts you have shared a given portfolio with
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListPortfolioAccess.html
     */
    listPortfolioAccess() {
        this.add('servicecatalog:ListPortfolioAccess');
        return this;
    }
    /**
     * Lists the portfolios in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListPortfolios.html
     */
    listPortfolios() {
        this.add('servicecatalog:ListPortfolios');
        return this;
    }
    /**
     * Lists the portfolios associated with a given product
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListPortfoliosForProduct.html
     */
    listPortfoliosForProduct() {
        this.add('servicecatalog:ListPortfoliosForProduct');
        return this;
    }
    /**
     * Lists the IAM principals associated with a given portfolio
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListPrincipalsForPortfolio.html
     */
    listPrincipalsForPortfolio() {
        this.add('servicecatalog:ListPrincipalsForPortfolio');
        return this;
    }
    /**
     * Lists the provisioned product plans
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListProvisionedProductPlans.html
     */
    listProvisionedProductPlans() {
        this.add('servicecatalog:ListProvisionedProductPlans');
        return this;
    }
    /**
     * Lists the provisioning artifacts associated with a given product
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListProvisioningArtifacts.html
     */
    listProvisioningArtifacts() {
        this.add('servicecatalog:ListProvisioningArtifacts');
        return this;
    }
    /**
     * Lists all provisioning artifacts for the specified self-service action.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListProvisioningArtifactsForServiceAction.html
     */
    listProvisioningArtifactsForServiceAction() {
        this.add('servicecatalog:ListProvisioningArtifactsForServiceAction');
        return this;
    }
    /**
     * Lists all the records in your account or all the records related to a given provisioned product
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListRecordHistory.html
     */
    listRecordHistory() {
        this.add('servicecatalog:ListRecordHistory');
        return this;
    }
    /**
     * Lists the resources associated with the specified TagOption.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListResourcesForTagOption.html
     */
    listResourcesForTagOption() {
        this.add('servicecatalog:ListResourcesForTagOption');
        return this;
    }
    /**
     * Lists all self-service actions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListServiceActions.html
     */
    listServiceActions() {
        this.add('servicecatalog:ListServiceActions');
        return this;
    }
    /**
     * Lists all the service actions associated with the specified provisioning artifact in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListServiceActionsForProvisioningArtifact.html
     */
    listServiceActionsForProvisioningArtifact() {
        this.add('servicecatalog:ListServiceActionsForProvisioningArtifact');
        return this;
    }
    /**
     * Lists account, region and status of each stack instances that are associated with a CFN_STACKSET type provisioned product
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListStackInstancesForProvisionedProduct.html
     */
    listStackInstancesForProvisionedProduct() {
        this.add('servicecatalog:ListStackInstancesForProvisionedProduct');
        return this;
    }
    /**
     * Lists the specified TagOptions or all TagOptions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListTagOptions.html
     */
    listTagOptions() {
        this.add('servicecatalog:ListTagOptions');
        return this;
    }
    /**
     * Provisions a product with a specified provisioning artifact and launch parameters
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProvisionProduct.html
     */
    provisionProduct() {
        this.add('servicecatalog:ProvisionProduct');
        return this;
    }
    /**
     * Rejects a portfolio that has been shared with you that you previously accepted
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_RejectPortfolioShare.html
     */
    rejectPortfolioShare() {
        this.add('servicecatalog:RejectPortfolioShare');
        return this;
    }
    /**
     * Lists all the provisioned products in your account
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ScanProvisionedProducts.html
     */
    scanProvisionedProducts() {
        this.add('servicecatalog:ScanProvisionedProducts');
        return this;
    }
    /**
     * Lists the products available to you as an end-user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_SearchProducts.html
     */
    searchProducts() {
        this.add('servicecatalog:SearchProducts');
        return this;
    }
    /**
     * Lists all the products in your account or all the products associated with a given portfolio
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_SearchProductsAsAdmin.html
     */
    searchProductsAsAdmin() {
        this.add('servicecatalog:SearchProductsAsAdmin');
        return this;
    }
    /**
     * Lists all the provisioned products in your account
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_SearchProvisionedProducts.html
     */
    searchProvisionedProducts() {
        this.add('servicecatalog:SearchProvisionedProducts');
        return this;
    }
    /**
     * Terminates an existing provisioned product
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_TerminateProvisionedProduct.html
     */
    terminateProvisionedProduct() {
        this.add('servicecatalog:TerminateProvisionedProduct');
        return this;
    }
    /**
     * Updates the metadata fields of an existing constraint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateConstraint.html
     */
    updateConstraint() {
        this.add('servicecatalog:UpdateConstraint');
        return this;
    }
    /**
     * Updates the metadata fields and/or tags of an existing portfolio
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdatePortfolio.html
     */
    updatePortfolio() {
        this.add('servicecatalog:UpdatePortfolio');
        return this;
    }
    /**
     * Updates the metadata fields and/or tags of an existing product
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateProduct.html
     */
    updateProduct() {
        this.add('servicecatalog:UpdateProduct');
        return this;
    }
    /**
     * Updates an existing provisioned product
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAccountLevel()
     * - .ifRoleLevel()
     * - .ifUserLevel()
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateProvisionedProduct.html
     */
    updateProvisionedProduct() {
        this.add('servicecatalog:UpdateProvisionedProduct');
        return this;
    }
    /**
     * Updates the properties of an existing provisioned product
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateProvisionedProductProperties.html
     */
    updateProvisionedProductProperties() {
        this.add('servicecatalog:UpdateProvisionedProductProperties');
        return this;
    }
    /**
     * Updates the metadata fields of an existing provisioning artifact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateProvisioningArtifact.html
     */
    updateProvisioningArtifact() {
        this.add('servicecatalog:UpdateProvisioningArtifact');
        return this;
    }
    /**
     * Updates a self-service action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateServiceAction.html
     */
    updateServiceAction() {
        this.add('servicecatalog:UpdateServiceAction');
        return this;
    }
    /**
     * Updates the specified TagOption.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_UpdateTagOption.html
     */
    updateTagOption() {
        this.add('servicecatalog:UpdateTagOption');
        return this;
    }
    /**
     * Adds a resource of type Portfolio to the statement
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_PortfolioDetail.html
     *
     * @param portfolioId - Identifier for the portfolioId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPortfolio(portfolioId, account, region, partition) {
        var arn = 'arn:${Partition}:catalog:${Region}:${Account}:portfolio/${PortfolioId}';
        arn = arn.replace('${PortfolioId}', portfolioId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type Product to the statement
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProductViewDetail.html
     *
     * @param productId - Identifier for the productId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProduct(productId, account, region, partition) {
        var arn = 'arn:${Partition}:catalog:${Region}:${Account}:product/${ProductId}';
        arn = arn.replace('${ProductId}', productId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Filters actions based on the presence of tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .createPortfolio()
     * - .createProduct()
     * - .updatePortfolio()
     * - .updateProduct()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey, value, operator) {
        return this.if(`aws:RequestTag/${tagKey}`, value, operator || 'StringLike');
    }
    /**
     * Filters actions based on tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - Portfolio
     * - Product
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey, value, operator) {
        return this.if(`aws:ResourceTag/${tagKey}`, value, operator || 'StringLike');
    }
    /**
     * Filters actions based on the presence of tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .createPortfolio()
     * - .createProduct()
     * - .updatePortfolio()
     * - .updateProduct()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value, operator) {
        return this.if(`aws:TagKeys`, value, operator || 'StringLike');
    }
    /**
     * Allows users to see and perform actions on resources created by anyone in the account.
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/adminguide/permissions-examples.html
     *
     * Applies to actions:
     * - .describeRecord()
     * - .listRecordHistory()
     * - .scanProvisionedProducts()
     * - .searchProvisionedProducts()
     * - .terminateProvisionedProduct()
     * - .updateProvisionedProduct()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAccountLevel(value, operator) {
        return this.if(`servicecatalog:accountLevel`, value, operator || 'StringLike');
    }
    /**
     * Allows users to see and perform actions on resources created either by them or by anyone federating into the same role as them.
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/adminguide/permissions-examples.html
     *
     * Applies to actions:
     * - .describeRecord()
     * - .listRecordHistory()
     * - .scanProvisionedProducts()
     * - .searchProvisionedProducts()
     * - .terminateProvisionedProduct()
     * - .updateProvisionedProduct()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRoleLevel(value, operator) {
        return this.if(`servicecatalog:roleLevel`, value, operator || 'StringLike');
    }
    /**
     * Allows users to see and perform actions on only resources that they created.
     *
     * https://docs.aws.amazon.com/servicecatalog/latest/adminguide/permissions-examples.html
     *
     * Applies to actions:
     * - .describeRecord()
     * - .listRecordHistory()
     * - .scanProvisionedProducts()
     * - .searchProvisionedProducts()
     * - .terminateProvisionedProduct()
     * - .updateProvisionedProduct()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifUserLevel(value, operator) {
        return this.if(`servicecatalog:userLevel`, value, operator || 'StringLike');
    }
}
exports.Servicecatalog = Servicecatalog;
//# sourceMappingURL=data:application/json;base64,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