"use strict";
// This file is used in the base variant of the package: iam-floyd
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementBase = void 0;
/**
 * Base class for the Policy Statement
 */
class PolicyStatementBase {
    constructor(sid) {
        this.sid = '';
        /**
         * Holds the prefix of the service actions, e.g. `ec2`
         */
        this.servicePrefix = '';
        if (typeof sid !== 'undefined') {
            this.sid = sid;
        }
    }
    /**
     * JSON-ify the policy statement
     *
     * Used when JSON.stringify() is called
     */
    toJSON() {
        const statement = {};
        if (this.sid.length) {
            statement.Sid = this.sid;
        }
        return statement;
    }
}
exports.PolicyStatementBase = PolicyStatementBase;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMS1iYXNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiMS1iYXNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSxrRUFBa0U7OztBQUVsRTs7R0FFRztBQUNILE1BQWEsbUJBQW1CO0lBUTlCLFlBQVksR0FBWTtRQVBqQixRQUFHLEdBQUcsRUFBRSxDQUFDO1FBRWhCOztXQUVHO1FBQ08sa0JBQWEsR0FBRyxFQUFFLENBQUM7UUFHM0IsSUFBSSxPQUFPLEdBQUcsS0FBSyxXQUFXLEVBQUU7WUFDOUIsSUFBSSxDQUFDLEdBQUcsR0FBRyxHQUFHLENBQUM7U0FDaEI7SUFDSCxDQUFDO0lBRUQ7Ozs7T0FJRztJQUVJLE1BQU07UUFDWCxNQUFNLFNBQVMsR0FBUSxFQUFFLENBQUM7UUFFMUIsSUFBSSxJQUFJLENBQUMsR0FBRyxDQUFDLE1BQU0sRUFBRTtZQUNuQixTQUFTLENBQUMsR0FBRyxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUM7U0FDMUI7UUFFRCxPQUFPLFNBQVMsQ0FBQztJQUNuQixDQUFDO0NBQ0Y7QUE3QkQsa0RBNkJDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gVGhpcyBmaWxlIGlzIHVzZWQgaW4gdGhlIGJhc2UgdmFyaWFudCBvZiB0aGUgcGFja2FnZTogaWFtLWZsb3lkXG5cbi8qKlxuICogQmFzZSBjbGFzcyBmb3IgdGhlIFBvbGljeSBTdGF0ZW1lbnRcbiAqL1xuZXhwb3J0IGNsYXNzIFBvbGljeVN0YXRlbWVudEJhc2Uge1xuICBwdWJsaWMgc2lkID0gJyc7XG5cbiAgLyoqXG4gICAqIEhvbGRzIHRoZSBwcmVmaXggb2YgdGhlIHNlcnZpY2UgYWN0aW9ucywgZS5nLiBgZWMyYFxuICAgKi9cbiAgcHJvdGVjdGVkIHNlcnZpY2VQcmVmaXggPSAnJztcblxuICBjb25zdHJ1Y3RvcihzaWQ/OiBzdHJpbmcpIHtcbiAgICBpZiAodHlwZW9mIHNpZCAhPT0gJ3VuZGVmaW5lZCcpIHtcbiAgICAgIHRoaXMuc2lkID0gc2lkO1xuICAgIH1cbiAgfVxuXG4gIC8qKlxuICAgKiBKU09OLWlmeSB0aGUgcG9saWN5IHN0YXRlbWVudFxuICAgKlxuICAgKiBVc2VkIHdoZW4gSlNPTi5zdHJpbmdpZnkoKSBpcyBjYWxsZWRcbiAgICovXG5cbiAgcHVibGljIHRvSlNPTigpOiBhbnkge1xuICAgIGNvbnN0IHN0YXRlbWVudDogYW55ID0ge307XG5cbiAgICBpZiAodGhpcy5zaWQubGVuZ3RoKSB7XG4gICAgICBzdGF0ZW1lbnQuU2lkID0gdGhpcy5zaWQ7XG4gICAgfVxuXG4gICAgcmV0dXJuIHN0YXRlbWVudDtcbiAgfVxufVxuIl19