// asn1hex-1.2.8.js (c) 2012-2020 Kenji Urushima | kjur.github.com/jsrsasign/license

import BigInteger from "./jsbn.min.js"

var ASN1HEX=new function(){};ASN1HEX.getLblen=function(t,n){if("8"!=t.substr(n+2,1))return 1;var r=parseInt(t.substr(n+3,1));return 0==r?-1:0<r&&r<10?r+1:-2},ASN1HEX.getL=function(t,n){var r=ASN1HEX.getLblen(t,n);return r<1?"":t.substr(n+2,2*r)},ASN1HEX.getVblen=function(t,n){var r;return""==(r=ASN1HEX.getL(t,n))?-1:("8"===r.substr(0,1)?new BigInteger(r.substr(2),16):new BigInteger(r,16)).intValue()},ASN1HEX.getVidx=function(t,n){var r=ASN1HEX.getLblen(t,n);return r<0?r:n+2*(r+1)},ASN1HEX.getV=function(t,n){var r=ASN1HEX.getVidx(t,n),e=ASN1HEX.getVblen(t,n);return t.substr(r,2*e)},ASN1HEX.getTLV=function(t,n){return t.substr(n,2)+ASN1HEX.getL(t,n)+ASN1HEX.getV(t,n)},ASN1HEX.getTLVblen=function(t,n){return 2+2*ASN1HEX.getLblen(t,n)+2*ASN1HEX.getVblen(t,n)},ASN1HEX.getNextSiblingIdx=function(t,n){return ASN1HEX.getVidx(t,n)+2*ASN1HEX.getVblen(t,n)},ASN1HEX.getChildIdx=function(t,n){var r,e,i,u=ASN1HEX,g=[];r=u.getVidx(t,n),e=2*u.getVblen(t,n),"03"==t.substr(n,2)&&(r+=2,e-=2),i=0;for(var s=r;i<=e;){var o=u.getTLVblen(t,s);if((i+=o)<=e&&g.push(s),s+=o,i>=e)break}return g},ASN1HEX.getNthChildIdx=function(t,n,r){return ASN1HEX.getChildIdx(t,n)[r]},ASN1HEX.getIdxbyList=function(t,n,r,e){var i,u,g=ASN1HEX;return 0==r.length?void 0!==e&&t.substr(n,2)!==e?-1:n:(i=r.shift())>=(u=g.getChildIdx(t,n)).length?-1:g.getIdxbyList(t,u[i],r,e)},ASN1HEX.getIdxbyListEx=function(t,n,r,e){var i,u,g=ASN1HEX;if(0==r.length)return void 0!==e&&t.substr(n,2)!==e?-1:n;i=r.shift(),u=g.getChildIdx(t,n);for(var s=0,o=0;o<u.length;o++){var a=t.substr(u[o],2);if("number"==typeof i&&!g.isContextTag(a)&&s==i||"string"==typeof i&&g.isContextTag(a,i))return g.getIdxbyListEx(t,u[o],r,e);g.isContextTag(a)||s++}return-1},ASN1HEX.getTLVbyList=function(t,n,r,e){var i=ASN1HEX,u=i.getIdxbyList(t,n,r,e);return-1==u?null:u>=t.length?null:i.getTLV(t,u)},ASN1HEX.getTLVbyListEx=function(t,n,r,e){var i=ASN1HEX,u=i.getIdxbyListEx(t,n,r,e);return-1==u?null:i.getTLV(t,u)},ASN1HEX.getVbyList=function(t,n,r,e,i){var u,g,s=ASN1HEX;return-1==(u=s.getIdxbyList(t,n,r,e))?null:u>=t.length?null:(g=s.getV(t,u),!0===i&&(g=g.substr(2)),g)},ASN1HEX.getVbyListEx=function(t,n,r,e,i){var u,g,s=ASN1HEX;return-1==(u=s.getIdxbyListEx(t,n,r,e))?null:(g=s.getV(t,u),"03"==t.substr(u,2)&&!1!==i&&(g=g.substr(2)),g)},ASN1HEX.getInt=function(t,n,r){null==r&&(r=-1);try{var e=t.substr(n,2);if("02"!=e&&"03"!=e)return r;var i=ASN1HEX.getV(t,n);return"02"==e?parseInt(i,16):bitstrtoint(i)}catch(t){return r}},ASN1HEX.getOID=function(t,n,r){null==r&&(r=null);try{if("06"!=t.substr(n,2))return r;var e=ASN1HEX.getV(t,n);return hextooid(e)}catch(t){return r}},ASN1HEX.getOIDName=function(t,n,r){null==r&&(r=null);try{var e=ASN1HEX.getOID(t,n,r);if(e==r)return r;var i=KJUR.asn1.x509.OID.oid2name(e);return""==i?e:i}catch(t){return r}},ASN1HEX.getString=function(t,n,r){null==r&&(r=null);try{var e=ASN1HEX.getV(t,n);return hextorstr(e)}catch(t){return r}},ASN1HEX.hextooidstr=function(t){var n=function(t,n){return t.length>=n?t:new Array(n-t.length+1).join("0")+t},r=[],e=t.substr(0,2),i=parseInt(e,16);r[0]=new String(Math.floor(i/40)),r[1]=new String(i%40);for(var u=t.substr(2),g=[],s=0;s<u.length/2;s++)g.push(parseInt(u.substr(2*s,2),16));var o=[],a="";for(s=0;s<g.length;s++)128&g[s]?a+=n((127&g[s]).toString(2),7):(a+=n((127&g[s]).toString(2),7),o.push(new String(parseInt(a,2))),a="");var l=r.join(".");return o.length>0&&(l=l+"."+o.join(".")),l},ASN1HEX.dump=function(t,n,r,e){var i=ASN1HEX,u=i.getV,g=i.dump,s=i.getChildIdx,o=t;t instanceof KJUR.asn1.ASN1Object&&(o=t.getEncodedHex());var a=function(t,n){return t.length<=2*n?t:t.substr(0,n)+"..(total "+t.length/2+"bytes).."+t.substr(t.length-n,n)};void 0===n&&(n={ommit_long_octet:32}),void 0===r&&(r=0),void 0===e&&(e="");var l,f=n.ommit_long_octet;if("01"==(l=o.substr(r,2)))return"00"==(E=u(o,r))?e+"BOOLEAN FALSE\n":e+"BOOLEAN TRUE\n";if("02"==l)return e+"INTEGER "+a(E=u(o,r),f)+"\n";if("03"==l){var E=u(o,r);if(i.isASN1HEX(E.substr(2))){var h=e+"BITSTRING, encapsulates\n";return h+=g(E.substr(2),n,0,e+"  ")}return e+"BITSTRING "+a(E,f)+"\n"}if("04"==l){E=u(o,r);if(i.isASN1HEX(E)){h=e+"OCTETSTRING, encapsulates\n";return h+=g(E,n,0,e+"  ")}return e+"OCTETSTRING "+a(E,f)+"\n"}if("05"==l)return e+"NULL\n";if("06"==l){var S=u(o,r),N=KJUR.asn1.ASN1Util.oidHexToInt(S),A=KJUR.asn1.x509.OID.oid2name(N),b=N.replace(/\./g," ");return""!=A?e+"ObjectIdentifier "+A+" ("+b+")\n":e+"ObjectIdentifier ("+b+")\n"}if("0a"==l)return e+"ENUMERATED "+parseInt(u(o,r))+"\n";if("0c"==l)return e+"UTF8String '"+hextoutf8(u(o,r))+"'\n";if("13"==l)return e+"PrintableString '"+hextoutf8(u(o,r))+"'\n";if("14"==l)return e+"TeletexString '"+hextoutf8(u(o,r))+"'\n";if("16"==l)return e+"IA5String '"+hextoutf8(u(o,r))+"'\n";if("17"==l)return e+"UTCTime "+hextoutf8(u(o,r))+"\n";if("18"==l)return e+"GeneralizedTime "+hextoutf8(u(o,r))+"\n";if("1a"==l)return e+"VisualString '"+hextoutf8(u(o,r))+"'\n";if("1e"==l)return e+"BMPString '"+hextoutf8(u(o,r))+"'\n";if("30"==l){if("3000"==o.substr(r,4))return e+"SEQUENCE {}\n";h=e+"SEQUENCE\n";var c=n;if((2==(v=s(o,r)).length||3==v.length)&&"06"==o.substr(v[0],2)&&"04"==o.substr(v[v.length-1],2)){A=i.oidname(u(o,v[0]));var x=JSON.parse(JSON.stringify(n));x.x509ExtName=A,c=x}for(var H=0;H<v.length;H++)h+=g(o,c,v[H],e+"  ");return h}if("31"==l){h=e+"SET\n";var v=s(o,r);for(H=0;H<v.length;H++)h+=g(o,n,v[H],e+"  ");return h}if(0!=(128&(l=parseInt(l,16)))){var d=31&l;if(0!=(32&l)){for(h=e+"["+d+"]\n",v=s(o,r),H=0;H<v.length;H++)h+=g(o,n,v[H],e+"  ");return h}E=u(o,r);if(ASN1HEX.isASN1HEX(E)){var h=e+"["+d+"]\n";return h+=g(E,n,0,e+"  ")}return"68747470"==E.substr(0,8)?E=hextoutf8(E):"subjectAltName"===n.x509ExtName&&2==d&&(E=hextoutf8(E)),h=e+"["+d+"] "+E+"\n"}return e+"UNKNOWN("+l+") "+u(o,r)+"\n"},ASN1HEX.isContextTag=function(t,n){var r,e;t=t.toLowerCase();try{r=parseInt(t,16)}catch(t){return-1}if(void 0===n)return 128==(192&r);try{return null!=n.match(/^\[[0-9]+\]$/)&&(!((e=parseInt(n.substr(1,n.length-1),10))>31)&&(128==(192&r)&&(31&r)==e))}catch(t){return!1}},ASN1HEX.isASN1HEX=function(t){var n=ASN1HEX;if(t.length%2==1)return!1;var r=n.getVblen(t,0),e=t.substr(0,2),i=n.getL(t,0);return t.length-e.length-i.length==2*r},ASN1HEX.checkStrictDER=function(t,n,r,e,i){var u=ASN1HEX;if(void 0===r){if("string"!=typeof t)throw new Error("not hex string");if(t=t.toLowerCase(),!KJUR.lang.String.isHex(t))throw new Error("not hex string");r=t.length,i=(e=t.length/2)<128?1:Math.ceil(e.toString(16))+1}if(u.getL(t,n).length>2*i)throw new Error("L of TLV too long: idx="+n);var g=u.getVblen(t,n);if(g>e)throw new Error("value of L too long than hex: idx="+n);var s=u.getTLV(t,n),o=s.length-2-u.getL(t,n).length;if(o!==2*g)throw new Error("V string length and L's value not the same:"+o+"/"+2*g);if(0===n&&t.length!=s.length)throw new Error("total length and TLV length unmatch:"+t.length+"!="+s.length);var a=t.substr(n,2);if("02"===a){var l=u.getVidx(t,n);if("00"==t.substr(l,2)&&t.charCodeAt(l+2)<56)throw new Error("not least zeros for DER INTEGER")}if(32&parseInt(a,16)){for(var f=u.getVblen(t,n),E=0,h=u.getChildIdx(t,n),S=0;S<h.length;S++){E+=u.getTLV(t,h[S]).length,u.checkStrictDER(t,h[S],r,e,i)}if(2*f!=E)throw new Error("sum of children's TLV length and L unmatch: "+2*f+"!="+E)}},ASN1HEX.oidname=function(t){var n=KJUR.asn1;KJUR.lang.String.isHex(t)&&(t=n.ASN1Util.oidHexToInt(t));var r=n.x509.OID.oid2name(t);return""===r&&(r=t),r};

export default ASN1HEX
