// From http://www-cs-students.stanford.edu/~tjw/jsbn/rsa.js
// Modified to use Uint8Array instead of UTF-8 strings in pkcs1pad2.

// Copyright (c) 2005  Tom Wu
// http://www-cs-students.stanford.edu/~tjw/jsbn/LICENSE

import BigInteger from "./jsbn.min.js"
import SecureRandom from "./rng.min.js"

function parseBigInt(n,t){return new BigInteger(n,t)}function linebrk(n,t){for(var e="",r=0;r+t<n.length;)e+=n.substring(r,r+t)+"\n",r+=t;return e+n.substring(r,n.length)}function byte2Hex(n){return n<16?"0"+n.toString(16):n.toString(16)}function pkcs1pad2(n,t){if(t<n.length+11)return alert("Message too long for RSA"),null;for(var e=new Array,r=n.length-1;r>=0&&t>0;)e[--t]=n[r--];e[--t]=0;for(var l=new SecureRandom,i=new Array;t>2;){for(i[0]=0;0==i[0];)l.nextBytes(i);e[--t]=i[0]}return e[--t]=2,e[--t]=0,new BigInteger(e)}function RSAKey(){this.n=null,this.e=0,this.d=null,this.p=null,this.q=null,this.dmp1=null,this.dmq1=null,this.coeff=null}function RSASetPublic(n,t){null!=n&&null!=t&&n.length>0&&t.length>0?(this.n=parseBigInt(n,16),this.e=parseInt(t,16)):alert("Invalid RSA public key")}function RSADoPublic(n){return n.modPowInt(this.e,this.n)}function RSAEncrypt(n){var t=pkcs1pad2(n,this.n.bitLength()+7>>3);if(null==t)return null;var e=this.doPublic(t);if(null==e)return null;var r=e.toString(16);return 0==(1&r.length)?r:"0"+r}RSAKey.prototype.doPublic=RSADoPublic,RSAKey.prototype.setPublic=RSASetPublic,RSAKey.prototype.encrypt=RSAEncrypt;

export default RSAKey
