from http.client import HTTPMessage
from typing import Any, Dict, Iterable, List, Mapping, Optional, Tuple, Union
from urllib.parse import SplitResult

from botocore.credentials import Credentials
from requests import Request

EMPTY_SHA256_HASH: str
PAYLOAD_BUFFER: Any
ISO8601: str
SIGV4_TIMESTAMP: str
SIGNED_HEADERS_BLACKLIST: Any
UNSIGNED_PAYLOAD: str

class BaseSigner:
    REQUIRES_REGION: bool = ...
    def add_auth(self, request: Request) -> Optional[Request]: ...

class SigV2Auth(BaseSigner):
    def __init__(self, credentials: Credentials) -> None:
        self.credentials: Credentials
    def calc_signature(self, request: Request, params: Mapping[str, Any]) -> Tuple[str, str]: ...
    def add_auth(self, request: Request) -> Request: ...

class SigV3Auth(BaseSigner):
    def __init__(self, credentials: Credentials) -> None:
        self.credentials: Credentials
    def add_auth(self, request: Any) -> None: ...

class SigV4Auth(BaseSigner):
    REQUIRES_REGION: bool = ...
    def __init__(self, credentials: Credentials, service_name: str, region_name: str) -> None:
        self.credentials: Credentials
    def headers_to_sign(self, request: Request) -> HTTPMessage: ...
    def canonical_query_string(self, request: Request) -> str: ...
    def canonical_headers(self, headers_to_sign: Iterable[str]) -> str: ...
    def signed_headers(self, headers_to_sign: Iterable[str]) -> str: ...
    def payload(self, request: Request) -> str: ...
    def canonical_request(self, request: Request) -> str: ...
    def scope(self, request: Request) -> str: ...
    def credential_scope(self, request: Request) -> str: ...
    def string_to_sign(self, request: Request, canonical_request: str) -> str: ...
    def signature(self, string_to_sign: str, request: Request) -> bytes: ...
    def add_auth(self, request: Request) -> None: ...

class S3SigV4Auth(SigV4Auth): ...

class SigV4QueryAuth(SigV4Auth):
    DEFAULT_EXPIRES: int = ...
    def __init__(
        self, credentials: Credentials, service_name: str, region_name: str, expires: int = ...
    ) -> None: ...

class S3SigV4QueryAuth(SigV4QueryAuth):
    def payload(self, request: Request) -> str: ...

class S3SigV4PostAuth(SigV4Auth):
    def add_auth(self, request: Request) -> None: ...

class HmacV1Auth(BaseSigner):
    QSAOfInterest: List[str] = ...
    def __init__(
        self,
        credentials: Credentials,
        service_name: Optional[str] = ...,
        region_name: Optional[str] = ...,
    ) -> None:
        self.credentials: Credentials
    def sign_string(self, string_to_sign: str) -> str: ...
    def canonical_standard_headers(self, headers: Mapping[str, Any]) -> str: ...
    def canonical_custom_headers(self, headers: Mapping[str, Any]) -> str: ...
    def unquote_v(self, nv: str) -> Union[Tuple[str, str], str]: ...
    def canonical_resource(self, split: SplitResult, auth_path: Optional[str] = ...) -> str: ...
    def canonical_string(
        self,
        method: str,
        split: SplitResult,
        headers: Mapping[str, Any],
        expires: Optional[int] = ...,
        auth_path: Optional[str] = ...,
    ) -> Any: ...
    def get_signature(
        self,
        method: str,
        split: SplitResult,
        headers: Mapping[str, Any],
        expires: Optional[int] = ...,
        auth_path: Optional[str] = ...,
    ) -> Any: ...
    def add_auth(self, request: Request) -> None: ...

class HmacV1QueryAuth(HmacV1Auth):
    DEFAULT_EXPIRES: int = ...
    def __init__(self, credentials: Credentials, expires: int = ...) -> None:
        self.credentials: Credentials

class HmacV1PostAuth(HmacV1Auth):
    def add_auth(self, request: Request) -> None: ...

AUTH_TYPE_MAPS: Dict[str, BaseSigner]
