# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['ServiceCompute']


class ServiceCompute(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activate: Optional[pulumi.Input[bool]] = None,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeBackendArgs']]]]] = None,
                 bigqueryloggings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeBigqueryloggingArgs']]]]] = None,
                 blobstorageloggings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeBlobstorageloggingArgs']]]]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeDomainArgs']]]]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 gcsloggings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeGcsloggingArgs']]]]] = None,
                 healthchecks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeHealthcheckArgs']]]]] = None,
                 httpsloggings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeHttpsloggingArgs']]]]] = None,
                 logentries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLogentryArgs']]]]] = None,
                 logging_cloudfiles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingCloudfileArgs']]]]] = None,
                 logging_datadogs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingDatadogArgs']]]]] = None,
                 logging_digitaloceans: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingDigitaloceanArgs']]]]] = None,
                 logging_elasticsearches: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingElasticsearchArgs']]]]] = None,
                 logging_ftps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingFtpArgs']]]]] = None,
                 logging_googlepubsubs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingGooglepubsubArgs']]]]] = None,
                 logging_heroku: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingHerokuArgs']]]]] = None,
                 logging_honeycombs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingHoneycombArgs']]]]] = None,
                 logging_kafkas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingKafkaArgs']]]]] = None,
                 logging_logglies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingLogglyArgs']]]]] = None,
                 logging_logshuttles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingLogshuttleArgs']]]]] = None,
                 logging_newrelics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingNewrelicArgs']]]]] = None,
                 logging_openstacks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingOpenstackArgs']]]]] = None,
                 logging_scalyrs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingScalyrArgs']]]]] = None,
                 logging_sftps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingSftpArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 package: Optional[pulumi.Input[pulumi.InputType['ServiceComputePackageArgs']]] = None,
                 papertrails: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputePapertrailArgs']]]]] = None,
                 s3loggings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeS3loggingArgs']]]]] = None,
                 splunks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeSplunkArgs']]]]] = None,
                 sumologics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeSumologicArgs']]]]] = None,
                 syslogs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeSyslogArgs']]]]] = None,
                 version_comment: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a Fastly Compute@Edge service. Compute@Edge is a computation platform capable of running custom binaries that you compile on your own systems and upload to Fastly. Security and portability is provided by compiling your code to [WebAssembly](https://webassembly.org/), which is ran at the edge using [Lucet](https://github.com/bytecodealliance/lucet), an open-source WebAssembly runtime created by Fastly. A compute service encompasses Domains and Backends.

        The Service resource requires a domain name that is correctly set up to direct
        traffic to the Fastly service. See Fastly's guide on [Adding CNAME Records][fastly-cname]
        on their documentation site for guidance.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] activate: Conditionally prevents the Service from being activated. The apply step will continue to create a new draft version but will not activate it if this is set to false. Default true.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeBackendArgs']]]] backends: A set of Backends to service requests from your Domains.
               Defined below. Backends must be defined in this argument, or defined in the
               `vcl` argument below
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeBigqueryloggingArgs']]]] bigqueryloggings: A BigQuery endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeBlobstorageloggingArgs']]]] blobstorageloggings: An Azure Blob Storage endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[str] comment: An optional comment about the Domain.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeDomainArgs']]]] domains: The domain of the DigitalOcean Spaces endpoint (default "nyc3.digitaloceanspaces.com").
        :param pulumi.Input[bool] force_destroy: Services that are active cannot be destroyed. In
               order to destroy the Service, set `force_destroy` to `true`. Default `false`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeGcsloggingArgs']]]] gcsloggings: A gcs endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeHealthcheckArgs']]]] healthchecks: Name of a defined `healthcheck` to assign to this backend.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeHttpsloggingArgs']]]] httpsloggings: An HTTPS endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLogentryArgs']]]] logentries: A logentries endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingCloudfileArgs']]]] logging_cloudfiles: A Rackspace Cloud Files endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingDatadogArgs']]]] logging_datadogs: A Datadog endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingDigitaloceanArgs']]]] logging_digitaloceans: A DigitalOcean Spaces endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingElasticsearchArgs']]]] logging_elasticsearches: An Elasticsearch endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingFtpArgs']]]] logging_ftps: An FTP endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingGooglepubsubArgs']]]] logging_googlepubsubs: A Google Cloud Pub/Sub endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingHerokuArgs']]]] logging_heroku: A Heroku endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingHoneycombArgs']]]] logging_honeycombs: A Honeycomb endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingKafkaArgs']]]] logging_kafkas: A Kafka endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingLogglyArgs']]]] logging_logglies: A Loggly endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingLogshuttleArgs']]]] logging_logshuttles: A Log Shuttle endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingNewrelicArgs']]]] logging_newrelics: A New Relic endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingOpenstackArgs']]]] logging_openstacks: An OpenStack endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingScalyrArgs']]]] logging_scalyrs: A Scalyr endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingSftpArgs']]]] logging_sftps: An SFTP endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[str] name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param pulumi.Input[pulumi.InputType['ServiceComputePackageArgs']] package: A Wasm deployment package to upload. Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputePapertrailArgs']]]] papertrails: A Papertrail endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeS3loggingArgs']]]] s3loggings: A set of S3 Buckets to send streaming logs too.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeSplunkArgs']]]] splunks: A Splunk endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeSumologicArgs']]]] sumologics: A Sumologic endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeSyslogArgs']]]] syslogs: A syslog endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[str] version_comment: Description field for the version.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['activate'] = activate
            __props__['backends'] = backends
            __props__['bigqueryloggings'] = bigqueryloggings
            __props__['blobstorageloggings'] = blobstorageloggings
            __props__['comment'] = comment
            if domains is None:
                raise TypeError("Missing required property 'domains'")
            __props__['domains'] = domains
            __props__['force_destroy'] = force_destroy
            __props__['gcsloggings'] = gcsloggings
            __props__['healthchecks'] = healthchecks
            __props__['httpsloggings'] = httpsloggings
            __props__['logentries'] = logentries
            __props__['logging_cloudfiles'] = logging_cloudfiles
            __props__['logging_datadogs'] = logging_datadogs
            __props__['logging_digitaloceans'] = logging_digitaloceans
            __props__['logging_elasticsearches'] = logging_elasticsearches
            __props__['logging_ftps'] = logging_ftps
            __props__['logging_googlepubsubs'] = logging_googlepubsubs
            __props__['logging_heroku'] = logging_heroku
            __props__['logging_honeycombs'] = logging_honeycombs
            __props__['logging_kafkas'] = logging_kafkas
            __props__['logging_logglies'] = logging_logglies
            __props__['logging_logshuttles'] = logging_logshuttles
            __props__['logging_newrelics'] = logging_newrelics
            __props__['logging_openstacks'] = logging_openstacks
            __props__['logging_scalyrs'] = logging_scalyrs
            __props__['logging_sftps'] = logging_sftps
            __props__['name'] = name
            if package is None:
                raise TypeError("Missing required property 'package'")
            __props__['package'] = package
            __props__['papertrails'] = papertrails
            __props__['s3loggings'] = s3loggings
            __props__['splunks'] = splunks
            __props__['sumologics'] = sumologics
            __props__['syslogs'] = syslogs
            __props__['version_comment'] = version_comment
            __props__['active_version'] = None
            __props__['cloned_version'] = None
        super(ServiceCompute, __self__).__init__(
            'fastly:index/serviceCompute:ServiceCompute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activate: Optional[pulumi.Input[bool]] = None,
            active_version: Optional[pulumi.Input[int]] = None,
            backends: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeBackendArgs']]]]] = None,
            bigqueryloggings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeBigqueryloggingArgs']]]]] = None,
            blobstorageloggings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeBlobstorageloggingArgs']]]]] = None,
            cloned_version: Optional[pulumi.Input[int]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            domains: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeDomainArgs']]]]] = None,
            force_destroy: Optional[pulumi.Input[bool]] = None,
            gcsloggings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeGcsloggingArgs']]]]] = None,
            healthchecks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeHealthcheckArgs']]]]] = None,
            httpsloggings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeHttpsloggingArgs']]]]] = None,
            logentries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLogentryArgs']]]]] = None,
            logging_cloudfiles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingCloudfileArgs']]]]] = None,
            logging_datadogs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingDatadogArgs']]]]] = None,
            logging_digitaloceans: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingDigitaloceanArgs']]]]] = None,
            logging_elasticsearches: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingElasticsearchArgs']]]]] = None,
            logging_ftps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingFtpArgs']]]]] = None,
            logging_googlepubsubs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingGooglepubsubArgs']]]]] = None,
            logging_heroku: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingHerokuArgs']]]]] = None,
            logging_honeycombs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingHoneycombArgs']]]]] = None,
            logging_kafkas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingKafkaArgs']]]]] = None,
            logging_logglies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingLogglyArgs']]]]] = None,
            logging_logshuttles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingLogshuttleArgs']]]]] = None,
            logging_newrelics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingNewrelicArgs']]]]] = None,
            logging_openstacks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingOpenstackArgs']]]]] = None,
            logging_scalyrs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingScalyrArgs']]]]] = None,
            logging_sftps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingSftpArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            package: Optional[pulumi.Input[pulumi.InputType['ServiceComputePackageArgs']]] = None,
            papertrails: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputePapertrailArgs']]]]] = None,
            s3loggings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeS3loggingArgs']]]]] = None,
            splunks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeSplunkArgs']]]]] = None,
            sumologics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeSumologicArgs']]]]] = None,
            syslogs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeSyslogArgs']]]]] = None,
            version_comment: Optional[pulumi.Input[str]] = None) -> 'ServiceCompute':
        """
        Get an existing ServiceCompute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] activate: Conditionally prevents the Service from being activated. The apply step will continue to create a new draft version but will not activate it if this is set to false. Default true.
        :param pulumi.Input[int] active_version: The currently active version of your Fastly Service.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeBackendArgs']]]] backends: A set of Backends to service requests from your Domains.
               Defined below. Backends must be defined in this argument, or defined in the
               `vcl` argument below
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeBigqueryloggingArgs']]]] bigqueryloggings: A BigQuery endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeBlobstorageloggingArgs']]]] blobstorageloggings: An Azure Blob Storage endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[str] comment: An optional comment about the Domain.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeDomainArgs']]]] domains: The domain of the DigitalOcean Spaces endpoint (default "nyc3.digitaloceanspaces.com").
        :param pulumi.Input[bool] force_destroy: Services that are active cannot be destroyed. In
               order to destroy the Service, set `force_destroy` to `true`. Default `false`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeGcsloggingArgs']]]] gcsloggings: A gcs endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeHealthcheckArgs']]]] healthchecks: Name of a defined `healthcheck` to assign to this backend.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeHttpsloggingArgs']]]] httpsloggings: An HTTPS endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLogentryArgs']]]] logentries: A logentries endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingCloudfileArgs']]]] logging_cloudfiles: A Rackspace Cloud Files endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingDatadogArgs']]]] logging_datadogs: A Datadog endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingDigitaloceanArgs']]]] logging_digitaloceans: A DigitalOcean Spaces endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingElasticsearchArgs']]]] logging_elasticsearches: An Elasticsearch endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingFtpArgs']]]] logging_ftps: An FTP endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingGooglepubsubArgs']]]] logging_googlepubsubs: A Google Cloud Pub/Sub endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingHerokuArgs']]]] logging_heroku: A Heroku endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingHoneycombArgs']]]] logging_honeycombs: A Honeycomb endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingKafkaArgs']]]] logging_kafkas: A Kafka endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingLogglyArgs']]]] logging_logglies: A Loggly endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingLogshuttleArgs']]]] logging_logshuttles: A Log Shuttle endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingNewrelicArgs']]]] logging_newrelics: A New Relic endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingOpenstackArgs']]]] logging_openstacks: An OpenStack endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingScalyrArgs']]]] logging_scalyrs: A Scalyr endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeLoggingSftpArgs']]]] logging_sftps: An SFTP endpoint to send streaming logs to.
               Defined below.
        :param pulumi.Input[str] name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param pulumi.Input[pulumi.InputType['ServiceComputePackageArgs']] package: A Wasm deployment package to upload. Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputePapertrailArgs']]]] papertrails: A Papertrail endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeS3loggingArgs']]]] s3loggings: A set of S3 Buckets to send streaming logs too.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeSplunkArgs']]]] splunks: A Splunk endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeSumologicArgs']]]] sumologics: A Sumologic endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComputeSyslogArgs']]]] syslogs: A syslog endpoint to send streaming logs too.
               Defined below.
        :param pulumi.Input[str] version_comment: Description field for the version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["activate"] = activate
        __props__["active_version"] = active_version
        __props__["backends"] = backends
        __props__["bigqueryloggings"] = bigqueryloggings
        __props__["blobstorageloggings"] = blobstorageloggings
        __props__["cloned_version"] = cloned_version
        __props__["comment"] = comment
        __props__["domains"] = domains
        __props__["force_destroy"] = force_destroy
        __props__["gcsloggings"] = gcsloggings
        __props__["healthchecks"] = healthchecks
        __props__["httpsloggings"] = httpsloggings
        __props__["logentries"] = logentries
        __props__["logging_cloudfiles"] = logging_cloudfiles
        __props__["logging_datadogs"] = logging_datadogs
        __props__["logging_digitaloceans"] = logging_digitaloceans
        __props__["logging_elasticsearches"] = logging_elasticsearches
        __props__["logging_ftps"] = logging_ftps
        __props__["logging_googlepubsubs"] = logging_googlepubsubs
        __props__["logging_heroku"] = logging_heroku
        __props__["logging_honeycombs"] = logging_honeycombs
        __props__["logging_kafkas"] = logging_kafkas
        __props__["logging_logglies"] = logging_logglies
        __props__["logging_logshuttles"] = logging_logshuttles
        __props__["logging_newrelics"] = logging_newrelics
        __props__["logging_openstacks"] = logging_openstacks
        __props__["logging_scalyrs"] = logging_scalyrs
        __props__["logging_sftps"] = logging_sftps
        __props__["name"] = name
        __props__["package"] = package
        __props__["papertrails"] = papertrails
        __props__["s3loggings"] = s3loggings
        __props__["splunks"] = splunks
        __props__["sumologics"] = sumologics
        __props__["syslogs"] = syslogs
        __props__["version_comment"] = version_comment
        return ServiceCompute(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def activate(self) -> pulumi.Output[Optional[bool]]:
        """
        Conditionally prevents the Service from being activated. The apply step will continue to create a new draft version but will not activate it if this is set to false. Default true.
        """
        return pulumi.get(self, "activate")

    @property
    @pulumi.getter(name="activeVersion")
    def active_version(self) -> pulumi.Output[int]:
        """
        The currently active version of your Fastly Service.
        """
        return pulumi.get(self, "active_version")

    @property
    @pulumi.getter
    def backends(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeBackend']]]:
        """
        A set of Backends to service requests from your Domains.
        Defined below. Backends must be defined in this argument, or defined in the
        `vcl` argument below
        """
        return pulumi.get(self, "backends")

    @property
    @pulumi.getter
    def bigqueryloggings(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeBigquerylogging']]]:
        """
        A BigQuery endpoint to send streaming logs too.
        Defined below.
        """
        return pulumi.get(self, "bigqueryloggings")

    @property
    @pulumi.getter
    def blobstorageloggings(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeBlobstoragelogging']]]:
        """
        An Azure Blob Storage endpoint to send streaming logs too.
        Defined below.
        """
        return pulumi.get(self, "blobstorageloggings")

    @property
    @pulumi.getter(name="clonedVersion")
    def cloned_version(self) -> pulumi.Output[int]:
        return pulumi.get(self, "cloned_version")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        An optional comment about the Domain.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def domains(self) -> pulumi.Output[Sequence['outputs.ServiceComputeDomain']]:
        """
        The domain of the DigitalOcean Spaces endpoint (default "nyc3.digitaloceanspaces.com").
        """
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        Services that are active cannot be destroyed. In
        order to destroy the Service, set `force_destroy` to `true`. Default `false`.
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter
    def gcsloggings(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeGcslogging']]]:
        """
        A gcs endpoint to send streaming logs too.
        Defined below.
        """
        return pulumi.get(self, "gcsloggings")

    @property
    @pulumi.getter
    def healthchecks(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeHealthcheck']]]:
        """
        Name of a defined `healthcheck` to assign to this backend.
        """
        return pulumi.get(self, "healthchecks")

    @property
    @pulumi.getter
    def httpsloggings(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeHttpslogging']]]:
        """
        An HTTPS endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "httpsloggings")

    @property
    @pulumi.getter
    def logentries(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeLogentry']]]:
        """
        A logentries endpoint to send streaming logs too.
        Defined below.
        """
        return pulumi.get(self, "logentries")

    @property
    @pulumi.getter(name="loggingCloudfiles")
    def logging_cloudfiles(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeLoggingCloudfile']]]:
        """
        A Rackspace Cloud Files endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_cloudfiles")

    @property
    @pulumi.getter(name="loggingDatadogs")
    def logging_datadogs(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeLoggingDatadog']]]:
        """
        A Datadog endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_datadogs")

    @property
    @pulumi.getter(name="loggingDigitaloceans")
    def logging_digitaloceans(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeLoggingDigitalocean']]]:
        """
        A DigitalOcean Spaces endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_digitaloceans")

    @property
    @pulumi.getter(name="loggingElasticsearches")
    def logging_elasticsearches(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeLoggingElasticsearch']]]:
        """
        An Elasticsearch endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_elasticsearches")

    @property
    @pulumi.getter(name="loggingFtps")
    def logging_ftps(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeLoggingFtp']]]:
        """
        An FTP endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_ftps")

    @property
    @pulumi.getter(name="loggingGooglepubsubs")
    def logging_googlepubsubs(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeLoggingGooglepubsub']]]:
        """
        A Google Cloud Pub/Sub endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_googlepubsubs")

    @property
    @pulumi.getter(name="loggingHeroku")
    def logging_heroku(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeLoggingHeroku']]]:
        """
        A Heroku endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_heroku")

    @property
    @pulumi.getter(name="loggingHoneycombs")
    def logging_honeycombs(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeLoggingHoneycomb']]]:
        """
        A Honeycomb endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_honeycombs")

    @property
    @pulumi.getter(name="loggingKafkas")
    def logging_kafkas(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeLoggingKafka']]]:
        """
        A Kafka endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_kafkas")

    @property
    @pulumi.getter(name="loggingLogglies")
    def logging_logglies(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeLoggingLoggly']]]:
        """
        A Loggly endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_logglies")

    @property
    @pulumi.getter(name="loggingLogshuttles")
    def logging_logshuttles(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeLoggingLogshuttle']]]:
        """
        A Log Shuttle endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_logshuttles")

    @property
    @pulumi.getter(name="loggingNewrelics")
    def logging_newrelics(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeLoggingNewrelic']]]:
        """
        A New Relic endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_newrelics")

    @property
    @pulumi.getter(name="loggingOpenstacks")
    def logging_openstacks(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeLoggingOpenstack']]]:
        """
        An OpenStack endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_openstacks")

    @property
    @pulumi.getter(name="loggingScalyrs")
    def logging_scalyrs(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeLoggingScalyr']]]:
        """
        A Scalyr endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_scalyrs")

    @property
    @pulumi.getter(name="loggingSftps")
    def logging_sftps(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeLoggingSftp']]]:
        """
        An SFTP endpoint to send streaming logs to.
        Defined below.
        """
        return pulumi.get(self, "logging_sftps")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def package(self) -> pulumi.Output['outputs.ServiceComputePackage']:
        """
        A Wasm deployment package to upload. Defined below.
        """
        return pulumi.get(self, "package")

    @property
    @pulumi.getter
    def papertrails(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputePapertrail']]]:
        """
        A Papertrail endpoint to send streaming logs too.
        Defined below.
        """
        return pulumi.get(self, "papertrails")

    @property
    @pulumi.getter
    def s3loggings(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeS3logging']]]:
        """
        A set of S3 Buckets to send streaming logs too.
        Defined below.
        """
        return pulumi.get(self, "s3loggings")

    @property
    @pulumi.getter
    def splunks(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeSplunk']]]:
        """
        A Splunk endpoint to send streaming logs too.
        Defined below.
        """
        return pulumi.get(self, "splunks")

    @property
    @pulumi.getter
    def sumologics(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeSumologic']]]:
        """
        A Sumologic endpoint to send streaming logs too.
        Defined below.
        """
        return pulumi.get(self, "sumologics")

    @property
    @pulumi.getter
    def syslogs(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceComputeSyslog']]]:
        """
        A syslog endpoint to send streaming logs too.
        Defined below.
        """
        return pulumi.get(self, "syslogs")

    @property
    @pulumi.getter(name="versionComment")
    def version_comment(self) -> pulumi.Output[Optional[str]]:
        """
        Description field for the version.
        """
        return pulumi.get(self, "version_comment")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

