<a id="mypy-boto3-rds-data"></a>

# mypy-boto3-rds-data

[![PyPI - mypy-boto3-rds-data](https://img.shields.io/pypi/v/mypy-boto3-rds-data.svg?color=blue)](https://pypi.org/project/mypy-boto3-rds-data)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-rds-data.svg?color=blue)](https://pypi.org/project/mypy-boto3-rds-data)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-rds-data?color=blue)](https://pypistats.org/packages/mypy-boto3-rds-data)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.RDSDataService 1.17.109](https://boto3.amazonaws.com/v1/documentation/api/1.17.109/reference/services/rds-data.html#RDSDataService)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.22.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-rds-data docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_rds_data/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-rds-data](#mypy-boto3-rds-data)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `RDSDataService` service.

```bash
python -m pip install boto3-stubs[rds-data]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[rds-data]` in your environment:
  `python -m pip install 'boto3-stubs[rds-data]'`

Both type checking and auto-complete should work for `RDSDataService` service.
No explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[rds-data]` in your environment:
  `python -m pip install 'boto3-stubs[rds-data]'`

Both type checking and auto-complete should work for `RDSDataService` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[rds-data]` in your environment:
  `python -m pip install 'boto3-stubs[rds-data]'`
- Run `mypy` as usual

Type checking should work for `RDSDataService` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[rds-data]` in your environment:
  `python -m pip install 'boto3-stubs[rds-data]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `RDSDataService` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`RDSDataServiceClient` provides annotations for `boto3.client("rds-data")`.

```python
import boto3

from mypy_boto3_rds_data import RDSDataServiceClient

client: RDSDataServiceClient = boto3.client("rds-data")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: RDSDataServiceClient = session.client("rds-data")
```

<a id="literals"></a>

### Literals

`mypy_boto3_rds_data.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_rds_data.literals import (
    DecimalReturnTypeType,
    TypeHintType,
)

def check_value(value: DecimalReturnTypeType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_rds_data.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_rds_data.type_defs import (
    ArrayValueTypeDef,
    BatchExecuteStatementRequestRequestTypeDef,
    BatchExecuteStatementResponseTypeDef,
    BeginTransactionRequestRequestTypeDef,
    BeginTransactionResponseTypeDef,
    ColumnMetadataTypeDef,
    CommitTransactionRequestRequestTypeDef,
    CommitTransactionResponseTypeDef,
    ExecuteSqlRequestRequestTypeDef,
    ExecuteSqlResponseTypeDef,
    ExecuteStatementRequestRequestTypeDef,
    ExecuteStatementResponseTypeDef,
    FieldTypeDef,
    RecordTypeDef,
    ResponseMetadataTypeDef,
    ResultFrameTypeDef,
    ResultSetMetadataTypeDef,
    ResultSetOptionsTypeDef,
    RollbackTransactionRequestRequestTypeDef,
    RollbackTransactionResponseTypeDef,
    SqlParameterTypeDef,
    SqlStatementResultTypeDef,
    StructValueTypeDef,
    UpdateResultTypeDef,
    ValueTypeDef,
)

def get_structure() -> ArrayValueTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-rds-data` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-rds-data docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_rds_data/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
