import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [internetmonitor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchinternetmonitor.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Internetmonitor extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [internetmonitor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatchinternetmonitor.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a monitor
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_CreateMonitor.html
     */
    toCreateMonitor(): this;
    /**
     * Grants permission to delete a monitor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_DeleteMonitor.html
     */
    toDeleteMonitor(): this;
    /**
     * Grants permission to get information about a health event for a specified monitor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_GetHealthEvent.html
     */
    toGetHealthEvent(): this;
    /**
     * Grants permission to get information about a monitor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_GetMonitor.html
     */
    toGetMonitor(): this;
    /**
     * Grants permission to list all health events for a monitor
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_ListHealthEvents.html
     */
    toListHealthEvents(): this;
    /**
     * Grants permission to list all monitors in an account and their statuses
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_ListMonitors.html
     */
    toListMonitors(): this;
    /**
     * Grants permission to list the tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a monitor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/internet-monitor/latest/api/API_UpdateMonitor.html
     */
    toUpdateMonitor(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type HealthEvent to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-components.html
     *
     * @param monitorName - Identifier for the monitorName.
     * @param eventId - Identifier for the eventId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onHealthEvent(monitorName: string, eventId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Monitor to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-components.html
     *
     * @param monitorName - Identifier for the monitorName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMonitor(monitorName: string, account?: string, region?: string, partition?: string): this;
}
