"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodedeployCommandsSecure = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [codedeploy-commands-secure](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscodedeploysecurehostcommandsservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class CodedeployCommandsSecure extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [codedeploy-commands-secure](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscodedeploysecurehostcommandsservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'codedeploy-commands-secure';
        this.accessLevelList = {
            Read: [
                'GetDeploymentSpecification',
                'PollHostCommand'
            ],
            Write: [
                'PutHostCommandAcknowledgement',
                'PutHostCommandComplete'
            ]
        };
    }
    /**
     * Grants permission to get deployment specification
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/vpc-endpoints.html#vpc-codedeploy-agent-configuration
     */
    toGetDeploymentSpecification() {
        return this.to('GetDeploymentSpecification');
    }
    /**
     * Grants permission to request host agent commands
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/vpc-endpoints.html#vpc-codedeploy-agent-configuration
     */
    toPollHostCommand() {
        return this.to('PollHostCommand');
    }
    /**
     * Grants permission to mark host agent commands acknowledged
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/vpc-endpoints.html#vpc-codedeploy-agent-configuration
     */
    toPutHostCommandAcknowledgement() {
        return this.to('PutHostCommandAcknowledgement');
    }
    /**
     * Grants permission to mark host agent commands completed
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/vpc-endpoints.html#vpc-codedeploy-agent-configuration
     */
    toPutHostCommandComplete() {
        return this.to('PutHostCommandComplete');
    }
}
exports.CodedeployCommandsSecure = CodedeployCommandsSecure;
_a = JSII_RTTI_SYMBOL_1;
CodedeployCommandsSecure[_a] = { fqn: "iam-floyd.CodedeployCommandsSecure", version: "0.498.0" };
//# sourceMappingURL=data:application/json;base64,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