"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConnectCampaigns = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [connect-campaigns](https://docs.aws.amazon.com/service-authorization/latest/reference/list_high-volumeoutboundcommunications.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class ConnectCampaigns extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [connect-campaigns](https://docs.aws.amazon.com/service-authorization/latest/reference/list_high-volumeoutboundcommunications.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'connect-campaigns';
        this.accessLevelList = {
            Write: [
                'CreateCampaign',
                'DeleteCampaign',
                'DeleteConnectInstanceConfig',
                'DeleteInstanceOnboardingJob',
                'PauseCampaign',
                'PutDialRequestBatch',
                'ResumeCampaign',
                'StartCampaign',
                'StartInstanceOnboardingJob',
                'StopCampaign',
                'UpdateCampaignDialerConfig',
                'UpdateCampaignName',
                'UpdateCampaignOutboundCallConfig'
            ],
            Read: [
                'DescribeCampaign',
                'GetCampaignState',
                'GetCampaignStateBatch',
                'GetConnectInstanceConfig',
                'GetInstanceOnboardingJobStatus',
                'ListTagsForResource'
            ],
            List: [
                'ListCampaigns'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to create a campaign
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toCreateCampaign() {
        return this.to('CreateCampaign');
    }
    /**
     * Grants permission to delete a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toDeleteCampaign() {
        return this.to('DeleteCampaign');
    }
    /**
     * Grants permission to remove configuration information for an Amazon Connect instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toDeleteConnectInstanceConfig() {
        return this.to('DeleteConnectInstanceConfig');
    }
    /**
     * Grants permission to remove onboarding job for an Amazon Connect instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toDeleteInstanceOnboardingJob() {
        return this.to('DeleteInstanceOnboardingJob');
    }
    /**
     * Grants permission to describe a specific campaign
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toDescribeCampaign() {
        return this.to('DescribeCampaign');
    }
    /**
     * Grants permission to get state of a campaign
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toGetCampaignState() {
        return this.to('GetCampaignState');
    }
    /**
     * Grants permission to get state of campaigns
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toGetCampaignStateBatch() {
        return this.to('GetCampaignStateBatch');
    }
    /**
     * Grants permission to get configuration information for an Amazon Connect instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toGetConnectInstanceConfig() {
        return this.to('GetConnectInstanceConfig');
    }
    /**
     * Grants permission to get onboarding job status for an Amazon Connect instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toGetInstanceOnboardingJobStatus() {
        return this.to('GetInstanceOnboardingJobStatus');
    }
    /**
     * Grants permission to provide summary of all campaigns
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toListCampaigns() {
        return this.to('ListCampaigns');
    }
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to pause a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toPauseCampaign() {
        return this.to('PauseCampaign');
    }
    /**
     * Grants permission to create dial requests for the specified campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toPutDialRequestBatch() {
        return this.to('PutDialRequestBatch');
    }
    /**
     * Grants permission to resume a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toResumeCampaign() {
        return this.to('ResumeCampaign');
    }
    /**
     * Grants permission to start a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toStartCampaign() {
        return this.to('StartCampaign');
    }
    /**
     * Grants permission to start onboarding job for an Amazon Connect instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toStartInstanceOnboardingJob() {
        return this.to('StartInstanceOnboardingJob');
    }
    /**
     * Grants permission to stop a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toStopCampaign() {
        return this.to('StopCampaign');
    }
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update the dialer configuration of a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toUpdateCampaignDialerConfig() {
        return this.to('UpdateCampaignDialerConfig');
    }
    /**
     * Grants permission to update the name of a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toUpdateCampaignName() {
        return this.to('UpdateCampaignName');
    }
    /**
     * Grants permission to update the outbound call configuration of a campaign
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     */
    toUpdateCampaignOutboundCallConfig() {
        return this.to('UpdateCampaignOutboundCallConfig');
    }
    /**
     * Adds a resource of type campaign to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/enable-high-volume-outbound-communications.html
     *
     * @param campaignId - Identifier for the campaignId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCampaign(campaignId, account, region, partition) {
        return this.on(`arn:${partition || ConnectCampaigns.defaultPartition}:connect-campaigns:${region || '*'}:${account || '*'}:campaign/${campaignId}`);
    }
}
exports.ConnectCampaigns = ConnectCampaigns;
_a = JSII_RTTI_SYMBOL_1;
ConnectCampaigns[_a] = { fqn: "iam-floyd.ConnectCampaigns", version: "0.498.0" };
//# sourceMappingURL=data:application/json;base64,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