"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Inspector = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [inspector](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninspector.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Inspector extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [inspector](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninspector.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'inspector';
        this.accessLevelList = {
            Write: [
                'AddAttributesToFindings',
                'CreateAssessmentTarget',
                'CreateAssessmentTemplate',
                'CreateExclusionsPreview',
                'CreateResourceGroup',
                'DeleteAssessmentRun',
                'DeleteAssessmentTarget',
                'DeleteAssessmentTemplate',
                'RegisterCrossAccountAccessRole',
                'RemoveAttributesFromFindings',
                'StartAssessmentRun',
                'StopAssessmentRun',
                'SubscribeToEvent',
                'UnsubscribeFromEvent',
                'UpdateAssessmentTarget'
            ],
            Read: [
                'DescribeAssessmentRuns',
                'DescribeAssessmentTargets',
                'DescribeAssessmentTemplates',
                'DescribeCrossAccountAccessRole',
                'DescribeExclusions',
                'DescribeFindings',
                'DescribeResourceGroups',
                'DescribeRulesPackages',
                'GetAssessmentReport',
                'GetExclusionsPreview',
                'GetTelemetryMetadata',
                'ListTagsForResource',
                'PreviewAgents'
            ],
            List: [
                'ListAssessmentRunAgents',
                'ListAssessmentRuns',
                'ListAssessmentTargets',
                'ListAssessmentTemplates',
                'ListEventSubscriptions',
                'ListExclusions',
                'ListFindings',
                'ListRulesPackages'
            ],
            Tagging: [
                'SetTagsForResource'
            ]
        };
    }
    /**
     * Grants permission to assign attributes (key and value pairs) to the findings that are specified by the ARNs of the findings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_AddAttributesToFindings.html
     */
    toAddAttributesToFindings() {
        return this.to('AddAttributesToFindings');
    }
    /**
     * Grants permission to create a new assessment target using the ARN of the resource group that is generated by CreateResourceGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateAssessmentTarget.html
     */
    toCreateAssessmentTarget() {
        return this.to('CreateAssessmentTarget');
    }
    /**
     * Grants permission to create an assessment template for the assessment target that is specified by the ARN of the assessment target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateAssessmentTemplate.html
     */
    toCreateAssessmentTemplate() {
        return this.to('CreateAssessmentTemplate');
    }
    /**
     * Grants permission to start the generation of an exclusions preview for the specified assessment template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateExclusionsPreview.html
     */
    toCreateExclusionsPreview() {
        return this.to('CreateExclusionsPreview');
    }
    /**
     * Grants permission to create a resource group using the specified set of tags (key and value pairs) that are used to select the EC2 instances to be included in an Amazon Inspector assessment target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateResourceGroup.html
     */
    toCreateResourceGroup() {
        return this.to('CreateResourceGroup');
    }
    /**
     * Grants permission to delete the assessment run that is specified by the ARN of the assessment run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentRun.html
     */
    toDeleteAssessmentRun() {
        return this.to('DeleteAssessmentRun');
    }
    /**
     * Grants permission to delete the assessment target that is specified by the ARN of the assessment target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentTarget.html
     */
    toDeleteAssessmentTarget() {
        return this.to('DeleteAssessmentTarget');
    }
    /**
     * Grants permission to delete the assessment template that is specified by the ARN of the assessment template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentTemplate.html
     */
    toDeleteAssessmentTemplate() {
        return this.to('DeleteAssessmentTemplate');
    }
    /**
     * Grants permission to describe the assessment runs that are specified by the ARNs of the assessment runs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentRuns.html
     */
    toDescribeAssessmentRuns() {
        return this.to('DescribeAssessmentRuns');
    }
    /**
     * Grants permission to describe the assessment targets that are specified by the ARNs of the assessment targets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentTargets.html
     */
    toDescribeAssessmentTargets() {
        return this.to('DescribeAssessmentTargets');
    }
    /**
     * Grants permission to describe the assessment templates that are specified by the ARNs of the assessment templates
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentTemplates.html
     */
    toDescribeAssessmentTemplates() {
        return this.to('DescribeAssessmentTemplates');
    }
    /**
     * Grants permission to describe the IAM role that enables Amazon Inspector to access your AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeCrossAccountAccessRole.html
     */
    toDescribeCrossAccountAccessRole() {
        return this.to('DescribeCrossAccountAccessRole');
    }
    /**
     * Grants permission to describe the exclusions that are specified by the exclusions' ARNs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeExclusions.html
     */
    toDescribeExclusions() {
        return this.to('DescribeExclusions');
    }
    /**
     * Grants permission to describe the findings that are specified by the ARNs of the findings
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeFindings.html
     */
    toDescribeFindings() {
        return this.to('DescribeFindings');
    }
    /**
     * Grants permission to describe the resource groups that are specified by the ARNs of the resource groups
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeResourceGroups.html
     */
    toDescribeResourceGroups() {
        return this.to('DescribeResourceGroups');
    }
    /**
     * Grants permission to describe the rules packages that are specified by the ARNs of the rules packages
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeRulesPackages.html
     */
    toDescribeRulesPackages() {
        return this.to('DescribeRulesPackages');
    }
    /**
     * Grants permission to produce an assessment report that includes detailed and comprehensive results of a specified assessment run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_GetAssessmentReport.html
     */
    toGetAssessmentReport() {
        return this.to('GetAssessmentReport');
    }
    /**
     * Grants permission to retrieve the exclusions preview (a list of ExclusionPreview objects) specified by the preview token
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_GetExclusionsPreview.html
     */
    toGetExclusionsPreview() {
        return this.to('GetExclusionsPreview');
    }
    /**
     * Grants permission to get information about the data that is collected for the specified assessment run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_GetTelemetryMetadata.html
     */
    toGetTelemetryMetadata() {
        return this.to('GetTelemetryMetadata');
    }
    /**
     * Grants permission to list the agents of the assessment runs that are specified by the ARNs of the assessment runs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentRunAgents.html
     */
    toListAssessmentRunAgents() {
        return this.to('ListAssessmentRunAgents');
    }
    /**
     * Grants permission to list the assessment runs that correspond to the assessment templates that are specified by the ARNs of the assessment templates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentRuns.html
     */
    toListAssessmentRuns() {
        return this.to('ListAssessmentRuns');
    }
    /**
     * Grants permission to list the ARNs of the assessment targets within this AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentTargets.html
     */
    toListAssessmentTargets() {
        return this.to('ListAssessmentTargets');
    }
    /**
     * Grants permission to list the assessment templates that correspond to the assessment targets that are specified by the ARNs of the assessment targets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentTemplates.html
     */
    toListAssessmentTemplates() {
        return this.to('ListAssessmentTemplates');
    }
    /**
     * Grants permission to list all the event subscriptions for the assessment template that is specified by the ARN of the assessment template
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListEventSubscriptions.html
     */
    toListEventSubscriptions() {
        return this.to('ListEventSubscriptions');
    }
    /**
     * Grants permission to list exclusions that are generated by the assessment run
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListExclusions.html
     */
    toListExclusions() {
        return this.to('ListExclusions');
    }
    /**
     * Grants permission to list findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListFindings.html
     */
    toListFindings() {
        return this.to('ListFindings');
    }
    /**
     * Grants permission to list all available Amazon Inspector rules packages
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListRulesPackages.html
     */
    toListRulesPackages() {
        return this.to('ListRulesPackages');
    }
    /**
     * Grants permission to list all tags associated with an assessment template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to preview the agents installed on the EC2 instances that are part of the specified assessment target
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_PreviewAgents.html
     */
    toPreviewAgents() {
        return this.to('PreviewAgents');
    }
    /**
     * Grants permission to register the IAM role that Amazon Inspector uses to list your EC2 instances at the start of the assessment run or when you call the PreviewAgents action
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_RegisterCrossAccountAccessRole.html
     */
    toRegisterCrossAccountAccessRole() {
        return this.to('RegisterCrossAccountAccessRole');
    }
    /**
     * Grants permission to remove entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings where an attribute with the specified key exists
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_RemoveAttributesFromFindings.html
     */
    toRemoveAttributesFromFindings() {
        return this.to('RemoveAttributesFromFindings');
    }
    /**
     * Grants permission to set tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment template
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_SetTagsForResource.html
     */
    toSetTagsForResource() {
        return this.to('SetTagsForResource');
    }
    /**
     * Grants permission to start the assessment run specified by the ARN of the assessment template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_StartAssessmentRun.html
     */
    toStartAssessmentRun() {
        return this.to('StartAssessmentRun');
    }
    /**
     * Grants permission to stop the assessment run that is specified by the ARN of the assessment run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_StopAssessmentRun.html
     */
    toStopAssessmentRun() {
        return this.to('StopAssessmentRun');
    }
    /**
     * Grants permission to enable the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_SubscribeToEvent.html
     */
    toSubscribeToEvent() {
        return this.to('SubscribeToEvent');
    }
    /**
     * Grants permission to disable the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_UnsubscribeFromEvent.html
     */
    toUnsubscribeFromEvent() {
        return this.to('UnsubscribeFromEvent');
    }
    /**
     * Grants permission to update the assessment target that is specified by the ARN of the assessment target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_UpdateAssessmentTarget.html
     */
    toUpdateAssessmentTarget() {
        return this.to('UpdateAssessmentTarget');
    }
}
exports.Inspector = Inspector;
_a = JSII_RTTI_SYMBOL_1;
Inspector[_a] = { fqn: "iam-floyd.Inspector", version: "0.498.0" };
//# sourceMappingURL=data:application/json;base64,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