import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [iq-permission](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiqpermissions.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class IqPermission extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [iq-permission](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiqpermissions.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to approve a permission request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toApproveAccessGrant(): this;
    /**
     * Grants permission to approve a permission request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toApprovePermissionRequest(): this;
    /**
     * Grants permission to create a permission request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreatePermissionRequest(): this;
    /**
     * Grants permission to get a permission request
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetPermissionRequest(): this;
    /**
     * Grants permission to list permission requests
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListPermissionRequests(): this;
    /**
     * Grants permission to reject a permission request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toRejectPermissionRequest(): this;
    /**
     * Grants permission to revoke a permission request which was previously approved
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toRevokePermissionRequest(): this;
    /**
     * Grants permission to withdraw a permission request that has not been approved or declined
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toWithdrawPermissionRequest(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type permission to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param permissionRequestId - Identifier for the permissionRequestId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onPermission(permissionRequestId: string, region?: string, partition?: string): this;
}
