"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourceExplorer2 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [resource-explorer-2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresourceexplorer.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class ResourceExplorer2 extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [resource-explorer-2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresourceexplorer.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'resource-explorer-2';
        this.accessLevelList = {
            Write: [
                'AssociateDefaultView',
                'CreateIndex',
                'CreateView',
                'DeleteIndex',
                'DeleteView',
                'DisassociateDefaultView',
                'UpdateIndexType',
                'UpdateView'
            ],
            Read: [
                'BatchGetView',
                'GetDefaultView',
                'GetIndex',
                'GetView',
                'ListTagsForResource',
                'Search'
            ],
            List: [
                'ListIndexes',
                'ListSupportedResourceTypes',
                'ListViews'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to set the specified view as the default for this AWS Region in this AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_AssociateDefaultView.html
     */
    toAssociateDefaultView() {
        return this.to('AssociateDefaultView');
    }
    /**
     * Grants permission to retrieve details about views that you specify by a list of ARNs
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - resource-explorer-2:GetView
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_BatchGetView.html
     */
    toBatchGetView() {
        return this.to('BatchGetView');
    }
    /**
     * Grants permission to turn on Resource Explorer in the AWS Region in which you called this operation by creating an index
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_CreateIndex.html
     */
    toCreateIndex() {
        return this.to('CreateIndex');
    }
    /**
     * Grants permission to create a view that users can query
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_CreateView.html
     */
    toCreateView() {
        return this.to('CreateView');
    }
    /**
     * Grants permission to turn off Resource Explorer in the specified AWS Region by deleting the index
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_DeleteIndex.html
     */
    toDeleteIndex() {
        return this.to('DeleteIndex');
    }
    /**
     * Grants permission to delete a view
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_DeleteView.html
     */
    toDeleteView() {
        return this.to('DeleteView');
    }
    /**
     * Grants permission to remove the default view for the AWS Region in which you call this operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_DisassociateDefaultView.html
     */
    toDisassociateDefaultView() {
        return this.to('DisassociateDefaultView');
    }
    /**
     * Grants permission to retrieve the Amazon resource name (ARN) of the view that is the default for the AWS Region in which you call this operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_GetDefaultView.html
     */
    toGetDefaultView() {
        return this.to('GetDefaultView');
    }
    /**
     * Grants permission to retrieve information about the index in the AWS Region in which you call this operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_GetIndex.html
     */
    toGetIndex() {
        return this.to('GetIndex');
    }
    /**
     * Grants permission to retrieve information about the specified view
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_GetView.html
     */
    toGetView() {
        return this.to('GetView');
    }
    /**
     * Grants permission to list the indexes in all AWS Regions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_ListIndexes.html
     */
    toListIndexes() {
        return this.to('ListIndexes');
    }
    /**
     * Grants permission to retrieve a list of all resource types currently supported by Resource Explorer
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_ListSupportedResourceTypes.html
     */
    toListSupportedResourceTypes() {
        return this.to('ListSupportedResourceTypes');
    }
    /**
     * Grants permission to list the tags that are attached to the specified resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list the Amazon resource names (ARNs) of all of the views available in the AWS Region in which you call this operation
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_ListViews.html
     */
    toListViews() {
        return this.to('ListViews');
    }
    /**
     * Grants permission to search for resources and display details about all resources that match the specified criteria
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_Search.html
     */
    toSearch() {
        return this.to('Search');
    }
    /**
     * Grants permission to add one or more tag key and value pairs to the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove one or more tag key and value pairs from the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to change the type of the index from LOCAL to AGGREGATOR or back
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_UpdateIndexType.html
     */
    toUpdateIndexType() {
        return this.to('UpdateIndexType');
    }
    /**
     * Grants permission to modify some of the details of a view
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_UpdateView.html
     */
    toUpdateView() {
        return this.to('UpdateView');
    }
    /**
     * Adds a resource of type view to the statement
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_View.html
     *
     * @param viewName - Identifier for the viewName.
     * @param viewUuid - Identifier for the viewUuid.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onView(viewName, viewUuid, account, region, partition) {
        return this.on(`arn:${partition || ResourceExplorer2.defaultPartition}:resource-explorer-2:${region || '*'}:${account || '*'}:view/${viewName}/${viewUuid}`);
    }
    /**
     * Adds a resource of type index to the statement
     *
     * https://docs.aws.amazon.com/resource-explorer/latest/apireference/API_Index.html
     *
     * @param indexUuid - Identifier for the indexUuid.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onIndex(indexUuid, account, region, partition) {
        return this.on(`arn:${partition || ResourceExplorer2.defaultPartition}:resource-explorer-2:${region || '*'}:${account || '*'}:index/${indexUuid}`);
    }
}
exports.ResourceExplorer2 = ResourceExplorer2;
_a = JSII_RTTI_SYMBOL_1;
ResourceExplorer2[_a] = { fqn: "iam-floyd.ResourceExplorer2", version: "0.498.0" };
//# sourceMappingURL=data:application/json;base64,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