import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [vpc-lattice-svcs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonvpclatticeservices.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class VpcLatticeSvcs extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [vpc-lattice-svcs](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonvpclatticeservices.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to invoke a VPC Lattice service
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifPort()
     * - .ifServiceNetworkArn()
     * - .ifServiceArn()
     * - .ifSourceVpc()
     * - .ifSourceVpcOwnerAccount()
     * - .ifRequestHeader()
     * - .ifRequestQueryString()
     *
     * https://aws.amazon.com/vpc/lattice
     */
    toInvoke(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type Service to the statement
     *
     * https://aws.amazon.com/vpc/lattice
     *
     * @param serviceId - Identifier for the serviceId.
     * @param requestPath - Identifier for the requestPath.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onService(serviceId: string, requestPath: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the destination port the request is made to
     *
     * https://aws.amazon.com/vpc/lattice
     *
     * Applies to actions:
     * - .toInvoke()
     *
     * @param value The value(s) to check
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`
     */
    ifPort(value: number | number[], operator?: Operator | string): this;
    /**
     * Filters access by a header name-value pair in the request headers
     *
     * https://aws.amazon.com/vpc/lattice
     *
     * Applies to actions:
     * - .toInvoke()
     *
     * @param headerName The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRequestHeader(headerName: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the method of the request
     *
     * https://aws.amazon.com/vpc/lattice
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRequestMethod(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the query string key-value pairs in the request URL
     *
     * https://aws.amazon.com/vpc/lattice
     *
     * Applies to actions:
     * - .toInvoke()
     *
     * @param queryStringKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRequestQueryString(queryStringKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of the service receiving the request
     *
     * https://aws.amazon.com/vpc/lattice
     *
     * Applies to actions:
     * - .toInvoke()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifServiceArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of the service network receiving the request
     *
     * https://aws.amazon.com/vpc/lattice
     *
     * Applies to actions:
     * - .toInvoke()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifServiceNetworkArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the VPC the request is made from
     *
     * https://aws.amazon.com/vpc/lattice
     *
     * Applies to actions:
     * - .toInvoke()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSourceVpc(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the owning account of the VPC the request is made from
     *
     * https://aws.amazon.com/vpc/lattice
     *
     * Applies to actions:
     * - .toInvoke()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSourceVpcOwnerAccount(value: string | string[], operator?: Operator | string): this;
}
