'''
Created on Feb 17, 2017

@author: calin
'''
#  (C) Copyright IBM Corp. 2021.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import logging

from pyspark.ml.param import Params
from pyspark.ml.pipeline import Pipeline
from pyspark.ml.wrapper import JavaEstimator
from pyspark.ml.wrapper import _jvm

__all__ = ['Learner', 'Target']

logger = logging.getLogger("mlpipelinepy")

def estimatorCopy(estimator, jvmObject, extra=None):
    if extra is None:
        extra = dict()
    if isinstance(estimator , Pipeline):
        that = Params.copy(estimator, extra)
        stages = [estimatorCopy(stage, jvmObject, extra) for stage in that.getStages()]
        return that.setStages(stages)
    elif (isinstance(estimator,JavaEstimator)):
        newJavaEstimator = estimator.copy(extra)
        paramMapConstructor = jvmObject.org.apache.spark.ml.param.ParamMap
        jParamMap = paramMapConstructor()
        newJavaEstimator._java_obj = newJavaEstimator._java_obj.copy(jParamMap)
        return newJavaEstimator
    else :
        return estimator.copy(extra)


def emptyParam():
    jvmObject = _jvm()
    return jvmObject.org.apache.spark.ml.param.ParamMap.empty()