"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Domain = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_amplify_1 = require("aws-cdk-lib/aws-amplify");
/**
 * (experimental) An Amplify Console domain.
 *
 * @experimental
 */
class Domain extends aws_cdk_lib_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.subDomains = props.subDomains || [];
        const domainName = props.domainName || id;
        const domain = new aws_amplify_1.CfnDomain(this, 'Resource', {
            appId: props.app.appId,
            domainName,
            subDomainSettings: aws_cdk_lib_1.Lazy.any({ produce: () => this.renderSubDomainSettings() }, { omitEmptyArray: true }),
            enableAutoSubDomain: !!props.enableAutoSubdomain,
            autoSubDomainCreationPatterns: props.autoSubdomainCreationPatterns || ['*', 'pr*'],
            autoSubDomainIamRole: (_b = props.autoSubDomainIamRole) === null || _b === void 0 ? void 0 : _b.roleArn,
        });
        this.arn = domain.attrArn;
        this.certificateRecord = domain.attrCertificateRecord;
        this.domainName = domain.attrDomainName;
        this.domainStatus = domain.attrDomainStatus;
        this.statusReason = domain.attrStatusReason;
        this.domainAutoSubDomainCreationPatterns = domain.attrAutoSubDomainCreationPatterns;
        this.domainAutoSubDomainIamRole = domain.attrAutoSubDomainIamRole;
        this.domainEnableAutoSubDomain = domain.attrEnableAutoSubDomain;
        this.node.addValidation({ validate: () => this.validateDomain() });
    }
    /**
     * (experimental) Maps a branch to a sub domain.
     *
     * @param branch The branch.
     * @param prefix The prefix.
     * @experimental
     */
    mapSubDomain(branch, prefix) {
        this.subDomains.push({ branch, prefix });
        return this;
    }
    /**
     * (experimental) Maps a branch to the domain root.
     *
     * @experimental
     */
    mapRoot(branch) {
        return this.mapSubDomain(branch, '');
    }
    validateDomain() {
        if (this.subDomains.length === 0) {
            return ['The domain doesn\'t contain any subdomains'];
        }
        return [];
    }
    renderSubDomainSettings() {
        return this.subDomains.map(s => {
            var _b;
            return ({
                branchName: s.branch.branchName,
                prefix: (_b = s.prefix) !== null && _b !== void 0 ? _b : s.branch.branchName,
            });
        });
    }
}
exports.Domain = Domain;
_a = JSII_RTTI_SYMBOL_1;
Domain[_a] = { fqn: "@aws-cdk/aws-amplify-alpha.Domain", version: "2.0.0-alpha.4" };
//# sourceMappingURL=data:application/json;base64,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