"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomRule = exports.RedirectStatus = exports.App = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const YAML = require("yaml");
const aws_amplify_1 = require("aws-cdk-lib/aws-amplify");
const branch_1 = require("./branch");
const domain_1 = require("./domain");
const utils_1 = require("./utils");
/**
 * (experimental) An Amplify Console application.
 *
 * @experimental
 */
class App extends aws_cdk_lib_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _c, _d, _e, _f, _g;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_AppProps(props);
        this.customRules = props.customRules || [];
        this.environmentVariables = props.environmentVariables || {};
        this.autoBranchEnvironmentVariables = props.autoBranchCreation && props.autoBranchCreation.environmentVariables || {};
        const role = props.role || new iam.Role(this, 'Role', {
            assumedBy: new iam.ServicePrincipal('amplify.amazonaws.com'),
        });
        this.grantPrincipal = role;
        const sourceCodeProviderOptions = (_c = props.sourceCodeProvider) === null || _c === void 0 ? void 0 : _c.bind(this);
        const app = new aws_amplify_1.CfnApp(this, 'Resource', {
            accessToken: (_d = sourceCodeProviderOptions === null || sourceCodeProviderOptions === void 0 ? void 0 : sourceCodeProviderOptions.accessToken) === null || _d === void 0 ? void 0 : _d.toString(),
            autoBranchCreationConfig: props.autoBranchCreation && {
                autoBranchCreationPatterns: props.autoBranchCreation.patterns,
                basicAuthConfig: props.autoBranchCreation.basicAuth
                    ? props.autoBranchCreation.basicAuth.bind(this, 'BranchBasicAuth')
                    : { enableBasicAuth: false },
                buildSpec: props.autoBranchCreation.buildSpec && props.autoBranchCreation.buildSpec.toBuildSpec(),
                enableAutoBranchCreation: true,
                enableAutoBuild: (_e = props.autoBranchCreation.autoBuild) !== null && _e !== void 0 ? _e : true,
                environmentVariables: aws_cdk_lib_1.Lazy.any({ produce: () => utils_1.renderEnvironmentVariables(this.autoBranchEnvironmentVariables) }, { omitEmptyArray: true }),
                enablePullRequestPreview: (_f = props.autoBranchCreation.pullRequestPreview) !== null && _f !== void 0 ? _f : true,
                pullRequestEnvironmentName: props.autoBranchCreation.pullRequestEnvironmentName,
                stage: props.autoBranchCreation.stage,
            },
            enableBranchAutoDeletion: props.autoBranchDeletion,
            basicAuthConfig: props.basicAuth
                ? props.basicAuth.bind(this, 'AppBasicAuth')
                : { enableBasicAuth: false },
            buildSpec: props.buildSpec && props.buildSpec.toBuildSpec(),
            customRules: aws_cdk_lib_1.Lazy.any({ produce: () => this.customRules }, { omitEmptyArray: true }),
            description: props.description,
            environmentVariables: aws_cdk_lib_1.Lazy.any({ produce: () => utils_1.renderEnvironmentVariables(this.environmentVariables) }, { omitEmptyArray: true }),
            iamServiceRole: role.roleArn,
            name: props.appName || this.node.id,
            oauthToken: (_g = sourceCodeProviderOptions === null || sourceCodeProviderOptions === void 0 ? void 0 : sourceCodeProviderOptions.oauthToken) === null || _g === void 0 ? void 0 : _g.toString(),
            repository: sourceCodeProviderOptions === null || sourceCodeProviderOptions === void 0 ? void 0 : sourceCodeProviderOptions.repository,
            customHeaders: props.customResponseHeaders ? renderCustomResponseHeaders(props.customResponseHeaders) : undefined,
        });
        this.appId = app.attrAppId;
        this.appName = app.attrAppName;
        this.arn = app.attrArn;
        this.defaultDomain = app.attrDefaultDomain;
    }
    /**
     * (experimental) Import an existing application.
     *
     * @experimental
     */
    static fromAppId(scope, id, appId) {
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.appId = appId;
            }
        }
        return new Import(scope, id);
    }
    /**
     * (experimental) Adds a custom rewrite/redirect rule to this application.
     *
     * @experimental
     */
    addCustomRule(rule) {
        jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_CustomRule(rule);
        this.customRules.push(rule);
        return this;
    }
    /**
     * (experimental) Adds an environment variable to this application.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     *
     * @experimental
     */
    addEnvironment(name, value) {
        this.environmentVariables[name] = value;
        return this;
    }
    /**
     * (experimental) Adds an environment variable to the auto created branch.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     *
     * @experimental
     */
    addAutoBranchEnvironment(name, value) {
        this.autoBranchEnvironmentVariables[name] = value;
        return this;
    }
    /**
     * (experimental) Adds a branch to this application.
     *
     * @experimental
     */
    addBranch(id, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_BranchOptions(options);
        return new branch_1.Branch(this, id, {
            ...options,
            app: this,
        });
    }
    /**
     * (experimental) Adds a domain to this application.
     *
     * @experimental
     */
    addDomain(id, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_DomainOptions(options);
        return new domain_1.Domain(this, id, {
            ...options,
            app: this,
            autoSubDomainIamRole: this.grantPrincipal,
        });
    }
}
exports.App = App;
_a = JSII_RTTI_SYMBOL_1;
App[_a] = { fqn: "@aws-cdk/aws-amplify-alpha.App", version: "2.5.0-alpha.0" };
/**
 * (experimental) The status code for a URL rewrite or redirect rule.
 *
 * @experimental
 */
var RedirectStatus;
(function (RedirectStatus) {
    RedirectStatus["REWRITE"] = "200";
    RedirectStatus["PERMANENT_REDIRECT"] = "301";
    RedirectStatus["TEMPORARY_REDIRECT"] = "302";
    RedirectStatus["NOT_FOUND"] = "404";
    RedirectStatus["NOT_FOUND_REWRITE"] = "404-200";
})(RedirectStatus = exports.RedirectStatus || (exports.RedirectStatus = {}));
/**
 * (experimental) Custom rewrite/redirect rule for an Amplify App.
 *
 * @see https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html
 * @experimental
 */
class CustomRule {
    /**
     * @experimental
     */
    constructor(options) {
        jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_CustomRuleOptions(options);
        this.source = options.source;
        this.target = options.target;
        this.status = options.status;
        this.condition = options.condition;
    }
}
exports.CustomRule = CustomRule;
_b = JSII_RTTI_SYMBOL_1;
CustomRule[_b] = { fqn: "@aws-cdk/aws-amplify-alpha.CustomRule", version: "2.5.0-alpha.0" };
/**
 * (experimental) Sets up a 200 rewrite for all paths to `index.html` except for path containing a file extension.
 *
 * @experimental
 */
CustomRule.SINGLE_PAGE_APPLICATION_REDIRECT = new CustomRule({
    source: '</^[^.]+$/>',
    target: '/index.html',
    status: RedirectStatus.REWRITE,
});
function renderCustomResponseHeaders(customHeaders) {
    const modifiedHeaders = customHeaders.map(customHeader => ({
        ...customHeader,
        headers: Object.entries(customHeader.headers).map(([key, value]) => ({ key, value })),
    }));
    const customHeadersObject = { customHeaders: modifiedHeaders };
    return YAML.stringify(customHeadersObject);
}
//# sourceMappingURL=data:application/json;base64,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