"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Branch = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const aws_lambda_nodejs_1 = require("aws-cdk-lib/aws-lambda-nodejs");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const aws_amplify_1 = require("aws-cdk-lib/aws-amplify");
const utils_1 = require("./utils");
/**
 * (experimental) An Amplify Console branch.
 *
 * @experimental
 */
class Branch extends aws_cdk_lib_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_BranchProps(props);
        this.environmentVariables = props.environmentVariables || {};
        const branchName = props.branchName || id;
        const branch = new aws_amplify_1.CfnBranch(this, 'Resource', {
            appId: props.app.appId,
            basicAuthConfig: props.basicAuth && props.basicAuth.bind(this, `${branchName}BasicAuth`),
            branchName,
            buildSpec: props.buildSpec && props.buildSpec.toBuildSpec(),
            description: props.description,
            enableAutoBuild: (_b = props.autoBuild) !== null && _b !== void 0 ? _b : true,
            enablePullRequestPreview: (_c = props.pullRequestPreview) !== null && _c !== void 0 ? _c : true,
            environmentVariables: aws_cdk_lib_1.Lazy.any({ produce: () => utils_1.renderEnvironmentVariables(this.environmentVariables) }, { omitEmptyArray: true }),
            pullRequestEnvironmentName: props.pullRequestEnvironmentName,
            stage: props.stage,
        });
        this.arn = branch.attrArn;
        this.branchName = branch.attrBranchName;
        if (props.asset) {
            new aws_cdk_lib_1.CustomResource(this, 'DeploymentResource', {
                serviceToken: AmplifyAssetDeploymentProvider.getOrCreate(this),
                resourceType: 'Custom::AmplifyAssetDeployment',
                properties: {
                    AppId: props.app.appId,
                    BranchName: branchName,
                    S3ObjectKey: props.asset.s3ObjectKey,
                    S3BucketName: props.asset.s3BucketName,
                },
            });
        }
    }
    /**
     * (experimental) Import an existing branch.
     *
     * @experimental
     */
    static fromBranchName(scope, id, branchName) {
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.branchName = branchName;
            }
        }
        return new Import(scope, id);
    }
    /**
     * (experimental) Adds an environment variable to this branch.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     *
     * @experimental
     */
    addEnvironment(name, value) {
        this.environmentVariables[name] = value;
        return this;
    }
}
exports.Branch = Branch;
_a = JSII_RTTI_SYMBOL_1;
Branch[_a] = { fqn: "@aws-cdk/aws-amplify-alpha.Branch", version: "2.5.0-alpha.0" };
class AmplifyAssetDeploymentProvider extends aws_cdk_lib_1.NestedStack {
    constructor(scope, id) {
        super(scope, id);
        const onEvent = new aws_lambda_nodejs_1.NodejsFunction(this, 'amplify-asset-deployment-on-event', {
            entry: path.join(__dirname, 'asset-deployment-handler/index.js'),
            runtime: lambda.Runtime.NODEJS_14_X,
            handler: 'onEvent',
            initialPolicy: [
                new iam.PolicyStatement({
                    resources: ['*'],
                    actions: [
                        's3:GetObject',
                        's3:GetSignedUrl',
                        'amplify:ListJobs',
                        'amplify:StartDeployment',
                    ],
                }),
            ],
        });
        const isComplete = new aws_lambda_nodejs_1.NodejsFunction(this, 'amplify-asset-deployment-is-complete', {
            entry: path.join(__dirname, 'asset-deployment-handler/index.js'),
            runtime: lambda.Runtime.NODEJS_14_X,
            handler: 'isComplete',
            initialPolicy: [
                new iam.PolicyStatement({
                    resources: ['*'],
                    actions: ['amplify:GetJob*'],
                }),
            ],
        });
        this.provider = new custom_resources_1.Provider(this, 'amplify-asset-deployment-handler-provider', {
            onEventHandler: onEvent,
            isCompleteHandler: isComplete,
            totalTimeout: aws_cdk_lib_1.Duration.minutes(5),
        });
    }
    /**
     * Returns the singleton provider.
     */
    static getOrCreate(scope) {
        var _b;
        const providerId = 'com.amazonaws.cdk.custom-resources.amplify-asset-deployment-provider';
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const group = (_b = stack.node.tryFindChild(providerId)) !== null && _b !== void 0 ? _b : new AmplifyAssetDeploymentProvider(stack, providerId);
        return group.provider.serviceToken;
    }
}
//# sourceMappingURL=data:application/json;base64,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