import * as codecommit from 'aws-cdk-lib/aws-codecommit';
import { SecretValue } from 'aws-cdk-lib';
import { App, ISourceCodeProvider, SourceCodeProviderConfig } from './app';
/**
 * (experimental) Properties for a GitHub source code provider.
 *
 * @experimental
 */
export interface GitHubSourceCodeProviderProps {
    /**
     * (experimental) The user or organization owning the repository.
     *
     * @experimental
     */
    readonly owner: string;
    /**
     * (experimental) The name of the repository.
     *
     * @experimental
     */
    readonly repository: string;
    /**
     * (experimental) A personal access token with the `repo` scope.
     *
     * @experimental
     */
    readonly oauthToken: SecretValue;
}
/**
 * (experimental) GitHub source code provider.
 *
 * @experimental
 */
export declare class GitHubSourceCodeProvider implements ISourceCodeProvider {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: GitHubSourceCodeProviderProps);
    /**
     * (experimental) Binds the source code provider to an app.
     *
     * @experimental
     */
    bind(_app: App): SourceCodeProviderConfig;
}
/**
 * (experimental) Properties for a GitLab source code provider.
 *
 * @experimental
 */
export interface GitLabSourceCodeProviderProps {
    /**
     * (experimental) The user or organization owning the repository.
     *
     * @experimental
     */
    readonly owner: string;
    /**
     * (experimental) The name of the repository.
     *
     * @experimental
     */
    readonly repository: string;
    /**
     * (experimental) A personal access token with the `repo` scope.
     *
     * @experimental
     */
    readonly oauthToken: SecretValue;
}
/**
 * (experimental) GitLab source code provider.
 *
 * @experimental
 */
export declare class GitLabSourceCodeProvider implements ISourceCodeProvider {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: GitLabSourceCodeProviderProps);
    /**
     * (experimental) Binds the source code provider to an app.
     *
     * @experimental
     */
    bind(_app: App): SourceCodeProviderConfig;
}
/**
 * (experimental) Properties for a CodeCommit source code provider.
 *
 * @experimental
 */
export interface CodeCommitSourceCodeProviderProps {
    /**
     * (experimental) The CodeCommit repository.
     *
     * @experimental
     */
    readonly repository: codecommit.IRepository;
}
/**
 * (experimental) CodeCommit source code provider.
 *
 * @experimental
 */
export declare class CodeCommitSourceCodeProvider implements ISourceCodeProvider {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: CodeCommitSourceCodeProviderProps);
    /**
     * (experimental) Binds the source code provider to an app.
     *
     * @experimental
     */
    bind(app: App): SourceCodeProviderConfig;
}
